/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.metadata;

import com.lightcrafts.image.metadata.EXIFConstants;
import com.lightcrafts.image.metadata.EXIFDirectory;
import com.lightcrafts.image.metadata.GPSDirectory;
import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.image.metadata.ImageMetadataDirectory;
import com.lightcrafts.image.metadata.SubEXIFDirectory;
import com.lightcrafts.image.metadata.values.DoubleMetaValue;
import com.lightcrafts.image.metadata.values.FloatMetaValue;
import com.lightcrafts.image.metadata.values.ImageMetaValue;
import com.lightcrafts.image.metadata.values.LongMetaValue;
import com.lightcrafts.image.metadata.values.RationalMetaValue;
import com.lightcrafts.image.metadata.values.UndefinedMetaValue;
import com.lightcrafts.utils.Rational;
import com.lightcrafts.utils.bytebuffer.ByteBufferUtil;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;

public final class EXIFEncoder {
    private int m_endPosPlus1;
    private final boolean m_includeHeader;
    private final ImageMetadata m_metadata;
    private int m_nextEXIFBigValuePos;

    public static ByteBuffer encode(ImageMetadata metadata, boolean includeHeader) {
        EXIFEncoder encoder = new EXIFEncoder(metadata, includeHeader);
        return encoder.encode();
    }

    private EXIFEncoder(ImageMetadata metadata, boolean includeHeader) {
        this.m_metadata = metadata;
        this.m_includeHeader = includeHeader;
    }

    private int calcDirSize(ImageMetadataDirectory dir) {
        int size = EXIFEncoder.calcIFDSize(dir);
        Iterator<Map.Entry<Integer, ImageMetaValue>> i = dir.iterator();
        while (i.hasNext()) {
            Map.Entry<Integer, ImageMetaValue> me = i.next();
            int tagID = me.getKey();
            if (EXIFEncoder.skipTag(tagID)) {
                size -= 12;
                continue;
            }
            ImageMetaValue imValue = me.getValue();
            int valueSize = EXIFEncoder.calcValueSize(imValue);
            if ((valueSize += valueSize & 1) > 4) {
                size += valueSize;
            }
            switch (tagID) {
                case 34853: {
                    ImageMetadataDirectory gpsDir = this.m_metadata.getDirectoryFor(GPSDirectory.class);
                    if (gpsDir == null) break;
                    size += this.calcDirSize(gpsDir);
                    break;
                }
                case 34665: {
                    ImageMetadataDirectory subEXIFDir = this.m_metadata.getDirectoryFor(SubEXIFDirectory.class);
                    if (subEXIFDir == null) break;
                    size += this.calcDirSize(subEXIFDir);
                    break;
                }
                case 40965: {
                    break;
                }
            }
        }
        return size;
    }

    private static int calcDirEntriesDelta(ImageMetadataDirectory dir) {
        int delta = 0;
        Iterator<Map.Entry<Integer, ImageMetaValue>> i = dir.iterator();
        while (i.hasNext()) {
            Map.Entry<Integer, ImageMetaValue> me = i.next();
            int tagID = me.getKey();
            if (!EXIFEncoder.skipTag(tagID)) continue;
            --delta;
        }
        return delta;
    }

    private static int calcIFDSize(ImageMetadataDirectory dir) {
        return 2 + dir.size() * 12 + 4;
    }

    private static int calcValueSize(ImageMetaValue value) {
        int size = 0;
        switch (value.getType()) {
            case META_DATE: 
            case META_STRING: {
                for (String s : value.getValues()) {
                    try {
                        byte[] b = s.getBytes("ISO-8859-1");
                        size += b.length + 1;
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new IllegalStateException(e);
                    }
                }
                break;
            }
            case META_UNDEFINED: {
                UndefinedMetaValue undefined = (UndefinedMetaValue)value;
                size = undefined.getUndefinedValue().length;
                break;
            }
            default: {
                size = value.getValueCount() * EXIFConstants.EXIF_FIELD_SIZE[value.getType().getTIFFConstant()];
            }
        }
        return size;
    }

    private ByteBuffer encode() {
        ImageMetadataDirectory exifDir = this.m_metadata.getDirectoryFor(EXIFDirectory.class);
        return exifDir != null ? this.encodeEXIFDir((EXIFDirectory)exifDir) : null;
    }

    private ByteBuffer encodeEXIFDir(EXIFDirectory dir) {
        int entriesDelta = EXIFEncoder.calcDirEntriesDelta(dir);
        this.m_nextEXIFBigValuePos = EXIFEncoder.calcIFDSize(dir) + entriesDelta * 12;
        this.m_endPosPlus1 = this.calcDirSize(dir);
        if (this.m_includeHeader) {
            this.m_nextEXIFBigValuePos += 14;
            this.m_endPosPlus1 += 14;
        }
        ByteBuffer buf = ByteBuffer.allocate(this.m_endPosPlus1);
        ByteOrder nativeOrder = ByteOrder.nativeOrder();
        buf.order(nativeOrder);
        if (this.m_includeHeader) {
            ByteBufferUtil.put(buf, "Exif\u0000\u0000", "ASCII");
            buf.putShort(nativeOrder == ByteOrder.BIG_ENDIAN ? (short)19789 : 18761);
            buf.putShort((short)42);
            buf.putInt(8);
        }
        this.encodeEXIFDir(dir, buf, entriesDelta);
        return buf;
    }

    /*
     * WARNING - void declaration
     */
    private void encodeEXIFDir(ImageMetadataDirectory dir, ByteBuffer buf, int entriesDelta) {
        buf.putShort((short)(dir.size() + entriesDelta));
        Object[] tagIDs = dir.getTagIDSet(false).toArray(new Integer[]{null});
        Arrays.sort(tagIDs);
        Object[] arr$ = tagIDs;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int tagID = (Integer)arr$[i$];
            if (EXIFEncoder.skipTag(tagID)) continue;
            buf.putShort((short)tagID);
            ImageMetaValue imValue = dir.getValue(tagID);
            int valueSize = EXIFEncoder.calcValueSize(imValue);
            switch (imValue.getType()) {
                case META_DATE: 
                case META_STRING: {
                    buf.putShort((short)2);
                    buf.putInt(valueSize);
                    break;
                }
                case META_UNDEFINED: {
                    buf.putShort(imValue.getType().getTIFFConstant());
                    buf.putInt(valueSize);
                    break;
                }
                default: {
                    buf.putShort(imValue.getType().getTIFFConstant());
                    buf.putInt(imValue.getValueCount());
                }
            }
            valueSize += valueSize & 1;
            int prevBufPos = 0;
            if (valueSize > 4) {
                buf.putInt(this.m_nextEXIFBigValuePos - (this.m_includeHeader ? 6 : 0));
                prevBufPos = buf.position();
                buf.position(this.m_nextEXIFBigValuePos);
                this.m_nextEXIFBigValuePos += valueSize;
            }
            switch (imValue.getType()) {
                case META_SBYTE: 
                case META_UBYTE: {
                    void var13_16;
                    Object[] bytes;
                    for (long b : bytes = ((LongMetaValue)imValue).getLongValues()) {
                        buf.put((byte)(b & 0xFFL));
                    }
                    int n = bytes.length;
                    while (var13_16 < 4) {
                        buf.put((byte)0);
                        ++var13_16;
                    }
                    break;
                }
                case META_DATE: 
                case META_STRING: {
                    try {
                        String[] strings = imValue.getValues();
                        byte[] byArray = strings[0].getBytes("ISO-8859-1");
                        buf.put(byArray);
                        buf.put((byte)0);
                        for (int j = byArray.length + 1; j < 4; ++j) {
                            buf.put((byte)0);
                        }
                        break;
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new IllegalStateException(e);
                    }
                }
                case META_SSHORT: 
                case META_USHORT: {
                    long[] shorts;
                    for (long s : shorts = ((LongMetaValue)imValue).getLongValues()) {
                        buf.putShort((short)(s & 0xFFFFL));
                    }
                    if (valueSize >= 4) break;
                    buf.putShort((short)0);
                    break;
                }
                case META_SLONG: 
                case META_ULONG: {
                    long[] longs;
                    for (long l : longs = ((LongMetaValue)imValue).getLongValues()) {
                        buf.putInt((int)(l & 0xFFFFFFFFFFFFFFFFL));
                    }
                    break;
                }
                case META_SRATIONAL: 
                case META_URATIONAL: {
                    Rational[] rats;
                    for (Rational r : rats = ((RationalMetaValue)imValue).getRationalValues()) {
                        buf.putInt(r.numerator());
                        buf.putInt(r.denominator());
                    }
                    break;
                }
                case META_FLOAT: {
                    float[] floats;
                    for (float f : floats = ((FloatMetaValue)imValue).getFloatValues()) {
                        buf.putFloat(f);
                    }
                    break;
                }
                case META_DOUBLE: {
                    double[] doubles;
                    for (double d : doubles = ((DoubleMetaValue)imValue).getDoubleValues()) {
                        buf.putDouble(d);
                    }
                    break;
                }
                case META_UNDEFINED: {
                    void var13_24;
                    Object[] bytes = ((UndefinedMetaValue)imValue).getUndefinedValue();
                    buf.put((byte[])bytes);
                    int n = bytes.length;
                    while (var13_24 < 4) {
                        buf.put((byte)0);
                        ++var13_24;
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            switch (tagID) {
                case 34853: {
                    this.encodeSubEXIFDir(GPSDirectory.class, buf);
                    break;
                }
                case 34665: {
                    this.encodeSubEXIFDir(SubEXIFDirectory.class, buf);
                    break;
                }
                case 40965: {
                    break;
                }
            }
            if (valueSize <= 4) continue;
            buf.position(prevBufPos);
        }
        buf.putInt(0);
    }

    private void encodeSubEXIFDir(Class<? extends ImageMetadataDirectory> dirClass, ByteBuffer buf) {
        ImageMetadataDirectory subDir = this.m_metadata.getDirectoryFor(dirClass);
        this.m_endPosPlus1 -= this.calcDirSize(subDir);
        buf.position(buf.position() - 4);
        buf.putInt(this.m_endPosPlus1 - (this.m_includeHeader ? 6 : 0));
        int prevBufPos = buf.position();
        buf.position(this.m_endPosPlus1);
        int origNextEXIFBigValuePos = this.m_nextEXIFBigValuePos;
        int entriesDelta = EXIFEncoder.calcDirEntriesDelta(subDir);
        this.m_nextEXIFBigValuePos = this.m_endPosPlus1 + EXIFEncoder.calcIFDSize(subDir) + entriesDelta * 12;
        this.encodeEXIFDir(subDir, buf, entriesDelta);
        buf.position(prevBufPos);
        this.m_nextEXIFBigValuePos = origNextEXIFBigValuePos;
    }

    private static boolean skipTag(int tagID) {
        switch (tagID) {
            case 37500: 
            case 40961: 
            case 40965: {
                return true;
            }
        }
        return false;
    }
}

