/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.metadata;

import com.lightcrafts.image.metadata.DNGTags;
import com.lightcrafts.image.metadata.ImageMetaTagInfo;
import com.lightcrafts.image.metadata.ImageMetaTags;
import com.lightcrafts.image.metadata.ImageMetaType;
import com.lightcrafts.image.metadata.TIFFDirectory;
import com.lightcrafts.image.metadata.providers.LensProvider;
import com.lightcrafts.image.metadata.values.ByteMetaValue;
import com.lightcrafts.image.metadata.values.ImageMetaValue;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

public final class DNGDirectory
extends TIFFDirectory
implements LensProvider {
    private static final ResourceBundle m_tagBundle = ResourceBundle.getBundle("com.lightcrafts.image.metadata.DNGTags");
    private static final Map<Integer, ImageMetaTagInfo> m_tagsByID = new HashMap<Integer, ImageMetaTagInfo>();
    private static final Map<String, ImageMetaTagInfo> m_tagsByName = new HashMap<String, ImageMetaTagInfo>();

    @Override
    public String getCameraMake(boolean includeModel) {
        ImageMetaValue value;
        String make = super.getCameraMake(includeModel);
        if (make == null && includeModel && (value = this.getValue(50708)) != null) {
            return value.getStringValue().toUpperCase().trim();
        }
        return make;
    }

    @Override
    public String getLens() {
        ImageMetaValue lens = this.getValue(50736);
        return lens != null ? lens.toString() : null;
    }

    @Override
    public String getName() {
        return "DNG";
    }

    @Override
    public ImageMetaTagInfo getTagInfoFor(Integer id) {
        return m_tagsByID.get(id);
    }

    @Override
    public ImageMetaTagInfo getTagInfoFor(String name) {
        return m_tagsByName.get(name);
    }

    @Override
    public String valueToString(ImageMetaValue value) {
        int tagID = value.getOwningTagID();
        switch (tagID) {
            case 50736: {
                String lensLabel = DNGDirectory.makeLensLabelFrom(value);
                if (lensLabel == null) break;
                return lensLabel;
            }
            case 50709: 
            case 50827: {
                switch (value.getType()) {
                    case META_SBYTE: 
                    case META_UBYTE: {
                        try {
                            return new String(((ByteMetaValue)value).getByteValues(), "UTF-8");
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return super.valueToString(value);
    }

    @Override
    protected ResourceBundle getTagLabelBundle() {
        return m_tagBundle;
    }

    @Override
    protected Class<? extends ImageMetaTags> getTagsInterface() {
        return DNGTags.class;
    }

    private static void add(int id, String name, ImageMetaType type, boolean isChangeable) {
        ImageMetaTagInfo tagInfo = new ImageMetaTagInfo(id, name, type, isChangeable);
        m_tagsByID.put(id, tagInfo);
        m_tagsByName.put(name, tagInfo);
    }

    static {
        DNGDirectory.add(50829, "ActiveArea", ImageMetaType.META_USHORT, false);
        DNGDirectory.add(50727, "AnalogBalance", ImageMetaType.META_URATIONAL, false);
        DNGDirectory.add(50738, "AntiAliasStrength", ImageMetaType.META_URATIONAL, false);
        DNGDirectory.add(50831, "AsShotICCProfile", ImageMetaType.META_UNDEFINED, false);
        DNGDirectory.add(50728, "AsShotNeutral", ImageMetaType.META_URATIONAL, false);
        DNGDirectory.add(50832, "AsShotPreProfileMatrix", ImageMetaType.META_SRATIONAL, false);
        DNGDirectory.add(50729, "AsShotWhiteXY", ImageMetaType.META_URATIONAL, false);
        DNGDirectory.add(50707, "BackwardVersion", ImageMetaType.META_UBYTE, false);
        DNGDirectory.add(50730, "BaselineExposure", ImageMetaType.META_SRATIONAL, false);
        DNGDirectory.add(50731, "BaselineNoise", ImageMetaType.META_URATIONAL, false);
        DNGDirectory.add(50732, "BaselineSharpness", ImageMetaType.META_URATIONAL, false);
        DNGDirectory.add(50733, "BayerGreenSplit", ImageMetaType.META_ULONG, false);
        DNGDirectory.add(50780, "BestQualityScale", ImageMetaType.META_URATIONAL, false);
        DNGDirectory.add(50714, "BlackLevel", ImageMetaType.META_URATIONAL, false);
        DNGDirectory.add(50715, "BlackLevelDeltaH", ImageMetaType.META_SRATIONAL, false);
        DNGDirectory.add(50716, "BlackLevelDeltaV", ImageMetaType.META_SRATIONAL, false);
        DNGDirectory.add(50713, "BlackLevelRepeatDim", ImageMetaType.META_USHORT, false);
        DNGDirectory.add(50778, "CalibrationIlluminant1", ImageMetaType.META_USHORT, false);
        DNGDirectory.add(50779, "CalibrationIlluminant2", ImageMetaType.META_USHORT, false);
        DNGDirectory.add(50723, "CameraCalibration1", ImageMetaType.META_SRATIONAL, false);
        DNGDirectory.add(50724, "CameraCalibration2", ImageMetaType.META_SRATIONAL, false);
        DNGDirectory.add(50735, "CameraSerialNumber", ImageMetaType.META_STRING, false);
        DNGDirectory.add(50711, "CFALayout", ImageMetaType.META_USHORT, false);
        DNGDirectory.add(50710, "CFAPlaneColor", ImageMetaType.META_UBYTE, false);
        DNGDirectory.add(50737, "ChromaBlurRadius", ImageMetaType.META_URATIONAL, false);
        DNGDirectory.add(50721, "ColorMatrix1", ImageMetaType.META_SRATIONAL, false);
        DNGDirectory.add(50722, "ColorMatrix2", ImageMetaType.META_SRATIONAL, false);
        DNGDirectory.add(50833, "CurrentICCProfile", ImageMetaType.META_UNDEFINED, false);
        DNGDirectory.add(50834, "CurrentPreProfileMatrix", ImageMetaType.META_SRATIONAL, false);
        DNGDirectory.add(50719, "DefaultCropOrigin", ImageMetaType.META_URATIONAL, false);
        DNGDirectory.add(50720, "DefaultCropSize", ImageMetaType.META_URATIONAL, false);
        DNGDirectory.add(50718, "DefaultScale", ImageMetaType.META_URATIONAL, false);
        DNGDirectory.add(50736, "LensInfo", ImageMetaType.META_URATIONAL, false);
        DNGDirectory.add(50712, "LinearizationTable", ImageMetaType.META_USHORT, false);
        DNGDirectory.add(50734, "LinearResponseLimit", ImageMetaType.META_URATIONAL, false);
        DNGDirectory.add(50709, "LocalizedCameraModel", ImageMetaType.META_STRING, false);
        DNGDirectory.add(50741, "MakerNoteSafety", ImageMetaType.META_USHORT, false);
        DNGDirectory.add(50830, "MaskedAreas", ImageMetaType.META_ULONG, false);
        DNGDirectory.add(50828, "OriginalRawFileData", ImageMetaType.META_UNDEFINED, false);
        DNGDirectory.add(50827, "OriginalRawFileName", ImageMetaType.META_STRING, false);
        DNGDirectory.add(50740, "PrivateData", ImageMetaType.META_UBYTE, false);
        DNGDirectory.add(50781, "RawDataUniqueID", ImageMetaType.META_UBYTE, false);
        DNGDirectory.add(50725, "ReductionMatrix1", ImageMetaType.META_SRATIONAL, false);
        DNGDirectory.add(50726, "ReductionMatrix2", ImageMetaType.META_SRATIONAL, false);
        DNGDirectory.add(50739, "ShadowScale", ImageMetaType.META_URATIONAL, false);
        DNGDirectory.add(50708, "UniqueCameraModel", ImageMetaType.META_STRING, false);
        DNGDirectory.add(50706, "Version", ImageMetaType.META_UBYTE, false);
        DNGDirectory.add(50717, "WhiteLevel", ImageMetaType.META_ULONG, false);
        DNGDirectory.add(315, "Artist", ImageMetaType.META_STRING, true);
        DNGDirectory.add(258, "BitsPerSample", ImageMetaType.META_USHORT, false);
        DNGDirectory.add(265, "CellLength", ImageMetaType.META_USHORT, false);
        DNGDirectory.add(264, "CellWidth", ImageMetaType.META_USHORT, false);
        DNGDirectory.add(320, "ColorMap", ImageMetaType.META_USHORT, false);
        DNGDirectory.add(259, "Compression", ImageMetaType.META_USHORT, false);
        DNGDirectory.add(33432, "Copyright", ImageMetaType.META_STRING, true);
        DNGDirectory.add(306, "DateTime", ImageMetaType.META_DATE, false);
        DNGDirectory.add(269, "DocumentName", ImageMetaType.META_STRING, true);
        DNGDirectory.add(336, "DotRange", ImageMetaType.META_USHORT, false);
        DNGDirectory.add(34665, "EXIFIFDPointer", ImageMetaType.META_ULONG, false);
        DNGDirectory.add(338, "ExtraSamples", ImageMetaType.META_USHORT, false);
        DNGDirectory.add(266, "FillOrder", ImageMetaType.META_USHORT, false);
        DNGDirectory.add(289, "FreeByteCounts", ImageMetaType.META_ULONG, false);
        DNGDirectory.add(288, "FreeOffsets", ImageMetaType.META_ULONG, false);
        DNGDirectory.add(291, "GrayResponseCurve", ImageMetaType.META_USHORT, false);
        DNGDirectory.add(290, "GrayResponseUnit", ImageMetaType.META_USHORT, false);
        DNGDirectory.add(321, "HalftoneHints", ImageMetaType.META_USHORT, false);
        DNGDirectory.add(316, "HostComputer", ImageMetaType.META_STRING, false);
        DNGDirectory.add(34675, "ICCProfile", ImageMetaType.META_UNDEFINED, false);
        DNGDirectory.add(270, "ImageDescription", ImageMetaType.META_STRING, true);
        DNGDirectory.add(32781, "ImageID", ImageMetaType.META_STRING, true);
        DNGDirectory.add(257, "ImageLength", ImageMetaType.META_USHORT, false);
        DNGDirectory.add(256, "ImageWidth", ImageMetaType.META_USHORT, false);
        DNGDirectory.add(346, "Indexed", ImageMetaType.META_USHORT, false);
        DNGDirectory.add(333, "InkNames", ImageMetaType.META_STRING, false);
        DNGDirectory.add(332, "InkSet", ImageMetaType.META_USHORT, false);
        DNGDirectory.add(521, "JPEGACTables", ImageMetaType.META_ULONG, false);
        DNGDirectory.add(520, "JPEGDCTables", ImageMetaType.META_ULONG, false);
        DNGDirectory.add(513, "JPEGInterchangeFormat", ImageMetaType.META_ULONG, false);
        DNGDirectory.add(514, "JPEGInterchangeFormatLength", ImageMetaType.META_ULONG, false);
        DNGDirectory.add(517, "JPEGLosslessPredictors", ImageMetaType.META_USHORT, false);
        DNGDirectory.add(518, "JPEGPointTransforms", ImageMetaType.META_USHORT, false);
        DNGDirectory.add(512, "JPEGProc", ImageMetaType.META_USHORT, false);
        DNGDirectory.add(519, "JPEGQTables", ImageMetaType.META_ULONG, false);
        DNGDirectory.add(515, "JPEGRestartInterval", ImageMetaType.META_USHORT, false);
        DNGDirectory.add(271, "Make", ImageMetaType.META_STRING, false);
        DNGDirectory.add(281, "MaxSampleValue", ImageMetaType.META_USHORT, false);
        DNGDirectory.add(280, "MinSampleValue", ImageMetaType.META_USHORT, false);
        DNGDirectory.add(272, "Model", ImageMetaType.META_STRING, false);
        DNGDirectory.add(254, "NewSubfileType", ImageMetaType.META_ULONG, false);
        DNGDirectory.add(334, "NumberOfInks", ImageMetaType.META_USHORT, false);
        DNGDirectory.add(351, "OPIProxy", ImageMetaType.META_USHORT, false);
        DNGDirectory.add(274, "Orientation", ImageMetaType.META_USHORT, false);
        DNGDirectory.add(285, "PageName", ImageMetaType.META_STRING, false);
        DNGDirectory.add(297, "PageNumber", ImageMetaType.META_USHORT, false);
        DNGDirectory.add(262, "PhotometricInterpretation", ImageMetaType.META_USHORT, false);
        DNGDirectory.add(284, "PlanarConfiguration", ImageMetaType.META_USHORT, false);
        DNGDirectory.add(317, "Predictor", ImageMetaType.META_USHORT, false);
        DNGDirectory.add(319, "PrimaryChromaticities", ImageMetaType.META_URATIONAL, false);
        DNGDirectory.add(532, "ReferenceBlackWhite", ImageMetaType.META_URATIONAL, false);
        DNGDirectory.add(296, "ResolutionUnit", ImageMetaType.META_USHORT, false);
        DNGDirectory.add(33723, "RichTIFFIPTC", ImageMetaType.META_UNDEFINED, false);
        DNGDirectory.add(278, "RowsPerStrip", ImageMetaType.META_USHORT, false);
        DNGDirectory.add(339, "SampleFormat", ImageMetaType.META_USHORT, false);
        DNGDirectory.add(277, "SamplesPerPixel", ImageMetaType.META_USHORT, false);
        DNGDirectory.add(341, "SMaxSampleValue", ImageMetaType.META_SRATIONAL, false);
        DNGDirectory.add(340, "SMinSampleValue", ImageMetaType.META_SRATIONAL, false);
        DNGDirectory.add(305, "Software", ImageMetaType.META_STRING, false);
        DNGDirectory.add(279, "StripByteCounts", ImageMetaType.META_ULONG, false);
        DNGDirectory.add(273, "StripOffsets", ImageMetaType.META_ULONG, false);
        DNGDirectory.add(255, "SubfileType", ImageMetaType.META_USHORT, false);
        DNGDirectory.add(292, "T4Options", ImageMetaType.META_ULONG, false);
        DNGDirectory.add(293, "T6Options", ImageMetaType.META_ULONG, false);
        DNGDirectory.add(337, "TargetPrinter", ImageMetaType.META_STRING, true);
        DNGDirectory.add(263, "Threshholding", ImageMetaType.META_USHORT, false);
        DNGDirectory.add(325, "TileByteCounts", ImageMetaType.META_ULONG, false);
        DNGDirectory.add(323, "TileLength", ImageMetaType.META_ULONG, false);
        DNGDirectory.add(324, "TileOffsets", ImageMetaType.META_ULONG, false);
        DNGDirectory.add(322, "TileWidth", ImageMetaType.META_ULONG, false);
        DNGDirectory.add(301, "TransferFunction", ImageMetaType.META_USHORT, false);
        DNGDirectory.add(342, "TransferRange", ImageMetaType.META_USHORT, false);
        DNGDirectory.add(318, "WhitePoint", ImageMetaType.META_URATIONAL, false);
        DNGDirectory.add(344, "XClipPathUnits", ImageMetaType.META_ULONG, false);
        DNGDirectory.add(700, "XMPPacket", ImageMetaType.META_SBYTE, false);
        DNGDirectory.add(286, "XPosition", ImageMetaType.META_URATIONAL, false);
        DNGDirectory.add(282, "XResolution", ImageMetaType.META_URATIONAL, false);
        DNGDirectory.add(529, "YCbCrCoefficients", ImageMetaType.META_URATIONAL, false);
        DNGDirectory.add(531, "YCbCrPositioning", ImageMetaType.META_USHORT, false);
        DNGDirectory.add(530, "YCbCrSubSampling", ImageMetaType.META_USHORT, false);
        DNGDirectory.add(345, "YClipPathUnits", ImageMetaType.META_ULONG, false);
        DNGDirectory.add(287, "YPosition", ImageMetaType.META_URATIONAL, false);
        DNGDirectory.add(283, "YResolution", ImageMetaType.META_URATIONAL, false);
    }
}

