/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.metadata;

import com.lightcrafts.image.metadata.CIFFDirectory;
import com.lightcrafts.image.metadata.EXIFDirectory;
import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.image.metadata.ImageMetadataDirectory;
import com.lightcrafts.image.metadata.MetadataUtil;
import com.lightcrafts.image.metadata.TIFFDirectory;
import com.lightcrafts.image.metadata.values.ImageMetaValue;
import com.lightcrafts.image.metadata.values.RationalMetaValue;
import com.lightcrafts.image.metadata.values.StringMetaValue;
import com.lightcrafts.image.metadata.values.UnsignedLongMetaValue;
import com.lightcrafts.image.metadata.values.UnsignedRationalMetaValue;
import com.lightcrafts.image.metadata.values.UnsignedShortMetaValue;

final class CIFFMetadataConverter {
    private final ImageMetadata m_metadata;
    private final CIFFDirectory m_ciffDir;
    private final ImageMetadataDirectory m_exifDir;
    private final ImageMetadataDirectory m_tiffDir;

    static ImageMetadata convert(CIFFDirectory ciffDir, boolean forJPEG) {
        return new CIFFMetadataConverter(ciffDir, forJPEG).convert();
    }

    private CIFFMetadataConverter(CIFFDirectory ciffDir, boolean forJPEG) {
        this.m_ciffDir = ciffDir;
        this.m_metadata = new ImageMetadata();
        this.m_exifDir = this.m_metadata.getDirectoryFor(EXIFDirectory.class, true);
        this.m_tiffDir = forJPEG ? this.m_exifDir : this.m_metadata.getDirectoryFor(TIFFDirectory.class, true);
        this.m_tiffDir.putValue(34665, new UnsignedLongMetaValue(0L));
    }

    private ImageMetadata convert() {
        String model;
        this.map(1576964, 258, this.m_tiffDir);
        this.map(0x181001, 257, this.m_tiffDir);
        this.map(0x181000, 256, this.m_tiffDir);
        this.map(1576963, 274, this.m_tiffDir);
        this.map(10244, 270, this.m_tiffDir);
        this.map(2064, 315, this.m_tiffDir);
        this.map(1062915, 257, this.m_tiffDir);
        this.map(1062914, 256, this.m_tiffDir);
        this.map(1059355, 274, this.m_tiffDir);
        String make = this.m_ciffDir.getCameraMake(false);
        if (make != null) {
            this.m_tiffDir.putValue(271, new StringMetaValue(make));
        }
        if ((model = this.m_ciffDir.getCameraModel()) != null) {
            this.m_tiffDir.putValue(272, new StringMetaValue(model));
        }
        this.map(6158, 36867, this.m_exifDir);
        this.map(4276, 40961, this.m_exifDir);
        this.map(1060109, 41992, this.m_exifDir);
        this.map(1060116, 34850, this.m_exifDir);
        this.map(1060100, 37385, this.m_exifDir);
        this.map(1060112, 34855, this.m_exifDir);
        this.map(1060113, 37383, this.m_exifDir);
        this.map(1060110, 41993, this.m_exifDir);
        this.map(1060111, 41994, this.m_exifDir);
        this.map(1059073, 37386, this.m_exifDir);
        this.map(1059074, 41486, this.m_exifDir);
        this.map(1059075, 41487, this.m_exifDir);
        this.map(1059349, 37378, this.m_exifDir);
        this.map(1059330, 34855, this.m_exifDir);
        this.map(1059350, 33434, this.m_exifDir);
        return this.m_metadata;
    }

    private void map(int fromTagID, int toTagID, ImageMetadataDirectory toDir) {
        ImageMetaValue value = this.m_ciffDir.getValue(fromTagID);
        if (value == null) {
            return;
        }
        boolean setOwner = true;
        switch (fromTagID) {
            case 1060109: {
                int n = value.getShortValue();
                switch (n) {
                    case -1: {
                        n = 1;
                        break;
                    }
                    case 0: {
                        break;
                    }
                    case 1: {
                        n = 2;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                value = new UnsignedShortMetaValue(n);
                break;
            }
            case 1060116: {
                int n = value.getShortValue();
                switch (n) {
                    case 1: {
                        n = 2;
                        break;
                    }
                    case 2: {
                        n = 4;
                        break;
                    }
                    case 4: {
                        n = 1;
                        break;
                    }
                    case 5: {
                        n = 6;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                value = new UnsignedShortMetaValue(n);
                break;
            }
            case 1060100: {
                int exifFlashMode = 0;
                switch (value.getShortValue()) {
                    case 0: {
                        break;
                    }
                    case 3: {
                        exifFlashMode = 65;
                        break;
                    }
                    case 5: {
                        exifFlashMode = 65;
                    }
                    case 1: {
                        exifFlashMode = (short)(exifFlashMode | 0x18);
                        break;
                    }
                    case 6: {
                        exifFlashMode = 64;
                    }
                    case 2: {
                        exifFlashMode = (short)(exifFlashMode | 9);
                        break;
                    }
                    default: {
                        return;
                    }
                }
                value = new UnsignedShortMetaValue(exifFlashMode);
                break;
            }
            case 1059330: 
            case 1060112: {
                short apex = value.getShortValue();
                if (apex == 0) {
                    return;
                }
                value = new UnsignedShortMetaValue(MetadataUtil.convertISOFromAPEX(apex));
                break;
            }
            case 1060113: {
                int n = value.getShortValue();
                switch (n) {
                    case 4: {
                        n = 6;
                        break;
                    }
                    case 5: {
                        n = 2;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                value = new UnsignedShortMetaValue(n);
                break;
            }
            case 4276: {
                value = new UnsignedShortMetaValue(value.getShortValue());
                break;
            }
            case 1060110: 
            case 1060111: {
                int n = value.getShortValue();
                switch (n) {
                    case -1: {
                        n = 1;
                        break;
                    }
                    case 0: {
                        break;
                    }
                    case 1: {
                        n = 2;
                    }
                }
                value = new UnsignedShortMetaValue(n);
                break;
            }
            case 1059073: 
            case 1059074: 
            case 1059075: {
                int n = value.getIntValue();
                value = new UnsignedRationalMetaValue(n, 1);
                break;
            }
            case 1576964: {
                int n = value.getIntValue();
                value = new UnsignedShortMetaValue(n, n, n);
                break;
            }
            case 1576963: {
                int orientation = value.getIntValue();
                if (orientation < 0) {
                    orientation = 360 + orientation;
                }
                switch (orientation) {
                    case 0: {
                        orientation = 1;
                        break;
                    }
                    case 90: {
                        orientation = 6;
                        break;
                    }
                    case 180: {
                        orientation = 3;
                        break;
                    }
                    case 270: {
                        orientation = 8;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                value = new UnsignedShortMetaValue(orientation);
                break;
            }
            case 1059355: {
                int orientation = value.getIntValue();
                switch (orientation) {
                    case 0: {
                        orientation = 1;
                        break;
                    }
                    case 2: {
                        orientation = 3;
                        break;
                    }
                    case 1: {
                        orientation = 6;
                        break;
                    }
                    case 3: {
                        orientation = 8;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                value = new UnsignedShortMetaValue(orientation);
                break;
            }
            case 1059349: {
                int apex = value.getIntValue();
                value = new UnsignedRationalMetaValue((int)(MetadataUtil.convertFStopFromAPEX(apex) * 10.0), 10);
                break;
            }
            case 1059350: {
                float speed = this.m_ciffDir.getShutterSpeed();
                value = new RationalMetaValue((int)(speed * 1000.0f), 1000);
                break;
            }
            default: {
                setOwner = false;
            }
        }
        toDir.putValue(toTagID, value, setOwner);
    }
}

