/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.metadata;

import com.lightcrafts.image.metadata.CIFFMetadataConverter;
import com.lightcrafts.image.metadata.CIFFTags;
import com.lightcrafts.image.metadata.ImageMetaTagInfo;
import com.lightcrafts.image.metadata.ImageMetaTags;
import com.lightcrafts.image.metadata.ImageMetaType;
import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.image.metadata.ImageMetadataDirectory;
import com.lightcrafts.image.metadata.ImageOrientation;
import com.lightcrafts.image.metadata.MetadataUtil;
import com.lightcrafts.image.metadata.providers.ApertureProvider;
import com.lightcrafts.image.metadata.providers.ArtistProvider;
import com.lightcrafts.image.metadata.providers.BitsPerChannelProvider;
import com.lightcrafts.image.metadata.providers.CaptureDateTimeProvider;
import com.lightcrafts.image.metadata.providers.ColorTemperatureProvider;
import com.lightcrafts.image.metadata.providers.FocalLengthProvider;
import com.lightcrafts.image.metadata.providers.ISOProvider;
import com.lightcrafts.image.metadata.providers.ImageMetadataProvider;
import com.lightcrafts.image.metadata.providers.LensProvider;
import com.lightcrafts.image.metadata.providers.MakeModelProvider;
import com.lightcrafts.image.metadata.providers.OrientationProvider;
import com.lightcrafts.image.metadata.providers.ShutterSpeedProvider;
import com.lightcrafts.image.metadata.providers.WidthHeightProvider;
import com.lightcrafts.image.metadata.values.DateMetaValue;
import com.lightcrafts.image.metadata.values.ImageMetaValue;
import com.lightcrafts.image.metadata.values.UnsignedLongMetaValue;
import com.lightcrafts.image.metadata.values.UnsignedShortMetaValue;
import com.lightcrafts.utils.Rational;
import com.lightcrafts.utils.TextUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

public final class CIFFDirectory
extends ImageMetadataDirectory
implements ApertureProvider,
ArtistProvider,
BitsPerChannelProvider,
CaptureDateTimeProvider,
ColorTemperatureProvider,
FocalLengthProvider,
ISOProvider,
LensProvider,
MakeModelProvider,
OrientationProvider,
ShutterSpeedProvider,
WidthHeightProvider {
    private static final ResourceBundle m_tagBundle = ResourceBundle.getBundle("com.lightcrafts.image.metadata.CIFFTags");
    private static final Map<Integer, ImageMetaTagInfo> m_tagsByID = new HashMap<Integer, ImageMetaTagInfo>();
    private static final Map<String, ImageMetaTagInfo> m_tagsByName = new HashMap<String, ImageMetaTagInfo>();

    public ImageMetadata convertMetadata(boolean forJPEG) {
        return CIFFMetadataConverter.convert(this, forJPEG);
    }

    @Override
    public float getAperture() {
        ImageMetaValue value = this.getValue(1059349);
        return value != null ? (float)MetadataUtil.convertFStopFromAPEX(value.getIntValue()) : 0.0f;
    }

    @Override
    public String getArtist() {
        ImageMetaValue value = this.getValue(2064);
        return value != null ? value.getStringValue() : null;
    }

    @Override
    public int getBitsPerChannel() {
        ImageMetaValue value = this.getValue(1576964);
        return value != null ? value.getIntValue() : 0;
    }

    @Override
    public String getCameraMake(boolean includeModel) {
        ImageMetaValue value = this.getValue(2058);
        if (value != null) {
            String makeModel = value.getStringValue();
            int makeNullPos = makeModel.indexOf(0);
            if (makeNullPos >= 0) {
                if (includeModel) {
                    int modelPos = makeNullPos + 1;
                    int endPos = makeModel.indexOf(0, modelPos);
                    if (endPos == -1) {
                        endPos = makeModel.length();
                    }
                    makeModel = MetadataUtil.undupMakeModel(makeModel.substring(0, makeNullPos), makeModel.substring(modelPos, endPos));
                }
                if (!includeModel) {
                    makeModel = makeModel.substring(0, makeNullPos);
                }
            }
            return makeModel.toUpperCase().trim();
        }
        return null;
    }

    public String getCameraModel() {
        ImageMetaValue value = this.getValue(2058);
        if (value == null) {
            return null;
        }
        String makeModel = value.getStringValue();
        int nullPos = makeModel.indexOf(0);
        if (nullPos == -1) {
            return null;
        }
        int modelPos = nullPos + 1;
        int endPos = makeModel.indexOf(0, modelPos);
        if (endPos == -1) {
            endPos = makeModel.length();
        }
        makeModel = makeModel.substring(modelPos, endPos);
        return makeModel.toUpperCase();
    }

    @Override
    public Date getCaptureDateTime() {
        ImageMetaValue value = this.getValue(6158);
        return value instanceof DateMetaValue ? ((DateMetaValue)value).getDateValue() : null;
    }

    @Override
    public int getColorTemperature() {
        ImageMetaValue value = this.getValue(4270);
        return value != null ? value.getIntValue() : 0;
    }

    @Override
    public float getFocalLength() {
        ImageMetaValue value = this.getValue(1059073);
        return value != null ? value.getFloatValue() : 0.0f;
    }

    @Override
    public int getImageHeight() {
        ImageMetaValue value = this.getValue(0x181001);
        if (value == null) {
            value = this.getValue(1062915);
        }
        return value != null ? value.getIntValue() : 0;
    }

    @Override
    public int getImageWidth() {
        ImageMetaValue value = this.getValue(0x181000);
        if (value == null) {
            value = this.getValue(1062914);
        }
        return value != null ? value.getIntValue() : 0;
    }

    @Override
    public int getISO() {
        ImageMetaValue value = this.getValue(1059330);
        if (value != null) {
            return MetadataUtil.convertISOFromAPEX(value.getIntValue());
        }
        String isoLabel = this.hasTagValueLabelFor(1060112);
        if (isoLabel != null) {
            try {
                return Integer.parseInt(isoLabel);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    @Override
    public String getLens() {
        ImageMetaValue lensValue = this.getValue(1060118);
        String label = CIFFDirectory.hasTagValueLabelFor(lensValue);
        if (label != null) {
            return label;
        }
        return CIFFDirectory.makeLensLabelFrom(this.getValue(1060120), this.getValue(1060119), this.getValue(1060121));
    }

    @Override
    public String getName() {
        return "CIFF";
    }

    @Override
    public ImageOrientation getOrientation() {
        ImageMetaValue value = this.getValue(1576963);
        if (value != null) {
            int orientation = value.getIntValue();
            if (orientation < 0) {
                orientation += 360;
            }
            switch (orientation) {
                case 0: {
                    return ImageOrientation.ORIENTATION_LANDSCAPE;
                }
                case 90: {
                    return ImageOrientation.ORIENTATION_90CCW;
                }
                case 180: {
                    return ImageOrientation.ORIENTATION_180;
                }
                case 270: {
                    return ImageOrientation.ORIENTATION_90CW;
                }
            }
        }
        if ((value = this.getValue(1059355)) != null) {
            switch (value.getIntValue()) {
                case 0: {
                    return ImageOrientation.ORIENTATION_LANDSCAPE;
                }
                case 1: {
                    return ImageOrientation.ORIENTATION_90CCW;
                }
                case 2: {
                    return ImageOrientation.ORIENTATION_180;
                }
                case 3: {
                    return ImageOrientation.ORIENTATION_90CW;
                }
            }
        }
        return ImageOrientation.ORIENTATION_UNKNOWN;
    }

    @Override
    public float getShutterSpeed() {
        ImageMetaValue value = this.getValue(1059350);
        if (value == null) {
            return 0.0f;
        }
        int apex = value.getIntValue();
        Rational speed = MetadataUtil.convertShutterSpeedFromAPEX(apex);
        return speed.floatValue();
    }

    @Override
    public ImageMetaTagInfo getTagInfoFor(Integer id) {
        return m_tagsByID.get(id);
    }

    @Override
    public ImageMetaTagInfo getTagInfoFor(String name) {
        return m_tagsByName.get(name);
    }

    @Override
    public void putValue(Integer tagID, ImageMetaValue value) {
        switch (tagID) {
            case 4124: {
                value = new UnsignedShortMetaValue(value.getUnsignedShortValue());
                break;
            }
            case 4138: 
            case 4141: 
            case 4145: 
            case 4147: {
                this.explodeSubfields(tagID, 1, value, false);
                return;
            }
            case 1060112: {
                if (value.getIntValue() != 0) break;
                return;
            }
            case 6147: {
                value = new UnsignedLongMetaValue(value.getLongValue());
                break;
            }
            case 1059330: {
                if (value.getIntValue() != 0) break;
                return;
            }
            case 4137: 
            case 4152: {
                this.explodeSubfields(tagID, 1, value, true);
                return;
            }
            case 6160: {
                this.explodeSubfields(tagID, 0, value, false);
                return;
            }
            case 4265: {
                return;
            }
        }
        super.putValue(tagID, value);
    }

    @Override
    public String valueToString(ImageMetaValue value) {
        switch (value.getOwningTagID()) {
            case 1059073: 
            case 1060119: 
            case 1060120: {
                return value.getStringValue() + "mm";
            }
            case 2058: {
                return this.getCameraMake(true);
            }
            case 1059352: {
                int n = value.getIntValue();
                return TextUtil.tenths((float)n / 10.0f);
            }
            case 1059349: {
                int apex = value.getIntValue();
                return TextUtil.tenths(MetadataUtil.convertFStopFromAPEX(apex));
            }
            case 1059330: {
                int apex = value.getIntValue();
                return Integer.toString(MetadataUtil.convertISOFromAPEX(apex));
            }
            case 1059350: {
                int apex = value.getIntValue();
                Rational speed = MetadataUtil.convertShutterSpeedFromAPEX(apex);
                return MetadataUtil.shutterSpeedString(speed.doubleValue());
            }
        }
        return super.valueToString(value);
    }

    @Override
    protected int getProviderPriorityFor(Class<? extends ImageMetadataProvider> provider) {
        return 0;
    }

    @Override
    protected ResourceBundle getTagLabelBundle() {
        return m_tagBundle;
    }

    @Override
    protected Class<? extends ImageMetaTags> getTagsInterface() {
        return CIFFTags.class;
    }

    private static void add(int id, String name, ImageMetaType type) {
        ImageMetaTagInfo tagInfo = new ImageMetaTagInfo(id, name, type, false);
        m_tagsByID.put(id, tagInfo);
        m_tagsByName.put(name, tagInfo);
    }

    static {
        CIFFDirectory.add(4124, "BaseISO", ImageMetaType.META_USHORT);
        CIFFDirectory.add(6155, "SerialNumber", ImageMetaType.META_ULONG);
        CIFFDirectory.add(10247, "CameraObject", ImageMetaType.META_UNDEFINED);
        CIFFDirectory.add(4141, "CameraSettings", ImageMetaType.META_UNDEFINED);
        CIFFDirectory.add(12292, "CameraSpecification", ImageMetaType.META_UNDEFINED);
        CIFFDirectory.add(6158, "CapturedTime", ImageMetaType.META_DATE);
        CIFFDirectory.add(4276, "ColorSpace", ImageMetaType.META_USHORT);
        CIFFDirectory.add(4270, "ColorTemperature", ImageMetaType.META_USHORT);
        CIFFDirectory.add(1060115, "CSAFPointSelected", ImageMetaType.META_USHORT);
        CIFFDirectory.add(1060101, "CSContinuousDriveMode", ImageMetaType.META_USHORT);
        CIFFDirectory.add(1060109, "CSContrast", ImageMetaType.META_USHORT);
        CIFFDirectory.add(1060108, "CSDigitalZoom", ImageMetaType.META_USHORT);
        CIFFDirectory.add(1060107, "CSEasyShootingMode", ImageMetaType.META_USHORT);
        CIFFDirectory.add(1060116, "CSExposureMode", ImageMetaType.META_USHORT);
        CIFFDirectory.add(1060124, "CSFlashActivity", ImageMetaType.META_USHORT);
        CIFFDirectory.add(1060125, "CSFlashDetails", ImageMetaType.META_USHORT);
        CIFFDirectory.add(1060100, "CSFlashMode", ImageMetaType.META_USHORT);
        CIFFDirectory.add(1060121, "CSFocalUnitsPerMM", ImageMetaType.META_USHORT);
        CIFFDirectory.add(1060103, "CSFocusMode", ImageMetaType.META_USHORT);
        CIFFDirectory.add(1060128, "CSFocusModeG1", ImageMetaType.META_USHORT);
        CIFFDirectory.add(1060114, "CSFocusType", ImageMetaType.META_USHORT);
        CIFFDirectory.add(1060106, "CSImageSize", ImageMetaType.META_USHORT);
        CIFFDirectory.add(1060112, "CSISO", ImageMetaType.META_USHORT);
        CIFFDirectory.add(1060118, "CSLensType", ImageMetaType.META_USHORT);
        CIFFDirectory.add(1060119, "CSLongFocalLength", ImageMetaType.META_USHORT);
        CIFFDirectory.add(1060097, "CSMacroMode", ImageMetaType.META_USHORT);
        CIFFDirectory.add(1060113, "CSMeteringMode", ImageMetaType.META_USHORT);
        CIFFDirectory.add(1060099, "CSQuality", ImageMetaType.META_USHORT);
        CIFFDirectory.add(1060110, "CSSaturation", ImageMetaType.META_USHORT);
        CIFFDirectory.add(1060098, "CSSelfTimerDelay", ImageMetaType.META_USHORT);
        CIFFDirectory.add(1060111, "CSSharpness", ImageMetaType.META_USHORT);
        CIFFDirectory.add(1060120, "CSShortFocalLength", ImageMetaType.META_USHORT);
        CIFFDirectory.add(1060132, "CSZoomedResolution", ImageMetaType.META_USHORT);
        CIFFDirectory.add(1060133, "CSZoomedResolutionBase", ImageMetaType.META_USHORT);
        CIFFDirectory.add(4147, "CustomFunctions", ImageMetaType.META_UNDEFINED);
        CIFFDirectory.add(6197, "DecoderTable", ImageMetaType.META_ULONG);
        CIFFDirectory.add(12299, "EXIFInformation", ImageMetaType.META_UNDEFINED);
        CIFFDirectory.add(6168, "ExposureInfo", ImageMetaType.META_ULONG);
        CIFFDirectory.add(2053, "FileDescription", ImageMetaType.META_STRING);
        CIFFDirectory.add(6167, "FileNumber", ImageMetaType.META_ULONG);
        CIFFDirectory.add(2059, "FirmwareVersion", ImageMetaType.META_STRING);
        CIFFDirectory.add(6163, "FlashInfo", ImageMetaType.META_ULONG);
        CIFFDirectory.add(1059073, "FLFocalLength", ImageMetaType.META_USHORT);
        CIFFDirectory.add(1059074, "FLFocalPlaneXSize", ImageMetaType.META_USHORT);
        CIFFDirectory.add(1059075, "FLFocalPlaneYSize", ImageMetaType.META_USHORT);
        CIFFDirectory.add(4137, "FocalLength", ImageMetaType.META_UNDEFINED);
        CIFFDirectory.add(1576965, "IIColorBitDepth", ImageMetaType.META_ULONG);
        CIFFDirectory.add(1576966, "IIColorBw", ImageMetaType.META_ULONG);
        CIFFDirectory.add(1576964, "IIComponentBitDepTH", ImageMetaType.META_ULONG);
        CIFFDirectory.add(0x181001, "IIImageHeight", ImageMetaType.META_ULONG);
        CIFFDirectory.add(0x181000, "IIImageWidth", ImageMetaType.META_ULONG);
        CIFFDirectory.add(1576962, "IIPixelAspectRatio", ImageMetaType.META_ULONG);
        CIFFDirectory.add(1576963, "IIRotation", ImageMetaType.META_ULONG);
        CIFFDirectory.add(10244, "ImageDescription", ImageMetaType.META_UNDEFINED);
        CIFFDirectory.add(2070, "ImageFileName", ImageMetaType.META_STRING);
        CIFFDirectory.add(6147, "ImageFormat", ImageMetaType.META_ULONG);
        CIFFDirectory.add(6160, "ImageInfo", ImageMetaType.META_ULONG);
        CIFFDirectory.add(12298, "ImageProps", ImageMetaType.META_UNDEFINED);
        CIFFDirectory.add(2069, "ImageType", ImageMetaType.META_STRING);
        CIFFDirectory.add(8199, "JPGFromRaw", ImageMetaType.META_UNDEFINED);
        CIFFDirectory.add(2058, "MakeModel", ImageMetaType.META_STRING);
        CIFFDirectory.add(6164, "MeasuredEv", ImageMetaType.META_ULONG);
        CIFFDirectory.add(12291, "MeasuredInfo", ImageMetaType.META_UNDEFINED);
        CIFFDirectory.add(2064, "OwnerName", ImageMetaType.META_STRING);
        CIFFDirectory.add(4152, "PictureInfo", ImageMetaType.META_UNDEFINED);
        CIFFDirectory.add(1062934, "PIAfPointsUsed", ImageMetaType.META_USHORT);
        CIFFDirectory.add(1062915, "PIImageHeight", ImageMetaType.META_USHORT);
        CIFFDirectory.add(1062917, "PIImageHeightAsShot", ImageMetaType.META_USHORT);
        CIFFDirectory.add(1062914, "PIImageWidth", ImageMetaType.META_USHORT);
        CIFFDirectory.add(1062916, "PIImageWidthAsShot", ImageMetaType.META_USHORT);
        CIFFDirectory.add(2098945, "PreviewImageLength", ImageMetaType.META_ULONG);
        CIFFDirectory.add(0x200702, "PreviewImageOffset", ImageMetaType.META_ULONG);
        CIFFDirectory.add(8197, "RawData", ImageMetaType.META_UNDEFINED);
        CIFFDirectory.add(6148, "RecordID", ImageMetaType.META_ULONG);
        CIFFDirectory.add(4118, "ReleaseSetting", ImageMetaType.META_USHORT);
        CIFFDirectory.add(2061, "ROMOperationMode", ImageMetaType.META_STRING);
        CIFFDirectory.add(6150, "SelfTimerTime", ImageMetaType.META_ULONG);
        CIFFDirectory.add(4145, "SensorInfo", ImageMetaType.META_UNDEFINED);
        CIFFDirectory.add(12290, "ShootingRecord", ImageMetaType.META_UNDEFINED);
        CIFFDirectory.add(4138, "ShotInfo", ImageMetaType.META_UNDEFINED);
        CIFFDirectory.add(4112, "ShutterReleaseMethod", ImageMetaType.META_USHORT);
        CIFFDirectory.add(4113, "ShutterReleaseTiming", ImageMetaType.META_USHORT);
        CIFFDirectory.add(1059342, "SIAfPointUsed", ImageMetaType.META_USHORT);
        CIFFDirectory.add(1059344, "SIAutoExposureBracketing", ImageMetaType.META_USHORT);
        CIFFDirectory.add(1059355, "SIAutoRotate", ImageMetaType.META_USHORT);
        CIFFDirectory.add(1059352, "SIBulbDuration", ImageMetaType.META_USHORT);
        CIFFDirectory.add(1059334, "SIExposureCompensation", ImageMetaType.META_USHORT);
        CIFFDirectory.add(1059343, "SIFlashBias", ImageMetaType.META_USHORT);
        CIFFDirectory.add(1059349, "FNumber", ImageMetaType.META_USHORT);
        CIFFDirectory.add(1059348, "SIFocusDistanceLower", ImageMetaType.META_USHORT);
        CIFFDirectory.add(1059347, "SIFocusDistanceUpper", ImageMetaType.META_USHORT);
        CIFFDirectory.add(1059330, "SIISO", ImageMetaType.META_USHORT);
        CIFFDirectory.add(1059337, "SISequenceNumber", ImageMetaType.META_USHORT);
        CIFFDirectory.add(1059350, "SIShutterSpeed", ImageMetaType.META_USHORT);
        CIFFDirectory.add(1059335, "SIWhiteBalance", ImageMetaType.META_USHORT);
        CIFFDirectory.add(1061128, "SSISensorBottomBorder", ImageMetaType.META_USHORT);
        CIFFDirectory.add(1061122, "SSISensorHeight", ImageMetaType.META_USHORT);
        CIFFDirectory.add(1061125, "SSISensorLeftBorder", ImageMetaType.META_USHORT);
        CIFFDirectory.add(1061127, "SSISensorRightBorder", ImageMetaType.META_USHORT);
        CIFFDirectory.add(1061126, "SSISensorTopBorder", ImageMetaType.META_USHORT);
        CIFFDirectory.add(0x103101, "SSISensorWidth", ImageMetaType.META_USHORT);
        CIFFDirectory.add(6151, "TargetDistanceSetting", ImageMetaType.META_ULONG);
        CIFFDirectory.add(4106, "TargetImageType", ImageMetaType.META_USHORT);
        CIFFDirectory.add(2071, "ThumbnailFileName", ImageMetaType.META_STRING);
        CIFFDirectory.add(8200, "ThumbnailImage", ImageMetaType.META_UNDEFINED);
        CIFFDirectory.add(2053, "UserComment", ImageMetaType.META_STRING);
        CIFFDirectory.add(4265, "WhiteBalanceTable", ImageMetaType.META_UNDEFINED);
    }
}

