/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.libs;

import com.lightcrafts.image.BadColorProfileException;
import com.lightcrafts.image.ColorProfileException;
import com.lightcrafts.image.libs.LCImageLibException;
import com.lightcrafts.image.libs.LCTIFFCommon;
import com.lightcrafts.jai.JAIContext;
import com.lightcrafts.jai.opimage.CachedImage;
import com.lightcrafts.mediax.jai.ImageLayout;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.mediax.jai.TileCache;
import com.lightcrafts.utils.ProgressIndicator;
import com.lightcrafts.utils.UserCanceledException;
import com.lightcrafts.utils.thread.ProgressThread;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.geom.AffineTransform;
import java.awt.image.BandedSampleModel;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public final class LCTIFFReader
extends LCTIFFCommon {
    private PlanarImage m_image;
    private final boolean m_read2nd;

    public LCTIFFReader(String fileName) throws LCImageLibException {
        this(fileName, false);
    }

    public LCTIFFReader(String fileName, boolean read2nd) throws LCImageLibException {
        this.m_read2nd = read2nd;
        this.openForReading(fileName);
        if (this.m_nativePtr == 0L) {
            throw new LCImageLibException("Could not open " + fileName);
        }
    }

    public ICC_Profile getICCProfile() throws ColorProfileException {
        byte[] iccProfileData = this.getICCProfileData();
        if (iccProfileData == null) {
            return null;
        }
        try {
            return ICC_Profile.getInstance(iccProfileData);
        }
        catch (IllegalArgumentException e) {
            throw new BadColorProfileException(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized PlanarImage getImage(ProgressThread thread) throws LCImageLibException, UserCanceledException {
        if (this.m_image == null) {
            try {
                if (this.m_read2nd && this.isLightZoneLayeredTIFF() && !this.nextDirectory()) {
                    PlanarImage planarImage = null;
                    return planarImage;
                }
                this.readImage(thread);
            }
            finally {
                this.dispose();
            }
        }
        return this.m_image;
    }

    public native int getIntField(int var1);

    public native int getIntField2(int var1, boolean var2);

    public native int getNumberOfStrips();

    public native int getNumberOfTiles();

    public native String getStringField(int var1);

    public native int getStripSize();

    public native int getTileSize();

    public native boolean isTiled();

    private native byte[] getICCProfileData();

    private boolean isLightZoneLayeredTIFF() {
        String software = this.getStringField(305);
        if (software == null || !software.startsWith("LightZone")) {
            return false;
        }
        int pages = this.getIntField2(297, true);
        return pages == 2;
    }

    private native boolean nextDirectory() throws LCImageLibException;

    private native void openForReading(String var1) throws LCImageLibException;

    private TIFF_Format getFormat() throws LCImageLibException {
        return new TIFF_Format();
    }

    private void readImage(ProgressThread thread) throws LCImageLibException, UserCanceledException {
        TIFF_Format tf = new TIFF_Format();
        ComponentColorModel imageCcm = new ComponentColorModel(tf.colorSpace, false, false, 1, tf.bitsPerSample == 8 ? 0 : (tf.sampleFormat == 2 ? 2 : 1));
        DataBuffer db = null;
        if (!tf.tiled || tf.hasAlpha) {
            db = tf.bitsPerSample == 8 ? (tf.planes == 1 ? new DataBufferByte(tf.tileSize) : new DataBufferByte(tf.tileSize, tf.planes)) : (tf.planes == 1 ? new DataBufferUShort(tf.tileSize / 2) : new DataBufferUShort(tf.tileSize / 2, tf.planes));
        }
        SampleModel tsm = imageCcm.createCompatibleSampleModel(256, 256);
        ImageLayout layout = new ImageLayout(0, 0, tf.imageWidth, tf.imageHeight, 0, 0, 256, 256, tsm, (ColorModel)imageCcm);
        CachedImage image = new CachedImage(layout, JAIContext.fileCache);
        int maxTileX = image.getNumXTiles();
        ProgressIndicator indicator = null;
        if (thread != null) {
            indicator = thread.getProgressIndicator();
        }
        if (indicator != null) {
            indicator.setMaximum(tf.tiles);
        }
        int[] bandList = new int[tf.samplesPerPixel];
        for (int i = 0; i < tf.samplesPerPixel; ++i) {
            bandList[i] = i;
        }
        Rectangle imageBounds = new Rectangle(0, 0, tf.imageWidth, tf.imageHeight);
        for (int tile = 0; tile < tf.tiles; ++tile) {
            if (thread != null && thread.isCanceled()) {
                throw new UserCanceledException();
            }
            int tileX = tf.tiled ? tile % maxTileX : 0;
            int tileY = tf.tiled ? tile / maxTileX : tile;
            Rectangle tileBounds = new Rectangle(tileX * tf.tiffTileWidth, tileY * tf.tiffTileHeight, tf.tiffTileWidth, tf.tiffTileHeight).intersection(imageBounds);
            int tileData = tf.samplesPerPixel / tf.planes * tileBounds.width * tileBounds.height * (tf.bitsPerSample == 8 ? 1 : 2);
            WritableRaster raster = !tf.tiled || tf.hasAlpha ? Raster.createWritableRaster(tf.tiffTsm, db, new Point(tileBounds.x, tileBounds.y)) : null;
            for (int plane = 0; plane < tf.planes; ++plane) {
                Object[] buffer;
                int read;
                if (tf.tiled) {
                    if (!tf.hasAlpha) {
                        raster = image.getWritableTile(tileX, tileY);
                    }
                    if (!(tf.bitsPerSample == 8 ? (read = this.readTileByte(tile + plane * tf.tiles, (byte[])(buffer = ((DataBufferByte)raster.getDataBuffer()).getData(plane)), 0L, tileData)) != tileData : (read = this.readTileShort(tile + plane * tf.tiles, (short[])(buffer = (Object[])((DataBufferUShort)raster.getDataBuffer()).getData(plane)), 0L, tileData)) != tileData)) continue;
                    throw new LCImageLibException("Broken TIFF File");
                }
                if (!(tf.bitsPerSample == 8 ? (read = this.readStripByte(tileY + plane * tf.tiles, (byte[])(buffer = ((DataBufferByte)db).getData(plane)), 0L, tileData)) != tileData : (read = this.readStripShort(tileY + plane * tf.tiles, (short[])(buffer = (Object[])((DataBufferUShort)db).getData(plane)), 0L, tileData)) != tileData)) continue;
                throw new LCImageLibException("Broken TIFF File");
            }
            if (!tf.tiled || tf.hasAlpha) {
                image.setData(raster.createChild(raster.getMinX(), raster.getMinY(), raster.getWidth(), raster.getHeight(), raster.getMinX(), raster.getMinY(), bandList));
            }
            if (indicator == null) continue;
            indicator.incrementBy(1);
        }
        if (indicator != null) {
            indicator.setIndeterminate(true);
        }
        this.m_image = image;
    }

    private synchronized native int readStripByte(int var1, byte[] var2, long var3, int var5) throws LCImageLibException;

    private synchronized native int readStripShort(int var1, short[] var2, long var3, int var5) throws LCImageLibException;

    private synchronized native int readTileByte(int var1, byte[] var2, long var3, int var5) throws LCImageLibException;

    private synchronized native int readTileShort(int var1, short[] var2, long var3, int var5) throws LCImageLibException;

    public static void main(String[] args) {
        try {
            final TIFFImage image = new TIFFImage(args[0]);
            JFrame frame = new JFrame("TIFF Image");
            JPanel imagePanel = new JPanel(){

                @Override
                public void paintComponent(Graphics g) {
                    ((Graphics2D)g).drawRenderedImage((RenderedImage)image, new AffineTransform());
                }
            };
            imagePanel.setPreferredSize(new Dimension(image.getWidth(), image.getHeight()));
            JScrollPane scrollPane = new JScrollPane(imagePanel);
            frame.setContentPane(scrollPane);
            frame.pack();
            frame.setSize(800, 600);
            frame.show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class TIFFImage
    extends PlanarImage {
        final TIFF_Format tf;
        final LCTIFFReader reader;
        protected transient TileCache cache = JAIContext.defaultTileCache;
        protected Object tileCacheMetric;

        public TIFFImage(String path) throws LCImageLibException {
            this.reader = new LCTIFFReader(path);
            this.tf = this.reader.getFormat();
            ImageLayout layout = new ImageLayout(0, 0, this.tf.imageWidth, this.tf.imageHeight, 0, 0, this.tf.tiffTileWidth, this.tf.tiffTileHeight, this.tf.tiffTsm, (ColorModel)this.tf.tiffCcm);
            this.setImageLayout(layout);
        }

        public void dispose() {
            super.dispose();
            this.reader.dispose();
        }

        public TileCache getTileCache() {
            return this.cache;
        }

        public void setTileCache(TileCache cache) {
            if (this.cache != null) {
                this.cache.removeTiles((RenderedImage)((Object)this));
            }
            this.cache = cache;
        }

        protected Raster getTileFromCache(int tileX, int tileY) {
            return this.cache != null ? this.cache.getTile((RenderedImage)((Object)this), tileX, tileY) : null;
        }

        protected void addTileToCache(int tileX, int tileY, Raster tile) {
            if (this.cache != null) {
                this.cache.add((RenderedImage)((Object)this), tileX, tileY, tile, null);
            }
        }

        public Raster getTile(int tileX, int tileY) {
            Raster tile = null;
            int tileN = tileX + tileY * this.getNumXTiles();
            if (tileX >= this.getMinTileX() && tileX <= this.getMaxTileX() && tileY >= this.getMinTileY() && tileY <= this.getMaxTileY() && (tile = this.getTileFromCache(tileX, tileY)) == null) {
                tile = Raster.createWritableRaster(this.tf.tiffTsm, new Point(tileX * this.tf.tiffTileWidth, tileY * this.tf.tiffTileHeight));
                try {
                    for (int plane = 0; plane < this.tf.planes; ++plane) {
                        Object[] buffer;
                        if (this.tf.tiled) {
                            if (this.tf.bitsPerSample == 8) {
                                buffer = ((DataBufferByte)tile.getDataBuffer()).getData(plane);
                                this.reader.readTileByte(tileN + plane * this.tf.tiles, buffer, 0L, this.tf.tileSize);
                                continue;
                            }
                            buffer = ((DataBufferUShort)tile.getDataBuffer()).getData(plane);
                            this.reader.readTileShort(tileN + plane * this.tf.tiles, buffer, 0L, this.tf.tileSize);
                            continue;
                        }
                        if (this.tf.bitsPerSample == 8) {
                            buffer = ((DataBufferByte)tile.getDataBuffer()).getData(plane);
                            this.reader.readStripByte(tileY + plane * this.tf.tiles, buffer, 0L, this.tf.tileSize);
                            continue;
                        }
                        buffer = ((DataBufferUShort)tile.getDataBuffer()).getData(plane);
                        this.reader.readStripShort(tileY + plane * this.tf.tiles, buffer, 0L, this.tf.tileSize);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.addTileToCache(tileX, tileY, tile);
            }
            return tile;
        }
    }

    private class TIFF_Format {
        final int imageWidth;
        final int imageHeight;
        final int bitsPerSample;
        final int samplesPerPixel;
        final int sampleFormat;
        final int extraSamples;
        final int photometric;
        final int planarConfig;
        final int planes;
        final boolean tiled;
        final int tiles;
        final int tileSize;
        final int tiffTileWidth;
        final int tiffTileHeight;
        final boolean hasAlpha;
        final boolean isAlphaPremultiplied;
        final ICC_Profile profile;
        final ColorSpace colorSpace;
        final ComponentColorModel tiffCcm;
        final SampleModel tiffTsm;

        TIFF_Format() throws LCImageLibException {
            this.imageWidth = LCTIFFReader.this.getIntField(256);
            this.imageHeight = LCTIFFReader.this.getIntField(257);
            this.bitsPerSample = LCTIFFReader.this.getIntField(258);
            this.samplesPerPixel = LCTIFFReader.this.getIntField(277);
            this.sampleFormat = LCTIFFReader.this.getIntField(339);
            this.extraSamples = LCTIFFReader.this.getIntField(338);
            this.photometric = LCTIFFReader.this.getIntField(262);
            this.planarConfig = LCTIFFReader.this.getIntField(284);
            this.planes = this.planarConfig == 1 ? 1 : this.samplesPerPixel;
            this.tiled = LCTIFFReader.this.isTiled();
            this.tiles = this.tiled ? LCTIFFReader.this.getNumberOfTiles() / this.planes : LCTIFFReader.this.getNumberOfStrips() / this.planes;
            this.tileSize = this.tiled ? LCTIFFReader.this.getTileSize() : LCTIFFReader.this.getStripSize();
            this.tiffTileWidth = this.tiled ? LCTIFFReader.this.getIntField(322) : this.imageWidth;
            this.tiffTileHeight = this.tiled ? LCTIFFReader.this.getIntField(323) : this.tileSize / (this.imageWidth * (this.samplesPerPixel / this.planes) * this.bitsPerSample / 8);
            this.hasAlpha = this.extraSamples == 1 || this.extraSamples == 2;
            boolean bl = this.isAlphaPremultiplied = this.extraSamples == 1;
            if (this.bitsPerSample != 8 && this.bitsPerSample != 16) {
                throw new LCImageLibException("Unsupported TIFF Bit per Sample Value: " + this.bitsPerSample);
            }
            ICC_Profile iccProfile = null;
            try {
                iccProfile = LCTIFFReader.this.getICCProfile();
                if (iccProfile == null && this.photometric == 8) {
                    iccProfile = JAIContext.labProfile;
                }
            }
            catch (ColorProfileException colorProfileException) {
                // empty catch block
            }
            this.profile = iccProfile;
            if (this.profile != null) {
                this.colorSpace = new ICC_ColorSpace(this.profile);
            } else {
                switch (this.samplesPerPixel - (this.hasAlpha ? 1 : 0)) {
                    case 1: {
                        this.colorSpace = JAIContext.gray22ColorSpace;
                        break;
                    }
                    case 3: {
                        this.colorSpace = JAIContext.sRGBColorSpace;
                        break;
                    }
                    case 4: {
                        this.colorSpace = JAIContext.CMYKColorSpace;
                        break;
                    }
                    default: {
                        throw new LCImageLibException("Bad image: " + this.samplesPerPixel + " samples per pixel.");
                    }
                }
            }
            this.tiffCcm = new ComponentColorModel(this.colorSpace, this.hasAlpha, this.isAlphaPremultiplied, 1, this.bitsPerSample == 8 ? 0 : (this.sampleFormat == 2 ? 2 : 1));
            this.tiffTsm = this.planarConfig == 1 ? this.tiffCcm.createCompatibleSampleModel(this.tiffTileWidth, this.tiffTileHeight) : new BandedSampleModel(this.tiffCcm.getTransferType(), this.tiffTileWidth, this.tiffTileHeight, this.samplesPerPixel);
        }
    }
}

