/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.export;

import com.lightcrafts.image.export.BooleanExportOption;
import com.lightcrafts.image.export.ImageExportOptionWriter;
import com.lightcrafts.image.export.ImageExportOptions;
import com.lightcrafts.image.export.IntegerExportOption;
import com.lightcrafts.image.export.StringExportOption;
import com.lightcrafts.utils.xml.XMLUtil;
import java.io.File;
import java.io.IOException;
import org.w3c.dom.Element;

public final class ImageExportOptionXMLWriter
implements ImageExportOptionWriter {
    static final String ExportOptionsTag = "ExportOptions";
    static final String TypeTag = "type";
    static final String FileTag = "file";
    private final ImageExportOptions m_options;
    private Element m_parent;

    public ImageExportOptionXMLWriter(ImageExportOptions options, Element parent) {
        this.m_options = options;
        this.m_parent = parent;
    }

    @Override
    public void write(BooleanExportOption o) {
        Element child = XMLUtil.addElementChildTo(this.m_parent, o.getName());
        child.setAttribute("value", Boolean.toString(o.getValue()));
    }

    @Override
    public void write(IntegerExportOption o) {
        Element child = XMLUtil.addElementChildTo(this.m_parent, o.getName());
        child.setAttribute("value", Integer.toString(o.getValue()));
    }

    @Override
    public void write(StringExportOption o) {
        Element child = XMLUtil.addElementChildTo(this.m_parent, o.getName());
        child.setAttribute("value", o.getValue());
    }

    public void writeAll() throws IOException {
        this.m_parent = XMLUtil.addElementChildTo(this.m_parent, ExportOptionsTag);
        this.m_parent.setAttribute(TypeTag, this.m_options.getImageType().getName());
        File exportFile = this.m_options.getExportFile();
        if (exportFile != null) {
            this.m_parent.setAttribute(FileTag, exportFile.getAbsolutePath());
        }
        this.m_options.writeTo(this);
    }
}

