/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.export;

import com.lightcrafts.image.export.BooleanExportOption;
import com.lightcrafts.image.export.ImageExportOption;
import com.lightcrafts.image.export.ImageExportOptionReader;
import com.lightcrafts.image.export.ImageExportOptions;
import com.lightcrafts.image.export.IntegerExportOption;
import com.lightcrafts.image.export.StringExportOption;
import com.lightcrafts.image.types.ImageType;
import com.lightcrafts.utils.xml.ElementFilter;
import com.lightcrafts.utils.xml.XMLException;
import com.lightcrafts.utils.xml.XMLUtil;
import java.io.File;
import java.io.IOException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class ImageExportOptionXMLReader
implements ImageExportOptionReader {
    private final Element m_parent;

    public ImageExportOptionXMLReader(Element parent) throws IOException {
        Node node = XMLUtil.getFirstChildOf(parent, new ElementFilter("ExportOptions"));
        if (node == null) {
            throw new XMLException("ExportOptions\" expected");
        }
        this.m_parent = (Element)node;
    }

    @Override
    public void read(BooleanExportOption o) throws IOException {
        this.readImpl(o);
    }

    @Override
    public void read(IntegerExportOption o) throws IOException {
        this.readImpl(o);
    }

    @Override
    public void read(StringExportOption o) throws IOException {
        this.readImpl(o);
    }

    public ImageExportOptions readAll() throws IOException {
        String typeName = this.m_parent.getAttribute("type");
        ImageType type = ImageType.getImageTypeByName(typeName);
        if (type == null) {
            throw new XMLException("Unrecognized image export type: \"" + typeName + '\"');
        }
        ImageExportOptions options = type.newExportOptions();
        if (this.m_parent.hasAttribute("file")) {
            String exportFileName = this.m_parent.getAttribute("file");
            File exportFile = new File(exportFileName);
            options.setExportFile(exportFile);
        }
        options.readFrom(this);
        return options;
    }

    private void readImpl(ImageExportOption o) throws IOException {
        Node child = XMLUtil.getFirstChildOf(this.m_parent, new ElementFilter(o.getName()));
        if (child == null) {
            return;
        }
        String value = ((Element)child).getAttribute("value");
        if (value.length() == 0) {
            throw new IOException("empty value");
        }
        o.setValue(value);
    }
}

