/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app.menu;

import com.lightcrafts.platform.Platform;
import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;

class MenuFactory {
    private static boolean useMacMnemonics = false;
    static final ResourceBundle Resources = ResourceBundle.getBundle("com/lightcrafts/app/menu/MenuFactory");
    private static String PlatformSuffix = "";
    private static final String NameSuffix = "_Name";
    private static final String AcceleratorSuffix = "_Accelerator";
    private static final String MnemonicSuffix = "_Mnemonic";
    private static final String AcceleratorModifier;

    MenuFactory() {
    }

    static void configureMenuItem(String key, JMenuItem item) {
        String name = MenuFactory.getName(key);
        KeyStroke accel = MenuFactory.getAccelerator(key);
        int mnem = MenuFactory.getMnemonic(key);
        if (name == null) {
            throw new RuntimeException("Can't configure menu item \"" + key + "\"");
        }
        item.setText(name);
        if (accel != null) {
            item.setAccelerator(accel);
        }
        if (mnem > 0) {
            item.setMnemonic(mnem);
        }
    }

    static void configureMenu(String key, JMenu menu) {
        String name = MenuFactory.getName(key);
        int mnem = MenuFactory.getMnemonic(key);
        if (name == null) {
            throw new RuntimeException("Can't configure menu item \"" + key + "\"");
        }
        menu.setText(name);
        if (mnem > 0) {
            menu.setMnemonic(mnem);
        }
    }

    static JMenuItem createMenuItem(String key) {
        String name = MenuFactory.getName(key);
        KeyStroke accel = MenuFactory.getAccelerator(key);
        int mnem = MenuFactory.getMnemonic(key);
        if (name == null) {
            throw new RuntimeException("Can't configure menu item \"" + key + "\"");
        }
        JMenuItem item = new JMenuItem(name);
        if (accel != null) {
            item.setAccelerator(accel);
        }
        if (mnem > 0) {
            item.setMnemonic(mnem);
        }
        return item;
    }

    static JRadioButtonMenuItem createRadioButtonMenuItem(String key) {
        String name = MenuFactory.getName(key);
        KeyStroke accel = MenuFactory.getAccelerator(key);
        int mnem = MenuFactory.getMnemonic(key);
        if (name == null) {
            throw new RuntimeException("Can't configure menu item \"" + key + "\"");
        }
        JRadioButtonMenuItem item = new JRadioButtonMenuItem(name);
        if (accel != null) {
            item.setAccelerator(accel);
        }
        if (mnem > 0) {
            item.setMnemonic(mnem);
        }
        return item;
    }

    static JMenu createMenu(String key) {
        String name = MenuFactory.getName(key);
        int mnem = MenuFactory.getMnemonic(key);
        if (name == null) {
            throw new RuntimeException("Can't configure menu item \"" + key + "\"");
        }
        JMenu menu = new JMenu(name);
        if (mnem > 0) {
            menu.setMnemonic(mnem);
        }
        return menu;
    }

    private static String getName(String key) {
        String s = MenuFactory.getPlatformString(key + NameSuffix);
        return s;
    }

    private static KeyStroke getAccelerator(String key) {
        String s = MenuFactory.getPlatformString(key + AcceleratorSuffix);
        KeyStroke stroke = KeyStroke.getKeyStroke(AcceleratorModifier + " " + s);
        return stroke;
    }

    private static int getMnemonic(String key) {
        if (!useMacMnemonics && Platform.getType() == Platform.MacOSX) {
            return -1;
        }
        String s = MenuFactory.getPlatformString(key + MnemonicSuffix);
        int code = MenuFactory.getKeyCode(s);
        return code;
    }

    private static String getPlatformString(String key) {
        String s = MenuFactory.getStringOrNull(key + PlatformSuffix);
        if (s == null) {
            s = MenuFactory.getStringOrNull(key);
        }
        return s;
    }

    private static String getStringOrNull(String key) {
        try {
            return Resources.getString(key);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    private static int getKeyCode(String vkString) {
        try {
            Class<KeyEvent> clazz = KeyEvent.class;
            Field field = clazz.getField(vkString);
            Integer virtualKeyCode = (Integer)field.get(null);
            return virtualKeyCode;
        }
        catch (NoSuchFieldException e) {
            return -1;
        }
        catch (IllegalAccessException e) {
            return -1;
        }
        catch (NullPointerException e) {
            return -1;
        }
    }

    static {
        if (Platform.getType() == Platform.Linux) {
            PlatformSuffix = "_Linux";
        } else if (Platform.getType() == Platform.MacOSX) {
            PlatformSuffix = "_Mac";
        } else if (Platform.getType() == Platform.Windows) {
            PlatformSuffix = "_Win";
        }
        AcceleratorModifier = Platform.getType() == Platform.MacOSX ? "meta" : "ctrl";
    }
}

