/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app.menu;

import com.lightcrafts.app.Application;
import com.lightcrafts.app.CheckForUpdate;
import com.lightcrafts.app.ComboFrame;
import com.lightcrafts.app.UpgradeDialog;
import com.lightcrafts.app.menu.MenuFactory;
import com.lightcrafts.app.menu.UpdatableDisposableMenu;
import com.lightcrafts.license.LicenseChecker;
import com.lightcrafts.platform.Platform;
import com.lightcrafts.prefs.ApplicationMode;
import com.lightcrafts.utils.Version;
import com.lightcrafts.utils.WebBrowser;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;

class HelpMenu
extends UpdatableDisposableMenu {
    HelpMenu(final ComboFrame frame) {
        super(frame, "Help");
        JMenuItem menuItem = MenuFactory.createMenuItem("LightZoneHelp");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Platform.getPlatform().showHelpTopic(null);
            }
        });
        this.add(menuItem);
        menuItem = MenuFactory.createMenuItem("VideoLearningCenter");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                URL url = Version.getVideoLearningCenterURL();
                WebBrowser.browse(url.toString());
            }
        });
        this.add(menuItem);
        this.add(new JSeparator());
        menuItem = MenuFactory.createMenuItem("ProductPage");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                URL url = Version.getApplicationURL();
                if (url != null) {
                    WebBrowser.browse(url.toString());
                }
            }
        });
        this.add(menuItem);
        menuItem = MenuFactory.createMenuItem("CheckForUpdate");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckForUpdate.checkNowAndWait();
            }
        });
        this.add(menuItem);
        if (LicenseChecker.getLicenseKey() == null) {
            final JMenuItem buyNowItem = MenuFactory.createMenuItem("BuyNow");
            buyNowItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (LicenseChecker.license()) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                HelpMenu.this.remove(buyNowItem);
                            }
                        });
                    }
                }
            });
            this.add(buyNowItem);
        }
        if (LicenseChecker.isBasic()) {
            menuItem = MenuFactory.createMenuItem("Relicense");
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean relicensed;
                    UpgradeDialog dialog = new UpgradeDialog(frame);
                    dialog.setVisible(true);
                    boolean bought = dialog.userBought();
                    if (bought && (relicensed = LicenseChecker.relicense())) {
                        ApplicationMode.resetPreference();
                        Application.appModeChanged();
                    }
                }
            });
            this.add(menuItem);
        }
        if (Platform.getType() != Platform.MacOSX) {
            menuItem = MenuFactory.createMenuItem("About");
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Application.showAbout();
                }
            });
            this.add(new JSeparator());
            this.add(menuItem);
        }
    }
}

