/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app.menu;

import com.lightcrafts.app.ComboFrame;
import com.lightcrafts.app.menu.DocumentMenuItem;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.KeyStroke;

abstract class ActionMenuItem
extends DocumentMenuItem {
    private String text = this.getText();
    private KeyStroke accelerator = this.getAccelerator();
    private int mnemonic = this.getMnemonic();

    protected ActionMenuItem(ComboFrame frame, String key) {
        super(frame, key);
        this.setEnabled(false);
    }

    @Override
    void update() {
        Action oldAction = this.getAction();
        Action newAction = this.getDocumentAction();
        if (newAction != oldAction) {
            if (newAction != null) {
                this.setAction(newAction);
                this.setIcon(null);
            } else {
                this.setAction(null);
                this.setText(this.text);
                this.setEnabled(false);
            }
            this.setAccelerator(this.accelerator);
            this.setMnemonic(this.mnemonic);
        }
    }

    abstract Action getDocumentAction();

    @Override
    public void actionPerformed(ActionEvent event) {
    }

    @Override
    protected PropertyChangeListener createActionPropertyChangeListener(Action a) {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String propName = e.getPropertyName();
                if (propName.equals("Name")) {
                    String text = (String)e.getNewValue();
                    ActionMenuItem.this.setText(text);
                    ActionMenuItem.this.repaint();
                } else if (propName.equals("enabled")) {
                    Boolean enabled = (Boolean)e.getNewValue();
                    ActionMenuItem.this.setEnabled(enabled);
                    ActionMenuItem.this.repaint();
                }
            }
        };
    }
}

