/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app.batch;

import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JTextArea;

class BatchText
extends JTextArea {
    private int tabSize;

    BatchText() {
        this.setEditable(false);
    }

    void appendStart(final String message) {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BatchText.this.appendStart(message);
                }
            });
            return;
        }
        this.append(message);
        int newTabSize = this.getTabEquivalent(message);
        if (newTabSize > this.tabSize) {
            this.tabSize = newTabSize;
            this.setTabSize(this.tabSize);
        }
    }

    void appendEnd(final String message) {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BatchText.this.appendEnd(message);
                }
            });
            return;
        }
        this.append("\t -- ");
        this.append(message);
        this.append("\n");
    }

    void appendError(String message) {
        this.appendEnd(message);
    }

    private int getTabEquivalent(String text) {
        Font font = this.getFont();
        FontMetrics metrics = this.getFontMetrics(font);
        int advance = 12;
        Graphics2D g = (Graphics2D)this.getGraphics();
        Rectangle2D bounds = metrics.getStringBounds(text, g);
        double width = bounds.getX() + bounds.getWidth();
        return (int)Math.ceil(width / (double)advance);
    }
}

