/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app;

import com.lightcrafts.utils.xml.XMLException;
import com.lightcrafts.utils.xml.XmlDocument;
import com.lightcrafts.utils.xml.XmlNode;
import java.util.ArrayList;

class TemplateJig {
    private XmlDocument xml;

    TemplateJig(XmlDocument xml) throws XMLException {
        this.xml = xml;
        this.validate();
    }

    private void validate() throws XMLException {
        XmlNode[] regions;
        XmlNode controls = this.getControlNode();
        if (controls == null) {
            throw new XMLException("No Control node");
        }
        XmlNode[] tools = this.getToolNodes();
        if (tools.length != (regions = this.getRegionNodes()).length) {
            throw new XMLException("Tool tags do not match region tags");
        }
    }

    String[] getToolNames() {
        XmlNode[] nodes = this.getToolNodes();
        ArrayList<String> names = new ArrayList<String>();
        for (XmlNode node : nodes) {
            String name = TemplateJig.getToolName(node);
            names.add(name);
        }
        return names.toArray(new String[0]);
    }

    void removeTool(int index) {
        XmlNode controls = this.getControlNode();
        XmlNode tool = this.getToolNode(index);
        XmlNode region = this.getRegionNode(index);
        controls.removeChild(tool);
        controls.removeChild(region);
    }

    private XmlNode getToolNode(int index) {
        return this.getToolNodes()[index];
    }

    private XmlNode getRegionNode(int index) {
        return this.getRegionNodes()[index];
    }

    private XmlNode[] getToolNodes() {
        XmlNode controls = this.getControlNode();
        XmlNode[] nodes = controls.getChildren();
        ArrayList<XmlNode> tools = new ArrayList<XmlNode>();
        for (XmlNode node : nodes) {
            if (!TemplateJig.isToolNode(node)) continue;
            tools.add(node);
        }
        return tools.toArray(new XmlNode[0]);
    }

    private static boolean isToolNode(XmlNode node) {
        return node.hasAttribute("Name");
    }

    private static String getToolName(XmlNode node) {
        assert (TemplateJig.isToolNode(node));
        try {
            return node.getAttribute("Name");
        }
        catch (XMLException e) {
            return null;
        }
    }

    private XmlNode[] getRegionNodes() {
        XmlNode controls = this.getControlNode();
        XmlNode[] nodes = controls.getChildren();
        ArrayList<XmlNode> tools = new ArrayList<XmlNode>();
        for (XmlNode node : nodes) {
            if (!this.isRegionNode(node)) continue;
            tools.add(node);
        }
        return tools.toArray(new XmlNode[0]);
    }

    private boolean isRegionNode(XmlNode node) {
        return node.getName().equals("Region");
    }

    private XmlNode getControlNode() {
        try {
            XmlNode root = this.xml.getRoot();
            XmlNode node = root.getChild("Controls");
            return node;
        }
        catch (XMLException e) {
            return null;
        }
    }
}

