/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app;

import com.lightcrafts.app.Application;
import com.lightcrafts.app.BrowserButton;
import com.lightcrafts.app.ComboFrame;
import com.lightcrafts.app.Locale;
import com.lightcrafts.prefs.ApplicationMode;
import com.lightcrafts.templates.TemplateDatabase;
import com.lightcrafts.templates.TemplateKey;
import com.lightcrafts.ui.browser.view.AbstractImageBrowser;
import com.lightcrafts.ui.editor.EditorMode;
import com.lightcrafts.ui.toolkit.IconFactory;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

class StylesButton
extends BrowserButton {
    private static final Icon Icon = IconFactory.createInvertedIcon(StylesButton.class, "styles.png");
    private static final String ToolTip = Locale.LOCALE.get("StylesButtonToolTip");

    StylesButton(ComboFrame frame) {
        super(frame, Locale.LOCALE.get("StylesButtonText"));
        this.setIcon(Icon);
        this.setToolTipText(ToolTip);
        if (!ApplicationMode.isBasicMode()) {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent event) {
                    ComboFrame frame = StylesButton.this.getComboFrame();
                    AbstractImageBrowser browser = frame.getBrowser();
                    ArrayList<File> files = browser.getSelectedFiles();
                    if (!files.isEmpty()) {
                        StylesButton.this.showPopup(files);
                    }
                }
            });
        } else {
            ApplicationMode.maybeSetToolTip(this);
        }
    }

    @Override
    void updateEnabled() {
        if (ApplicationMode.isBasicMode()) {
            this.setEnabled(false);
        } else {
            super.updateEnabled();
        }
    }

    private void showPopup(final ArrayList<File> files) {
        JPopupMenu popup = new JPopupMenu();
        try {
            LinkedHashSet<String> namespaces = StylesButton.getTemplateNamespaces();
            for (String namespace : namespaces) {
                JMenu menu = new JMenu(namespace);
                LinkedList<TemplateKey> keys = StylesButton.getKeysForNamespace(namespace);
                for (final TemplateKey key : keys) {
                    JMenuItem item = new JMenuItem(key.getName());
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent event) {
                            ComboFrame frame = StylesButton.this.getComboFrame();
                            File[] array = files.toArray(new File[0]);
                            frame.getEditor().setMode(EditorMode.ARROW);
                            Application.applyTemplate(frame, array, key);
                        }
                    });
                    menu.add(item);
                }
                popup.add(menu);
            }
        }
        catch (TemplateDatabase.TemplateException e) {
            e.printStackTrace();
            return;
        }
        Dimension size = this.getSize();
        popup.setAutoscrolls(true);
        popup.show(this, 0, size.height);
    }

    private static LinkedHashSet<String> getTemplateNamespaces() throws TemplateDatabase.TemplateException {
        List<TemplateKey> keys = TemplateDatabase.getTemplateKeys();
        LinkedHashSet<String> namespaces = new LinkedHashSet<String>();
        for (TemplateKey key : keys) {
            String namespace = key.getNamespace();
            namespaces.add(namespace);
        }
        return namespaces;
    }

    private static LinkedList<TemplateKey> getKeysForNamespace(String namespace) throws TemplateDatabase.TemplateException {
        LinkedList<TemplateKey> matches = new LinkedList<TemplateKey>();
        List<TemplateKey> keys = TemplateDatabase.getTemplateKeys();
        for (TemplateKey key : keys) {
            if (!key.getNamespace().equals(namespace)) continue;
            matches.add(key);
        }
        return matches;
    }
}

