/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app;

import com.lightcrafts.app.Locale;
import com.lightcrafts.app.TemplateToolSelector;
import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.image.types.RawImageType;
import com.lightcrafts.platform.Platform;
import com.lightcrafts.templates.TemplateDatabase;
import com.lightcrafts.templates.TemplateKey;
import com.lightcrafts.utils.xml.XMLException;
import com.lightcrafts.utils.xml.XmlDocument;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashSet;
import java.util.List;
import javax.swing.Box;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

class SaveTemplateDialog
extends JDialog {
    private XmlDocument originalTemplate;
    private JComboBox namespaceField;
    private JComboBox nameField;
    private TemplateToolSelector selector;
    private boolean isOkSelected;
    private boolean isDefaultSelected;

    SaveTemplateDialog() {
    }

    TemplateKey showDialog(ImageMetadata meta, XmlDocument template, String nsDefault, JFrame parent) {
        JCheckBox defaultCheck;
        this.originalTemplate = template;
        this.nameField = new JComboBox();
        this.namespaceField = new JComboBox();
        try {
            List<TemplateKey> keys = TemplateDatabase.getTemplateKeys();
            HashSet<String> namespaces = new HashSet<String>();
            for (TemplateKey key : keys) {
                namespaces.add(key.getNamespace());
            }
            for (String namespace : namespaces) {
                this.namespaceField.addItem(namespace);
            }
            this.namespaceField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Object name = SaveTemplateDialog.this.nameField.getSelectedItem();
                    SaveTemplateDialog.this.updateNameField();
                    SaveTemplateDialog.this.nameField.setSelectedItem(name);
                }
            });
        }
        catch (TemplateDatabase.TemplateException e) {
            // empty catch block
        }
        try {
            this.selector = new TemplateToolSelector(template);
        }
        catch (XMLException e) {
            System.err.println("Couldn't initialize TemplateToolSelector");
            e.printStackTrace();
        }
        JPanel textGrid = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 13;
        c.fill = 0;
        textGrid.add((Component)new JLabel(Locale.LOCALE.get("TemplateNameLabel") + ':'), c);
        c.gridx = 1;
        c.gridy = 0;
        c.anchor = 17;
        c.fill = 2;
        textGrid.add((Component)this.nameField, c);
        c.gridx = 0;
        c.gridy = 1;
        c.anchor = 13;
        c.fill = 0;
        textGrid.add((Component)new JLabel(Locale.LOCALE.get("TemplateNamespaceLabel") + ':'), c);
        c.gridx = 1;
        c.gridy = 1;
        c.anchor = 17;
        c.fill = 2;
        textGrid.add((Component)this.namespaceField, c);
        String camera = meta.getCameraMake(true);
        boolean isRaw = meta.getImageType() instanceof RawImageType;
        if (isRaw && camera != null) {
            defaultCheck = new JCheckBox(Locale.LOCALE.get("TemplateAlwaysLabel", camera));
        } else {
            defaultCheck = new JCheckBox(Locale.LOCALE.get("TemplateAlwaysDisabledLabel"));
            defaultCheck.setEnabled(false);
        }
        defaultCheck.setAlignmentX(1.0f);
        Box defaultBox = Box.createHorizontalBox();
        defaultBox.add(defaultCheck);
        defaultBox.add(Box.createHorizontalGlue());
        if (nsDefault == null) {
            nsDefault = Locale.LOCALE.get("TemplateDefaultNamespace");
        }
        int n = 1;
        String defaultName = null;
        do {
            String name = Locale.LOCALE.get("TemplateDefaultNamePattern", Integer.toString(n++));
            TemplateKey key = new TemplateKey(nsDefault, name);
            try {
                TemplateDatabase.getTemplateDocument(key);
            }
            catch (TemplateDatabase.TemplateException e) {
                defaultName = name;
            }
        } while (defaultName == null);
        this.namespaceField.addItem(nsDefault);
        this.namespaceField.setSelectedItem(nsDefault);
        this.namespaceField.setEditable(true);
        this.nameField.setPreferredSize(new Dimension(160, this.namespaceField.getPreferredSize().height));
        this.nameField.getEditor().selectAll();
        this.nameField.addItem(defaultName);
        this.nameField.setSelectedItem(defaultName);
        this.nameField.setEditable(true);
        this.nameField.setPreferredSize(new Dimension(160, this.nameField.getPreferredSize().height));
        this.nameField.getEditor().selectAll();
        Box messageBox = Box.createVerticalBox();
        messageBox.add(textGrid);
        messageBox.add(defaultBox);
        messageBox.add(Box.createVerticalStrut(8));
        if (this.selector != null) {
            messageBox.add(this.selector);
        }
        JButton okButton = new JButton(Locale.LOCALE.get("TemplateSaveOption"));
        JButton cancelButton = new JButton(Locale.LOCALE.get("TemplateCancelOption"));
        JOptionPane pane = new JOptionPane(messageBox, 3, 2, null, new Object[]{okButton, cancelButton}, null);
        Dimension size = pane.getPreferredSize();
        size = new Dimension(Math.max(size.width, 400), size.height);
        pane.setPreferredSize(size);
        final JDialog dialog = new JDialog(parent);
        dialog.setTitle(Locale.LOCALE.get("TemplateSaveDialogTitle"));
        dialog.setContentPane(pane);
        dialog.getRootPane().setDefaultButton(okButton);
        pane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ComboBoxEditor editor = SaveTemplateDialog.this.nameField.getEditor();
                JTextField text = (JTextField)editor.getEditorComponent();
                String name = text.getText();
                SaveTemplateDialog.this.nameField.setSelectedItem(name);
                SaveTemplateDialog.this.isOkSelected = true;
                dialog.setVisible(false);
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                dialog.setVisible(false);
            }
        });
        dialog.setModal(true);
        dialog.setResizable(true);
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        this.isDefaultSelected = defaultCheck.isSelected();
        if (!this.isOkSelected) {
            return null;
        }
        if (this.nameField.getEditor().getEditorComponent().isFocusOwner()) {
            KeyboardFocusManager focus = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            focus.upFocusCycle();
        }
        return new TemplateKey(this.getNamespaceText(), this.getNameText());
    }

    String getNameText() {
        Object selected = this.nameField.getSelectedItem();
        return selected != null ? selected.toString() : "";
    }

    String getNamespaceText() {
        Object selected = this.namespaceField.getSelectedItem();
        return selected != null ? selected.toString() : "";
    }

    boolean isDefaultSelected() {
        return this.isDefaultSelected;
    }

    XmlDocument getModifiedTemplate() {
        if (this.selector != null) {
            return this.selector.getModifiedTemplate();
        }
        return new XmlDocument(this.originalTemplate);
    }

    private void updateNameField() {
        String namespace = this.getNamespaceText();
        this.nameField.removeAllItems();
        try {
            List<TemplateKey> descs = TemplateDatabase.getTemplateKeys();
            for (TemplateKey desc : descs) {
                if (!namespace.equals(desc.getNamespace())) continue;
                this.nameField.addItem(desc.getName());
            }
        }
        catch (TemplateDatabase.TemplateException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel(Platform.getPlatform().getLookAndFeel());
        XmlDocument doc = new XmlDocument(new FileInputStream("/Users/anton/test/1/test.lzn"));
        ImageInfo info = ImageInfo.getInstanceFor(new File("/Users/anton/test/1/test.crw"));
        ImageMetadata meta = info.getMetadata();
        SaveTemplateDialog dialog = new SaveTemplateDialog();
        dialog.showDialog(meta, doc, null, null);
        System.out.println("name=" + dialog.getNameText());
        System.out.println("namespace=" + dialog.getNamespaceText());
        System.exit(0);
    }
}

