/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app;

import com.lightcrafts.app.other.OtherApplication;
import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.export.ImageExportOptions;
import com.lightcrafts.image.export.ImageFileExportOptions;
import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.image.types.JPEGImageType;
import com.lightcrafts.image.types.LZNImageType;
import com.lightcrafts.image.types.TIFFImageType;
import com.lightcrafts.model.Engine;
import com.lightcrafts.ui.editor.Document;
import com.lightcrafts.ui.export.SaveOptions;
import com.lightcrafts.utils.LightCraftsException;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;

public class OtherApplicationShim {
    public static boolean shouldSaveDirectly(Document doc) {
        OtherApplication app = (OtherApplication)doc.getSource();
        if (app != null) {
            ImageInfo info = OtherApplicationShim.getImageInfo(doc);
            return app.shouldSaveDirectly(info);
        }
        return false;
    }

    static SaveOptions createExportOptions(Document doc) {
        OtherApplication app = (OtherApplication)doc.getSource();
        ImageInfo info = OtherApplicationShim.getImageInfo(doc);
        Engine engine = doc.getEngine();
        Dimension size = engine.getNaturalSize();
        try {
            ImageFileExportOptions export = app.createExportOptions(info, size);
            if (export != null) {
                SaveOptions options = OtherApplicationShim.getSaveOptions(export);
                options.setShouldSaveDirectly(true);
                return options;
            }
        }
        catch (IOException e) {
        }
        catch (LightCraftsException e) {
            // empty catch block
        }
        return null;
    }

    private static ImageInfo getImageInfo(Document doc) {
        ImageMetadata meta = doc.getMetadata();
        File file = meta.getFile();
        return ImageInfo.getInstanceFor(file);
    }

    private static SaveOptions getSaveOptions(ImageExportOptions export) {
        if (export instanceof LZNImageType.ExportOptions) {
            return SaveOptions.createLzn(export.getExportFile());
        }
        if (export instanceof JPEGImageType.ExportOptions) {
            return SaveOptions.createSidecarJpeg(export);
        }
        if (export instanceof TIFFImageType.ExportOptions) {
            TIFFImageType.ExportOptions tiffOptions = (TIFFImageType.ExportOptions)export;
            if (tiffOptions.multilayer.getValue()) {
                return SaveOptions.createMultilayerTiff(export);
            }
            return SaveOptions.createSidecarTiff(export);
        }
        return null;
    }
}

