/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app;

import com.lightcrafts.app.Application;
import com.lightcrafts.app.ComboFrame;
import com.lightcrafts.app.Locale;
import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.types.LZNImageType;
import com.lightcrafts.jai.JAIContext;
import com.lightcrafts.jai.opimage.CachedImage;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.model.Engine;
import com.lightcrafts.ui.browser.model.PreviewUpdater;
import com.lightcrafts.ui.editor.Document;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.image.RenderedImage;
import java.io.File;

class LznPreviewProvider
implements PreviewUpdater.Provider {
    private ComboFrame frame;

    LznPreviewProvider(ComboFrame frame) {
        this.frame = frame;
    }

    @Override
    public RenderedImage getPreviewImage(File file, int size) {
        ImageInfo info = ImageInfo.getInstanceFor(file);
        try {
            if (info.getImageType() != LZNImageType.INSTANCE) {
                return null;
            }
            Document doc = Application.createDocumentHeadless(file);
            Engine engine = doc.getEngine();
            Dimension dim = new Dimension(size, size);
            Object preview = engine.getRendering(dim);
            preview = new CachedImage((PlanarImage)preview, JAIContext.fileCache);
            doc.dispose();
            return preview;
        }
        catch (Throwable t) {
            System.err.println("Error generating preview for " + file.getName() + ":");
            t.printStackTrace();
            return null;
        }
    }

    @Override
    public void previewStarted() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                LznPreviewProvider.this.frame.showWait(Locale.LOCALE.get("PreviewMessage"));
            }
        });
    }

    @Override
    public void previewEnded() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                LznPreviewProvider.this.frame.hideWait();
            }
        });
    }
}

