/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app;

import com.lightcrafts.ui.browser.model.ImageDatum;
import com.lightcrafts.ui.browser.model.ImageGroup;
import com.lightcrafts.ui.browser.model.ImageGroupProvider;
import com.lightcrafts.ui.editor.DocumentReader;
import com.lightcrafts.ui.editor.assoc.DocumentDatabase;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class LznImageGroupProvider
implements ImageGroupProvider {
    LznImageGroupProvider() {
    }

    @Override
    public void cluster(List<ImageDatum> datums) {
        for (ImageDatum datum : datums) {
            datum.newGroup();
        }
        Map<File, ImageDatum> fileDatumMap = LznImageGroupProvider.getFileDatumMap(datums);
        for (ImageDatum datum : datums) {
            File file = datum.getFile();
            if (DocumentReader.isReadable(file)) continue;
            List<File> docs = DocumentDatabase.getDocumentsForImage(file);
            ImageGroup group = datum.newGroup();
            for (File doc : docs) {
                ImageDatum docDatum = fileDatumMap.get(doc);
                if (docDatum == null || !DocumentReader.isReadable(doc)) continue;
                docDatum.setGroup(group);
            }
        }
    }

    static Map<File, ImageDatum> getFileDatumMap(Collection<ImageDatum> datums) {
        HashMap<File, ImageDatum> map = new HashMap<File, ImageDatum>();
        for (ImageDatum datum : datums) {
            File file = datum.getFile();
            map.put(file, datum);
        }
        return map;
    }
}

