/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app;

import com.lightcrafts.app.Locale;
import com.lightcrafts.platform.Platform;
import com.lightcrafts.ui.toolkit.CoolButton;
import com.lightcrafts.ui.toolkit.IconFactory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;

class HelpButton
extends CoolButton {
    private static final Icon Icon = IconFactory.createInvertedIcon(HelpButton.class, "info.png");
    private static final String ToolTip = Locale.LOCALE.get("HelpButtonToolTip");
    private String topic;

    HelpButton() {
        this.setIcon(Icon);
        this.setToolTipText(ToolTip);
        this.setMode(Mode.Combo);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Platform platform = Platform.getPlatform();
                platform.showHelpTopic(HelpButton.this.topic);
            }
        });
    }

    void setMode(Mode mode) {
        this.topic = null;
        switch (mode) {
            case Browse: {
                this.topic = "Anatomy-Browser";
                break;
            }
            case Edit: {
                this.topic = "Anatomy-Editor";
            }
        }
    }

    static enum Mode {
        Browse,
        Edit,
        Combo,
        Basic;

    }
}

