/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app;

import com.lightcrafts.app.Application;
import com.lightcrafts.app.BrowserButton;
import com.lightcrafts.app.ComboFrame;
import com.lightcrafts.app.Locale;
import com.lightcrafts.app.UndoButton;
import com.lightcrafts.prefs.ApplicationMode;
import com.lightcrafts.ui.browser.view.AbstractImageBrowser;
import com.lightcrafts.ui.editor.EditorMode;
import com.lightcrafts.ui.toolkit.IconFactory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.Icon;

class ExportButton
extends BrowserButton {
    private static final Icon Icon = IconFactory.createInvertedIcon(UndoButton.class, "convert.png");
    private static final String ToolTip = Locale.LOCALE.get("ExportButtonToolTip");

    ExportButton(ComboFrame frame) {
        super(frame, Icon);
        this.setToolTipText(ToolTip);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ComboFrame frame = ExportButton.this.getComboFrame();
                AbstractImageBrowser browser = frame.getBrowser();
                ArrayList<File> list = browser.getSelectedFiles();
                if (!list.isEmpty()) {
                    frame.getEditor().setMode(EditorMode.ARROW);
                    File[] files = list.toArray(new File[0]);
                    Application.export(frame, files);
                }
            }
        });
        ApplicationMode.maybeSetToolTip(this);
    }

    @Override
    void updateEnabled() {
        if (ApplicationMode.isBasicMode()) {
            this.setEnabled(false);
        } else {
            super.updateEnabled();
        }
    }
}

