/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app;

import com.lightcrafts.app.Locale;
import com.lightcrafts.image.ImageFilenameFilter;
import com.lightcrafts.platform.FileChooser;
import com.lightcrafts.platform.Platform;
import com.lightcrafts.ui.toolkit.TextAreaFactory;
import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class DocumentImageSelector {
    private static Platform Env = Platform.getPlatform();
    private static File file;

    DocumentImageSelector() {
    }

    static File chooseImageFile(File docFile, File oldImageFile, File[] imageFiles, final File chooserFile, final Frame parent) {
        if (imageFiles.length == 0) {
            return DocumentImageSelector.chooseImageFile(docFile, oldImageFile, chooserFile, parent);
        }
        if (imageFiles.length == 1) {
            return DocumentImageSelector.chooseImageFile(docFile, oldImageFile, imageFiles[0], chooserFile, parent);
        }
        String bigText = Locale.LOCALE.get("ImageSelectorMessage1Major", docFile.getName(), oldImageFile.getAbsolutePath());
        String smallText = Locale.LOCALE.get("ImageSelectorMessage1Minor");
        JTextArea bigTextComp = TextAreaFactory.createTextArea(bigText, 30);
        bigTextComp.setFont(bigTextComp.getFont().deriveFont(1));
        JTextArea smallTextComp = TextAreaFactory.createTextArea(smallText, 30);
        Object[] listEntries = new Object[imageFiles.length];
        for (int n = 0; n < imageFiles.length; ++n) {
            File file = new File(imageFiles[n], ""){

                @Override
                public String toString() {
                    return this.getAbsolutePath();
                }
            };
            listEntries[n] = file;
        }
        final JList<Object> list = new JList<Object>(listEntries);
        list.setSelectionMode(0);
        list.setBorder(BorderFactory.createLineBorder(Color.black));
        final JButton useThis = new JButton(Locale.LOCALE.get("ImageSelector1UseOption"));
        JButton search = new JButton(Locale.LOCALE.get("ImageSelectorSearchOption"));
        JButton cancel = new JButton(Locale.LOCALE.get("ImageSelectorCancelOption"));
        list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                Object selection = list.getSelectedValue();
                useThis.setEnabled(selection != null);
            }
        });
        useThis.setEnabled(false);
        final String findTitle = Locale.LOCALE.get("ImageSelectorFindDialogTitle", oldImageFile.getName());
        final JDialog dialog = new JDialog(parent, findTitle, true);
        dialog.setResizable(false);
        useThis.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                file = (File)list.getSelectedValue();
                dialog.dispose();
            }
        });
        search.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                FileChooser chooser = Env.getFileChooser();
                file = chooser.openFile(findTitle, chooserFile, parent, ImageFilenameFilter.INSTANCE);
                if (file != null) {
                    dialog.dispose();
                }
            }
        });
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                file = null;
                dialog.dispose();
            }
        });
        JPanel contents = new JPanel();
        contents.setLayout(new BoxLayout(contents, 1));
        contents.add(bigTextComp);
        contents.add(Box.createVerticalStrut(6));
        contents.add(smallTextComp);
        contents.add(Box.createVerticalStrut(6));
        contents.add(list);
        contents.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        bigTextComp.setBackground(contents.getBackground());
        smallTextComp.setBackground(contents.getBackground());
        JOptionPane option = new JOptionPane(contents, 3);
        option.setOptions(new Object[]{cancel, search, useThis});
        dialog.add(option);
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        return file;
    }

    static File chooseImageFile(File docFile, File oldImageFile, File newImageFile, File chooserFile, Frame parent) {
        int result = Env.getAlertDialog().showAlert(parent, Locale.LOCALE.get("ImageSelectorMessage2Major", docFile.getName(), oldImageFile.getName(), newImageFile.getAbsolutePath()), Locale.LOCALE.get("ImageSelectorMessage2Minor"), 2, Locale.LOCALE.get("ImageSelector2UseOption", newImageFile.getName()), Locale.LOCALE.get("ImageSelectorSearchOption"), Locale.LOCALE.get("ImageSelectorCancelOption"));
        if (result == 0) {
            file = newImageFile;
        } else if (result == 1) {
            FileChooser chooser = Env.getFileChooser();
            String title = Locale.LOCALE.get("ImageSelectorFindDialogTitle", oldImageFile.getName());
            file = chooser.openFile(title, chooserFile, parent, ImageFilenameFilter.INSTANCE);
        } else {
            file = null;
        }
        return file;
    }

    static File chooseImageFile(File docFile, File oldImageFile, File chooserFile, Frame parent) {
        int result = Env.getAlertDialog().showAlert(parent, Locale.LOCALE.get("ImageSelectorMessage3Major", docFile.getName(), oldImageFile.getName()), Locale.LOCALE.get("ImageSelectorMessage3Minor"), 2, Locale.LOCALE.get("ImageSelectorSearchOption"), Locale.LOCALE.get("ImageSelectorCancelOption"));
        if (result == 0) {
            FileChooser chooser = Env.getFileChooser();
            String title = Locale.LOCALE.get("ImageSelectorFindDialogTitle", oldImageFile.getName());
            file = chooser.openFile(title, chooserFile, parent, ImageFilenameFilter.INSTANCE);
        } else {
            file = null;
        }
        return file;
    }

    public static void main(String[] args) {
        File docFile = new File("/DocumentFile.lzn");
        File oldImageFile = new File("/OldImage.tif");
        File[] files = new File[]{new File("a"), new File("b"), new File("c")};
        File newImageFile = DocumentImageSelector.chooseImageFile(docFile, oldImageFile, files, null, null);
        System.out.println(newImageFile);
        System.exit(0);
    }
}

