/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app;

import com.lightcrafts.app.AbstractLayout;
import com.lightcrafts.app.ComboFrame;
import com.lightcrafts.app.HelpButton;
import com.lightcrafts.app.LayoutHeader;
import com.lightcrafts.app.Locale;
import com.lightcrafts.ui.browser.ctrls.BrowserControls;
import com.lightcrafts.ui.browser.ctrls.FolderCtrl;
import com.lightcrafts.ui.browser.view.ImageBrowserFooter;
import com.lightcrafts.ui.browser.view.ImageBrowserScrollPane;
import com.lightcrafts.ui.editor.DocUndoHistory;
import com.lightcrafts.ui.editor.Editor;
import com.lightcrafts.ui.layout.FadingTabConfiguration;
import com.lightcrafts.ui.layout.SmartSplitPane;
import com.lightcrafts.ui.metadata2.MetadataScroll;
import com.lightcrafts.ui.templates.TemplateControl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;

class BrowserLayout
extends AbstractLayout {
    private static final int MiddleDividerLoc = -1;
    private static final String MiddleDividerKey = "middleDividerLocation";
    private SmartSplitPane middleSplit;
    private JPanel browserPanel;
    private BrowserControls browserCtrls;
    private JComponent toolBar;
    private ImageBrowserFooter footer;
    private final ComboFrame frame;

    BrowserLayout(TemplateControl templates, Editor editor, DocUndoHistory history, FolderCtrl folders, ImageBrowserScrollPane browser, MetadataScroll info, LayoutHeader header, ComboFrame frame) {
        super(AbstractLayout.LayoutType.Browser, templates, editor, history, folders, browser, info, header);
        this.frame = frame;
        this.initToolBar();
        this.initFaders();
        this.browserPanel = new JPanel(new BorderLayout());
        this.browserPanel.add(browser);
        this.browserPanel.add((Component)this.toolBar, "North");
        this.footer = new ImageBrowserFooter();
        this.initFooter();
        browser.getBrowser().addBrowserListener(this.footer);
        this.browserPanel.add((Component)this.footer, "South");
        this.middleSplit = new SmartSplitPane(MiddleDividerKey, null);
        this.middleSplit.setLeftComponent(editor.getImage());
        this.middleSplit.setRightComponent(this.browserPanel);
        this.middleSplit.setResizeWeight(0.5);
        this.middleSplit.restoreFromPrefs(-1, 0);
        this.leftSplit.setLeftComponent(this.leftFader);
        this.leftSplit.setRightComponent(this.middleSplit);
        this.leftSplit.setResizeWeight(0.0);
        this.rightSplit.setLeftComponent(this.leftSplit);
        this.rightSplit.setRightComponent(this.rightFader);
        this.rightSplit.setResizeWeight(1.0);
        this.restoreLayout();
        String firstLayoutTag = "FirstLayout";
        Preferences prefs = Preferences.userNodeForPackage(BrowserLayout.class);
        boolean isFirstLayout = prefs.getBoolean(firstLayoutTag, true);
        if (isFirstLayout) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Dimension size = BrowserLayout.this.middleSplit.getSize();
                    BrowserLayout.this.middleSplit.setDividerLocation(size.height - 220);
                }
            });
            prefs.putBoolean(firstLayoutTag, false);
        }
        HelpButton help = new HelpButton();
        help.setAlignmentX(1.0f);
        this.setLayout(new BorderLayout());
        this.add(this.rightSplit);
        this.add((Component)this.header, "North");
        this.add((Component)this.leftFader.getButtonContainer(), "West");
        this.add((Component)this.rightFader.getButtonContainer(), "East");
    }

    @Override
    void updateEditor(TemplateControl templates, Editor editor, DocUndoHistory history) {
        super.updateEditor(templates, editor, history);
        this.middleSplit.setLeftFrozenDivider(editor.getImage());
    }

    @Override
    void updateBrowser() {
        this.browserPanel.remove(this.toolBar);
        this.browser.getBrowser().removeBrowserListener(this.footer);
        this.browserPanel.remove(this.footer);
        this.initToolBar();
        this.browserPanel.add((Component)this.toolBar, "North");
        this.footer = new ImageBrowserFooter();
        this.initFooter();
        this.browser.getBrowser().addBrowserListener(this.footer);
        this.browserPanel.add((Component)this.footer, "South");
        this.validate();
    }

    private void initFooter() {
        ArrayList<File> files = this.browser.getBrowser().getSelectedFiles();
        File leadFile = this.browser.getBrowser().getLeadSelectedFile();
        int count = this.browser.getBrowser().getImageCount();
        this.footer.setSelectedFiles(leadFile, files, count);
    }

    void ensureFoldersVisible() {
        String foldersLabel = Locale.LOCALE.get("FoldersTabLabel");
        this.leftFader.setSelected(foldersLabel);
    }

    private void initToolBar() {
        if (this.browserCtrls != null) {
            this.browserCtrls.dispose();
        }
        this.browserCtrls = new BrowserControls(this.browser, this.frame);
        this.toolBar = Box.createHorizontalBox();
        this.toolBar.add(this.browserCtrls);
    }

    @Override
    List<FadingTabConfiguration> getLeftFaderConfs() {
        String foldersLabel = Locale.LOCALE.get("FoldersTabLabel");
        String foldersTip = Locale.LOCALE.get("FoldersTabToolTip");
        LinkedList<FadingTabConfiguration> tabs = new LinkedList<FadingTabConfiguration>();
        tabs.add(new FadingTabConfiguration(this.folders, foldersLabel, foldersTip));
        return tabs;
    }

    @Override
    List<FadingTabConfiguration> getRightFaderConfs() {
        String infoLabel = Locale.LOCALE.get("InfoTabLabel");
        String infoTip = Locale.LOCALE.get("InfoTabToolTip");
        LinkedList<FadingTabConfiguration> tabs = new LinkedList<FadingTabConfiguration>();
        tabs.add(new FadingTabConfiguration(this.info, infoLabel, infoTip));
        return tabs;
    }

    @Override
    String getDefaultLeftFaderTab() {
        return Locale.LOCALE.get("FoldersTabLabel");
    }

    @Override
    String getDefaultRightFaderTab() {
        return Locale.LOCALE.get("InfoTabLabel");
    }

    @Override
    void dispose() {
        super.dispose();
        this.browserCtrls.dispose();
    }
}

