/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app;

import com.lightcrafts.app.ComboFrame;
import com.lightcrafts.app.Locale;
import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.ui.toolkit.CoolButton;
import com.lightcrafts.ui.toolkit.CoolToggleButton;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JToggleButton;

class BrowseEditButtons
extends Box {
    private static final String BrowseText = Locale.LOCALE.get("BrowseModeButtonText");
    private static final String EditText = Locale.LOCALE.get("EditModeButtonText");
    private static final String BrowseTip = Locale.LOCALE.get("BrowseModeButtonToolTip");
    private static final String EditTip = Locale.LOCALE.get("EditModeButtonToolTip");
    private JToggleButton browse = new CoolToggleButton(CoolButton.ButtonStyle.LEFT);
    private JToggleButton edit;
    private boolean isProgrammaticChange;

    BrowseEditButtons(final ComboFrame frame) {
        super(0);
        this.browse.setText(BrowseText);
        this.browse.setToolTipText(BrowseTip);
        Font font = this.browse.getFont();
        font = font.deriveFont(16.0f);
        this.browse.setFont(font);
        this.edit = new CoolToggleButton(CoolButton.ButtonStyle.RIGHT);
        this.edit.setText(EditText);
        this.edit.setToolTipText(EditTip);
        this.edit.setFont(font);
        ButtonGroup group = new ButtonGroup();
        group.add(this.browse);
        group.add(this.edit);
        this.browse.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    if (!BrowseEditButtons.this.isProgrammaticChange) {
                        BrowseEditButtons.this.isProgrammaticChange = true;
                        boolean switched = frame.showBrowserPerspective();
                        if (!switched) {
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    BrowseEditButtons.this.isProgrammaticChange = true;
                                    BrowseEditButtons.this.edit.doClick();
                                    BrowseEditButtons.this.isProgrammaticChange = false;
                                }
                            });
                        }
                        BrowseEditButtons.this.isProgrammaticChange = false;
                    }
                    BrowseEditButtons.this.browse.setForeground(LightZoneSkin.Colors.LZOrange);
                } else {
                    BrowseEditButtons.this.browse.setForeground(Color.lightGray);
                }
            }
        });
        this.edit.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    if (!BrowseEditButtons.this.isProgrammaticChange) {
                        BrowseEditButtons.this.isProgrammaticChange = true;
                        boolean switched = frame.openSelected();
                        if (!switched) {
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    BrowseEditButtons.this.isProgrammaticChange = true;
                                    BrowseEditButtons.this.browse.doClick();
                                    BrowseEditButtons.this.isProgrammaticChange = false;
                                }
                            });
                        }
                        BrowseEditButtons.this.isProgrammaticChange = false;
                    }
                    BrowseEditButtons.this.edit.setForeground(LightZoneSkin.Colors.LZOrange);
                } else {
                    BrowseEditButtons.this.edit.setForeground(Color.lightGray);
                }
            }
        });
        this.add(this.browse);
        this.add(this.edit);
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
    }

    void setEditSelected() {
        this.isProgrammaticChange = true;
        this.edit.setSelected(true);
        this.isProgrammaticChange = false;
    }

    void setBrowseSelected() {
        this.isProgrammaticChange = true;
        this.browse.setSelected(true);
        this.isProgrammaticChange = false;
    }
}

