/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app;

import com.lightcrafts.app.AwtWatchdog;
import com.lightcrafts.app.ComboFrame;
import com.lightcrafts.app.Displays;
import com.lightcrafts.app.DocumentImageSelector;
import com.lightcrafts.app.DocumentInitializer;
import com.lightcrafts.app.DocumentInitializerListener;
import com.lightcrafts.app.DocumentWriter;
import com.lightcrafts.app.ExceptionDialog;
import com.lightcrafts.app.Locale;
import com.lightcrafts.app.OtherApplicationShim;
import com.lightcrafts.app.SaveResult;
import com.lightcrafts.app.SaveTemplateDialog;
import com.lightcrafts.app.StartupCrash;
import com.lightcrafts.app.VideoLearningCenterDialog;
import com.lightcrafts.app.batch.BatchConfig;
import com.lightcrafts.app.batch.BatchConfigurator;
import com.lightcrafts.app.batch.BatchProcessor;
import com.lightcrafts.app.batch.SendDialog;
import com.lightcrafts.app.menu.ComboFrameMenuBar;
import com.lightcrafts.app.menu.WindowMenu;
import com.lightcrafts.app.other.OtherApplication;
import com.lightcrafts.image.BadImageFileException;
import com.lightcrafts.image.ColorProfileException;
import com.lightcrafts.image.ImageFilenameFilter;
import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.UnknownImageTypeException;
import com.lightcrafts.image.UnsupportedColorProfileException;
import com.lightcrafts.image.export.ImageExportOptions;
import com.lightcrafts.image.export.ImageFileExportOptions;
import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.image.types.ImageType;
import com.lightcrafts.image.types.JPEGImageType;
import com.lightcrafts.image.types.LZNImageType;
import com.lightcrafts.image.types.RawImageType;
import com.lightcrafts.image.types.TIFFImageType;
import com.lightcrafts.license.LicenseChecker;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.model.Engine;
import com.lightcrafts.model.OperationType;
import com.lightcrafts.model.PrintSettings;
import com.lightcrafts.model.Scale;
import com.lightcrafts.platform.FileChooser;
import com.lightcrafts.platform.Platform;
import com.lightcrafts.platform.PrinterLayer;
import com.lightcrafts.platform.ProgressDialog;
import com.lightcrafts.prefs.ApplicationMode;
import com.lightcrafts.prefs.PreferencesDialog;
import com.lightcrafts.splash.AboutDialog;
import com.lightcrafts.splash.SplashWindow;
import com.lightcrafts.splash.StartupProgress;
import com.lightcrafts.templates.TemplateDatabase;
import com.lightcrafts.templates.TemplateKey;
import com.lightcrafts.ui.editor.Document;
import com.lightcrafts.ui.editor.DocumentReader;
import com.lightcrafts.ui.editor.Editor;
import com.lightcrafts.ui.editor.ScaleModel;
import com.lightcrafts.ui.editor.TemporaryEditorCommitState;
import com.lightcrafts.ui.editor.assoc.DocumentDatabase;
import com.lightcrafts.ui.editor.assoc.DocumentInterpreter;
import com.lightcrafts.ui.export.ExportLogic;
import com.lightcrafts.ui.export.ExportNameUtility;
import com.lightcrafts.ui.export.SaveOptions;
import com.lightcrafts.ui.print.PrintLayoutDialog;
import com.lightcrafts.ui.print.PrintLayoutModel;
import com.lightcrafts.ui.templates.TemplateList;
import com.lightcrafts.utils.TerseLoggingHandler;
import com.lightcrafts.utils.UserCanceledException;
import com.lightcrafts.utils.file.FileUtil;
import com.lightcrafts.utils.thread.ProgressThread;
import com.lightcrafts.utils.xml.XMLException;
import com.lightcrafts.utils.xml.XmlDocument;
import com.lightcrafts.utils.xml.XmlNode;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.PrinterAbortException;
import java.awt.print.PrinterException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class Application {
    public static final String LznNamespace = "http://www.lightcrafts.com/lightzone/LightZoneTransform";
    public static final String LznPrefix = "lzn";
    private static Rectangle InitialFrameBounds;
    private static int InitialFrameState;
    private static StartupProgress Startup;
    private static int RecentCount;
    private static LinkedList<ComboFrame> Current;
    private static LinkedList<File> RecentFiles;
    private static LinkedList<File> RecentFolders;
    private static File LastOpenPath;
    private static SaveOptions LastSaveOptions;
    private static ImageExportOptions LastExportOptions;
    private static PrintLayoutModel LastPrintLayout;
    private static boolean IsQuitting;
    private static Platform Env;
    private static final int SAVE_YES = 0;
    private static final int SAVE_CANCEL = 1;
    private static final String FirstLaunchTag = "FirstLaunch";
    private static final String RecentFileTag = "RecentFile";
    private static final String RecentFolderTag = "RecentFolder";
    private static final String CurrentTag = "Current";
    private static final String OpenTag = "Open";
    private static final String SaveTag = "Save";
    private static final String PrintTag = "Print";
    private static final String ExportTag = "Export";
    private static final String FrameBoundsTag = "Bounds";
    private static final String FrameStateTag = "State";

    public static void setStartupProgress(StartupProgress startup) {
        Startup = startup;
    }

    public static void open(ComboFrame parent) {
        FileChooser chooser = Env.getFileChooser();
        File file = chooser.openFile(Locale.LOCALE.get("OpenFileDialogTitle"), LastOpenPath, parent, ImageFilenameFilter.INSTANCE);
        if (file != null) {
            ComboFrame frame = Application.getFrameForFile(file);
            if (frame != parent) {
                Application.open(file, parent, null);
            } else {
                parent.requestFocus();
            }
            LastOpenPath = file.getParentFile();
            Application.savePrefs();
        }
    }

    public static void open(ComboFrame frame, File file) {
        ComboFrame priorFrame = Application.getFrameForFile(file);
        if (priorFrame != null) {
            priorFrame.requestFocus();
            return;
        }
        if (frame == null && (frame = Application.getActiveFrame()) == null) {
            frame = Application.openEmpty();
        }
        Application.open(file, frame, null);
    }

    public static void openFrom(File file, OtherApplication otherApp) {
        ComboFrame priorFrame = Application.getFrameForFile(file);
        if (priorFrame != null) {
            priorFrame.requestFocus();
            return;
        }
        ComboFrame frame = Application.getActiveFrame();
        if (frame == null) {
            frame = Application.openEmpty();
        }
        Application.open(file, frame, otherApp);
    }

    public static void reOpen(ComboFrame frame) {
        Document doc = frame.getDocument();
        File file = doc.getFile();
        ImageMetadata meta = doc.getMetadata();
        OtherApplication otherApp = (OtherApplication)doc.getSource();
        if (file != null) {
            Application.open(file, frame, otherApp);
        } else {
            Application.open(meta.getFile(), frame, otherApp);
        }
    }

    static void open(File file, final ComboFrame frame, final OtherApplication otherApp) {
        Document doc = frame.getDocument();
        if (doc != null && doc.isDirty()) {
            int result = Application.askToSaveChanges(frame);
            if (result == 0) {
                boolean saved = Application.save(frame, true);
                if (!saved) {
                    return;
                }
            } else {
                if (result == 1) {
                    return;
                }
                if (result < 0) {
                    return;
                }
            }
        }
        DocumentInitializer.createDocument(file, frame, new DocumentInitializerListener(){

            @Override
            public void documentStarted() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void documentInitialized(Document doc) {
                if (doc != null) {
                    frame.pause();
                    try {
                        doc.setSource(otherApp);
                        ComboFrame docFrame = Application.show(doc, frame);
                        docFrame.validate();
                        Application.setInitialSize(doc);
                    }
                    finally {
                        frame.resume();
                    }
                }
            }

            @Override
            public void documentCancelled() {
                System.err.println("Document cancelled");
            }

            @Override
            public void documentFailed(Throwable t) {
                Application.handleDocInitError(t, frame);
            }
        });
    }

    private static void handleDocInitError(Throwable t, ComboFrame frame) {
        try {
            throw t;
        }
        catch (BadImageFileException e) {
            Application.showError(Locale.LOCALE.get("InvalidImageFileError"), e, frame);
        }
        catch (Document.MissingImageFileException e) {
            Application.showError(Locale.LOCALE.get("UnknownOriginalFileError"), e, frame);
        }
        catch (XMLException e) {
            Application.showError(Locale.LOCALE.get("MalformedLznFileError"), e, frame);
        }
        catch (IOException e) {
            Application.showError(Locale.LOCALE.get("IOFileError"), e, frame);
        }
        catch (OutOfMemoryError e) {
            Application.showError(Locale.LOCALE.get("InsufficientMemoryFileError"), e, frame);
        }
        catch (UnknownImageTypeException e) {
            Application.showError(Locale.LOCALE.get("ImageFormatFileError"), e, frame);
        }
        catch (UnsupportedColorProfileException e) {
            Application.showError(Locale.LOCALE.get("UnsupportedCameraFileError"), e, frame);
        }
        catch (ColorProfileException e) {
            Application.showError(Locale.LOCALE.get("UnsupportedColorProfileFileError"), e, frame);
        }
        catch (Throwable e) {
            Application.showError(Locale.LOCALE.get("UnknownFileError"), e, frame);
        }
    }

    static Document createDocument(File file, ComboFrame frame, ProgressThread cancel) throws UserCanceledException, XMLException, UnknownImageTypeException, IOException, BadImageFileException, ColorProfileException, Document.MissingImageFileException {
        boolean oldLzn;
        Document doc;
        DocumentReader.Interpretation interp = DocumentReader.read(file);
        if (interp != null) {
            XmlDocument xml = interp.xml;
            File imageFile = interp.imageFile;
            ImageInfo info = interp.info;
            if (imageFile == null) {
                if (file.getName().endsWith(".lzt")) {
                    int option = Env.getAlertDialog().showAlert((Frame)frame, Locale.LOCALE.get("TemplateQuestionMajor"), Locale.LOCALE.get("TemplateQuestionMinor"), 1, Locale.LOCALE.get("TemplateImportOption"), Locale.LOCALE.get("TemplateOpenOption"), Locale.LOCALE.get("TemplateCancelOption"));
                    if (option == 0) {
                        try {
                            FileInputStream in = new FileInputStream(file);
                            XmlDocument template = new XmlDocument(in);
                            TemplateKey key = TemplateKey.importKey(file);
                            TemplateDatabase.addTemplateDocument(template, key, true);
                            TemplateList.showDialog(frame);
                        }
                        catch (Throwable t) {
                            Application.showError(Locale.LOCALE.get("TemplateImportError", file.getName()), t, frame);
                        }
                        return null;
                    }
                    if (option == 2) {
                        return null;
                    }
                }
                doc = new Document(xml, null, info, cancel);
            } else {
                boolean hunted = false;
                if (!imageFile.exists()) {
                    File docDir;
                    File altImageFile;
                    String imageFileName = imageFile.getAbsolutePath().replaceAll(".*[/\\\\]", "");
                    File[] files = DocumentDatabase.findImageFiles(imageFileName);
                    if (files.length == 0 && (altImageFile = new File(docDir = file.getParentFile(), imageFileName)).isFile()) {
                        files = new File[]{altImageFile};
                    }
                    if ((imageFile = DocumentImageSelector.chooseImageFile(file, imageFile, files, LastOpenPath, (Frame)frame)) == null) {
                        return null;
                    }
                    hunted = true;
                }
                ImageInfo imageFileInfo = ImageInfo.getInstanceFor(imageFile);
                ImageMetadata meta = imageFileInfo.getMetadata();
                doc = new Document(xml, meta, info, cancel);
                if (hunted) {
                    doc.markDirty();
                }
            }
            DocumentDatabase.addDocumentFile(file);
        } else {
            boolean isRaw;
            ImageInfo info = ImageInfo.getInstanceFor(file);
            ImageMetadata meta = info.getMetadata();
            ImageType type = info.getImageType();
            XmlDocument xml = null;
            TemplateKey template = TemplateDatabase.getDefaultTemplate(meta);
            if (template != null) {
                try {
                    xml = TemplateDatabase.getTemplateDocument(template);
                }
                catch (TemplateDatabase.TemplateException e) {
                    // empty catch block
                }
            }
            if (xml == null) {
                xml = DocumentDatabase.getDefaultDocument(meta);
            }
            doc = (isRaw = type instanceof RawImageType) && xml != null ? new Document(xml, meta, null, cancel) : new Document(meta, cancel);
        }
        Application.maybeAddRawAdjustments(doc);
        SaveOptions save = doc.getSaveOptions();
        if (save != null) {
            save.setFile(file);
        }
        ImageType type = ImageType.determineTypeByExtensionOf(file);
        boolean recentLzn = save != null && save.isLzn();
        boolean bl = oldLzn = save == null && type.equals(LZNImageType.INSTANCE);
        if (recentLzn || oldLzn) {
            doc.setSaveOptions(null);
            save = Application.getSaveOptions(doc);
            doc.setSaveOptions(save);
        }
        Application.addToRecentFiles(file);
        return doc;
    }

    public static Document createDocumentHeadless(File file) throws UserCanceledException, XMLException, UnknownImageTypeException, IOException, BadImageFileException, ColorProfileException, Document.MissingImageFileException {
        boolean oldLzn;
        Document doc;
        ImageMetadata meta;
        DocumentReader.Interpretation interp = DocumentReader.read(file);
        if (interp != null) {
            if (interp.imageFile != null) {
                ImageInfo imageFileInfo = ImageInfo.getInstanceFor(interp.imageFile);
                meta = imageFileInfo.getMetadata();
                doc = new Document(interp.xml, meta, interp.info, null);
            } else {
                doc = new Document(interp.xml);
            }
            DocumentDatabase.addDocumentFile(file);
        } else {
            boolean isRaw;
            ImageInfo info = ImageInfo.getInstanceFor(file);
            meta = info.getMetadata();
            ImageType type = info.getImageType();
            XmlDocument xml = null;
            TemplateKey template = TemplateDatabase.getDefaultTemplate(meta);
            if (template != null) {
                try {
                    xml = TemplateDatabase.getTemplateDocument(template);
                }
                catch (TemplateDatabase.TemplateException e) {
                    // empty catch block
                }
            }
            if (xml == null) {
                xml = DocumentDatabase.getDefaultDocument(meta);
            }
            doc = (isRaw = type instanceof RawImageType) && xml != null ? new Document(xml, meta) : new Document(meta);
        }
        Application.maybeAddRawAdjustments(doc);
        SaveOptions save = doc.getSaveOptions();
        if (save != null) {
            save.setFile(file);
        }
        ImageType type = ImageType.determineTypeByExtensionOf(file);
        boolean recentLzn = save != null && save.isLzn();
        boolean bl = oldLzn = save == null && type.equals(LZNImageType.INSTANCE);
        if (recentLzn || oldLzn) {
            doc.setSaveOptions(null);
            save = Application.getSaveOptions(doc);
            doc.setSaveOptions(save);
        }
        return doc;
    }

    private static void maybeAddRawAdjustments(Document doc) {
        ImageMetadata meta = doc.getMetadata();
        ImageType type = meta.getImageType();
        if (type instanceof RawImageType && !doc.hasRawAdjustments()) {
            Engine engine = doc.getEngine();
            OperationType rawType = engine.getRawAdjustmentsOperationType();
            Editor editor = doc.getEditor();
            editor.addControl(rawType, 0);
            doc.discardEdits();
            doc.markClean();
        }
    }

    public static ComboFrame openEmpty() {
        ComboFrame frame = Application.createNewComboFrame(null);
        Application.addToCurrent(frame);
        frame.setVisible(true);
        return frame;
    }

    public static void openRecentFolder(ComboFrame frame, File folder) {
        if (frame == null && (frame = Application.getActiveFrame()) == null) {
            frame = Application.openEmpty();
        }
        frame.showRecentFolder(folder);
        Application.addToRecentFolders(folder);
        Application.savePrefs();
    }

    public static void notifyRecentFolder(File folder) {
        Application.addToRecentFolders(folder);
        Application.savePrefs();
    }

    public static boolean save(ComboFrame frame) {
        return Application.save(frame, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean save(ComboFrame frame, boolean openPending) {
        File file;
        Document doc = frame.getDocument();
        if (doc == null) {
            return false;
        }
        boolean saveDirectly = false;
        SaveOptions options = doc.getSaveOptions();
        if (options == null) {
            if (OtherApplicationShim.shouldSaveDirectly(doc)) {
                options = OtherApplicationShim.createExportOptions(doc);
                if (options == null) {
                    Application.showError(Locale.LOCALE.get("DirectSaveError"), null, frame);
                    return false;
                }
                doc.setSaveOptions(options);
                saveDirectly = true;
            } else {
                options = Application.getSaveOptions(doc);
                FileChooser chooser = Platform.getPlatform().getFileChooser();
                File file2 = options.getFile();
                if ((file2 = chooser.saveFile(file2, frame)) == null) {
                    return false;
                }
                options.setFile(file2);
                if (options.isMultilayerTiff()) {
                    ImageExportOptions export = SaveOptions.getExportOptions(options);
                    options = SaveOptions.createSidecarTiff(export);
                }
                LastSaveOptions = options;
                doc.setSaveOptions(options);
            }
        } else {
            saveDirectly = options.shouldSaveDirectly();
        }
        frame.showWait(Locale.LOCALE.get("SaveMessage"));
        boolean isLzn = options.isLzn();
        File saveFile = options.getFile();
        Exception error = null;
        frame.pause();
        try {
            OtherApplication app;
            TemporaryEditorCommitState state = doc.saveStart();
            DocumentWriter.save(doc, frame, saveDirectly, null);
            doc.saveEnd(state);
            if (!isLzn && OtherApplication.isIntegrationEnabled() && (app = (OtherApplication)doc.getSource()) != null) {
                app.postSave(saveFile, saveDirectly, openPending);
            }
        }
        catch (Exception e) {
            error = e;
        }
        finally {
            frame.resume();
        }
        frame.hideWait();
        if (error != null) {
            file = options.getFile();
            Application.showError(Locale.LOCALE.get("SaveError", file.getPath()), error, frame);
            return false;
        }
        doc.markClean();
        if (saveDirectly) {
            doc.setSaveOptions(null);
        }
        file = options.getFile();
        DocumentDatabase.addDocumentFile(file);
        Application.addToRecentFiles(file);
        Application.savePrefs();
        return true;
    }

    public static SaveResult saveAs(ComboFrame frame) {
        Document doc = frame.getDocument();
        if (doc == null) {
            return SaveResult.DontSave;
        }
        SaveOptions options = Application.getSaveOptions(doc);
        FileChooser chooser = Platform.getPlatform().getFileChooser();
        File file = options.getFile();
        if ((file = chooser.saveFile(file, frame)) == null) {
            return SaveResult.Cancelled;
        }
        options.setFile(file);
        if (options.isMultilayerTiff()) {
            ImageExportOptions export = SaveOptions.getExportOptions(options);
            options = SaveOptions.createSidecarTiff(export);
        }
        LastSaveOptions = options;
        doc.setSaveOptions(options);
        boolean saved = Application.save(frame);
        if (!saved) {
            return SaveResult.CouldntSave;
        }
        Application.savePrefs();
        return SaveResult.Saved;
    }

    public static void saveAll() {
        for (ComboFrame frame : Current) {
            Document doc = frame.getDocument();
            if (doc == null || !doc.isDirty()) continue;
            Application.save(frame);
        }
    }

    public static boolean close(ComboFrame frame) {
        if (Application.closeDocument(frame)) {
            Application.savePrefs();
            Application.removeFromCurrent(frame);
            frame.dispose();
            if (Platform.getType() != Platform.MacOSX) {
                Application.maybeQuit();
            }
            return true;
        }
        return false;
    }

    public static boolean closeDocument(ComboFrame frame) {
        Document doc = frame.getDocument();
        if (doc != null && doc.isDirty()) {
            int result = Application.askToSaveChanges(frame);
            if (result == 0) {
                boolean saved = Application.save(frame);
                if (!saved) {
                    return false;
                }
            } else {
                if (result == 1) {
                    return false;
                }
                if (result < 0) {
                    return false;
                }
            }
        }
        frame.setDocument(null);
        if (doc != null) {
            doc.dispose();
        }
        return true;
    }

    public static void closeDocumentForce(ComboFrame frame) {
        Document doc = frame.getDocument();
        frame.setDocument(null);
        if (doc != null) {
            doc.dispose();
        }
    }

    public static void quit() {
        StartupCrash.startupEnded();
        ArrayList<ComboFrame> frames = new ArrayList<ComboFrame>(Current);
        IsQuitting = true;
        for (ComboFrame frame : frames) {
            boolean closed = Application.close(frame);
            if (closed) continue;
            IsQuitting = false;
            return;
        }
        Application.savePrefs();
        System.exit(0);
    }

    public static boolean isQuitInProgress() {
        return IsQuitting;
    }

    public static void print(ComboFrame frame) {
        Document doc = frame.getDocument();
        if (doc != null) {
            Application.print(frame, doc, null);
        }
    }

    public static void print(ComboFrame frame, File file) {
        try {
            Document doc = Application.createDocument(file, frame, null);
            if (doc == null) {
                return;
            }
            Application.print(frame, doc, new PrintDoneCallback(doc));
        }
        catch (Throwable t) {
            Application.handleDocInitError(t, frame);
        }
    }

    public static void print(final ComboFrame frame, final Document doc, final PrintDoneCallback callback) {
        PrintLayoutModel layout;
        Engine engine = doc.getEngine();
        RenderedImage image = engine.getRendering(new Dimension(400, 300));
        if (image instanceof PlanarImage) {
            image = ((PlanarImage)image).getAsBufferedImage();
        }
        if ((layout = doc.getPrintLayout()) == null) {
            Dimension size = engine.getNaturalSize();
            if (LastPrintLayout != null) {
                layout = LastPrintLayout;
                layout.updateImageSize(size.width, size.height);
            } else {
                layout = new PrintLayoutModel(size.width, size.height);
            }
        }
        final PrintLayoutDialog dialog = new PrintLayoutDialog((BufferedImage)image, layout, frame, Locale.LOCALE.get("PrintDialogTitle"));
        dialog.addCancelAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                dialog.dispose();
                if (callback != null) {
                    callback.done();
                }
            }
        });
        dialog.addDoneAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PrintLayoutModel layout = dialog.getPrintLayout();
                doc.setPrintLayout(layout);
                dialog.dispose();
                if (callback != null) {
                    callback.done();
                }
                LastPrintLayout = layout;
                Application.savePrefs();
            }
        });
        dialog.addPrintAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PrintLayoutModel layout = dialog.getPrintLayout();
                doc.setPrintLayout(layout);
                Application.printHeadless(frame, doc);
                LastPrintLayout = layout;
                Application.savePrefs();
            }
        });
        dialog.addPageSetupAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PrintLayoutModel layout = dialog.getPrintLayout();
                doc.setPrintLayout(layout);
                Application.pageSetup(doc);
                layout = doc.getPrintLayout();
                PageFormat format = layout.getPageFormat();
                dialog.setPageFormat(format);
            }
        });
        PrinterLayer printer = Env.getPrinterLayer();
        printer.initialize();
        dialog.pack();
        dialog.setLocationRelativeTo(frame);
        dialog.setVisible(true);
    }

    public static boolean export(ComboFrame frame) {
        Document doc = frame.getDocument();
        if (doc == null) {
            return false;
        }
        return Application.export(frame, doc);
    }

    public static boolean export(ComboFrame frame, File file) {
        try {
            Document doc = Application.createDocument(file, frame, null);
            boolean result = Application.export(frame, doc);
            doc.dispose();
            return result;
        }
        catch (Throwable t) {
            Application.handleDocInitError(t, frame);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean export(ComboFrame frame, Document doc) {
        boolean success;
        File file;
        ImageExportOptions oldOptions = doc.getExportOptions();
        ImageMetadata meta = doc.getMetadata();
        Engine engine = doc.getEngine();
        Dimension size = engine.getNaturalSize();
        ImageExportOptions newOptions = oldOptions != null ? ExportLogic.getDefaultExportOptions(oldOptions, size) : (LastExportOptions != null ? ((file = doc.getFile()) != null ? ExportLogic.getDefaultExportOptions(LastExportOptions, meta, size, file.getName()) : ExportLogic.getDefaultExportOptions(LastExportOptions, meta, size)) : ExportLogic.getDefaultExportOptions(meta, size));
        FileChooser chooser = Platform.getPlatform().getFileChooser();
        ImageExportOptions options = chooser.exportFile(newOptions, frame);
        if (options == null) {
            return false;
        }
        frame.pause();
        try {
            success = DocumentWriter.exportWithDialog(engine, options, Locale.LOCALE.get("ExportMessage"), frame);
        }
        catch (Throwable e) {
            Application.showError(Locale.LOCALE.get("ExportError", options.getExportFile().toString()), e, frame);
            success = false;
        }
        finally {
            frame.resume();
        }
        if (!success) {
            File file2 = options.getExportFile();
            if (file2 != null) {
                file2.delete();
            }
            return false;
        }
        doc.setExportOptions(options);
        LastExportOptions = options;
        Application.addToRecentFiles(options.getExportFile());
        Application.savePrefs();
        return true;
    }

    public static TemplateKey saveTemplate(ComboFrame frame, String namespace) {
        TemplateKey key;
        Document doc = frame.getDocument();
        if (doc == null) {
            return null;
        }
        boolean done = false;
        do {
            int replace;
            XmlDocument xml = new XmlDocument("Template");
            XmlNode root = xml.getRoot();
            doc.saveTemplate(root);
            SaveTemplateDialog dialog = new SaveTemplateDialog();
            ImageMetadata meta = doc.getMetadata();
            key = dialog.showDialog(meta, xml, namespace, frame);
            if (key == null) {
                return null;
            }
            XmlDocument conflict = null;
            try {
                conflict = TemplateDatabase.getTemplateDocument(key);
            }
            catch (TemplateDatabase.TemplateException e) {
                // empty catch block
            }
            if (conflict != null && (replace = Env.getAlertDialog().showAlert((Frame)frame, Locale.LOCALE.get("TemplateClobberQuestionMajor", key.toString()), Locale.LOCALE.get("TemplateClobberQuestionMinor"), 1, Locale.LOCALE.get("TemplateClobberReplaceOption"), Locale.LOCALE.get("TemplateClobberCancelOption"))) != 0) continue;
            try {
                xml = dialog.getModifiedTemplate();
                TemplateDatabase.addTemplateDocument(xml, key, true);
                if (dialog.isDefaultSelected()) {
                    TemplateDatabase.setDefaultTemplate(meta, key);
                }
            }
            catch (TemplateDatabase.TemplateException e) {
                Application.showError(Locale.LOCALE.get("TemplateWriteError"), e, frame);
            }
            done = true;
        } while (!done);
        return key;
    }

    public static void applyTemplate(ComboFrame frame, TemplateKey key) {
        Document doc = frame.getDocument();
        if (doc == null) {
            return;
        }
        try {
            XmlDocument template = TemplateDatabase.getTemplateDocument(key);
            if (template != null) {
                XmlNode root = template.getRoot();
                doc.applyTemplate(root);
            } else {
                Application.showError(Locale.LOCALE.get("TemplateNameError", key.toString()), null, frame);
            }
        }
        catch (TemplateDatabase.TemplateException e) {
            Application.showError(Locale.LOCALE.get("TemplateReadError", key.toString()), e, frame);
        }
        catch (XMLException e) {
            Application.showError("Template \"" + key.toString() + "\" is malformed", e, frame);
        }
        catch (Throwable t) {
            Application.showError(Locale.LOCALE.get("TemplateGeneralError", key.toString()), t, frame);
        }
    }

    public static void applyTemplate(ComboFrame frame, File[] files, TemplateKey key) {
        XmlDocument template;
        try {
            template = TemplateDatabase.getTemplateDocument(key);
        }
        catch (TemplateDatabase.TemplateException e) {
            Application.showError(Locale.LOCALE.get("TemplateReadError", key.toString()), e, frame);
            return;
        }
        if (template == null) {
            Application.showError(Locale.LOCALE.get("TemplateNameError", key.toString()), null, frame);
            return;
        }
        BatchConfig conf = new BatchConfig();
        conf.name = "";
        conf.export = (ImageFileExportOptions)SaveOptions.getExportOptions(SaveOptions.getDefaultSaveOptions());
        try {
            BatchProcessor.process(frame, files, template, conf);
        }
        catch (RuntimeException e) {
            Application.showError("An error occurred during batch processing.", e, frame);
        }
    }

    public static void applyTemplate(ComboFrame frame, File[] files, File file) {
        DocumentReader.Interpretation interp = DocumentReader.read(file);
        if (interp == null) {
            Application.showError(Locale.LOCALE.get("TemplateInterpError", file.getName()), null, frame);
            return;
        }
        BatchConfig conf = new BatchConfig();
        conf.name = "";
        conf.export = (ImageFileExportOptions)SaveOptions.getExportOptions(SaveOptions.getDefaultSaveOptions());
        try {
            XmlDocument template = interp.xml;
            BatchProcessor.process(frame, files, template, conf);
        }
        catch (RuntimeException e) {
            Application.showError("An error occurred during batch processing.", e, frame);
        }
    }

    public static void export(ComboFrame frame, File[] files) {
        BatchConfig conf = BatchConfigurator.showDialog(files, frame, true);
        if (conf != null) {
            BatchProcessor.process(frame, files, null, conf);
        }
    }

    public static void send(ComboFrame frame, File[] files) {
        File folder = frame.getRecentFolder();
        String from = folder.getName();
        BatchConfig conf = SendDialog.showDialog(frame, from, files.length);
        if (conf != null) {
            BatchProcessor.process(frame, files, null, conf);
            if (conf.directory != null && files.length > 0) {
                Platform.getPlatform().showFileInFolder(conf.directory.getAbsolutePath());
            }
        }
    }

    public static List<File> getRecentFiles() {
        return new ArrayList<File>(RecentFiles);
    }

    public static void clearRecentFiles() {
        RecentFiles.clear();
        Application.savePrefs();
    }

    public static List<File> getRecentFolders() {
        return new ArrayList<File>(RecentFolders);
    }

    public static void clearRecentFolders() {
        RecentFolders.clear();
        Application.savePrefs();
    }

    public static List<ComboFrame> getCurrentFrames() {
        ArrayList<ComboFrame> frames = new ArrayList<ComboFrame>(Current);
        return frames;
    }

    public static void setLookAndFeel(LookAndFeel laf) {
        try {
            UIManager.setLookAndFeel(laf);
            for (ComboFrame frame : Current) {
                SwingUtilities.updateComponentTreeUI(frame);
                frame.pack();
            }
        }
        catch (UnsupportedLookAndFeelException e) {
            Application.showError("Error setting look and feel", e, null);
        }
    }

    public static void setLookAndFeel(String className) {
        try {
            UIManager.setLookAndFeel(className);
            for (ComboFrame frame : Current) {
                SwingUtilities.updateComponentTreeUI(frame);
                frame.pack();
            }
        }
        catch (ClassNotFoundException e) {
            Application.showError("Error setting look and feel", e, null);
        }
        catch (InstantiationException e) {
            Application.showError("Error setting look and feel", e, null);
        }
        catch (IllegalAccessException e) {
            Application.showError("Error setting look and feel", e, null);
        }
        catch (UnsupportedLookAndFeelException e) {
            Application.showError("Error setting look and feel", e, null);
        }
    }

    public static Preferences getPreferences() {
        return Preferences.userNodeForPackage(Application.class);
    }

    public static void showError(String message, Throwable e, Frame frame) {
        if (e != null) {
            e.printStackTrace();
        }
        if (System.getProperty("dieOnError") != null) {
            System.exit(-1);
        }
        SplashWindow.disposeSplash();
        String detail = null;
        if (e != null && (detail = e.getMessage()) == null) {
            detail = e.getClass().toString();
        }
        Env.getAlertDialog().showAlert(frame, message, detail, 2, Locale.LOCALE.get("ErrorDialogOk"));
    }

    public static void showAbout() {
        ComboFrame frame = Application.getActiveFrame();
        AboutDialog about = new AboutDialog(frame);
        about.centerOnScreen();
        about.setVisible(true);
        if (LicenseChecker.getLicenseKey() == null) {
            LicenseChecker.license();
        }
    }

    public static void showPreferences() {
        boolean wasBasic = ApplicationMode.isBasicMode();
        PreferencesDialog.showDialog(Application.getActiveFrame());
        boolean isBasic = ApplicationMode.isBasicMode();
        if (isBasic != wasBasic) {
            Application.appModeChanged();
        }
    }

    public static void appModeChanged() {
        ComboFrame newFrame = Application.openEmpty();
        LinkedList<ComboFrame> frames = new LinkedList<ComboFrame>(Current);
        for (ComboFrame frame : frames) {
            if (newFrame == frame) continue;
            Application.close(frame);
        }
    }

    static ComboFrame getFrameForFile(File file) {
        for (ComboFrame frame : Current) {
            long docTime;
            long time;
            Document doc = frame.getDocument();
            if (doc == null) continue;
            File docFile = doc.getFile();
            if (docFile == null) {
                docFile = doc.getMetadata().getFile();
            }
            if (!file.equals(docFile) || (time = file.lastModified()) != (docTime = docFile.lastModified())) continue;
            return frame;
        }
        return null;
    }

    static void copyFiles(ComboFrame frame, List<File> files, File folder) {
        for (File source : files) {
            File target = new File(folder, source.getName());
            try {
                if (target.isFile()) {
                    throw new IOException(Locale.LOCALE.get("MoveExistsMessage", target.getName(), folder.getName()));
                }
                FileUtil.copyFile(source, target);
            }
            catch (IOException e) {
                Application.showError(Locale.LOCALE.get("MoveCopyFailedMessage", source.getName(), folder.getName()), e, frame);
                return;
            }
        }
    }

    static void moveFiles(ComboFrame frame, List<File> files, File folder) {
        for (File source : files) {
            File target = new File(folder, source.getName());
            try {
                if (target.isFile()) {
                    throw new IOException(Locale.LOCALE.get("MoveExistsMessage", target.getName(), folder.getName()));
                }
                boolean renamed = source.renameTo(target);
                if (renamed) continue;
                FileUtil.copyFile(source, target);
            }
            catch (IOException e) {
                Application.showError(Locale.LOCALE.get("MoveCopyFailedMessage", source.getName(), folder.getName()), e, frame);
                return;
            }
        }
        for (File source : files) {
            boolean deleted;
            if (!source.isFile() || (deleted = source.delete())) continue;
            File oldFolder = source.getParentFile();
            Application.showError(Locale.LOCALE.get("MoveDeleteFailedMessage", source.getName(), folder.getName(), oldFolder.getName()), null, frame);
        }
    }

    private static void openMacPlaceholderFrame() {
        ComboFrameMenuBar menus = new ComboFrameMenuBar();
        JFrame frame = new JFrame();
        frame.setJMenuBar(menus);
        frame.setBounds(-1000000, -1000000, 0, 0);
        frame.setUndecorated(true);
        frame.setVisible(true);
    }

    private static int askToSaveChanges(ComboFrame frame) {
        return Env.getAlertDialog().showAlert((Frame)frame, Locale.LOCALE.get("SaveChangesQuestionMajor"), Locale.LOCALE.get("SaveChangesQuestionMinor"), 1, 2, Locale.LOCALE.get("SaveChangesSaveOption"), Locale.LOCALE.get("SaveChangesCancelOption"), Locale.LOCALE.get("SaveChangesDontSaveOption"));
    }

    private static boolean askConfirmQuit(ComboFrame frame) {
        String ConfirmQuitKey = "ConfirmQuit";
        Preferences prefs = Application.getPreferences();
        boolean ask = prefs.getBoolean(ConfirmQuitKey, true);
        int option = 0;
        if (ask) {
            String alwaysPrompt = Locale.LOCALE.get("ConfirmQuitAlwaysPrompt");
            JCheckBox alwaysCheck = new JCheckBox(alwaysPrompt);
            Box message = Box.createVerticalBox();
            message.add(new JLabel(Locale.LOCALE.get("ConfirmQuitQuestion")));
            message.add(alwaysCheck);
            option = JOptionPane.showOptionDialog(frame, message, "Quit LightZone", 2, 3, null, new Object[]{Locale.LOCALE.get("ConfirmQuitConfirmOption"), Locale.LOCALE.get("ConfirmQuitCancelOption")}, Locale.LOCALE.get("ConfirmQuitConfirmOption"));
            if (option == 0 && alwaysCheck.isSelected()) {
                prefs.putBoolean(ConfirmQuitKey, false);
            }
        }
        return option == 0;
    }

    private static ComboFrame createNewComboFrame(ComboFrame parent) {
        ComboFrame frame = new ComboFrame();
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                boolean confirmed;
                ComboFrame frame = (ComboFrame)event.getWindow();
                if (Platform.getType() != Platform.MacOSX && Current.size() == 1 && !(confirmed = Application.askConfirmQuit(frame))) {
                    return;
                }
                Application.close(frame);
            }
        });
        frame.setDefaultCloseOperation(0);
        frame.pack();
        Application.setNewWindowBounds(frame, parent);
        return frame;
    }

    private static ComboFrame show(Document doc, ComboFrame frame) {
        if (frame == null) {
            frame = Application.createNewComboFrame(null);
        }
        Document old = frame.getDocument();
        frame.setDocument(doc);
        if (old != null) {
            old.dispose();
        }
        Application.addToCurrent(frame);
        Application.savePrefs();
        frame.setVisible(true);
        return frame;
    }

    private static void setInitialSize(Document doc) {
        doc.zoomToFit();
        ScaleModel scales = doc.getScaleModel();
        Scale s = scales.getCurrentScale();
        if (s.getFactor() > 1.0f) {
            s = new Scale(1, 1);
            scales.setScale(s);
        }
    }

    static SaveOptions getSaveOptions(Document doc) {
        SaveOptions options = doc.getSaveOptions();
        if (options == null) {
            ImageMetadata meta = doc.getMetadata();
            Preferences prefs = Application.getPreferences();
            boolean byOriginal = prefs.getBoolean("SaveByOriginal", true);
            File dir = byOriginal || LastSaveOptions == null ? meta.getFile().getParentFile() : LastSaveOptions.getFile().getParentFile();
            options = SaveOptions.getDefaultSaveOptions();
            ImageFileExportOptions export = (ImageFileExportOptions)SaveOptions.getExportOptions(options);
            ImageType type = export.getImageType();
            File file = new File(dir, meta.getFile().getName());
            String name = ExportNameUtility.getBaseName(file);
            name = name + "_lzn." + type.getExtensions()[0];
            file = new File(name);
            file = ExportNameUtility.ensureNotExists(file);
            if (export.resizeWidth.getValue() == 0 && export.resizeHeight.getValue() == 0) {
                Engine engine = doc.getEngine();
                Dimension size = engine.getNaturalSize();
                options.updateSize(size);
            }
            options.setFile(file);
        }
        return options;
    }

    private static void pageSetup(Document doc) {
        PrintLayoutModel layout = doc.getPrintLayout();
        PageFormat format = layout.getPageFormat();
        format = Platform.getPlatform().getPrinterLayer().pageDialog(format);
        if (format != null) {
            layout.setPageFormat(format);
        }
    }

    private static void printHeadless(ComboFrame frame, Document doc) {
        String jobName;
        final Engine engine = doc.getEngine();
        PrintLayoutModel layout = doc.getPrintLayout();
        final PrintSettings settings = layout.getPrintSettings();
        PrinterLayer printer = Platform.getPlatform().getPrinterLayer();
        printer.setPageFormat(layout.getPageFormat());
        final PageFormat format = printer.getPageFormat();
        File file = doc.getFile();
        if (file != null) {
            jobName = file.getName();
        } else {
            ImageMetadata meta = doc.getMetadata();
            jobName = meta.getFile().getName();
        }
        printer.setJobName(jobName);
        boolean doPrint = printer.printDialog();
        if (doPrint) {
            ProgressDialog dialog = Platform.getPlatform().getProgressDialog();
            ProgressThread thread = new ProgressThread(dialog){

                @Override
                public void run() {
                    try {
                        engine.print(this, format, settings);
                    }
                    catch (PrinterException e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void cancel() {
                    engine.cancelPrint();
                }
            };
            dialog.showProgress(frame, thread, Locale.LOCALE.get("PrintingMessage"), 0, 0, true);
            Throwable error = dialog.getThrown();
            if (error != null) {
                if (error instanceof RuntimeException) {
                    throw (RuntimeException)error;
                }
                if (error instanceof PrinterAbortException) {
                    return;
                }
                Application.showError(Locale.LOCALE.get("PrintError"), error, frame);
            }
        }
    }

    private static void maybeQuit() {
        if (Current.isEmpty()) {
            System.exit(0);
        }
    }

    private static void addToRecentFiles(File file) {
        RecentFiles.remove(file);
        RecentFiles.addFirst(file);
        while (RecentFiles.size() > RecentCount) {
            RecentFiles.removeLast();
        }
    }

    private static void addToRecentFolders(File file) {
        RecentFolders.remove(file);
        RecentFolders.addFirst(file);
        while (RecentFolders.size() > RecentCount) {
            File old = RecentFolders.removeLast();
            ComboFrame.clearFolder(old);
        }
    }

    private static void addToCurrent(ComboFrame frame) {
        Current.remove(frame);
        Current.addFirst(frame);
        WindowMenu.updateAll();
    }

    private static void removeFromCurrent(ComboFrame frame) {
        Current.remove(frame);
        WindowMenu.updateAll();
    }

    private static ComboFrame getActiveFrame() {
        for (ComboFrame frame : Current) {
            if (!frame.isActive()) continue;
            return frame;
        }
        return ComboFrame.LastActiveComboFrame;
    }

    private static void verifyLibraries() {
        String[] libs;
        for (String lib : libs = new String[]{"DCRaw", "Segment", "JAI", "FASTJAI", "fbf", "LCJPEG", "LCTIFF"}) {
            try {
                System.loadLibrary(lib);
            }
            catch (UnsatisfiedLinkError e) {
                Application.showError("Couldn't link with native library: \"" + lib, e, null);
            }
        }
        try {
            Env.loadLibraries();
        }
        catch (UnsatisfiedLinkError e) {
            Application.showError("Couldn't link with platform-specific native libraries", e, null);
        }
        try {
            Startup.startupMessage(Locale.LOCALE.get("StartupEngineMessage"));
            Class.forName("com.lightcrafts.jai.JAIContext");
            Startup.startupMessage(Locale.LOCALE.get("StartupClassesMessage"));
            Class.forName("com.lightcrafts.mediax.jai.JAI");
            Class.forName("com.lightcrafts.media.jai.codec.ImageCodec");
        }
        catch (ClassNotFoundException e) {
            Application.showError("Couldn't link with image processing class libraries", e, null);
        }
    }

    private static void scanProfiles() {
        Env.getExportProfiles();
        Env.getPrinterProfiles();
    }

    private static void initLogging() {
        Logger logger = Logger.getLogger("com.lightcrafts.image.metadata");
        TerseLoggingHandler handler = new TerseLoggingHandler(System.out);
        logger.addHandler(handler);
        logger.setUseParentHandlers(false);
    }

    private static void initDocumentDatabase() {
        DocumentDatabase.addDocumentInterpreter(new DocumentInterpreter(){

            @Override
            public File getImageFile(File file) {
                DocumentReader.Interpretation interp = DocumentReader.read(file);
                return interp != null ? interp.imageFile : null;
            }

            @Override
            public Collection<String> getSuffixes() {
                List<String> tiffs = Arrays.asList(TIFFImageType.INSTANCE.getExtensions());
                List<String> jpegs = Arrays.asList(JPEGImageType.INSTANCE.getExtensions());
                LinkedList<String> all = new LinkedList<String>();
                all.addAll(tiffs);
                all.addAll(jpegs);
                return all;
            }
        });
    }

    private static void setNewWindowBounds(Frame frame, Frame parent) {
        int inset = 20;
        if (parent == null) {
            parent = Application.getActiveFrame();
        }
        if (parent != null && parent != frame) {
            Rectangle bounds = parent.getBounds();
            bounds = new Rectangle(bounds.x + 20, bounds.y + 20, bounds.width, bounds.height);
            GraphicsConfiguration gc = parent.getGraphicsConfiguration();
            Rectangle screen = gc.getBounds();
            if (bounds.getMaxX() > screen.getMaxX() - 20.0) {
                bounds.width = (int)screen.getMaxX() - bounds.x - 20;
            }
            if (bounds.getMaxY() > screen.getMaxY() - 20.0) {
                bounds.height = (int)screen.getMaxY() - bounds.y - 20;
            }
            frame.setBounds(bounds);
        } else if (InitialFrameBounds != null && Displays.getVirtualBounds().intersects(InitialFrameBounds)) {
            frame.setBounds(Application.InitialFrameBounds.x, Application.InitialFrameBounds.y, Application.InitialFrameBounds.width, Application.InitialFrameBounds.height);
            frame.setExtendedState(InitialFrameState);
            InitialFrameBounds = null;
        } else {
            GraphicsConfiguration gc = frame.getGraphicsConfiguration();
            Rectangle bounds = gc.getBounds();
            int x = 20;
            int y = 20;
            int width = bounds.width - 40;
            int height = bounds.height - 40;
            frame.setBounds(x, y, width, height);
            InitialFrameBounds = null;
        }
        frame.validate();
    }

    private static void setLookAndFeel() {
        LookAndFeel plafName = Env.getLookAndFeel();
        Application.setLookAndFeel(plafName);
    }

    private static void showFirstTimeHelp() {
        Preferences prefs = Application.getPreferences();
        if (prefs.getBoolean(FirstLaunchTag, true)) {
            Env.showHelpTopic("Discover");
            prefs.putBoolean(FirstLaunchTag, false);
        }
        if (VideoLearningCenterDialog.shouldShowDialog()) {
            VideoLearningCenterDialog.showDialog();
        }
    }

    private static void savePrefs() {
        XmlDocument doc;
        String value;
        Preferences prefs = Application.getPreferences();
        ComboFrame active = Application.getActiveFrame();
        if (active != null) {
            Rectangle bounds = active.getUnmaximizedBounds();
            if (bounds != null) {
                prefs.putInt("BoundsX", bounds.x);
                prefs.putInt("BoundsY", bounds.y);
                prefs.putInt("BoundsW", bounds.width);
                prefs.putInt("BoundsH", bounds.height);
            }
            int state = active.getExtendedState();
            prefs.putInt(FrameStateTag, state);
        }
        int n = 0;
        for (File file : RecentFiles) {
            String key = RecentFileTag + n;
            value = file.getAbsolutePath();
            prefs.put(key, value);
            ++n;
        }
        String key = RecentFileTag + n++;
        while (prefs.get(key, null) != null) {
            prefs.remove(key);
            key = RecentFileTag + n++;
        }
        n = 0;
        for (File file : RecentFolders) {
            key = RecentFolderTag + n;
            value = file.getAbsolutePath();
            prefs.put(key, value);
            ++n;
        }
        key = RecentFolderTag + n++;
        while (prefs.get(key, null) != null) {
            prefs.remove(key);
            key = RecentFolderTag + n++;
        }
        n = 0;
        for (ComboFrame frame : Current) {
            Document doc2 = frame.getDocument();
            if (doc2 == null) continue;
            File file = doc2.getFile();
            key = CurrentTag + n;
            if (file == null) continue;
            String value2 = file.getAbsolutePath();
            prefs.put(key, value2);
            ++n;
        }
        key = CurrentTag + n++;
        while (prefs.get(key, null) != null) {
            prefs.remove(key);
            key = CurrentTag + n++;
        }
        if (LastOpenPath != null) {
            String path = LastOpenPath.getAbsolutePath();
            prefs.put(OpenTag, path);
        }
        if (LastSaveOptions != null) {
            doc = new XmlDocument(SaveTag);
            LastSaveOptions.save(doc.getRoot());
            Application.saveXmlPrefs(SaveTag, doc);
        }
        if (LastPrintLayout != null) {
            doc = new XmlDocument(PrintTag);
            LastPrintLayout.save(doc.getRoot());
            Application.saveXmlPrefs(PrintTag, doc);
        }
        if (LastExportOptions != null) {
            doc = new XmlDocument(ExportTag);
            LastExportOptions.write(doc.getRoot());
            Application.saveXmlPrefs(ExportTag, doc);
        }
        try {
            prefs.sync();
        }
        catch (BackingStoreException e) {
            Application.showError(Locale.LOCALE.get("PrefsWriteError"), e, null);
        }
    }

    private static boolean saveXmlPrefs(String tag, XmlDocument doc) {
        Preferences prefs = Application.getPreferences();
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            doc.write(out);
            String text = out.toString("UTF-8");
            prefs.put(tag, text);
            return true;
        }
        catch (IOException e) {
            System.err.print("Error saving preferences: ");
            System.err.print(e.getClass().getName() + " ");
            System.err.println(e.getMessage());
            return false;
        }
    }

    private static void restorePrefs() {
        Preferences prefs = Application.getPreferences();
        try {
            XmlDocument doc;
            File file;
            String value;
            Integer index;
            String indexString;
            int state;
            int x = prefs.getInt("BoundsX", -2147483647);
            int y = prefs.getInt("BoundsY", -2147483647);
            int w = prefs.getInt("BoundsW", -1);
            int h = prefs.getInt("BoundsH", -1);
            if (x > -2147483647 && y > -2147483647 && w > 0 && h > 0) {
                InitialFrameBounds = new Rectangle(x, y, w, h);
            }
            InitialFrameState = (state = prefs.getInt(FrameStateTag, 0)) != 1 ? state : 0;
            String[] keys = prefs.keys();
            HashMap<Integer, File> recentMap = new HashMap<Integer, File>();
            for (String key : keys) {
                if (!key.startsWith(RecentFileTag)) continue;
                indexString = key.substring(RecentFileTag.length());
                try {
                    index = Integer.decode(indexString);
                    value = prefs.get(key, null);
                    file = new File(value);
                    recentMap.put(index, file);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            for (int n = recentMap.size() - 1; n >= 0; --n) {
                File file2 = (File)recentMap.get(n);
                if (file2 == null) continue;
                Application.addToRecentFiles(file2);
            }
            keys = prefs.keys();
            recentMap = new HashMap();
            for (String key : keys) {
                if (!key.startsWith(RecentFolderTag)) continue;
                indexString = key.substring(RecentFolderTag.length());
                try {
                    index = Integer.decode(indexString);
                    value = prefs.get(key, null);
                    file = new File(value);
                    recentMap.put(index, file);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            for (int n = recentMap.size() - 1; n >= 0; --n) {
                File file3 = (File)recentMap.get(n);
                if (file3 == null) continue;
                Application.addToRecentFolders(file3);
            }
            String path = prefs.get(OpenTag, null);
            if (path != null) {
                LastOpenPath = new File(path);
            }
            if ((doc = Application.restoreXmlPrefs(SaveTag)) != null) {
                try {
                    LastSaveOptions = SaveOptions.restore(doc.getRoot());
                }
                catch (XMLException e) {
                    System.err.println("Malformed save preferences: " + e.getMessage());
                    LastSaveOptions = null;
                }
            }
            if ((doc = Application.restoreXmlPrefs(PrintTag)) != null) {
                try {
                    LastPrintLayout = new PrintLayoutModel(0, 0);
                    LastPrintLayout.restore(doc.getRoot());
                }
                catch (XMLException e) {
                    System.err.println("Malformed print preferences: " + e.getMessage());
                    LastPrintLayout = null;
                }
            }
            if ((doc = Application.restoreXmlPrefs(ExportTag)) != null) {
                try {
                    LastExportOptions = ImageExportOptions.read(doc.getRoot());
                }
                catch (XMLException e) {
                    System.err.println("Malformed export preferences: " + e.getMessage());
                    LastExportOptions = null;
                }
            }
        }
        catch (BackingStoreException e) {
            Application.showError(Locale.LOCALE.get("PrefsReadError"), e, null);
        }
    }

    private static XmlDocument restoreXmlPrefs(String tag) {
        Preferences prefs = Application.getPreferences();
        String text = prefs.get(tag, null);
        if (text != null) {
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(text.getBytes("UTF-8"));
                XmlDocument doc = new XmlDocument(in);
                return doc;
            }
            catch (Exception e) {
                System.err.print("Error reading preferences: ");
                System.err.print(e.getClass().getName() + " ");
                System.err.println(e.getMessage());
                prefs.remove(tag);
            }
        }
        return null;
    }

    private static void initFocusDebug() {
        KeyboardFocusManager focus = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        focus.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propName = evt.getPropertyName();
                Object oldValue = evt.getOldValue();
                String oldName = oldValue != null ? oldValue.getClass().getName() : "null";
                Object newValue = evt.getNewValue();
                String newName = newValue != null ? newValue.getClass().getName() : "null";
                System.out.println(propName + ": " + oldName + " -> " + newName);
            }
        });
    }

    public static void main(String[] args) {
        StartupCrash.checkLastStartupSuccessful();
        StartupCrash.startupStarted();
        ExceptionDialog.installHandler();
        if (LicenseChecker.enteredLicenseKey()) {
            ApplicationMode.resetPreference();
        }
        if (System.getProperty("lightcrafts.debug.focus") != null) {
            Application.initFocusDebug();
        }
        try {
            Startup.startupMessage(Locale.LOCALE.get("StartupLibsMessage"));
            Application.verifyLibraries();
            Startup.startupMessage(Locale.LOCALE.get("StartupColorsMessage"));
            Application.scanProfiles();
            Startup.startupMessage(Locale.LOCALE.get("StartupPrefsMessage"));
            Application.restorePrefs();
            Startup.startupMessage(Locale.LOCALE.get("StartupLogsMessage"));
            Application.initLogging();
            Startup.startupMessage(Locale.LOCALE.get("StartupScanMessage"));
            Application.initDocumentDatabase();
            Startup.startupMessage(Locale.LOCALE.get("StartupOpeningMessage"));
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Application.setLookAndFeel();
                    if (Platform.getType() == Platform.MacOSX) {
                        Application.openMacPlaceholderFrame();
                    }
                    Application.openEmpty();
                    Platform.getPlatform().readyToOpenFiles();
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Application.showFirstTimeHelp();
                        }
                    });
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Thread.sleep(20000L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            StartupCrash.startupEnded();
                        }
                    }, "StartupSuccessWait").start();
                }
            });
            AwtWatchdog.spawn();
        }
        catch (Throwable e) {
            new ExceptionDialog().handle(e);
        }
    }

    static {
        Startup = new StartupProgress();
        RecentCount = 5;
        Current = new LinkedList();
        RecentFiles = new LinkedList();
        RecentFolders = new LinkedList();
        Env = Platform.getPlatform();
    }

    private static class PrintDoneCallback {
        private final Document doc;

        PrintDoneCallback(Document doc) {
            this.doc = doc;
        }

        public void done() {
            this.doc.dispose();
            PrinterLayer printer = Env.getPrinterLayer();
            printer.dispose();
        }
    }
}

