/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Vector;
import org.jfree.data.AbstractDataset;
import org.jfree.data.Range;
import org.jfree.data.RangeInfo;
import org.jfree.data.XYDataset;

public class JDBCXYDataset
extends AbstractDataset
implements XYDataset,
RangeInfo {
    Connection connection;
    Statement statement;
    ResultSet resultSet;
    ResultSetMetaData metaData;
    String[] columnNames = new String[0];
    Vector rows = new Vector(0);
    protected double maxValue = 0.0;
    protected double minValue = 0.0;
    public boolean isTimeSeries = false;

    public JDBCXYDataset() {
    }

    public JDBCXYDataset(String string, String string2, String string3, String string4) {
        try {
            Class.forName(string2);
            this.connection = DriverManager.getConnection(string, string3, string4);
            this.statement = this.connection.createStatement();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Cannot find the database driver classes.");
            System.err.println(classNotFoundException);
        }
        catch (SQLException sQLException) {
            System.err.println("Cannot connect to this database.");
            System.err.println(sQLException);
        }
    }

    public JDBCXYDataset(Connection connection) {
        try {
            this.connection = connection;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public JDBCXYDataset(Connection connection, String string) {
        this(connection);
        this.executeQuery(string);
    }

    public void executeQuery(String string) {
        this.executeQuery(this.connection, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void executeQuery(Connection var1_1, String var2_2) {
        block51: {
            block48: {
                block46: {
                    block47: {
                        var3_3 = null;
                        var4_4 = 0;
                        var5_5 = 0;
                        var6_6 = 0;
                        var7_7 = 0;
                        var8_8 = null;
                        if (var1_1 == null) {
                            System.err.println("There is no database to execute the query.");
                            return;
                        }
                        try {
                            try {
                                this.statement = var1_1.createStatement();
                                this.resultSet = this.statement.executeQuery(var2_2);
                                this.metaData = this.resultSet.getMetaData();
                                var6_6 = this.metaData.getColumnCount();
                                var8_8 = new int[var6_6];
                                for (var4_4 = 0; var4_4 < var6_6; ++var4_4) {
                                    try {
                                        var9_9 = this.metaData.getColumnType(var4_4 + 1);
                                        switch (var9_9) {
                                            case -7: 
                                            case -5: 
                                            case 2: 
                                            case 3: 
                                            case 4: 
                                            case 6: 
                                            case 7: 
                                            case 8: 
                                            case 91: 
                                            case 92: 
                                            case 93: {
                                                ++var7_7;
                                                var8_8[var4_4] = var9_9;
                                                break;
                                            }
                                            default: {
                                                System.err.println("Unable to load column " + var4_4 + " (" + var9_9 + "," + this.metaData.getColumnClassName(var4_4 + 1) + ")");
                                                var8_8[var4_4] = 0;
                                                break;
                                            }
                                        }
                                        continue;
                                    }
                                    catch (SQLException var9_10) {
                                        var9_10.printStackTrace();
                                        var8_8[var4_4] = 0;
                                    }
                                }
                                if (var7_7 <= 1) {
                                    System.err.println("Not enough valid columns where generated by query.");
                                    var14_16 = null;
                                    if (this.resultSet == null) break block46;
                                    break block47;
                                }
                                this.columnNames = new String[var7_7 - 1];
                                var5_5 = 0;
                                for (var4_4 = 1; var4_4 < var6_6; ++var4_4) {
                                    if (var8_8[var4_4] == 0) continue;
                                    this.columnNames[var5_5] = this.metaData.getColumnLabel(var4_4 + 1);
                                    ++var5_5;
                                }
                                if (this.rows != null) {
                                    for (var4_4 = 0; var4_4 < this.rows.size(); ++var4_4) {
                                        var9_11 = (Vector)this.rows.get(var4_4);
                                        var9_11.removeAllElements();
                                    }
                                    this.rows.removeAllElements();
                                }
                                switch (var8_8[0]) {
                                    case 91: 
                                    case 92: 
                                    case 93: {
                                        this.isTimeSeries = true;
                                        break;
                                    }
                                    default: {
                                        this.isTimeSeries = false;
                                    }
                                }
                                this.rows = new Vector<E>();
                                while (this.resultSet.next()) {
                                    var9_12 = new Vector<Object>();
                                    block31: for (var4_4 = 0; var4_4 < var6_6; ++var4_4) {
                                        var3_3 = this.resultSet.getObject(var4_4 + 1);
                                        switch (var8_8[var4_4]) {
                                            case -5: 
                                            case 2: 
                                            case 3: 
                                            case 4: 
                                            case 6: 
                                            case 7: 
                                            case 8: {
                                                var9_12.addElement(var3_3);
                                                continue block31;
                                            }
                                            case 91: 
                                            case 92: 
                                            case 93: {
                                                var9_12.addElement(new Long(((Date)var3_3).getTime()));
                                                continue block31;
                                            }
                                            case 0: {
                                                continue block31;
                                            }
                                            default: {
                                                System.err.println("Unknown data");
                                                var8_8[var4_4] = 0;
                                            }
                                        }
                                    }
                                    this.rows.addElement(var9_12);
                                }
                                if (this.rows.size() == 0) {
                                    var9_13 = new Vector<Integer>();
                                    for (var4_4 = 0; var4_4 < var6_6; ++var4_4) {
                                        if (var8_8[var4_4] == 0) continue;
                                        var9_13.addElement(new Integer(0));
                                    }
                                    this.rows.addElement(var9_13);
                                }
                                if (this.rows.size() < 1) {
                                    this.maxValue = 0.0;
                                    this.minValue = 0.0;
                                } else {
                                    var9_14 = (Vector)this.rows.elementAt(0);
                                    this.minValue = this.maxValue = ((Number)var9_14.get(1)).doubleValue();
                                    for (var12_24 = 0; var12_24 < this.rows.size(); ++var12_24) {
                                        var9_14 = (Vector)this.rows.elementAt(var12_24);
                                        for (var4_4 = 1; var4_4 < var6_6; ++var4_4) {
                                            var10_25 = ((Number)var9_14.get(var4_4)).doubleValue();
                                            if (var10_25 < this.minValue) {
                                                this.minValue = var10_25;
                                            }
                                            if (!(var10_25 > this.maxValue)) continue;
                                            this.maxValue = var10_25;
                                        }
                                    }
                                }
                                this.fireDatasetChanged();
                                break block48;
                            }
                            catch (SQLException var9_15) {
                                System.err.println(var9_15);
                                var9_15.printStackTrace();
                                var14_18 = null;
                                if (this.resultSet != null) {
                                    try {
                                        this.resultSet.close();
                                    }
                                    catch (Exception var15_22) {
                                        // empty catch block
                                    }
                                }
                                if (this.statement == null) return;
                                try {
                                    this.statement.close();
                                    return;
                                }
                                catch (Exception var15_22) {
                                    return;
                                }
                            }
                        }
                        catch (Throwable var13_26) {
                            block50: {
                                var14_19 = null;
                                if (this.resultSet != null) {
                                    ** try [egrp 3[TRYBLOCK] [7 : 986->998)] { 
lbl127:
                                    // 1 sources

                                    this.resultSet.close();
                                    break block50;
lbl129:
                                    // 1 sources

                                    catch (Exception var15_23) {
                                        // empty catch block
                                    }
                                }
                            }
                            if (this.statement == null) throw var13_26;
                            ** try [egrp 4[TRYBLOCK] [8 : 1007->1019)] { 
lbl134:
                            // 1 sources

                            this.statement.close();
                            throw var13_26;
lbl136:
                            // 1 sources

                            catch (Exception var15_23) {
                                // empty catch block
                            }
                            throw var13_26;
                        }
                    }
                    ** try [egrp 3[TRYBLOCK] [7 : 986->998)] { 
lbl141:
                    // 1 sources

                    this.resultSet.close();
                    break block46;
lbl143:
                    // 1 sources

                    catch (Exception var15_20) {
                        // empty catch block
                    }
                }
                if (this.statement == null) return;
                ** try [egrp 4[TRYBLOCK] [8 : 1007->1019)] { 
lbl148:
                // 1 sources

                this.statement.close();
                return;
lbl150:
                // 1 sources

                catch (Exception var15_20) {
                    // empty catch block
                }
                return;
            }
            var14_17 = null;
            if (this.resultSet != null) {
                ** try [egrp 3[TRYBLOCK] [7 : 986->998)] { 
lbl157:
                // 1 sources

                this.resultSet.close();
                break block51;
lbl159:
                // 1 sources

                catch (Exception var15_21) {
                    // empty catch block
                }
            }
        }
        if (this.statement == null) return;
        try {}
        catch (Exception var15_21) {}
        this.statement.close();
        return;
    }

    public Number getXValue(int n, int n2) {
        Vector vector = (Vector)this.rows.elementAt(n2);
        return (Number)vector.elementAt(0);
    }

    public Number getYValue(int n, int n2) {
        Vector vector = (Vector)this.rows.elementAt(n2);
        return (Number)vector.elementAt(n + 1);
    }

    public int getItemCount(int n) {
        return this.rows.size();
    }

    public int getSeriesCount() {
        return this.columnNames.length;
    }

    public String getSeriesName(int n) {
        if (n < this.columnNames.length && this.columnNames[n] != null) {
            return this.columnNames[n];
        }
        return "";
    }

    public int getLegendItemCount() {
        return this.getSeriesCount();
    }

    public String[] getLegendItemLabels() {
        return this.columnNames;
    }

    public Number getMinimumRangeValue() {
        return new Double(this.minValue);
    }

    public Number getMaximumRangeValue() {
        return new Double(this.maxValue);
    }

    public void close() {
        try {
            this.resultSet.close();
        }
        catch (Exception exception) {
            System.err.println("JdbcXYDataset: swallowing exception.");
        }
        try {
            this.statement.close();
        }
        catch (Exception exception) {
            System.err.println("JdbcXYDataset: swallowing exception.");
        }
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            System.err.println("JdbcXYDataset: swallowing exception.");
        }
    }

    public Range getValueRange() {
        return new Range(this.minValue, this.maxValue);
    }
}

