/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jfree.data.CategoryDataset;
import org.jfree.data.Dataset;
import org.jfree.data.DefaultCategoryDataset;
import org.jfree.data.DefaultPieDataset;
import org.jfree.data.DomainInfo;
import org.jfree.data.Function2D;
import org.jfree.data.HighLowDataset;
import org.jfree.data.IntervalCategoryDataset;
import org.jfree.data.IntervalXYDataset;
import org.jfree.data.KeyedValues;
import org.jfree.data.PieDataset;
import org.jfree.data.Range;
import org.jfree.data.RangeInfo;
import org.jfree.data.TableXYDataset;
import org.jfree.data.XYDataset;
import org.jfree.data.XYSeries;
import org.jfree.data.XYSeriesCollection;

public class DatasetUtilities {
    protected DatasetUtilities() {
    }

    public static Number[] createNumberArray(double[] dArray) {
        Number[] numberArray = new Number[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            numberArray[i] = new Double(dArray[i]);
        }
        return numberArray;
    }

    public static Number[][] createNumberArray2D(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        Number[][] numberArray = new Number[n][n2];
        for (int i = 0; i < n; ++i) {
            numberArray[i] = DatasetUtilities.createNumberArray(dArray[i]);
        }
        return numberArray;
    }

    public static Range getDomainExtent(Dataset dataset) {
        if (dataset == null) {
            return null;
        }
        if (dataset instanceof CategoryDataset && !(dataset instanceof XYDataset)) {
            throw new IllegalArgumentException("Datasets.getDomainExtent(...): CategoryDataset does not have a numerical domain.");
        }
        if (dataset instanceof DomainInfo) {
            DomainInfo domainInfo = (DomainInfo)((Object)dataset);
            return domainInfo.getDomainRange();
        }
        if (dataset instanceof XYDataset) {
            double d = Double.POSITIVE_INFINITY;
            double d2 = Double.NEGATIVE_INFINITY;
            XYDataset xYDataset = (XYDataset)dataset;
            int n = xYDataset.getSeriesCount();
            for (int i = 0; i < n; ++i) {
                int n2 = xYDataset.getItemCount(i);
                for (int j = 0; j < n2; ++j) {
                    Number number = null;
                    Number number2 = null;
                    if (dataset instanceof IntervalXYDataset) {
                        IntervalXYDataset intervalXYDataset = (IntervalXYDataset)dataset;
                        number = intervalXYDataset.getStartXValue(i, j);
                        number2 = intervalXYDataset.getEndXValue(i, j);
                    } else {
                        number2 = number = xYDataset.getXValue(i, j);
                    }
                    if (number != null) {
                        d = Math.min(d, number.doubleValue());
                    }
                    if (number2 == null) continue;
                    d2 = Math.max(d2, number2.doubleValue());
                }
            }
            if (d == Double.POSITIVE_INFINITY) {
                return null;
            }
            return new Range(d, d2);
        }
        return null;
    }

    public static Range getRangeExtent(Dataset dataset) {
        if (dataset == null) {
            return null;
        }
        if (dataset instanceof RangeInfo) {
            RangeInfo rangeInfo = (RangeInfo)((Object)dataset);
            return rangeInfo.getValueRange();
        }
        if (dataset instanceof CategoryDataset) {
            CategoryDataset categoryDataset = (CategoryDataset)dataset;
            double d = Double.POSITIVE_INFINITY;
            double d2 = Double.NEGATIVE_INFINITY;
            int n = categoryDataset.getRowCount();
            int n2 = categoryDataset.getColumnCount();
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    Number number = null;
                    Number number2 = null;
                    if (dataset instanceof IntervalCategoryDataset) {
                        IntervalCategoryDataset intervalCategoryDataset = (IntervalCategoryDataset)dataset;
                        number = intervalCategoryDataset.getStartValue(i, j);
                        number2 = intervalCategoryDataset.getEndValue(i, j);
                    } else {
                        number2 = number = categoryDataset.getValue(i, j);
                    }
                    if (number != null) {
                        d = Math.min(d, number.doubleValue());
                    }
                    if (number2 == null) continue;
                    d2 = Math.max(d2, number2.doubleValue());
                }
            }
            if (d == Double.POSITIVE_INFINITY) {
                return null;
            }
            return new Range(d, d2);
        }
        if (dataset instanceof XYDataset) {
            XYDataset xYDataset = (XYDataset)dataset;
            double d = Double.POSITIVE_INFINITY;
            double d3 = Double.NEGATIVE_INFINITY;
            int n = xYDataset.getSeriesCount();
            for (int i = 0; i < n; ++i) {
                int n3 = xYDataset.getItemCount(i);
                for (int j = 0; j < n3; ++j) {
                    XYDataset xYDataset2;
                    Number number = null;
                    Number number3 = null;
                    if (dataset instanceof IntervalXYDataset) {
                        xYDataset2 = (IntervalXYDataset)dataset;
                        number = xYDataset2.getStartYValue(i, j);
                        number3 = xYDataset2.getEndYValue(i, j);
                    } else if (dataset instanceof HighLowDataset) {
                        xYDataset2 = (HighLowDataset)dataset;
                        number = xYDataset2.getLowValue(i, j);
                        number3 = xYDataset2.getHighValue(i, j);
                    } else {
                        number3 = number = xYDataset.getYValue(i, j);
                    }
                    if (number != null) {
                        d = Math.min(d, number.doubleValue());
                    }
                    if (number3 == null) continue;
                    d3 = Math.max(d3, number3.doubleValue());
                }
            }
            if (d == Double.POSITIVE_INFINITY) {
                return null;
            }
            return new Range(d, d3);
        }
        return null;
    }

    public static Number getMinimumDomainValue(Dataset dataset) {
        if (dataset == null) {
            throw new IllegalArgumentException("DatasetUtilities.getMinimumDomainValue: null dataset not allowed.");
        }
        if (dataset instanceof CategoryDataset && !(dataset instanceof XYDataset)) {
            throw new IllegalArgumentException("DatasetUtilities.getMinimumDomainValue(...): TableDataset does not have numerical domain.");
        }
        if (dataset instanceof DomainInfo) {
            DomainInfo domainInfo = (DomainInfo)((Object)dataset);
            return domainInfo.getMinimumDomainValue();
        }
        if (dataset instanceof XYDataset) {
            double d = Double.POSITIVE_INFINITY;
            XYDataset xYDataset = (XYDataset)dataset;
            int n = xYDataset.getSeriesCount();
            for (int i = 0; i < n; ++i) {
                int n2 = xYDataset.getItemCount(i);
                for (int j = 0; j < n2; ++j) {
                    Number number = null;
                    if (dataset instanceof IntervalXYDataset) {
                        IntervalXYDataset intervalXYDataset = (IntervalXYDataset)dataset;
                        number = intervalXYDataset.getStartXValue(i, j);
                    } else {
                        number = xYDataset.getXValue(i, j);
                    }
                    if (number == null) continue;
                    d = Math.min(d, number.doubleValue());
                }
            }
            if (d == Double.POSITIVE_INFINITY) {
                return null;
            }
            return new Double(d);
        }
        return null;
    }

    public static Number getMaximumDomainValue(Dataset dataset) {
        if (dataset == null) {
            throw new IllegalArgumentException("Datasets.getMaximumDomainValue: null dataset not allowed.");
        }
        if (dataset instanceof CategoryDataset && !(dataset instanceof XYDataset)) {
            throw new IllegalArgumentException("Datasets.getMaximumDomainValue(...): CategoryDataset does not have numerical domain.");
        }
        if (dataset instanceof DomainInfo) {
            DomainInfo domainInfo = (DomainInfo)((Object)dataset);
            return domainInfo.getMaximumDomainValue();
        }
        if (dataset instanceof XYDataset) {
            XYDataset xYDataset = (XYDataset)dataset;
            double d = Double.NEGATIVE_INFINITY;
            int n = xYDataset.getSeriesCount();
            for (int i = 0; i < n; ++i) {
                int n2 = xYDataset.getItemCount(i);
                for (int j = 0; j < n2; ++j) {
                    Number number = null;
                    if (dataset instanceof IntervalXYDataset) {
                        IntervalXYDataset intervalXYDataset = (IntervalXYDataset)dataset;
                        number = intervalXYDataset.getEndXValue(i, j);
                    } else {
                        number = xYDataset.getXValue(i, j);
                    }
                    if (number == null) continue;
                    d = Math.max(d, number.doubleValue());
                }
            }
            if (d == Double.NEGATIVE_INFINITY) {
                return null;
            }
            return new Double(d);
        }
        return null;
    }

    public static Number getMinimumRangeValue(Dataset dataset) {
        if (dataset == null) {
            throw new IllegalArgumentException("Datasets.getMinimumRangeValue: null dataset not allowed.");
        }
        if (dataset instanceof RangeInfo) {
            RangeInfo rangeInfo = (RangeInfo)((Object)dataset);
            return rangeInfo.getMinimumRangeValue();
        }
        if (dataset instanceof CategoryDataset) {
            CategoryDataset categoryDataset = (CategoryDataset)dataset;
            double d = Double.POSITIVE_INFINITY;
            int n = categoryDataset.getRowCount();
            int n2 = categoryDataset.getColumnCount();
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    Number number = null;
                    if (dataset instanceof IntervalCategoryDataset) {
                        IntervalCategoryDataset intervalCategoryDataset = (IntervalCategoryDataset)dataset;
                        number = intervalCategoryDataset.getStartValue(i, j);
                    } else {
                        number = categoryDataset.getValue(i, j);
                    }
                    if (number == null) continue;
                    d = Math.min(d, number.doubleValue());
                }
            }
            if (d == Double.POSITIVE_INFINITY) {
                return null;
            }
            return new Double(d);
        }
        if (dataset instanceof XYDataset) {
            XYDataset xYDataset = (XYDataset)dataset;
            double d = Double.POSITIVE_INFINITY;
            int n = xYDataset.getSeriesCount();
            for (int i = 0; i < n; ++i) {
                int n3 = xYDataset.getItemCount(i);
                for (int j = 0; j < n3; ++j) {
                    XYDataset xYDataset2;
                    Number number = null;
                    if (dataset instanceof IntervalXYDataset) {
                        xYDataset2 = (IntervalXYDataset)dataset;
                        number = xYDataset2.getStartYValue(i, j);
                    } else if (dataset instanceof HighLowDataset) {
                        xYDataset2 = (HighLowDataset)dataset;
                        number = xYDataset2.getLowValue(i, j);
                    } else {
                        number = xYDataset.getYValue(i, j);
                    }
                    if (number == null) continue;
                    d = Math.min(d, number.doubleValue());
                }
            }
            if (d == Double.POSITIVE_INFINITY) {
                return null;
            }
            return new Double(d);
        }
        return null;
    }

    public static Number getMaximumRangeValue(Dataset dataset) {
        if (dataset == null) {
            throw new IllegalArgumentException("Datasets.getMinimumRangeValue: null dataset not allowed.");
        }
        if (dataset instanceof RangeInfo) {
            RangeInfo rangeInfo = (RangeInfo)((Object)dataset);
            return rangeInfo.getMaximumRangeValue();
        }
        if (dataset instanceof CategoryDataset) {
            CategoryDataset categoryDataset = (CategoryDataset)dataset;
            double d = Double.NEGATIVE_INFINITY;
            int n = categoryDataset.getRowCount();
            int n2 = categoryDataset.getColumnCount();
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    Number number = null;
                    if (dataset instanceof IntervalCategoryDataset) {
                        IntervalCategoryDataset intervalCategoryDataset = (IntervalCategoryDataset)dataset;
                        number = intervalCategoryDataset.getEndValue(i, j);
                    } else {
                        number = categoryDataset.getValue(i, j);
                    }
                    if (number == null) continue;
                    d = Math.max(d, number.doubleValue());
                }
            }
            if (d == Double.NEGATIVE_INFINITY) {
                return null;
            }
            return new Double(d);
        }
        if (dataset instanceof XYDataset) {
            XYDataset xYDataset = (XYDataset)dataset;
            double d = Double.NEGATIVE_INFINITY;
            int n = xYDataset.getSeriesCount();
            for (int i = 0; i < n; ++i) {
                int n3 = xYDataset.getItemCount(i);
                for (int j = 0; j < n3; ++j) {
                    XYDataset xYDataset2;
                    Number number = null;
                    if (dataset instanceof IntervalXYDataset) {
                        xYDataset2 = (IntervalXYDataset)dataset;
                        number = xYDataset2.getEndYValue(i, j);
                    } else if (dataset instanceof HighLowDataset) {
                        xYDataset2 = (HighLowDataset)dataset;
                        number = xYDataset2.getHighValue(i, j);
                    } else {
                        number = xYDataset.getYValue(i, j);
                    }
                    if (number == null) continue;
                    d = Math.max(d, number.doubleValue());
                }
            }
            if (d == Double.NEGATIVE_INFINITY) {
                return null;
            }
            return new Double(d);
        }
        return null;
    }

    public static PieDataset createPieDatasetForRow(CategoryDataset categoryDataset, Comparable comparable) {
        int n = categoryDataset.getRowIndex(comparable);
        return DatasetUtilities.createPieDatasetForRow(categoryDataset, n);
    }

    public static PieDataset createPieDatasetForRow(CategoryDataset categoryDataset, int n) {
        DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
        int n2 = categoryDataset.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            Comparable comparable = categoryDataset.getColumnKey(i);
            defaultPieDataset.setValue(comparable, categoryDataset.getValue(n, i));
        }
        return defaultPieDataset;
    }

    public static PieDataset createPieDatasetForColumn(CategoryDataset categoryDataset, Comparable comparable) {
        int n = categoryDataset.getColumnIndex(comparable);
        return DatasetUtilities.createPieDatasetForColumn(categoryDataset, n);
    }

    public static PieDataset createPieDatasetForColumn(CategoryDataset categoryDataset, int n) {
        DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
        int n2 = categoryDataset.getRowCount();
        for (int i = 0; i < n2; ++i) {
            Comparable comparable = categoryDataset.getRowKey(i);
            defaultPieDataset.setValue(comparable, categoryDataset.getValue(i, n));
        }
        return defaultPieDataset;
    }

    public static double getPieDatasetTotal(PieDataset pieDataset) {
        List list = pieDataset.getKeys();
        double d = 0.0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Comparable comparable = (Comparable)iterator.next();
            if (comparable == null) continue;
            Number number = pieDataset.getValue(comparable);
            double d2 = 0.0;
            if (number != null) {
                d2 = number.doubleValue();
            }
            if (!(d2 > 0.0)) continue;
            d += d2;
        }
        return d;
    }

    public static Range getStackedRangeExtent(CategoryDataset categoryDataset) {
        Range range = null;
        if (categoryDataset != null) {
            double d = 0.0;
            double d2 = 0.0;
            int n = categoryDataset.getColumnCount();
            for (int i = 0; i < n; ++i) {
                double d3 = 0.0;
                double d4 = 0.0;
                int n2 = categoryDataset.getRowCount();
                for (int j = 0; j < n2; ++j) {
                    Number number = categoryDataset.getValue(j, i);
                    if (number == null) continue;
                    double d5 = number.doubleValue();
                    if (d5 > 0.0) {
                        d3 += d5;
                    }
                    if (!(d5 < 0.0)) continue;
                    d4 += d5;
                }
                d = Math.min(d, d4);
                d2 = Math.max(d2, d3);
            }
            range = new Range(d, d2);
        }
        return range;
    }

    public static Number getMinimumStackedRangeValue(CategoryDataset categoryDataset) {
        Double d = null;
        if (categoryDataset != null) {
            double d2 = 0.0;
            int n = categoryDataset.getRowCount();
            for (int i = 0; i < n; ++i) {
                double d3 = 0.0;
                int n2 = categoryDataset.getColumnCount();
                for (int j = 0; j < n2; ++j) {
                    double d4;
                    Number number = categoryDataset.getValue(j, i);
                    if (number == null || !((d4 = number.doubleValue()) < 0.0)) continue;
                    d3 += d4;
                }
                d2 = Math.min(d2, d3);
            }
            d = new Double(d2);
        }
        return d;
    }

    public static Number getMaximumStackedRangeValue(CategoryDataset categoryDataset) {
        Double d = null;
        if (categoryDataset != null) {
            double d2 = 0.0;
            int n = categoryDataset.getRowCount();
            for (int i = 0; i < n; ++i) {
                double d3 = 0.0;
                int n2 = categoryDataset.getColumnCount();
                for (int j = 0; j < n2; ++j) {
                    double d4;
                    Number number = categoryDataset.getValue(j, i);
                    if (number == null || !((d4 = number.doubleValue()) > 0.0)) continue;
                    d3 += d4;
                }
                d2 = Math.max(d2, d3);
            }
            d = new Double(d2);
        }
        return d;
    }

    public static XYDataset sampleFunction2D(Function2D function2D, double d, double d2, int n, String string) {
        if (d >= d2) {
            throw new IllegalArgumentException("DatasetUtilities.createXYDataset(...): start must be before end.");
        }
        if (n < 2) {
            throw new IllegalArgumentException("DatasetUtilities.createXYDataset(...): samples must be at least 2.");
        }
        XYSeries xYSeries = new XYSeries(string);
        double d3 = (d2 - d) / (double)n;
        for (int i = 0; i <= n; ++i) {
            double d4 = d + d3 * (double)i;
            xYSeries.add(d4, function2D.getValue(d4));
        }
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection(xYSeries);
        return xYSeriesCollection;
    }

    public static CategoryDataset createCategoryDataset(String string, String string2, double[][] dArray) {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        for (int i = 0; i < dArray.length; ++i) {
            String string3 = string + (i + 1);
            for (int j = 0; j < dArray[i].length; ++j) {
                String string4 = string2 + (j + 1);
                defaultCategoryDataset.addValue(new Double(dArray[i][j]), (Comparable)((Object)string3), (Comparable)((Object)string4));
            }
        }
        return defaultCategoryDataset;
    }

    public static CategoryDataset createCategoryDataset(String string, String string2, Number[][] numberArray) {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        for (int i = 0; i < numberArray.length; ++i) {
            String string3 = string + (i + 1);
            for (int j = 0; j < numberArray[i].length; ++j) {
                String string4 = string2 + (j + 1);
                defaultCategoryDataset.addValue(numberArray[i][j], (Comparable)((Object)string3), (Comparable)((Object)string4));
            }
        }
        return defaultCategoryDataset;
    }

    public static CategoryDataset createCategoryDataset(String[] stringArray, String[] stringArray2, double[][] dArray) {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        for (int i = 0; i < dArray.length; ++i) {
            String string = stringArray[i];
            for (int j = 0; j < dArray[i].length; ++j) {
                String string2 = stringArray2[j];
                defaultCategoryDataset.addValue(new Double(dArray[i][j]), (Comparable)((Object)string), (Comparable)((Object)string2));
            }
        }
        return defaultCategoryDataset;
    }

    public static CategoryDataset createCategoryDataset(String string, KeyedValues keyedValues) {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        for (int i = 0; i < keyedValues.getItemCount(); ++i) {
            defaultCategoryDataset.addValue(keyedValues.getValue(i), (Comparable)((Object)string), keyedValues.getKey(i));
        }
        return defaultCategoryDataset;
    }

    public static boolean isEmptyOrNull(XYDataset xYDataset) {
        boolean bl = true;
        if (xYDataset != null) {
            for (int i = 0; i < xYDataset.getSeriesCount(); ++i) {
                if (xYDataset.getItemCount(i) <= 0) continue;
                bl = false;
            }
        }
        return bl;
    }

    public static boolean isEmptyOrNull(PieDataset pieDataset) {
        if (pieDataset == null) {
            return true;
        }
        int n = pieDataset.getItemCount();
        if (n == 0) {
            return true;
        }
        for (int i = 0; i < n; ++i) {
            double d;
            Number number = pieDataset.getValue(i);
            if (number == null || !((d = number.doubleValue()) > 0.0)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmptyOrNull(CategoryDataset categoryDataset) {
        if (categoryDataset == null) {
            return true;
        }
        int n = categoryDataset.getRowCount();
        int n2 = categoryDataset.getColumnCount();
        if (n == 0 || n2 == 0) {
            return true;
        }
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (categoryDataset.getValue(i, j) == null) continue;
                return false;
            }
        }
        return true;
    }

    public static PieDataset limitPieDataset(PieDataset pieDataset, double d) {
        return DatasetUtilities.limitPieDataset(pieDataset, d, 1, "Other");
    }

    public static PieDataset limitPieDataset(PieDataset pieDataset, double d, int n) {
        return DatasetUtilities.limitPieDataset(pieDataset, d, n, "Other");
    }

    public static PieDataset limitPieDataset(PieDataset pieDataset, double d, int n, String string) {
        DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
        double d2 = DatasetUtilities.getPieDatasetTotal(pieDataset);
        List list = pieDataset.getKeys();
        ArrayList<Comparable> arrayList = new ArrayList<Comparable>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            double d3;
            Comparable comparable = (Comparable)iterator.next();
            Number number = pieDataset.getValue(comparable);
            if (number == null || !((d3 = number.doubleValue()) / d2 < d / 100.0)) continue;
            arrayList.add(comparable);
        }
        iterator = list.iterator();
        double d4 = 0.0;
        while (iterator.hasNext()) {
            Comparable comparable = (Comparable)iterator.next();
            Number number = pieDataset.getValue(comparable);
            if (number != null) {
                if (arrayList.contains(comparable) && arrayList.size() > n) {
                    d4 += number.doubleValue();
                } else {
                    defaultPieDataset.setValue(comparable, number);
                }
            }
            if (arrayList.size() <= n) continue;
            defaultPieDataset.setValue((Comparable)((Object)string), d4);
        }
        return defaultPieDataset;
    }

    public static Range getStackedRangeExtent(TableXYDataset tableXYDataset) {
        if (tableXYDataset == null) {
            return null;
        }
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < tableXYDataset.getItemCount(); ++i) {
            double d3 = 0.0;
            for (int j = 0; j < tableXYDataset.getSeriesCount(); ++j) {
                if (tableXYDataset.getYValue(j, i) == null) continue;
                d3 += tableXYDataset.getYValue(j, i).doubleValue();
            }
            if (d3 > d2) {
                d2 = d3;
            }
            if (!(d3 < d)) continue;
            d = d3;
        }
        if (d == Double.POSITIVE_INFINITY) {
            return null;
        }
        return new Range(d, d2);
    }

    public static Range getCumulativeRangeExtent(CategoryDataset categoryDataset) {
        if (categoryDataset == null) {
            return null;
        }
        boolean bl = true;
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < categoryDataset.getRowCount(); ++i) {
            double d3 = 0.0;
            for (int j = 0; j < categoryDataset.getColumnCount() - 1; ++j) {
                Number number = categoryDataset.getValue(i, j);
                if (number == null) continue;
                bl = false;
                double d4 = number.doubleValue();
                d = Math.min(d, d3 += d4);
                d2 = Math.max(d2, d3);
            }
        }
        if (!bl) {
            return new Range(d, d2);
        }
        return null;
    }
}

