/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.chart.AbstractTitle;
import org.jfree.chart.Spacer;
import org.jfree.chart.event.TitleChangeEvent;
import org.jfree.io.SerialUtilities;
import org.jfree.util.ObjectUtils;

public class TextTitle
extends AbstractTitle
implements Serializable,
Cloneable {
    public static final Font DEFAULT_FONT = new Font("SansSerif", 1, 12);
    public static final Paint DEFAULT_TEXT_PAINT = Color.black;
    private String text;
    private Font font;
    private transient Paint paint;
    private transient Paint backgroundPaint;

    public TextTitle(String string) {
        this(string, DEFAULT_FONT, DEFAULT_TEXT_PAINT, 0, 4, 4, AbstractTitle.DEFAULT_SPACER);
    }

    public TextTitle(String string, Font font) {
        this(string, font, DEFAULT_TEXT_PAINT, 0, 4, 4, AbstractTitle.DEFAULT_SPACER);
    }

    public TextTitle(String string, Font font, Paint paint) {
        this(string, font, paint, 0, 4, 4, AbstractTitle.DEFAULT_SPACER);
    }

    public TextTitle(String string, Font font, int n) {
        this(string, font, DEFAULT_TEXT_PAINT, 0, n, 4, AbstractTitle.DEFAULT_SPACER);
    }

    public TextTitle(String string, Font font, Paint paint, int n, int n2, int n3, Spacer spacer) {
        super(n, n2, n3, spacer);
        if (string == null) {
            throw new NullPointerException("TextTitle(..): Text is null");
        }
        if (font == null) {
            throw new NullPointerException("TextTitle(..): Font is null");
        }
        if (paint == null) {
            throw new NullPointerException("TextTitle(..): Paint is null");
        }
        this.text = string;
        this.font = font;
        this.paint = paint;
        this.backgroundPaint = null;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        if (string == null) {
            throw new NullPointerException("TextTitle.setText(..): Text is null");
        }
        if (!this.text.equals(string)) {
            this.text = string;
            this.notifyListeners(new TitleChangeEvent(this));
        }
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("TextTitle.setFont(...): null font not permitted.");
        }
        if (!this.font.equals(font)) {
            this.font = font;
            this.notifyListeners(new TitleChangeEvent(this));
        }
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("TextTitle.setPaint(...): null paint not permitted.");
        }
        if (!this.paint.equals(paint)) {
            this.paint = paint;
            this.notifyListeners(new TitleChangeEvent(this));
        }
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint paint) {
        this.backgroundPaint = paint;
        this.notifyListeners(new TitleChangeEvent(this));
    }

    public boolean isValidPosition(int n) {
        return n == 0 || n == 1;
    }

    public double getPreferredWidth(Graphics2D graphics2D) {
        graphics2D.setFont(this.font);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(this.font);
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(this.text, graphics2D);
        double d = rectangle2D.getWidth();
        Spacer spacer = this.getSpacer();
        if (spacer != null) {
            d = spacer.getAdjustedWidth(d);
        }
        return d;
    }

    public double getPreferredHeight(Graphics2D graphics2D) {
        double d = 0.0;
        graphics2D.setFont(this.font);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        LineMetrics lineMetrics = this.font.getLineMetrics(this.text, fontRenderContext);
        d = lineMetrics.getHeight();
        Spacer spacer = this.getSpacer();
        if (spacer != null) {
            d = spacer.getAdjustedHeight(d);
        }
        return d;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        this.drawHorizontal(graphics2D, rectangle2D);
    }

    protected void drawHorizontal(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        if (this.text.equals("")) {
            return;
        }
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        FontMetrics fontMetrics = graphics2D.getFontMetrics(this.font);
        Rectangle2D rectangle2D2 = fontMetrics.getStringBounds(this.text, graphics2D);
        LineMetrics lineMetrics = this.font.getLineMetrics(this.text, fontRenderContext);
        double d = rectangle2D2.getWidth();
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = lineMetrics.getHeight();
        double d5 = 0.0;
        double d6 = 0.0;
        Spacer spacer = this.getSpacer();
        d2 = spacer.getLeftSpace(rectangle2D.getWidth());
        d3 = spacer.getRightSpace(rectangle2D.getWidth());
        d5 = spacer.getTopSpace(d4);
        d6 = spacer.getBottomSpace(d4);
        double d7 = rectangle2D.getY() + d5;
        int n = this.getVerticalAlignment();
        if (n == 0) {
            d7 = d7 + d4 - (double)lineMetrics.getLeading() - (double)lineMetrics.getDescent();
        } else if (n == 4) {
            double d8 = rectangle2D.getHeight() - d5 - d6 - d4;
            d7 = d7 + d8 / 2.0 + d4 - (double)lineMetrics.getLeading() - (double)lineMetrics.getDescent();
        } else if (n == 1) {
            d7 = rectangle2D.getMaxY() - d6 - (double)lineMetrics.getLeading() - (double)lineMetrics.getDescent();
        }
        int n2 = this.getHorizontalAlignment();
        double d9 = rectangle2D.getX() + d2;
        if (n2 == 4) {
            d9 = d9 + (rectangle2D.getWidth() - d2 - d3) / 2.0 - d / 2.0;
        } else if (n2 == 3) {
            d9 = rectangle2D.getX() + d2;
        } else if (n2 == 2) {
            d9 = rectangle2D.getMaxX() - d3 - d;
        }
        if (this.backgroundPaint != null) {
            graphics2D.setPaint(this.backgroundPaint);
            graphics2D.fill(rectangle2D);
        }
        graphics2D.setFont(this.font);
        graphics2D.setPaint(this.paint);
        graphics2D.drawString(this.text, (float)d9, (float)d7);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof TextTitle) {
            TextTitle textTitle = (TextTitle)object;
            if (super.equals(object)) {
                if (!ObjectUtils.equal((Object)this.text, (Object)textTitle.text)) {
                    return false;
                }
                if (!ObjectUtils.equal((Object)this.font, (Object)textTitle.font)) {
                    return false;
                }
                return ObjectUtils.equal((Object)this.paint, (Object)textTitle.paint);
            }
        }
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint((Paint)this.paint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.backgroundPaint, (ObjectOutputStream)objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.paint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.backgroundPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
    }
}

