/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart;

public class CrosshairInfo {
    private boolean calculateDistanceInDataSpace = false;
    private double anchorX;
    private double anchorY;
    private double anchorXView;
    private double anchorYView;
    private double crosshairX;
    private double crosshairY;
    private double distance;

    public CrosshairInfo() {
    }

    public CrosshairInfo(boolean bl) {
        this.calculateDistanceInDataSpace = bl;
    }

    public void setCrosshairDistance(double d) {
        this.distance = d;
    }

    public void updateCrosshairPoint(double d, double d2, double d3, double d4) {
        double d5 = 0.0;
        d5 = this.calculateDistanceInDataSpace ? (d - this.anchorX) * (d - this.anchorX) + (d2 - this.anchorY) * (d2 - this.anchorY) : (d3 - this.anchorXView) * (d3 - this.anchorXView) + (d4 - this.anchorYView) * (d4 - this.anchorYView);
        if (d5 < this.distance) {
            this.crosshairX = d;
            this.crosshairY = d2;
            this.distance = d5;
        }
    }

    public void updateCrosshairX(double d) {
        double d2 = Math.abs(d - this.anchorX);
        if (d2 < this.distance) {
            this.crosshairX = d;
            this.distance = d2;
        }
    }

    public void updateCrosshairY(double d) {
        double d2 = Math.abs(d - this.anchorY);
        if (d2 < this.distance) {
            this.crosshairY = d;
            this.distance = d2;
        }
    }

    public void setAnchorX(double d) {
        this.anchorX = d;
        this.crosshairX = d;
    }

    public void setAnchorY(double d) {
        this.anchorY = d;
        this.crosshairY = d;
    }

    public void setAnchorXView(double d) {
        this.anchorXView = d;
    }

    public void setAnchorYView(double d) {
        this.anchorYView = d;
    }

    public double getCrosshairX() {
        return this.crosshairX;
    }

    public double getCrosshairY() {
        return this.crosshairY;
    }
}

