/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.writer;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import org.jfree.xml.writer.AttributeList;
import org.jfree.xml.writer.SafeTagList;

public class XMLWriterSupport {
    protected static final int OPEN_TAG_INCREASE = 1;
    protected static final int CLOSE_TAG_DECREASE = 2;
    protected static final int INDENT_ONLY = 3;
    public static final boolean CLOSE = true;
    public static final boolean OPEN = false;
    private static String lineSeparator;
    private SafeTagList safeTags;
    private int indentLevel;
    private String indentString;
    private boolean newLineOk;

    public XMLWriterSupport() {
        this(new SafeTagList(), 0);
    }

    public XMLWriterSupport(SafeTagList safeTagList, int n) {
        this(safeTagList, n, "    ");
    }

    public XMLWriterSupport(SafeTagList safeTagList, int n, String string) {
        if (string == null) {
            throw new NullPointerException("IndentString must not be null");
        }
        this.safeTags = safeTagList;
        this.indentLevel = n;
        this.indentString = string;
    }

    public void startBlock() throws IOException {
        ++this.indentLevel;
        this.allowLineBreak();
    }

    public void endBlock() throws IOException {
        --this.indentLevel;
        this.allowLineBreak();
    }

    public void allowLineBreak() throws IOException {
        this.newLineOk = true;
    }

    public static String getLineSeparator() {
        if (lineSeparator == null) {
            try {
                lineSeparator = System.getProperty("line.separator", "\n");
            }
            catch (SecurityException securityException) {
                lineSeparator = "\n";
            }
        }
        return lineSeparator;
    }

    public void writeTag(Writer writer, String string) throws IOException {
        if (this.newLineOk) {
            writer.write(XMLWriterSupport.getLineSeparator());
        }
        this.indent(writer, 1);
        writer.write("<");
        writer.write(string);
        writer.write(">");
        if (this.getSafeTags().isSafeForOpen(string)) {
            writer.write(XMLWriterSupport.getLineSeparator());
        }
    }

    public void writeCloseTag(Writer writer, String string) throws IOException {
        if (this.newLineOk || this.getSafeTags().isSafeForOpen(string)) {
            if (this.newLineOk) {
                writer.write(XMLWriterSupport.getLineSeparator());
            }
            this.indent(writer, 2);
        } else {
            this.decreaseIndent();
        }
        writer.write("</");
        writer.write(string);
        writer.write(">");
        if (this.getSafeTags().isSafeForClose(string)) {
            writer.write(XMLWriterSupport.getLineSeparator());
        }
        this.newLineOk = false;
    }

    public void writeTag(Writer writer, String string, String string2, String string3, boolean bl) throws IOException {
        AttributeList attributeList = new AttributeList();
        if (string2 != null) {
            attributeList.setAttribute(string2, string3);
        }
        this.writeTag(writer, string, attributeList, bl);
    }

    public void writeTag(Writer writer, String string, Properties properties, boolean bl) throws IOException {
        AttributeList attributeList = new AttributeList();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            attributeList.setAttribute(string2, properties.getProperty(string2));
        }
        this.writeTag(writer, string, attributeList, bl);
    }

    public void writeTag(Writer writer, String string, AttributeList attributeList, boolean bl) throws IOException {
        if (this.newLineOk) {
            writer.write(XMLWriterSupport.getLineSeparator());
            this.newLineOk = false;
        }
        this.indent(writer, 1);
        writer.write("<");
        writer.write(string);
        Iterator iterator = attributeList.keys();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = attributeList.getAttribute(string2);
            writer.write(" ");
            writer.write(string2);
            writer.write("=\"");
            writer.write(XMLWriterSupport.normalize(string3));
            writer.write("\"");
        }
        if (bl) {
            writer.write("/>");
            if (this.getSafeTags().isSafeForClose(string)) {
                writer.write(XMLWriterSupport.getLineSeparator());
            }
            this.decreaseIndent();
        } else {
            writer.write(">");
            if (this.getSafeTags().isSafeForOpen(string)) {
                writer.write(XMLWriterSupport.getLineSeparator());
            }
        }
    }

    public static String normalize(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string != null ? string.length() : 0;
        block7: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block7;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block7;
                }
                case '\n': {
                    if (i > 0) {
                        char c2 = stringBuffer.charAt(stringBuffer.length() - 1);
                        if (c2 != '\r') {
                            stringBuffer.append(XMLWriterSupport.getLineSeparator());
                            continue block7;
                        }
                        stringBuffer.append('\n');
                        continue block7;
                    }
                    stringBuffer.append(XMLWriterSupport.getLineSeparator());
                    continue block7;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    protected void indent(Writer writer, int n) throws IOException {
        if (n == 2) {
            this.decreaseIndent();
        }
        for (int i = 0; i < this.indentLevel; ++i) {
            writer.write(this.indentString);
        }
        if (n == 1) {
            this.increaseIndent();
        }
    }

    public int getIndentLevel() {
        return this.indentLevel;
    }

    protected void increaseIndent() {
        ++this.indentLevel;
    }

    protected void decreaseIndent() {
        --this.indentLevel;
    }

    public SafeTagList getSafeTags() {
        return this.safeTags;
    }
}

