/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.generator;

import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.jfree.util.HashNMap;
import org.jfree.xml.generator.SourceCollector;
import org.jfree.xml.generator.model.ClassDescription;
import org.jfree.xml.generator.model.DescriptionModel;
import org.jfree.xml.generator.model.MultiplexMappingInfo;
import org.jfree.xml.generator.model.PropertyInfo;
import org.jfree.xml.generator.model.PropertyType;
import org.jfree.xml.generator.model.TypeInfo;
import org.jfree.xml.util.BasicTypeSupport;

public final class ModelBuilder {
    private static ModelBuilder instance;
    private Properties handlerMapping = new Properties();
    static /* synthetic */ Class class$java$lang$Object;

    public static ModelBuilder getInstance() {
        if (instance == null) {
            instance = new ModelBuilder();
        }
        return instance;
    }

    private ModelBuilder() {
    }

    public void addAttributeHandlers(Properties properties) {
        this.handlerMapping.putAll((Map<?, ?>)properties);
    }

    private boolean contains(Class[] classArray, Class clazz) {
        for (int i = 0; i < classArray.length; ++i) {
            if (!classArray[i].equals(clazz)) continue;
            return true;
        }
        return false;
    }

    private Class[] fillModel(Class[] classArray, DescriptionModel descriptionModel) {
        ArrayList<Class> arrayList = new ArrayList<Class>();
        for (int i = 0; i < classArray.length; ++i) {
            Class clazz = classArray[i].getSuperclass();
            if (clazz != null) {
                if (clazz != (class$java$lang$Object == null ? ModelBuilder.class$("java.lang.Object") : class$java$lang$Object) && !this.contains(classArray, clazz) && !arrayList.contains(clazz)) {
                    arrayList.add(clazz);
                }
            } else {
                clazz = class$java$lang$Object == null ? ModelBuilder.class$("java.lang.Object") : class$java$lang$Object;
            }
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(classArray[i], clazz);
                ClassDescription classDescription = descriptionModel.get(classArray[i]);
                ClassDescription classDescription2 = this.createClassDescription(beanInfo, classDescription);
                if (classDescription2 == null) continue;
                descriptionModel.addClassDescription(classDescription2);
                continue;
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
        }
        return arrayList.toArray(new Class[0]);
    }

    public DescriptionModel buildModel(SourceCollector sourceCollector, DescriptionModel descriptionModel) {
        TypeInfo[] typeInfoArray;
        Class clazz;
        Class[] classArray = sourceCollector.getClasses();
        if (descriptionModel == null) {
            descriptionModel = new DescriptionModel();
        }
        while (classArray.length != 0) {
            classArray = this.fillModel(classArray, descriptionModel);
        }
        this.fillSuperClasses(descriptionModel);
        Class[] classArray2 = this.findElementTypes(descriptionModel);
        HashNMap hashNMap = new HashNMap();
        for (int i = 0; i < classArray2.length; ++i) {
            clazz = classArray2[i];
            for (int j = 0; j < classArray2.length; ++j) {
                typeInfoArray = classArray2[j];
                if (Modifier.isAbstract(typeInfoArray.getModifiers()) || !clazz.isAssignableFrom((Class<?>)typeInfoArray)) continue;
                hashNMap.add(clazz, typeInfoArray);
            }
        }
        Iterator iterator = hashNMap.keys();
        while (iterator.hasNext()) {
            clazz = (Class)iterator.next();
            Class[] classArray3 = (Class[])hashNMap.toArray(clazz, new Class[0]);
            if (classArray3.length < 2) {
                System.out.println("Prune: " + clazz);
                continue;
            }
            typeInfoArray = new TypeInfo[classArray3.length];
            for (int i = 0; i < classArray3.length; ++i) {
                TypeInfo typeInfo;
                typeInfoArray[i] = typeInfo = new TypeInfo(classArray3[i].getName(), classArray3[i]);
            }
            MultiplexMappingInfo multiplexMappingInfo = new MultiplexMappingInfo(clazz);
            multiplexMappingInfo.setChildClasses(typeInfoArray);
            descriptionModel.getMappingModel().addMultiplexMapping(multiplexMappingInfo);
        }
        return descriptionModel;
    }

    private Class[] findElementTypes(DescriptionModel descriptionModel) {
        ArrayList<Class> arrayList = new ArrayList<Class>();
        for (int i = 0; i < descriptionModel.size(); ++i) {
            ClassDescription classDescription = descriptionModel.get(i);
            if (!arrayList.contains(classDescription.getObjectClass())) {
                arrayList.add(classDescription.getObjectClass());
            }
            PropertyInfo[] propertyInfoArray = classDescription.getProperties();
            for (int j = 0; j < propertyInfoArray.length; ++j) {
                if (!propertyInfoArray[j].getPropertyType().equals(PropertyType.ELEMENT)) {
                    System.out.println("Filtering: " + propertyInfoArray[j].getType());
                    continue;
                }
                Class clazz = propertyInfoArray[j].getType();
                if (arrayList.contains(clazz)) continue;
                if (Modifier.isFinal(clazz.getModifiers())) {
                    System.out.println("Final: " + propertyInfoArray[j].getType());
                    continue;
                }
                arrayList.add(clazz);
            }
        }
        return arrayList.toArray(new Class[arrayList.size()]);
    }

    private void fillSuperClasses(DescriptionModel descriptionModel) {
        for (int i = 0; i < descriptionModel.size(); ++i) {
            ClassDescription classDescription;
            ClassDescription classDescription2 = descriptionModel.get(i);
            Class clazz = classDescription2.getObjectClass().getSuperclass();
            if (clazz == null || (classDescription = descriptionModel.get(clazz)) == null) continue;
            classDescription2.setSuperClass(classDescription.getObjectClass());
        }
    }

    private ClassDescription createClassDescription(BeanInfo beanInfo, ClassDescription classDescription) {
        Object object;
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        ArrayList<PropertyInfo> arrayList = new ArrayList<PropertyInfo>();
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            PropertyInfo propertyInfo;
            object = propertyDescriptorArray[i];
            if (classDescription != null && (propertyInfo = classDescription.getProperty(((FeatureDescriptor)object).getName())) != null) {
                System.out.println("Ingore predefined property: " + ((FeatureDescriptor)object).getName());
                continue;
            }
            if (propertyDescriptorArray[i] instanceof IndexedPropertyDescriptor || (propertyInfo = this.createSimplePropertyInfo(propertyDescriptorArray[i])) == null) continue;
            arrayList.add(propertyInfo);
        }
        PropertyInfo[] propertyInfoArray = arrayList.toArray(new PropertyInfo[arrayList.size()]);
        if (classDescription != null) {
            object = classDescription;
        } else {
            object = new ClassDescription(beanInfo.getBeanDescriptor().getBeanClass());
            ((ClassDescription)object).setDescription(beanInfo.getBeanDescriptor().getShortDescription());
        }
        ((ClassDescription)object).setProperties(propertyInfoArray);
        return object;
    }

    public static boolean isValidMethod(Method method) {
        if (method == null) {
            return false;
        }
        return Modifier.isPublic(method.getModifiers());
    }

    public PropertyInfo createSimplePropertyInfo(PropertyDescriptor propertyDescriptor) {
        boolean bl = ModelBuilder.isValidMethod(propertyDescriptor.getReadMethod());
        boolean bl2 = ModelBuilder.isValidMethod(propertyDescriptor.getWriteMethod());
        if (!bl2 || !bl) {
            return null;
        }
        PropertyInfo propertyInfo = new PropertyInfo(propertyDescriptor.getName(), propertyDescriptor.getPropertyType());
        propertyInfo.setConstrained(propertyDescriptor.isConstrained());
        propertyInfo.setDescription(propertyDescriptor.getShortDescription());
        propertyInfo.setNullable(true);
        propertyInfo.setPreserve(false);
        propertyInfo.setReadMethodAvailable(bl);
        propertyInfo.setWriteMethodAvailable(bl2);
        propertyInfo.setXmlName(propertyDescriptor.getName());
        if (this.isAttributeProperty(propertyDescriptor.getPropertyType())) {
            propertyInfo.setPropertyType(PropertyType.ATTRIBUTE);
            propertyInfo.setXmlHandler(this.getHandlerClass(propertyDescriptor.getPropertyType()));
        } else {
            propertyInfo.setPropertyType(PropertyType.ELEMENT);
        }
        return propertyInfo;
    }

    private boolean isAttributeProperty(Class clazz) {
        if (BasicTypeSupport.isBasicDataType(clazz)) {
            return true;
        }
        return this.handlerMapping.containsKey(clazz.getName());
    }

    private String getHandlerClass(Class clazz) {
        String string;
        if (BasicTypeSupport.isBasicDataType(clazz) && (string = BasicTypeSupport.getHandlerClass(clazz)) != null) {
            return string;
        }
        return this.handlerMapping.getProperty(clazz.getName());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

