/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class VerticalBagLayout
implements LayoutManager {
    int vgap;

    public VerticalBagLayout() {
        this(0);
    }

    public VerticalBagLayout(int n2) {
        this.vgap = n2;
    }

    public void removeLayoutComponent(Component component) {
    }

    public void layoutContainer(Container container) {
        Insets insets = container.insets();
        int n2 = insets.top;
        int n3 = container.size().height - insets.bottom;
        int n4 = insets.left;
        int n5 = container.size().width - insets.right;
        int n6 = container.countComponents();
        for (int i2 = 0; i2 < n6; ++i2) {
            Component component = container.getComponent(i2);
            if (!component.isVisible()) continue;
            int n7 = component.size().height;
            component.resize(n5 - n4, n7);
            Dimension dimension = component.preferredSize();
            component.reshape(n4, n2, n5 - n4, dimension.height);
            n2 += dimension.height + this.vgap;
        }
    }

    public String toString() {
        return this.getClass().getName() + "[vgap=" + this.vgap + "]";
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public Dimension minimumLayoutSize(Container container) {
        Dimension dimension = new Dimension();
        int n2 = container.countComponents();
        for (int i2 = 0; i2 < n2; ++i2) {
            Component component = container.getComponent(i2);
            if (!component.isVisible()) continue;
            Dimension dimension2 = component.minimumSize();
            dimension.width = Math.max(dimension2.width, dimension.width);
            dimension.height += dimension2.height + this.vgap;
        }
        Insets insets = container.insets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension = new Dimension();
        int n2 = container.countComponents();
        for (int i2 = 0; i2 < n2; ++i2) {
            Component component = container.getComponent(i2);
            Dimension dimension2 = component.preferredSize();
            dimension.width = Math.max(dimension2.width, dimension.width);
            dimension.height += dimension2.height + this.vgap;
        }
        Insets insets = container.insets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }
}

