/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;

public class UIDefaults
extends Hashtable {
    private static final Object PENDING = new String("Pending");
    private SwingPropertyChangeSupport changeSupport;
    private Vector resourceBundles;
    private Locale defaultLocale = Locale.getDefault();
    private Map resourceCache;
    static /* synthetic */ Class class$java$awt$Color;

    public UIDefaults() {
        this.resourceCache = new HashMap();
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public int getInt(Object object) {
        Object object2 = this.get(object);
        return object2 instanceof Integer ? (Integer)object2 : 0;
    }

    public boolean getBoolean(Object object) {
        Object object2 = this.get(object);
        return object2 instanceof Boolean ? (Boolean)object2 : false;
    }

    public UIDefaults(Object[] objectArray) {
        super(objectArray.length / 2);
        for (int i2 = 0; i2 < objectArray.length; i2 += 2) {
            super.put(objectArray[i2], objectArray[i2 + 1]);
        }
    }

    public void putDefaults(Object[] objectArray) {
        for (int i2 = 0; i2 < objectArray.length; i2 += 2) {
            Object object = objectArray[i2 + 1];
            if (object == null) {
                super.remove(objectArray[i2]);
                continue;
            }
            super.put(objectArray[i2], object);
        }
        this.firePropertyChange("UIDefaults", null, null);
    }

    public synchronized void addResourceBundle(String string) {
        if (string == null) {
            return;
        }
        if (this.resourceBundles == null) {
            this.resourceBundles = new Vector(5);
        }
        this.resourceBundles.add(string);
        this.resourceCache.clear();
    }

    protected void getUIError(String string) {
        System.err.println("UIDefaults.getUI() failed: " + string);
        try {
            throw new Error();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public synchronized void removeResourceBundle(String string) {
        if (this.resourceBundles != null) {
            this.resourceBundles.remove(string);
        }
        this.resourceCache.clear();
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public void setDefaultLocale(Locale locale) {
        this.defaultLocale = locale;
    }

    public Color getColor(Object object) {
        Object object2 = this.get(object);
        return object2 instanceof Color ? (Color)object2 : null;
    }

    public Dimension getDimension(Object object) {
        Object object2 = this.get(object);
        return object2 instanceof Dimension ? (Dimension)object2 : null;
    }

    public Font getFont(Object object) {
        Object object2 = this.get(object);
        return object2 instanceof Font ? (Font)object2 : null;
    }

    public Insets getInsets(Object object) {
        Object object2 = this.get(object);
        return object2 instanceof Insets ? (Insets)object2 : null;
    }

    public Class getUIClass(String string) {
        return this.getUIClass(string, null);
    }

    public Object get(Object object) {
        Object object2 = this.getFromHashtable(object);
        return object2 != null ? object2 : this.getFromResourceBundle(object, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getFromHashtable(Object object) {
        Object object2 = super.get(object);
        if (object2 != PENDING && !(object2 instanceof ActiveValue) && !(object2 instanceof LazyValue)) {
            return object2;
        }
        UIDefaults uIDefaults = this;
        synchronized (uIDefaults) {
            object2 = super.get(object);
            if (object2 == PENDING) {
                do {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while ((object2 = super.get(object)) == PENDING);
                return object2;
            }
            if (object2 instanceof LazyValue) {
                super.put(object, PENDING);
            } else if (!(object2 instanceof ActiveValue)) {
                return object2;
            }
        }
        if (object2 instanceof LazyValue) {
            UIDefaults uIDefaults2;
            try {
                object2 = ((LazyValue)object2).createValue(this);
                Object var7_6 = null;
                uIDefaults2 = this;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                UIDefaults uIDefaults3 = this;
                synchronized (uIDefaults3) {
                    if (object2 == null) {
                        super.remove(object);
                    } else {
                        super.put(object, object2);
                    }
                    this.notifyAll();
                }
                throw throwable;
            }
            synchronized (uIDefaults2) {
                if (object2 == null) {
                    super.remove(object);
                } else {
                    super.put(object, object2);
                }
                this.notifyAll();
            }
        }
        object2 = ((ActiveValue)object2).createValue(this);
        return object2;
    }

    public String getString(Object object) {
        Object object2 = this.get(object);
        return object2 instanceof String ? (String)object2 : null;
    }

    public int getInt(Object object, Locale locale) {
        Object object2 = this.get(object, locale);
        return object2 instanceof Integer ? (Integer)object2 : 0;
    }

    public boolean getBoolean(Object object, Locale locale) {
        Object object2 = this.get(object, locale);
        return object2 instanceof Boolean ? (Boolean)object2 : false;
    }

    private Map getResourceCache(Locale locale) {
        Map map = (Map)this.resourceCache.get(locale);
        if (map == null) {
            map = new HashMap();
            for (int i2 = this.resourceBundles.size() - 1; i2 >= 0; --i2) {
                String string = (String)this.resourceBundles.get(i2);
                try {
                    ResourceBundle resourceBundle = ResourceBundle.getBundle(string, locale);
                    Enumeration enumeration = resourceBundle.getKeys();
                    while (enumeration.hasMoreElements()) {
                        String string2 = (String)enumeration.nextElement();
                        if (map.get(string2) != null) continue;
                        Object object = resourceBundle.getObject(string2);
                        map.put(string2, object);
                    }
                    continue;
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            this.resourceCache.put(locale, map);
        }
        return map;
    }

    public Icon getIcon(Object object) {
        Object object2 = this.get(object);
        return object2 instanceof Icon ? (Icon)object2 : null;
    }

    public Border getBorder(Object object) {
        Object object2 = this.get(object);
        return object2 instanceof Border ? (Border)object2 : null;
    }

    public ComponentUI getUI(JComponent jComponent) {
        Object object = this.get("ClassLoader");
        ClassLoader classLoader = object != null ? (ClassLoader)object : jComponent.getClass().getClassLoader();
        Class clazz = this.getUIClass(jComponent.getUIClassID(), classLoader);
        Object object2 = null;
        if (clazz == null) {
            this.getUIError("no ComponentUI class for: " + jComponent);
        } else {
            try {
                Method method = (Method)this.get(clazz);
                if (method == null) {
                    Class clazz2 = JComponent.class;
                    method = clazz.getMethod("createUI", new Class[]{clazz2});
                    this.put(clazz, method);
                }
                object2 = method.invoke(null, new Object[]{jComponent});
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.getUIError("static createUI() method not found in " + clazz);
            }
            catch (Exception exception) {
                this.getUIError("createUI() failed for " + jComponent + " " + exception);
            }
        }
        return (ComponentUI)object2;
    }

    public Color getColor(Object object, Locale locale) {
        Object object2 = this.get(object, locale);
        return object2 instanceof Color ? (Color)object2 : null;
    }

    public Dimension getDimension(Object object, Locale locale) {
        Object object2 = this.get(object, locale);
        return object2 instanceof Dimension ? (Dimension)object2 : null;
    }

    public Font getFont(Object object, Locale locale) {
        Object object2 = this.get(object, locale);
        return object2 instanceof Font ? (Font)object2 : null;
    }

    public Insets getInsets(Object object, Locale locale) {
        Object object2 = this.get(object, locale);
        return object2 instanceof Insets ? (Insets)object2 : null;
    }

    public Class getUIClass(String string, ClassLoader classLoader) {
        try {
            String string2 = (String)this.get(string);
            if (string2 != null) {
                Class clazz = (Class)this.get(string2);
                if (clazz == null && (clazz = classLoader == null ? SwingUtilities.loadSystemClass(string2) : classLoader.loadClass(string2)) != null) {
                    this.put(string2, clazz);
                }
                return clazz;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
        return null;
    }

    public Object put(Object object, Object object2) {
        Object object3;
        Object object4 = object3 = object2 == null ? super.remove(object) : super.put(object, object2);
        if (object instanceof String) {
            this.firePropertyChange((String)object, object3, object2);
        }
        return object3;
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(string, object, object2);
        }
    }

    public Object get(Object object, Locale locale) {
        Object object2 = this.getFromHashtable(object);
        return object2 != null ? object2 : this.getFromResourceBundle(object, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getFromResourceBundle(Object object, Locale locale) {
        if (this.resourceBundles == null || this.resourceBundles.isEmpty() || !(object instanceof String)) {
            return null;
        }
        if (locale == null) {
            if (this.defaultLocale == null) {
                return null;
            }
            locale = this.defaultLocale;
        }
        UIDefaults uIDefaults = this;
        synchronized (uIDefaults) {
            return this.getResourceCache(locale).get((String)object);
        }
    }

    public String getString(Object object, Locale locale) {
        Object object2 = this.get(object, locale);
        return object2 instanceof String ? (String)object2 : null;
    }

    public Icon getIcon(Object object, Locale locale) {
        Object object2 = this.get(object, locale);
        return object2 instanceof Icon ? (Icon)object2 : null;
    }

    public Border getBorder(Object object, Locale locale) {
        Object object2 = this.get(object, locale);
        return object2 instanceof Border ? (Border)object2 : null;
    }

    public static interface ActiveValue {
        public Object createValue(UIDefaults var1);
    }

    public static class LazyInputMap
    implements LazyValue {
        private Object[] bindings;

        public LazyInputMap(Object[] objectArray) {
            this.bindings = objectArray;
        }

        public Object createValue(UIDefaults uIDefaults) {
            if (this.bindings != null) {
                InputMap inputMap = LookAndFeel.makeInputMap(this.bindings);
                return inputMap;
            }
            return null;
        }
    }

    public static interface LazyValue {
        public Object createValue(UIDefaults var1);
    }

    public static class ProxyLazyValue
    implements LazyValue {
        private String className;
        private String methodName;
        private Object[] args;

        public ProxyLazyValue(String string) {
            this(string, (String)null);
        }

        private Class[] getClassArray(Object[] objectArray) {
            Class[] classArray = null;
            if (objectArray != null) {
                classArray = new Class[objectArray.length];
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    classArray[i2] = objectArray[i2] instanceof Integer ? Integer.TYPE : (objectArray[i2] instanceof Boolean ? Boolean.TYPE : (objectArray[i2] instanceof ColorUIResource ? (class$java$awt$Color == null ? UIDefaults.class$("java.awt.Color") : class$java$awt$Color) : objectArray[i2].getClass()));
                }
            }
            return classArray;
        }

        public ProxyLazyValue(String string, Object[] objectArray) {
            this(string, null, objectArray);
        }

        public Object createValue(UIDefaults uIDefaults) {
            Object object = null;
            try {
                Object object2;
                Class clazz = uIDefaults != null && (object2 = uIDefaults.get("ClassLoader")) instanceof ClassLoader ? Class.forName(this.className, true, (ClassLoader)object2) : Class.forName(this.className, true, Thread.currentThread().getContextClassLoader());
                if (this.methodName != null) {
                    Class[] classArray = this.getClassArray(this.args);
                    Method method = clazz.getMethod(this.methodName, classArray);
                    object = method.invoke(clazz, this.args);
                } else {
                    Class[] classArray = this.getClassArray(this.args);
                    Constructor constructor = clazz.getConstructor(classArray);
                    object = constructor.newInstance(this.args);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return object;
        }

        private String printArgs(Object[] objectArray) {
            String string = "{";
            if (objectArray != null) {
                for (int i2 = 0; i2 < objectArray.length - 1; ++i2) {
                    string = string.concat(objectArray[i2] + ",");
                }
                string = string.concat(objectArray[objectArray.length - 1] + "}");
            } else {
                string = string.concat("}");
            }
            return string;
        }

        public ProxyLazyValue(String string, String string2) {
            this(string, string2, null);
        }

        public ProxyLazyValue(String string, String string2, Object[] objectArray) {
            this.className = string;
            this.methodName = string2;
            this.args = objectArray;
        }
    }
}

