/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.SystemEventQueueUtilities;
import sun.security.action.GetPropertyAction;

public class RepaintManager {
    Hashtable dirtyComponents = new Hashtable();
    Hashtable tmpDirtyComponents = new Hashtable();
    Vector invalidComponents;
    boolean doubleBufferingEnabled = true;
    private Dimension doubleBufferMaxSize;
    DoubleBufferInfo standardDoubleBuffer;
    DoubleBufferInfo volatileDoubleBuffer;
    private static final Object repaintManagerKey = RepaintManager.class;
    static boolean volatileImageBufferEnabled = true;
    static final int VOLATILE_LOOP_MAX = 1;
    Rectangle tmp = new Rectangle();

    static {
        String string = (String)AccessController.doPrivileged(new GetPropertyAction("swing.volatileImageBufferEnabled"));
        volatileImageBufferEnabled = string == null || string.equals("true");
    }

    public RepaintManager() {
        SwingUtilities.doPrivileged(new Runnable(){

            public void run() {
                boolean bl2 = Boolean.getBoolean("awt.nativeDoubleBuffering");
                RepaintManager.this.doubleBufferingEnabled = !bl2;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintDirtyRegions() {
        JComponent jComponent;
        Object object = this;
        synchronized (object) {
            Hashtable hashtable = this.tmpDirtyComponents;
            this.tmpDirtyComponents = this.dirtyComponents;
            this.dirtyComponents = hashtable;
            this.dirtyComponents.clear();
        }
        int n2 = this.tmpDirtyComponents.size();
        if (n2 == 0) {
            return;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        Vector vector = new Vector(n2);
        Enumeration enumeration = this.tmpDirtyComponents.keys();
        while (enumeration.hasMoreElements()) {
            jComponent = (JComponent)enumeration.nextElement();
            this.collectDirtyComponents(this.tmpDirtyComponents, jComponent, vector);
        }
        n2 = vector.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            jComponent = (JComponent)vector.elementAt(i2);
            object = (Rectangle)this.tmpDirtyComponents.get(jComponent);
            n5 = jComponent.getHeight();
            n6 = jComponent.getWidth();
            SwingUtilities.computeIntersection(n3, n4, n6, n5, (Rectangle)object);
            jComponent.paintImmediately(((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).width, ((Rectangle)object).height);
        }
        this.tmpDirtyComponents.clear();
    }

    void resetDoubleBuffer() {
        if (this.standardDoubleBuffer != null) {
            this.standardDoubleBuffer.needsReset = true;
        }
    }

    void resetVolatileDoubleBuffer() {
        if (this.volatileDoubleBuffer != null) {
            this.volatileDoubleBuffer.needsReset = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateInvalidComponents() {
        Vector vector;
        RepaintManager repaintManager = this;
        synchronized (repaintManager) {
            if (this.invalidComponents == null) {
                return;
            }
            vector = this.invalidComponents;
            this.invalidComponents = null;
        }
        int n2 = vector.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ((Component)vector.elementAt(i2)).validate();
        }
    }

    public boolean isDoubleBufferingEnabled() {
        return this.doubleBufferingEnabled;
    }

    boolean useVolatileDoubleBuffer() {
        return volatileImageBufferEnabled;
    }

    public void setDoubleBufferingEnabled(boolean bl2) {
        this.doubleBufferingEnabled = bl2;
    }

    public Dimension getDoubleBufferMaximumSize() {
        if (this.doubleBufferMaxSize == null) {
            try {
                this.doubleBufferMaxSize = Toolkit.getDefaultToolkit().getScreenSize();
            }
            catch (HeadlessException headlessException) {
                this.doubleBufferMaxSize = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
            }
        }
        return this.doubleBufferMaxSize;
    }

    public void setDoubleBufferMaximumSize(Dimension dimension) {
        this.doubleBufferMaxSize = dimension;
        if (this.standardDoubleBuffer != null && this.standardDoubleBuffer.image != null && (this.standardDoubleBuffer.image.getWidth(null) > dimension.width || this.standardDoubleBuffer.image.getHeight(null) > dimension.height)) {
            this.standardDoubleBuffer.image = null;
        }
        if (this.volatileDoubleBuffer != null && this.volatileDoubleBuffer.image != null && (this.volatileDoubleBuffer.image.getWidth(null) > dimension.width || this.volatileDoubleBuffer.image.getHeight(null) > dimension.height)) {
            this.volatileDoubleBuffer.image = null;
        }
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.dirtyComponents != null) {
            stringBuffer.append("" + this.dirtyComponents);
        }
        return stringBuffer.toString();
    }

    public synchronized void addInvalidComponent(JComponent jComponent) {
        Component component;
        Component component2 = null;
        for (component = jComponent; component != null; component = component.getParent()) {
            if (component instanceof CellRendererPane || component.getPeer() == null) {
                return;
            }
            if (!(component instanceof JComponent) || !component.isValidateRoot()) continue;
            component2 = component;
            break;
        }
        if (component2 == null) {
            return;
        }
        component = null;
        for (Component component3 = component2; component3 != null; component3 = component3.getParent()) {
            if (!component3.isVisible() || component3.getPeer() == null) {
                return;
            }
            if (!(component3 instanceof Window) && !(component3 instanceof Applet)) continue;
            component = component3;
            break;
        }
        if (component == null) {
            return;
        }
        if (this.invalidComponents == null) {
            this.invalidComponents = new Vector();
        } else {
            int n2 = this.invalidComponents.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (component2 != (Component)this.invalidComponents.elementAt(i2)) continue;
                return;
            }
        }
        this.invalidComponents.addElement(component2);
        SystemEventQueueUtilities.queueComponentWorkRequest(component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markCompletelyClean(JComponent jComponent) {
        RepaintManager repaintManager = this;
        synchronized (repaintManager) {
            this.dirtyComponents.remove(jComponent);
        }
    }

    public void markCompletelyDirty(JComponent jComponent) {
        this.addDirtyRegion(jComponent, 0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public synchronized void removeInvalidComponent(JComponent jComponent) {
        int n2;
        if (this.invalidComponents != null && (n2 = this.invalidComponents.indexOf(jComponent)) != -1) {
            this.invalidComponents.removeElementAt(n2);
        }
    }

    public boolean isCompletelyDirty(JComponent jComponent) {
        Rectangle rectangle = this.getDirtyRegion(jComponent);
        return rectangle.width == Integer.MAX_VALUE && rectangle.height == Integer.MAX_VALUE;
    }

    public synchronized void addDirtyRegion(JComponent jComponent, int n2, int n3, int n4, int n5) {
        if (n4 <= 0 || n5 <= 0 || jComponent == null) {
            return;
        }
        if (jComponent.getWidth() <= 0 || jComponent.getHeight() <= 0) {
            return;
        }
        Rectangle rectangle = (Rectangle)this.dirtyComponents.get(jComponent);
        if (rectangle != null) {
            SwingUtilities.computeUnion(n2, n3, n4, n5, rectangle);
            return;
        }
        JComponent jComponent2 = null;
        for (Container container = jComponent; container != null; container = container.getParent()) {
            if (!container.isVisible() || container.getPeer() == null) {
                return;
            }
            if (!(container instanceof Window) && !(container instanceof Applet)) continue;
            if (container instanceof Frame && (((Frame)container).getExtendedState() & 1) == 1) {
                return;
            }
            jComponent2 = container;
            break;
        }
        if (jComponent2 == null) {
            return;
        }
        this.dirtyComponents.put(jComponent, new Rectangle(n2, n3, n4, n5));
        SystemEventQueueUtilities.queueComponentWorkRequest(jComponent2);
    }

    public static void setCurrentManager(RepaintManager repaintManager) {
        if (repaintManager != null) {
            SwingUtilities.appContextPut(repaintManagerKey, repaintManager);
        } else {
            SwingUtilities.appContextRemove(repaintManagerKey);
        }
    }

    public Image getOffscreenBuffer(Component component, int n2, int n3) {
        return this._getOffscreenBuffer(component, n2, n3, false);
    }

    public Image getVolatileOffscreenBuffer(Component component, int n2, int n3) {
        return this._getOffscreenBuffer(component, n2, n3, true);
    }

    private Image _getOffscreenBuffer(Component component, int n2, int n3, boolean bl2) {
        int n4;
        int n5;
        Dimension dimension = this.getDoubleBufferMaximumSize();
        DoubleBufferInfo doubleBufferInfo = null;
        if (bl2) {
            if (this.volatileDoubleBuffer == null) {
                this.volatileDoubleBuffer = new DoubleBufferInfo();
            }
            doubleBufferInfo = this.volatileDoubleBuffer;
        } else {
            if (this.standardDoubleBuffer == null) {
                this.standardDoubleBuffer = new DoubleBufferInfo();
            }
            doubleBufferInfo = this.standardDoubleBuffer;
        }
        int n6 = n2 < 1 ? 1 : (n5 = n2 > dimension.width ? dimension.width : n2);
        int n7 = n3 < 1 ? 1 : (n4 = n3 > dimension.height ? dimension.height : n3);
        if (doubleBufferInfo.needsReset || doubleBufferInfo.image != null && (doubleBufferInfo.size.width < n5 || doubleBufferInfo.size.height < n4)) {
            doubleBufferInfo.needsReset = false;
            if (doubleBufferInfo.image != null) {
                doubleBufferInfo.image.flush();
                doubleBufferInfo.image = null;
            }
            n5 = Math.max(doubleBufferInfo.size.width, n5);
            n4 = Math.max(doubleBufferInfo.size.height, n4);
        }
        Image image = doubleBufferInfo.image;
        if (doubleBufferInfo.image == null) {
            image = bl2 ? component.createVolatileImage(n5, n4) : component.createImage(n5, n4);
            doubleBufferInfo.size = new Dimension(n5, n4);
            if (component instanceof JComponent) {
                ((JComponent)component).setCreatedDoubleBuffer(bl2, true);
                doubleBufferInfo.image = image;
            }
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle getDirtyRegion(JComponent jComponent) {
        Rectangle rectangle = null;
        RepaintManager repaintManager = this;
        synchronized (repaintManager) {
            rectangle = (Rectangle)this.dirtyComponents.get(jComponent);
        }
        if (rectangle == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        return new Rectangle(rectangle);
    }

    public static RepaintManager currentManager(Component component) {
        RepaintManager repaintManager = (RepaintManager)SwingUtilities.appContextGet(repaintManagerKey);
        if (repaintManager == null) {
            repaintManager = new RepaintManager();
            SwingUtilities.appContextPut(repaintManagerKey, repaintManager);
        }
        return repaintManager;
    }

    public static RepaintManager currentManager(JComponent jComponent) {
        return RepaintManager.currentManager((Component)jComponent);
    }

    void collectDirtyComponents(Hashtable hashtable, JComponent jComponent, Vector vector) {
        Container container;
        JComponent jComponent2;
        Container container2 = jComponent2 = jComponent;
        Rectangle rectangle = jComponent._bounds;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        this.tmp.setBounds((Rectangle)hashtable.get(jComponent));
        SwingUtilities.computeIntersection(0, 0, rectangle.width, rectangle.height, this.tmp);
        if (this.tmp.isEmpty()) {
            return;
        }
        while ((container = container2.getParent()) != null && container instanceof JComponent) {
            container2 = container;
            n3 += rectangle.x;
            n5 += rectangle.y;
            this.tmp.setLocation(this.tmp.x + rectangle.x, this.tmp.y + rectangle.y);
            rectangle = container2._bounds;
            this.tmp = SwingUtilities.computeIntersection(0, 0, rectangle.width, rectangle.height, this.tmp);
            if (this.tmp.isEmpty()) {
                return;
            }
            if (hashtable.get(container2) == null) continue;
            jComponent2 = container2;
            n2 = n3;
            n4 = n5;
        }
        if (jComponent != jComponent2) {
            this.tmp.setLocation(this.tmp.x + n2 - n3, this.tmp.y + n4 - n5);
            Rectangle rectangle2 = (Rectangle)hashtable.get(jComponent2);
            SwingUtilities.computeUnion(this.tmp.x, this.tmp.y, this.tmp.width, this.tmp.height, rectangle2);
        }
        if (!vector.contains(jComponent2)) {
            vector.addElement(jComponent2);
        }
    }

    private class DoubleBufferInfo {
        public Image image;
        public Dimension size;
        public boolean needsReset = false;

        private DoubleBufferInfo() {
        }
    }
}

