/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.SunMidiFileReader;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiFileFormat;
import javax.sound.midi.Sequence;

public class RmfFileReader
extends SunMidiFileReader {
    static final int RMF_MAGIC = 1230128474;
    private static final int MIDI_TYPE_1 = 1;
    private static final int bisBufferSize = 1024;
    public static final int[] types = new int[]{1};

    public MidiFileFormat getMidiFileFormat(File file) throws InvalidMidiDataException, IOException {
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        MidiFileFormat midiFileFormat = null;
        fileInputStream = new FileInputStream(file);
        bufferedInputStream = new BufferedInputStream(fileInputStream, 1024);
        midiFileFormat = this.getMidiFileFormat(bufferedInputStream);
        bufferedInputStream.close();
        return midiFileFormat;
    }

    public MidiFileFormat getMidiFileFormat(InputStream inputStream) throws InvalidMidiDataException, IOException {
        int n2 = 16;
        int n3 = -1;
        float f2 = -1.0f;
        int n4 = -1;
        int n5 = -1;
        MidiFileFormat midiFileFormat = null;
        int n6 = types[0];
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        dataInputStream.mark(n2);
        int n7 = dataInputStream.readInt();
        if (n7 != 1230128474) {
            dataInputStream.reset();
            throw new InvalidMidiDataException("not a valid RMF file");
        }
        dataInputStream.reset();
        midiFileFormat = new MidiFileFormat(n6, f2, n4, n3, n5);
        return midiFileFormat;
    }

    public MidiFileFormat getMidiFileFormat(URL uRL) throws InvalidMidiDataException, IOException {
        InputStream inputStream = null;
        BufferedInputStream bufferedInputStream = null;
        MidiFileFormat midiFileFormat = null;
        inputStream = uRL.openStream();
        bufferedInputStream = new BufferedInputStream(inputStream, 1024);
        midiFileFormat = this.getMidiFileFormat(bufferedInputStream);
        bufferedInputStream.close();
        return midiFileFormat;
    }

    public Sequence getSequence(File file) throws InvalidMidiDataException, IOException {
        throw new InvalidMidiDataException("cannot get sequence from RMF file");
    }

    public Sequence getSequence(InputStream inputStream) throws InvalidMidiDataException, IOException {
        throw new InvalidMidiDataException("cannot get sequence from RMF file");
    }

    public Sequence getSequence(URL uRL) throws InvalidMidiDataException, IOException {
        throw new InvalidMidiDataException("cannot get sequence from RMF file");
    }
}

