/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.LazyActionMap;
import com.sun.java.swing.plaf.gtk.Region;
import com.sun.java.swing.plaf.gtk.SynthArrowButton;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthLookAndFeel;
import com.sun.java.swing.plaf.gtk.SynthStyle;
import com.sun.java.swing.plaf.gtk.SynthUI;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BoundedRangeModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ScrollBarUI;

class SynthScrollBarUI
extends ScrollBarUI
implements SynthUI,
LayoutManager,
SwingConstants,
FocusListener {
    private static final int POSITIVE_SCROLL = 1;
    private static final int NEGATIVE_SCROLL = -1;
    private static final int MIN_SCROLL = 2;
    private static final int MAX_SCROLL = 3;
    private static final Insets tmpInsets = new Insets(0, 0, 0, 0);
    private SynthStyle style;
    private SynthStyle thumbStyle;
    private SynthStyle trackStyle;
    protected Dimension minimumThumbSize;
    protected Dimension maximumThumbSize;
    protected JScrollBar scrollbar;
    protected JButton incrButton;
    protected JButton decrButton;
    protected boolean isDragging;
    protected TrackListener trackListener;
    protected ArrowButtonListener buttonListener;
    protected ModelListener modelListener;
    protected Rectangle thumbRect;
    protected Rectangle trackRect;
    protected int trackHighlight;
    protected static final int NO_HIGHLIGHT = 0;
    protected static final int DECREASE_HIGHLIGHT = 1;
    protected static final int INCREASE_HIGHLIGHT = 2;
    protected ScrollListener scrollListener;
    protected PropertyChangeListener propertyChangeListener;
    protected Timer scrollTimer;
    private boolean thumbActive;
    private static final int scrollSpeedThrottle = 60;
    private boolean supportsAbsolutePositioning;
    private int scrollBarWidth;

    int getTrackHighlight() {
        return this.trackHighlight;
    }

    SynthScrollBarUI() {
    }

    protected void installComponents() {
        switch (this.scrollbar.getOrientation()) {
            case 1: {
                this.incrButton = this.createIncreaseButton(5);
                this.decrButton = this.createDecreaseButton(1);
                break;
            }
            case 0: {
                if (this.scrollbar.getComponentOrientation().isLeftToRight()) {
                    this.incrButton = this.createIncreaseButton(3);
                    this.decrButton = this.createDecreaseButton(7);
                    break;
                }
                this.incrButton = this.createIncreaseButton(7);
                this.decrButton = this.createDecreaseButton(3);
            }
        }
        this.scrollbar.add(this.incrButton);
        this.scrollbar.add(this.decrButton);
    }

    protected void installDefaults() {
        this.fetchStyle(this.scrollbar);
        this.trackHighlight = 0;
        this.scrollbar.setLayout(this);
    }

    protected void installKeyboardActions() {
        LazyActionMap.installLazyActionMap(this.scrollbar, SynthScrollBarUI.class, "ScrollBar.actionMap");
        InputMap inputMap = this.getInputMap(0);
        SwingUtilities.replaceUIInputMap(this.scrollbar, 0, inputMap);
    }

    protected void installListeners() {
        this.trackListener = this.createTrackListener();
        this.buttonListener = this.createArrowButtonListener();
        this.modelListener = this.createModelListener();
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.scrollbar.addMouseListener(this.trackListener);
        this.scrollbar.addMouseMotionListener(this.trackListener);
        this.scrollbar.getModel().addChangeListener(this.modelListener);
        this.scrollbar.addPropertyChangeListener(this.propertyChangeListener);
        if (this.incrButton != null) {
            this.incrButton.addMouseListener(this.buttonListener);
        }
        if (this.decrButton != null) {
            this.decrButton.addMouseListener(this.buttonListener);
        }
        this.scrollListener = this.createScrollListener();
        this.scrollTimer = new Timer(60, this.scrollListener);
        this.scrollTimer.setInitialDelay(300);
        this.scrollbar.addFocusListener(this);
    }

    protected void uninstallComponents() {
        this.scrollbar.remove(this.incrButton);
        this.scrollbar.remove(this.decrButton);
    }

    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext((JComponent)this.scrollbar, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
        synthContext = this.getContext(this.scrollbar, Region.SCROLL_BAR_TRACK, 1);
        this.trackStyle.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.trackStyle = null;
        synthContext = this.getContext(this.scrollbar, Region.SCROLL_BAR_THUMB, 1);
        this.thumbStyle.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.thumbStyle = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.scrollbar, 0, null);
        SwingUtilities.replaceUIActionMap(this.scrollbar, null);
    }

    protected void uninstallListeners() {
        this.scrollTimer.stop();
        this.scrollTimer = null;
        if (this.decrButton != null) {
            this.decrButton.removeMouseListener(this.buttonListener);
        }
        if (this.incrButton != null) {
            this.incrButton.removeMouseListener(this.buttonListener);
        }
        this.scrollbar.getModel().removeChangeListener(this.modelListener);
        this.scrollbar.removeMouseListener(this.trackListener);
        this.scrollbar.removeMouseMotionListener(this.trackListener);
        this.scrollbar.removePropertyChangeListener(this.propertyChangeListener);
        this.scrollbar.removeFocusListener(this);
    }

    private boolean getSupportsAbsolutePositioning() {
        return this.supportsAbsolutePositioning;
    }

    public boolean isThumbActive() {
        return this.thumbActive;
    }

    protected void scrollByBlock(int n2) {
        SynthScrollBarUI.scrollByBlock(this.scrollbar, n2);
        this.trackHighlight = n2 > 0 ? 2 : 1;
        Rectangle rectangle = this.getTrackBounds();
        this.scrollbar.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    protected void scrollByUnit(int n2) {
        SynthScrollBarUI.scrollByUnits(this.scrollbar, n2, 1);
    }

    private void updateThumbState(int n2, int n3) {
        Rectangle rectangle = this.getThumbBounds();
        this.setThumbActive(rectangle.contains(n2, n3));
    }

    protected void setThumbBounds(int n2, int n3, int n4, int n5) {
        if (this.thumbRect.x == n2 && this.thumbRect.y == n3 && this.thumbRect.width == n4 && this.thumbRect.height == n5) {
            return;
        }
        int n6 = Math.min(n2, this.thumbRect.x);
        int n7 = Math.min(n3, this.thumbRect.y);
        int n8 = Math.max(n2 + n4, this.thumbRect.x + this.thumbRect.width);
        int n9 = Math.max(n3 + n5, this.thumbRect.y + this.thumbRect.height);
        this.thumbRect.setBounds(n2, n3, n4, n5);
        this.scrollbar.repaint(n6, n7, n8 - n6, n9 - n7);
        this.setThumbActive(false);
    }

    private void setThumbActive(boolean bl2) {
        if (this.thumbActive != bl2) {
            this.thumbActive = bl2;
            this.scrollbar.repaint(this.getThumbBounds());
        }
    }

    protected ArrowButtonListener createArrowButtonListener() {
        return new ArrowButtonListener();
    }

    protected ModelListener createModelListener() {
        return new ModelListener();
    }

    protected ScrollListener createScrollListener() {
        return new ScrollListener();
    }

    protected TrackListener createTrackListener() {
        return new TrackListener();
    }

    public void removeLayoutComponent(Component component) {
    }

    public void layoutContainer(Container container) {
        if (this.isDragging) {
            return;
        }
        JScrollBar jScrollBar = (JScrollBar)container;
        switch (jScrollBar.getOrientation()) {
            case 1: {
                this.layoutVScrollbar(jScrollBar);
                break;
            }
            case 0: {
                this.layoutHScrollbar(jScrollBar);
            }
        }
    }

    protected Dimension getMaximumThumbSize() {
        return this.maximumThumbSize;
    }

    protected Dimension getMinimumThumbSize() {
        return this.minimumThumbSize;
    }

    protected Rectangle getThumbBounds() {
        return this.thumbRect;
    }

    protected Rectangle getTrackBounds() {
        return this.trackRect;
    }

    public void focusGained(FocusEvent focusEvent) {
        this.scrollbar.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.scrollbar.repaint();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    public static void loadActionMap(ActionMap actionMap) {
        actionMap.put("positiveUnitIncrement", new SharedActionScroller(1, false));
        actionMap.put("positiveBlockIncrement", new SharedActionScroller(1, true));
        actionMap.put("negativeUnitIncrement", new SharedActionScroller(-1, false));
        actionMap.put("negativeBlockIncrement", new SharedActionScroller(-1, true));
        actionMap.put("minScroll", new SharedActionScroller(2, true));
        actionMap.put("maxScroll", new SharedActionScroller(3, true));
    }

    private InputMap getInputMap(int n2) {
        if (n2 == 0) {
            InputMap inputMap;
            SynthContext synthContext = this.getContext((JComponent)this.scrollbar, 1);
            SynthStyle synthStyle = synthContext.getStyle();
            InputMap inputMap2 = (InputMap)synthStyle.get(synthContext, "ScrollBar.focusInputMap");
            if (this.scrollbar.getComponentOrientation().isLeftToRight() && (inputMap = (InputMap)synthStyle.get(synthContext, "ScrollBar.focusInputMap.RightToLeft")) != null) {
                inputMap.setParent(inputMap2);
                inputMap2 = inputMap;
            }
            synthContext.dispose();
            return inputMap2;
        }
        return null;
    }

    protected JButton createDecreaseButton(int n2) {
        SynthArrowButton synthArrowButton = new SynthArrowButton(n2);
        synthArrowButton.setName("ScrollBar.button");
        return synthArrowButton;
    }

    protected JButton createIncreaseButton(int n2) {
        SynthArrowButton synthArrowButton = new SynthArrowButton(n2);
        synthArrowButton.setName("ScrollBar.button");
        return synthArrowButton;
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    public void installUI(JComponent jComponent) {
        this.scrollbar = (JScrollBar)jComponent;
        this.thumbRect = new Rectangle(0, 0, 0, 0);
        this.trackRect = new Rectangle(0, 0, 0, 0);
        this.installDefaults();
        this.installComponents();
        this.installKeyboardActions();
        this.installListeners();
    }

    public void uninstallUI(JComponent jComponent) {
        this.scrollbar = (JScrollBar)jComponent;
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.uninstallComponents();
        this.uninstallDefaults();
        jComponent.setLayout(null);
        this.thumbRect = null;
        this.scrollbar = null;
        this.incrButton = null;
        this.decrButton = null;
    }

    private void fetchStyle(JScrollBar jScrollBar) {
        SynthContext synthContext = this.getContext((JComponent)jScrollBar, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (this.style != synthStyle) {
            Insets insets = jScrollBar.getInsets();
            this.scrollBarWidth = this.style.getInt(synthContext, "ScrollBar.thumbHeight", 14);
            this.minimumThumbSize = new Dimension();
            if (jScrollBar.getOrientation() == 1) {
                this.minimumThumbSize.width = this.scrollBarWidth;
                this.minimumThumbSize.height = 7;
                this.scrollBarWidth += insets.left + insets.right;
            } else {
                this.minimumThumbSize.width = 7;
                this.minimumThumbSize.height = this.scrollBarWidth;
                this.scrollBarWidth += insets.top + insets.bottom;
            }
            this.maximumThumbSize = (Dimension)this.style.get(synthContext, "ScrollBar.maximumThumbSize");
            this.supportsAbsolutePositioning = this.style.getBoolean(synthContext, "ScrollBar.allowsAbsolutePositioning", false);
        }
        synthContext.dispose();
        synthContext = this.getContext(jScrollBar, Region.SCROLL_BAR_TRACK, 1);
        this.trackStyle = SynthLookAndFeel.updateStyle(synthContext, this);
        synthContext.dispose();
        synthContext = this.getContext(jScrollBar, Region.SCROLL_BAR_THUMB, 1);
        this.thumbStyle = SynthLookAndFeel.updateStyle(synthContext, this);
        synthContext.dispose();
    }

    protected void layoutHScrollbar(JScrollBar jScrollBar) {
        int n2;
        int n3;
        Dimension dimension = jScrollBar.getSize();
        Insets insets = jScrollBar.getInsets();
        int n4 = dimension.height - (insets.top + insets.bottom);
        int n5 = insets.top;
        boolean bl2 = jScrollBar.getComponentOrientation().isLeftToRight();
        int n6 = n4;
        int n7 = insets.left;
        int n8 = n4;
        int n9 = dimension.width - (insets.right + n8);
        int n10 = insets.left + insets.right;
        int n11 = n6 + n8;
        float f2 = dimension.width - (n10 + n11);
        float f3 = jScrollBar.getMinimum();
        float f4 = jScrollBar.getMaximum();
        float f5 = jScrollBar.getVisibleAmount();
        float f6 = f4 - f3;
        float f7 = jScrollBar.getValue();
        int n12 = f6 <= 0.0f ? this.getMaximumThumbSize().width : (int)(f2 * (f5 / f6));
        n12 = Math.max(n12, this.getMinimumThumbSize().width);
        n12 = Math.min(n12, this.getMaximumThumbSize().width);
        int n13 = n3 = bl2 ? n9 - n12 : n7 + n6;
        if ((float)jScrollBar.getValue() < f4 - (float)jScrollBar.getVisibleAmount()) {
            float f8 = f2 - (float)n12;
            n3 = bl2 ? (int)(0.5f + f8 * ((f7 - f3) / (f6 - f5))) : (int)(0.5f + f8 * ((f4 - f5 - f7) / (f6 - f5)));
            n3 += n7 + n6;
        }
        if ((n2 = dimension.width - n10) < n11) {
            n8 = n6 = n2 / 2;
            n9 = dimension.width - (insets.right + n8);
        }
        (bl2 ? this.decrButton : this.incrButton).setBounds(n7, n5, n6, n4);
        (bl2 ? this.incrButton : this.decrButton).setBounds(n9, n5, n8, n4);
        int n14 = n7 + n6;
        int n15 = n9 - n14;
        this.trackRect.setBounds(n14, n5, n15, n4);
        if (n12 >= (int)f2) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (n3 + n12 > n9) {
                n3 = n9 - n12;
            }
            if (n3 < n7 + n6) {
                n3 = n7 + n6 + 1;
            }
            this.setThumbBounds(n3, n5, n12, n4);
        }
    }

    protected void layoutVScrollbar(JScrollBar jScrollBar) {
        int n2;
        Dimension dimension = jScrollBar.getSize();
        Insets insets = jScrollBar.getInsets();
        int n3 = dimension.width - (insets.left + insets.right);
        int n4 = insets.left;
        int n5 = n3;
        int n6 = insets.top;
        int n7 = n3;
        int n8 = dimension.height - (insets.bottom + n7);
        int n9 = insets.top + insets.bottom;
        int n10 = n5 + n7;
        float f2 = dimension.height - (n9 + n10);
        float f3 = jScrollBar.getMinimum();
        float f4 = jScrollBar.getVisibleAmount();
        float f5 = (float)jScrollBar.getMaximum() - f3;
        float f6 = jScrollBar.getValue();
        int n11 = f5 <= 0.0f ? this.getMaximumThumbSize().height : (int)(f2 * (f4 / f5));
        n11 = Math.max(n11, this.getMinimumThumbSize().height);
        n11 = Math.min(n11, this.getMaximumThumbSize().height);
        int n12 = n8 - n11;
        if (jScrollBar.getValue() < jScrollBar.getMaximum() - jScrollBar.getVisibleAmount()) {
            float f7 = f2 - (float)n11;
            n12 = (int)(0.5f + f7 * ((f6 - f3) / (f5 - f4)));
            n12 += n6 + n5;
        }
        if ((n2 = dimension.height - n9) < n10) {
            n7 = n5 = n2 / 2;
            n8 = dimension.height - (insets.bottom + n7);
        }
        this.decrButton.setBounds(n4, n6, n3, n5);
        this.incrButton.setBounds(n4, n8, n3, n7);
        int n13 = n6 + n5;
        int n14 = n8 - n13;
        this.trackRect.setBounds(n4, n13, n3, n14);
        if (n11 >= (int)f2) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (n12 + n11 > n8) {
                n12 = n8 - n11;
            }
            if (n12 < n6 + n5) {
                n12 = n6 + n5 + 1;
            }
            this.setThumbBounds(n4, n12, n3, n11);
        }
    }

    static void scrollByBlock(JScrollBar jScrollBar, int n2) {
        int n3 = jScrollBar.getValue();
        int n4 = jScrollBar.getBlockIncrement(n2);
        int n5 = n4 * (n2 > 0 ? 1 : -1);
        jScrollBar.setValue(n3 + n5);
    }

    static void scrollByUnits(JScrollBar jScrollBar, int n2, int n3) {
        int n4 = n3;
        n4 = n2 > 0 ? (n4 *= jScrollBar.getUnitIncrement(n2)) : (n4 *= -jScrollBar.getUnitIncrement(n2));
        int n5 = jScrollBar.getValue();
        int n6 = n5 + n4;
        if (n4 > 0 && n6 < n5) {
            n6 = jScrollBar.getMaximum();
        } else if (n4 < 0 && n6 > n5) {
            n6 = jScrollBar.getMinimum();
        }
        jScrollBar.setValue(n6);
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    private int getComponentState(JComponent jComponent, Region region) {
        if (region == Region.SCROLL_BAR_THUMB && this.thumbActive && jComponent.isEnabled()) {
            return 2;
        }
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n2) {
        return SynthContext.getContext(SynthContext.class, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n2);
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.getMinimumSize((JComponent)container);
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.getPreferredSize((JComponent)container);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return this.scrollbar.getOrientation() == 1 ? new Dimension(this.scrollBarWidth, 48) : new Dimension(48, this.scrollBarWidth);
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
        SynthContext synthContext2 = this.getContext((JComponent)this.scrollbar, Region.SCROLL_BAR_TRACK);
        this.paintTrack(synthContext2, graphics, this.getTrackBounds());
        synthContext2.dispose();
        synthContext2 = this.getContext((JComponent)this.scrollbar, Region.SCROLL_BAR_THUMB);
        this.paintThumb(synthContext2, graphics, this.getThumbBounds());
        synthContext2.dispose();
    }

    Rectangle getDecreaseHighlightRegion(Rectangle rectangle) {
        Insets insets = this.scrollbar.getInsets(tmpInsets);
        Rectangle rectangle2 = this.getThumbBounds();
        if (this.scrollbar.getOrientation() == 1) {
            rectangle.x = insets.left;
            rectangle.y = this.decrButton.getY() + this.decrButton.getHeight();
            rectangle.width = this.scrollbar.getWidth() - (insets.left + insets.right);
            rectangle.height = rectangle2.y - rectangle.y;
        } else {
            rectangle.x = this.decrButton.getX() + this.decrButton.getHeight();
            rectangle.y = insets.top;
            rectangle.width = rectangle2.x - rectangle.x;
            rectangle.height = this.scrollbar.getHeight() - (insets.top + insets.bottom);
        }
        return rectangle;
    }

    Rectangle getIncreaseHighlightRegion(Rectangle rectangle) {
        Insets insets = this.scrollbar.getInsets(tmpInsets);
        Rectangle rectangle2 = this.getThumbBounds();
        if (this.scrollbar.getOrientation() == 1) {
            rectangle.x = insets.left;
            rectangle.y = rectangle2.y + rectangle2.height;
            rectangle.width = this.scrollbar.getWidth() - (insets.left + insets.right);
            rectangle.height = this.incrButton.getY() - rectangle.y;
        } else {
            rectangle.x = rectangle2.x + rectangle2.width;
            rectangle.y = insets.top;
            rectangle.width = this.incrButton.getX() - rectangle.x;
            rectangle.height = this.scrollbar.getHeight() - (insets.top + insets.bottom);
        }
        return rectangle;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthScrollBarUI();
    }

    private SynthContext getContext(JComponent jComponent, Region region) {
        return this.getContext(jComponent, region, this.getComponentState(jComponent, region));
    }

    private SynthContext getContext(JComponent jComponent, Region region, int n2) {
        SynthStyle synthStyle = this.trackStyle;
        if (region == Region.SCROLL_BAR_THUMB) {
            synthStyle = this.thumbStyle;
        }
        return SynthContext.getContext(SynthContext.class, jComponent, region, synthStyle, n2);
    }

    protected void paintThumb(SynthContext synthContext, Graphics graphics, Rectangle rectangle) {
        SynthLookAndFeel.updateSubregion(synthContext, graphics, rectangle);
    }

    protected void paintTrack(SynthContext synthContext, Graphics graphics, Rectangle rectangle) {
        SynthLookAndFeel.updateSubregion(synthContext, graphics, rectangle);
    }

    protected class ArrowButtonListener
    extends MouseAdapter {
        boolean handledEvent;

        protected ArrowButtonListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!SynthScrollBarUI.this.scrollbar.isEnabled()) {
                return;
            }
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            int n2 = mouseEvent.getSource() == SynthScrollBarUI.this.incrButton ? 1 : -1;
            SynthScrollBarUI.this.scrollByUnit(n2);
            SynthScrollBarUI.this.scrollTimer.stop();
            SynthScrollBarUI.this.scrollListener.setDirection(n2);
            SynthScrollBarUI.this.scrollListener.setScrollByBlock(false);
            SynthScrollBarUI.this.scrollTimer.start();
            this.handledEvent = true;
            if (!SynthScrollBarUI.this.scrollbar.hasFocus() && SynthScrollBarUI.this.scrollbar.isRequestFocusEnabled()) {
                SynthScrollBarUI.this.scrollbar.requestFocus();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            SynthScrollBarUI.this.scrollTimer.stop();
            this.handledEvent = false;
            SynthScrollBarUI.this.scrollbar.setValueIsAdjusting(false);
        }
    }

    protected class ModelListener
    implements ChangeListener {
        protected ModelListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            SynthScrollBarUI.this.layoutContainer(SynthScrollBarUI.this.scrollbar);
        }
    }

    class PropertyChangeHandler
    implements PropertyChangeListener {
        PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
                SynthScrollBarUI.this.fetchStyle((JScrollBar)propertyChangeEvent.getSource());
            }
            if ("model".equals(string)) {
                BoundedRangeModel boundedRangeModel = (BoundedRangeModel)propertyChangeEvent.getOldValue();
                BoundedRangeModel boundedRangeModel2 = (BoundedRangeModel)propertyChangeEvent.getNewValue();
                boundedRangeModel.removeChangeListener(SynthScrollBarUI.this.modelListener);
                boundedRangeModel2.addChangeListener(SynthScrollBarUI.this.modelListener);
                SynthScrollBarUI.this.scrollbar.repaint();
                SynthScrollBarUI.this.scrollbar.revalidate();
            } else if ("orientation".equals(string)) {
                Integer n2 = (Integer)propertyChangeEvent.getNewValue();
                if (SynthScrollBarUI.this.scrollbar.getComponentOrientation().isLeftToRight()) {
                    if (SynthScrollBarUI.this.incrButton instanceof SynthArrowButton) {
                        ((SynthArrowButton)SynthScrollBarUI.this.incrButton).setDirection(n2 == 0 ? 3 : 5);
                    }
                    if (SynthScrollBarUI.this.decrButton instanceof SynthArrowButton) {
                        ((SynthArrowButton)SynthScrollBarUI.this.decrButton).setDirection(n2 == 0 ? 7 : 1);
                    }
                } else {
                    if (SynthScrollBarUI.this.incrButton instanceof SynthArrowButton) {
                        ((SynthArrowButton)SynthScrollBarUI.this.incrButton).setDirection(n2 == 0 ? 7 : 5);
                    }
                    if (SynthScrollBarUI.this.decrButton instanceof SynthArrowButton) {
                        ((SynthArrowButton)SynthScrollBarUI.this.decrButton).setDirection(n2 == 0 ? 3 : 1);
                    }
                }
            } else if ("componentOrientation".equals(string)) {
                ComponentOrientation componentOrientation = SynthScrollBarUI.this.scrollbar.getComponentOrientation();
                SynthScrollBarUI.this.incrButton.setComponentOrientation(componentOrientation);
                SynthScrollBarUI.this.decrButton.setComponentOrientation(componentOrientation);
                if (SynthScrollBarUI.this.scrollbar.getOrientation() == 0) {
                    if (componentOrientation.isLeftToRight()) {
                        if (SynthScrollBarUI.this.incrButton instanceof SynthArrowButton) {
                            ((SynthArrowButton)SynthScrollBarUI.this.incrButton).setDirection(3);
                        }
                        if (SynthScrollBarUI.this.decrButton instanceof SynthArrowButton) {
                            ((SynthArrowButton)SynthScrollBarUI.this.decrButton).setDirection(7);
                        }
                    } else {
                        if (SynthScrollBarUI.this.incrButton instanceof SynthArrowButton) {
                            ((SynthArrowButton)SynthScrollBarUI.this.incrButton).setDirection(7);
                        }
                        if (SynthScrollBarUI.this.decrButton instanceof SynthArrowButton) {
                            ((SynthArrowButton)SynthScrollBarUI.this.decrButton).setDirection(3);
                        }
                    }
                }
                InputMap inputMap = SynthScrollBarUI.this.getInputMap(0);
                SwingUtilities.replaceUIInputMap(SynthScrollBarUI.this.scrollbar, 0, inputMap);
            }
        }
    }

    protected class ScrollListener
    implements ActionListener {
        int direction = 1;
        boolean useBlockIncrement;

        public void setDirection(int n2) {
            this.direction = n2;
        }

        public void setScrollByBlock(boolean bl2) {
            this.useBlockIncrement = bl2;
        }

        public ScrollListener() {
            this.direction = 1;
            this.useBlockIncrement = false;
        }

        public ScrollListener(int n2, boolean bl2) {
            this.direction = n2;
            this.useBlockIncrement = bl2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.useBlockIncrement) {
                SynthScrollBarUI.this.scrollByBlock(this.direction);
                if (SynthScrollBarUI.this.scrollbar.getOrientation() == 1) {
                    if (this.direction > 0) {
                        if (SynthScrollBarUI.this.getThumbBounds().y + SynthScrollBarUI.this.getThumbBounds().height >= SynthScrollBarUI.this.trackListener.currentMouseY) {
                            ((Timer)actionEvent.getSource()).stop();
                        }
                    } else if (SynthScrollBarUI.this.getThumbBounds().y <= SynthScrollBarUI.this.trackListener.currentMouseY) {
                        ((Timer)actionEvent.getSource()).stop();
                    }
                } else if (this.direction > 0) {
                    if (SynthScrollBarUI.this.getThumbBounds().x + SynthScrollBarUI.this.getThumbBounds().width >= SynthScrollBarUI.this.trackListener.currentMouseX) {
                        ((Timer)actionEvent.getSource()).stop();
                    }
                } else if (SynthScrollBarUI.this.getThumbBounds().x <= SynthScrollBarUI.this.trackListener.currentMouseX) {
                    ((Timer)actionEvent.getSource()).stop();
                }
            } else {
                SynthScrollBarUI.this.scrollByUnit(this.direction);
            }
            if (this.direction > 0 && SynthScrollBarUI.this.scrollbar.getValue() + SynthScrollBarUI.this.scrollbar.getVisibleAmount() >= SynthScrollBarUI.this.scrollbar.getMaximum()) {
                ((Timer)actionEvent.getSource()).stop();
            } else if (this.direction < 0 && SynthScrollBarUI.this.scrollbar.getValue() <= SynthScrollBarUI.this.scrollbar.getMinimum()) {
                ((Timer)actionEvent.getSource()).stop();
            }
        }
    }

    private static class SharedActionScroller
    extends AbstractAction {
        private int dir;
        private boolean block;

        SharedActionScroller(int n2, boolean bl2) {
            this.dir = n2;
            this.block = bl2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JScrollBar jScrollBar = (JScrollBar)actionEvent.getSource();
            if (this.dir == -1 || this.dir == 1) {
                int n2 = this.block ? (this.dir == -1 ? -1 * jScrollBar.getBlockIncrement(-1) : jScrollBar.getBlockIncrement(1)) : (this.dir == -1 ? -1 * jScrollBar.getUnitIncrement(-1) : jScrollBar.getUnitIncrement(1));
                jScrollBar.setValue(jScrollBar.getValue() + n2);
            } else if (this.dir == 2) {
                jScrollBar.setValue(jScrollBar.getMinimum());
            } else if (this.dir == 3) {
                jScrollBar.setValue(jScrollBar.getMaximum());
            }
        }
    }

    protected class TrackListener
    extends MouseAdapter
    implements MouseMotionListener {
        protected transient int offset;
        protected transient int currentMouseX;
        protected transient int currentMouseY;
        private transient int direction = 1;

        private void startScrollTimerIfNecessary() {
            if (SynthScrollBarUI.this.scrollTimer.isRunning()) {
                return;
            }
            switch (SynthScrollBarUI.this.scrollbar.getOrientation()) {
                case 1: {
                    if (this.direction > 0) {
                        if (SynthScrollBarUI.this.getThumbBounds().y + SynthScrollBarUI.this.getThumbBounds().height >= SynthScrollBarUI.this.trackListener.currentMouseY) break;
                        SynthScrollBarUI.this.scrollTimer.start();
                        break;
                    }
                    if (SynthScrollBarUI.this.getThumbBounds().y <= SynthScrollBarUI.this.trackListener.currentMouseY) break;
                    SynthScrollBarUI.this.scrollTimer.start();
                    break;
                }
                case 0: {
                    if (this.direction > 0) {
                        if (SynthScrollBarUI.this.getThumbBounds().x + SynthScrollBarUI.this.getThumbBounds().width >= SynthScrollBarUI.this.trackListener.currentMouseX) break;
                        SynthScrollBarUI.this.scrollTimer.start();
                        break;
                    }
                    if (SynthScrollBarUI.this.getThumbBounds().x <= SynthScrollBarUI.this.trackListener.currentMouseX) break;
                    SynthScrollBarUI.this.scrollTimer.start();
                }
            }
        }

        protected TrackListener() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.setValueFrom(mouseEvent);
            if (SwingUtilities.isRightMouseButton(mouseEvent) || !SynthScrollBarUI.this.getSupportsAbsolutePositioning() && SwingUtilities.isMiddleMouseButton(mouseEvent)) {
                return;
            }
            if (!SynthScrollBarUI.this.scrollbar.isEnabled() || SynthScrollBarUI.this.getThumbBounds().isEmpty()) {
                return;
            }
            if (SynthScrollBarUI.this.isDragging) {
                this.setValueFrom(mouseEvent);
            } else {
                this.currentMouseX = mouseEvent.getX();
                this.currentMouseY = mouseEvent.getY();
                this.startScrollTimerIfNecessary();
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (!SynthScrollBarUI.this.isDragging) {
                SynthScrollBarUI.this.setThumbActive(false);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (!SynthScrollBarUI.this.isDragging) {
                SynthScrollBarUI.this.updateThumbState(mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent) || !SynthScrollBarUI.this.getSupportsAbsolutePositioning() && SwingUtilities.isMiddleMouseButton(mouseEvent)) {
                return;
            }
            if (!SynthScrollBarUI.this.scrollbar.isEnabled()) {
                return;
            }
            if (!SynthScrollBarUI.this.scrollbar.hasFocus() && SynthScrollBarUI.this.scrollbar.isRequestFocusEnabled()) {
                SynthScrollBarUI.this.scrollbar.requestFocus();
            }
            SynthScrollBarUI.this.scrollbar.setValueIsAdjusting(true);
            this.currentMouseX = mouseEvent.getX();
            this.currentMouseY = mouseEvent.getY();
            if (SynthScrollBarUI.this.getThumbBounds().contains(this.currentMouseX, this.currentMouseY)) {
                switch (SynthScrollBarUI.this.scrollbar.getOrientation()) {
                    case 1: {
                        this.offset = this.currentMouseY - SynthScrollBarUI.this.getThumbBounds().y;
                        break;
                    }
                    case 0: {
                        this.offset = this.currentMouseX - SynthScrollBarUI.this.getThumbBounds().x;
                    }
                }
                SynthScrollBarUI.this.isDragging = true;
                return;
            }
            if (SynthScrollBarUI.this.getSupportsAbsolutePositioning() && SwingUtilities.isMiddleMouseButton(mouseEvent)) {
                switch (SynthScrollBarUI.this.scrollbar.getOrientation()) {
                    case 1: {
                        this.offset = SynthScrollBarUI.this.getThumbBounds().height / 2;
                        break;
                    }
                    case 0: {
                        this.offset = SynthScrollBarUI.this.getThumbBounds().width / 2;
                    }
                }
                SynthScrollBarUI.this.isDragging = true;
                this.setValueFrom(mouseEvent);
                return;
            }
            SynthScrollBarUI.this.isDragging = false;
            Dimension dimension = SynthScrollBarUI.this.scrollbar.getSize();
            this.direction = 1;
            switch (SynthScrollBarUI.this.scrollbar.getOrientation()) {
                case 1: {
                    if (SynthScrollBarUI.this.getThumbBounds().isEmpty()) {
                        int n2 = dimension.height / 2;
                        this.direction = this.currentMouseY < n2 ? -1 : 1;
                        break;
                    }
                    int n3 = SynthScrollBarUI.this.getThumbBounds().y;
                    this.direction = this.currentMouseY < n3 ? -1 : 1;
                    break;
                }
                case 0: {
                    if (SynthScrollBarUI.this.getThumbBounds().isEmpty()) {
                        int n4 = dimension.width / 2;
                        this.direction = this.currentMouseX < n4 ? -1 : 1;
                    } else {
                        int n5 = SynthScrollBarUI.this.getThumbBounds().x;
                        int n6 = this.direction = this.currentMouseX < n5 ? -1 : 1;
                    }
                    if (SynthScrollBarUI.this.scrollbar.getComponentOrientation().isLeftToRight()) break;
                    this.direction = -this.direction;
                }
            }
            SynthScrollBarUI.this.scrollByBlock(this.direction);
            SynthScrollBarUI.this.scrollTimer.stop();
            SynthScrollBarUI.this.scrollListener.setDirection(this.direction);
            SynthScrollBarUI.this.scrollListener.setScrollByBlock(true);
            this.startScrollTimerIfNecessary();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (SynthScrollBarUI.this.isDragging) {
                SynthScrollBarUI.this.updateThumbState(mouseEvent.getX(), mouseEvent.getY());
            }
            if (SwingUtilities.isRightMouseButton(mouseEvent) || !SynthScrollBarUI.this.getSupportsAbsolutePositioning() && SwingUtilities.isMiddleMouseButton(mouseEvent)) {
                return;
            }
            if (!SynthScrollBarUI.this.scrollbar.isEnabled()) {
                return;
            }
            Rectangle rectangle = SynthScrollBarUI.this.getTrackBounds();
            SynthScrollBarUI.this.scrollbar.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            SynthScrollBarUI.this.trackHighlight = 0;
            SynthScrollBarUI.this.isDragging = false;
            this.offset = 0;
            SynthScrollBarUI.this.scrollTimer.stop();
            SynthScrollBarUI.this.scrollbar.setValueIsAdjusting(false);
        }

        private void setValueFrom(MouseEvent mouseEvent) {
            int n2;
            int n3;
            int n4;
            boolean bl2 = SynthScrollBarUI.this.isThumbActive();
            BoundedRangeModel boundedRangeModel = SynthScrollBarUI.this.scrollbar.getModel();
            Rectangle rectangle = SynthScrollBarUI.this.getThumbBounds();
            if (SynthScrollBarUI.this.scrollbar.getOrientation() == 1) {
                n4 = SynthScrollBarUI.this.decrButton.getY() + SynthScrollBarUI.this.decrButton.getHeight();
                n3 = SynthScrollBarUI.this.incrButton.getY() - rectangle.height;
                n2 = Math.min(n3, Math.max(n4, mouseEvent.getY() - this.offset));
                SynthScrollBarUI.this.setThumbBounds(rectangle.x, n2, rectangle.width, rectangle.height);
                float f2 = SynthScrollBarUI.this.getTrackBounds().height;
            } else {
                if (SynthScrollBarUI.this.scrollbar.getComponentOrientation().isLeftToRight()) {
                    n4 = SynthScrollBarUI.this.decrButton.getX() + SynthScrollBarUI.this.decrButton.getWidth();
                    n3 = SynthScrollBarUI.this.incrButton.getX() - rectangle.width;
                } else {
                    n4 = SynthScrollBarUI.this.incrButton.getX() + SynthScrollBarUI.this.incrButton.getWidth();
                    n3 = SynthScrollBarUI.this.decrButton.getX() - rectangle.width;
                }
                n2 = Math.min(n3, Math.max(n4, mouseEvent.getX() - this.offset));
                SynthScrollBarUI.this.setThumbBounds(n2, rectangle.y, rectangle.width, rectangle.height);
                float f3 = SynthScrollBarUI.this.getTrackBounds().width;
            }
            if (n2 == n3) {
                if (SynthScrollBarUI.this.scrollbar.getOrientation() == 1 || SynthScrollBarUI.this.scrollbar.getComponentOrientation().isLeftToRight()) {
                    SynthScrollBarUI.this.scrollbar.setValue(boundedRangeModel.getMaximum() - boundedRangeModel.getExtent());
                } else {
                    SynthScrollBarUI.this.scrollbar.setValue(boundedRangeModel.getMinimum());
                }
            } else {
                float f4 = boundedRangeModel.getMaximum() - boundedRangeModel.getExtent();
                float f5 = f4 - (float)boundedRangeModel.getMinimum();
                float f6 = n2 - n4;
                float f7 = n3 - n4;
                int n5 = SynthScrollBarUI.this.scrollbar.getOrientation() == 1 || SynthScrollBarUI.this.scrollbar.getComponentOrientation().isLeftToRight() ? (int)(0.5 + (double)(f6 / f7 * f5)) : (int)(0.5 + (double)((float)(n3 - n2) / f7 * f5));
                SynthScrollBarUI.this.scrollbar.setValue(n5 + boundedRangeModel.getMinimum());
            }
            SynthScrollBarUI.this.setThumbActive(bl2);
        }
    }
}

