/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.util;

import com.zerog.util.Err;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Properties;

public class FileEncoding {
    private static FileEncoding instance = null;
    private boolean initialized = false;
    private String platformDefaultFileEncoding;
    private String[] forcedEncodingsToTry = new String[]{"UTF-8", "ISO-8859-1", "8859_1"};
    private String[] unsupportedEncodings = new String[]{"cp1047", "cp1046", "ebcdic"};

    public static synchronized FileEncoding instance() {
        if (instance == null) {
            instance = new FileEncoding();
        }
        return instance;
    }

    private FileEncoding() {
    }

    public synchronized void initialize() {
        String string = new String("FileEncoding::initialize()");
        if (!this.initialized) {
            FileEncoding.debug(string, "initializing FileEncoding");
            this.platformDefaultFileEncoding = System.getProperty("file.encoding", "");
            if (this.isPlatformEncodingUnsupported()) {
                int n = 0;
                while (n < this.forcedEncodingsToTry.length) {
                    FileEncoding.debug(string, "checking: " + this.forcedEncodingsToTry[n]);
                    if (FileEncoding.isEncodingAvailable(this.forcedEncodingsToTry[n])) {
                        FileEncoding.debug(string, "  VALID!");
                        FileEncoding.setSystemProperty("file.encoding", this.forcedEncodingsToTry[n]);
                        break;
                    }
                    ++n;
                }
            }
            this.initialized = true;
            Err.info((String)(string + "- platform default encoding: " + this.getPlatformDefaultFileEncoding()));
            Err.info((String)(string + "- using encoding:            " + this.getFileEncoding()));
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isEncodingAvailable(String var0) {
        var1_1 = new String("FileEncoding::isEncodingAvailable()");
        var2_2 = null;
        var3_3 = null;
        try {
            try {
                var2_2 = new ByteArrayOutputStream(0);
                var3_3 = new OutputStreamWriter((OutputStream)var2_2, var0);
                var4_4 = true;
                var7_6 = null;
            }
            catch (UnsupportedEncodingException var4_5) {
                var5_12 = false;
                var7_7 = null;
                try {
                    if (var2_2 != null) {
                        var2_2.close();
                        var2_2 = null;
                    }
                    if (var3_3 == null) return var5_12;
                    var3_3.close();
                    return var5_12;
                }
                catch (IOException var8_10) {
                    Err.error((String)(var8_10.getClass().getName() + ": " + var8_10.getMessage()));
                }
                return var5_12;
            }
        }
        catch (Throwable var6_13) {
            var7_8 = null;
            try {}
            catch (IOException var8_11) {
                Err.error((String)(var8_11.getClass().getName() + ": " + var8_11.getMessage()));
                throw var6_13;
            }
            if (var2_2 != null) {
                var2_2.close();
                var2_2 = null;
            }
            if (var3_3 == null) throw var6_13;
            var3_3.close();
            var3_3 = null;
            throw var6_13;
        }
        ** try [egrp 2[TRYBLOCK] [2 : 63->86)] { 
lbl42:
        // 1 sources

        if (var2_2 != null) {
            var2_2.close();
            var2_2 = null;
        }
        if (var3_3 == null) return var4_4;
        var3_3.close();
        return var4_4;
lbl48:
        // 1 sources

        catch (IOException var8_9) {
            Err.error((String)(var8_9.getClass().getName() + ": " + var8_9.getMessage()));
        }
        return var4_4;
    }

    private boolean isPlatformEncodingUnsupported() {
        int n = 0;
        while (n < this.unsupportedEncodings.length) {
            if (this.unsupportedEncodings[n].equalsIgnoreCase(this.platformDefaultFileEncoding)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public String getPlatformDefaultFileEncoding() {
        String string = new String("FileEncoding::getPlatformDefaultFileEncoding()");
        this.initialize();
        return this.platformDefaultFileEncoding;
    }

    public Reader getIAFileReader(InputStream inputStream) {
        try {
            return new InputStreamReader(inputStream, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Err.error((String)("Failed to create a UTF-8 decoder! Trying default: " + unsupportedEncodingException.getMessage()));
            return new InputStreamReader(inputStream);
        }
    }

    public Writer getIAFileWriter(OutputStream outputStream) {
        try {
            return new OutputStreamWriter(outputStream, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Err.error((String)("Failed to create a UTF-8 encoder! Trying default: " + unsupportedEncodingException.getMessage()));
            return new OutputStreamWriter(outputStream);
        }
    }

    public String getFileEncoding() {
        String string = new String("FileEncoding::getFileEncoding()");
        this.initialize();
        return System.getProperty("file.encoding", this.platformDefaultFileEncoding);
    }

    private static synchronized String setSystemProperty(String string, String string2) {
        Properties properties = System.getProperties();
        String string3 = properties.getProperty(string);
        ((Hashtable)properties).put(string, string2);
        System.setProperties(properties);
        return string3;
    }

    private static void debug(String string, String string2) {
        Err.debug((String)(string + "- " + string2));
    }
}

