/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.download.utility;

import com.zerog.ia.download.WebInstallerApplet;
import com.zerog.ia.download.dialogs.ErrorDialog;
import com.zerog.ia.download.dialogs.ProgressDialog;
import com.zerog.ia.download.downloaders.BrowserDownloader;
import com.zerog.ia.download.downloaders.ZGDownloader;
import com.zerog.ia.download.outputListeners.GUIDownloadListener;
import com.zerog.ia.download.outputListeners.TimeoutListener;
import com.zerog.ia.download.utility.Gestalt;
import com.zerog.ia.download.utility.Util;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Observable;
import java.util.Observer;
import netscape.security.PrivilegeManager;

public class DiskSpaceCheckForDownload
implements Runnable,
Observer {
    private URL urlSource = null;
    private File diskSpaceCheckFile = null;
    private ProgressDialog progressDialog = null;
    private WebInstallerApplet applet = null;
    public static long contentLength;
    public static InputStream input;
    private boolean enoughDiskSpace = false;
    private boolean continueChecking = true;
    private boolean fileAlreadyExists = false;

    public DiskSpaceCheckForDownload(URL uRL, File file, ProgressDialog progressDialog, WebInstallerApplet webInstallerApplet) {
        this.urlSource = uRL;
        this.diskSpaceCheckFile = file;
        this.progressDialog = progressDialog;
        this.applet = webInstallerApplet;
    }

    /*
     * Loose catch block
     */
    public void run() {
        Object object;
        Object object2;
        boolean bl;
        ZGDownloader zGDownloader;
        block54: {
            zGDownloader = null;
            bl = false;
            System.err.println("DiskSpaceCheck: beginning check for disk space availability...");
            if (Gestalt.isNetscapeSecurityModelAvailable()) {
                PrivilegeManager.enablePrivilege((String)Gestalt.NETSCAPE_FILE_ACCESS);
            }
            if (!Util.makeLeadingDirectories(this.diskSpaceCheckFile)) {
                System.err.println("DiskSpaceCheck: failure to create download directories: '" + this.diskSpaceCheckFile.toString() + "'");
            } else {
                System.err.println("DiskSpaceCheck: download directories created: '" + this.diskSpaceCheckFile.toString() + "'");
                this.lengthOfDownloadFile();
                System.err.println("DiskSpaceCheck: space required for download: " + contentLength);
                if (this.diskSpaceCheckFile.length() == contentLength) {
                    System.err.println("DiskSpaceCheck: Installer already present on machine (same size), aborting re-download");
                    this.progressDialog.setProgressDialogText(0, null, this.diskSpaceCheckFile.toString());
                    this.progressDialog.pack();
                    this.progressDialog.show();
                    this.fileAlreadyExists = true;
                    this.enoughDiskSpace = true;
                    this.continueChecking = true;
                }
            }
            if (!this.fileAlreadyExists) {
                System.err.println("DiskSpaceCheck: Installer not present on machine, downloading...");
                this.progressDialog.show();
                object2 = null;
                try {
                    object2 = new FileOutputStream(this.diskSpaceCheckFile);
                    System.err.println("DiskSpaceCheck: FileOutputStream created");
                }
                catch (IOException iOException) {
                    System.err.println("DiskSpaceCheck: FileOutputStream failed creation, unable to determine disk space availability");
                    iOException.printStackTrace();
                    object2 = null;
                    this.enoughDiskSpace = false;
                    bl = true;
                }
                if (object2 != null) {
                    object = new byte[1024];
                    long l = 0L;
                    int n = 0;
                    int n2 = 0;
                    long l2 = 0L;
                    while (l2 < contentLength / 1024L && this.continueChecking) {
                        ((FileOutputStream)object2).write((byte[])object, 0, 1024);
                        n = (int)((l += 1024L) * 100L / contentLength);
                        if (n != n2) {
                            this.progressDialog.setPercentDone(n);
                            n2 = n;
                        }
                        ++l2;
                    }
                    ((FileOutputStream)object2).write((byte[])object, 0, (int)(contentLength % 1024L));
                    this.enoughDiskSpace = true;
                    Object var12_12 = null;
                    try {
                        if (object2 != null) {
                            ((OutputStream)object2).flush();
                            ((FileOutputStream)object2).close();
                            object2 = null;
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        this.enoughDiskSpace = false;
                    }
                    boolean bl2 = false;
                    if (this.diskSpaceCheckFile.exists()) {
                        System.err.println("DiskSpaceCheck: attempting to delete disk space check file: " + this.diskSpaceCheckFile.toString());
                        bl2 = this.diskSpaceCheckFile.delete();
                        if (bl2) {
                            System.err.println("    - disk space check file deleted");
                        }
                    } else {
                        System.err.println("DiskSpaceCheck: disk space check file: " + this.diskSpaceCheckFile.toString());
                        System.err.println("    - did not exist. There may not be enough disk space to continue");
                    }
                    String string = null;
                    File file = null;
                    try {
                        string = this.diskSpaceCheckFile.getCanonicalPath();
                    }
                    catch (Exception exception) {
                        string = this.diskSpaceCheckFile.getAbsolutePath();
                    }
                    if (string != null) {
                        string = new File(string).getParent();
                    }
                    if (string != null) {
                        file = new File(string);
                    }
                    System.err.println("DiskSpaceCheck: attempting to delete parent directories: " + file.toString());
                    bl2 = file.delete();
                    if (bl2) {
                        System.err.println("    - disk space check file deleted");
                    }
                    break block54;
                    {
                        catch (Exception exception) {
                            this.enoughDiskSpace = false;
                            Object var12_13 = null;
                            try {
                                if (object2 != null) {
                                    ((OutputStream)object2).flush();
                                    ((FileOutputStream)object2).close();
                                    object2 = null;
                                }
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                                this.enoughDiskSpace = false;
                            }
                            boolean bl3 = false;
                            if (this.diskSpaceCheckFile.exists()) {
                                System.err.println("DiskSpaceCheck: attempting to delete disk space check file: " + this.diskSpaceCheckFile.toString());
                                bl3 = this.diskSpaceCheckFile.delete();
                                if (bl3) {
                                    System.err.println("    - disk space check file deleted");
                                }
                            } else {
                                System.err.println("DiskSpaceCheck: disk space check file: " + this.diskSpaceCheckFile.toString());
                                System.err.println("    - did not exist. There may not be enough disk space to continue");
                            }
                            String string2 = null;
                            File file2 = null;
                            try {
                                string2 = this.diskSpaceCheckFile.getCanonicalPath();
                            }
                            catch (Exception exception2) {
                                string2 = this.diskSpaceCheckFile.getAbsolutePath();
                            }
                            if (string2 != null) {
                                string2 = new File(string2).getParent();
                            }
                            if (string2 != null) {
                                file2 = new File(string2);
                            }
                            System.err.println("DiskSpaceCheck: attempting to delete parent directories: " + file2.toString());
                            bl3 = file2.delete();
                            if (bl3) {
                                System.err.println("    - disk space check file deleted");
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var12_14 = null;
                        try {
                            if (object2 != null) {
                                ((OutputStream)object2).flush();
                                ((FileOutputStream)object2).close();
                                object2 = null;
                            }
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                            this.enoughDiskSpace = false;
                        }
                        boolean bl4 = false;
                        if (this.diskSpaceCheckFile.exists()) {
                            System.err.println("DiskSpaceCheck: attempting to delete disk space check file: " + this.diskSpaceCheckFile.toString());
                            bl4 = this.diskSpaceCheckFile.delete();
                            if (bl4) {
                                System.err.println("    - disk space check file deleted");
                            }
                        } else {
                            System.err.println("DiskSpaceCheck: disk space check file: " + this.diskSpaceCheckFile.toString());
                            System.err.println("    - did not exist. There may not be enough disk space to continue");
                        }
                        String string3 = null;
                        File file3 = null;
                        try {
                            string3 = this.diskSpaceCheckFile.getCanonicalPath();
                        }
                        catch (Exception exception) {
                            string3 = this.diskSpaceCheckFile.getAbsolutePath();
                        }
                        if (string3 != null) {
                            string3 = new File(string3).getParent();
                        }
                        if (string3 != null) {
                            file3 = new File(string3);
                        }
                        System.err.println("DiskSpaceCheck: attempting to delete parent directories: " + file3.toString());
                        bl4 = file3.delete();
                        if (bl4) {
                            System.err.println("    - disk space check file deleted");
                        }
                        throw throwable;
                    }
                }
            }
        }
        this.progressDialog.deleteObserver(this);
        if (this.continueChecking) {
            System.err.println("DiskSpaceCheck: confirming disk space availability results");
            if (!this.hasEnoughDiskSpace()) {
                object2 = null;
                object = null;
                if (bl) {
                    System.err.println("DiskSpaceCheck: an error occurred attempting to verify disk space availability");
                    object2 = "An error occurred while determining available disk space.";
                } else {
                    System.err.println("DiskSpaceCheck: insufficient disk space");
                    object2 = "Unable to verify disk space on this volume.";
                }
                object = "Either write permissions do not exist on this volume or there\nmay not have been sufficient space to download the installer.\n\nYou will be asked to choose another location on your system\nin which to save the installer.  Once downloaded, the installer\nmay be run manually from the new location.";
                ErrorDialog errorDialog = new ErrorDialog(this.applet.getParentFrame(), (String)object2, (String)object, this.applet);
                ((Component)this.progressDialog).setVisible(false);
                this.progressDialog.dispose();
                BrowserDownloader browserDownloader = new BrowserDownloader(this.applet);
                browserDownloader.setFileToDownload(this.urlSource);
                browserDownloader.start();
                this.applet.downloadStopped();
            } else {
                System.err.println("DiskSpaceCheck: disk space okay (" + this.continueChecking + "," + this.progressDialog.isShowing() + ")");
                if (this.continueChecking && this.progressDialog.isShowing()) {
                    System.err.println("DiskSpaceCheck: preparing downloader/executor object");
                    zGDownloader = new ZGDownloader(this.applet, this.progressDialog);
                    zGDownloader.addDownloadListener(new TimeoutListener(zGDownloader, 30000L));
                    zGDownloader.addDownloadListener(new GUIDownloadListener(zGDownloader, this.progressDialog));
                    zGDownloader.setFileToDownload(this.urlSource);
                    zGDownloader.setFileDestination(this.diskSpaceCheckFile);
                    System.err.println("DiskSpaceCheck: destination file = '" + this.diskSpaceCheckFile + "'");
                    System.err.println("DiskSpaceCheck: initiating downloader/executor object...");
                    zGDownloader.start();
                }
            }
        } else {
            System.err.println("DiskSpaceCheck: user has cancelled download/disk space checking");
            ((Component)this.progressDialog).setVisible(false);
            this.progressDialog.dispose();
            this.applet.downloadStopped();
        }
    }

    private void lengthOfDownloadFile() {
        URLConnection uRLConnection = null;
        try {
            uRLConnection = this.urlSource.openConnection();
            uRLConnection.connect();
            input = uRLConnection.getInputStream();
        }
        catch (Exception exception) {
            System.err.println("DiskSpaceCheck.lengthOfDownloadFile():  exception establishing URL connection");
            exception.printStackTrace();
        }
        contentLength = uRLConnection.getContentLength();
    }

    public boolean hasEnoughDiskSpace() {
        return this.enoughDiskSpace;
    }

    public void update(Observable observable, Object object) {
        this.continueChecking = false;
        System.err.println("DiskSpaceCheck: cancelling disk space check on user request.");
        try {
            if (input != null) {
                input.close();
            }
            System.err.println("DiskSpaceCheck: streams have been closed");
        }
        catch (Exception exception) {
            System.err.println("DiskSpaceCheck: exception while attempting to close streams");
            exception.printStackTrace();
        }
    }

    static {
        input = null;
    }
}

