/*
 * Decompiled with CFR 0.152.
 */
package javax.help.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import javax.help.HelpModel;
import javax.help.HelpSet;
import javax.help.InvalidHelpSetContextException;
import javax.help.JHelpTOCNavigator;
import javax.help.Map;
import javax.help.NavigatorView;
import javax.help.TOCItem;
import javax.help.TOCView;
import javax.help.event.HelpModelEvent;
import javax.help.event.HelpModelListener;
import javax.help.plaf.HelpNavigatorUI;
import javax.help.plaf.basic.BasicHelpUI;
import javax.help.plaf.basic.BasicTOCCellRenderer;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.RepaintManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class BasicTOCNavigatorUI
extends HelpNavigatorUI
implements HelpModelListener,
TreeSelectionListener,
PropertyChangeListener,
Serializable {
    protected JHelpTOCNavigator toc;
    protected JScrollPane sp;
    protected DefaultMutableTreeNode topNode;
    protected JTree tree;
    protected static final boolean debug = false;
    static /* synthetic */ Class class$0;

    public static ComponentUI createUI(JComponent x) {
        return new BasicTOCNavigatorUI((JHelpTOCNavigator)x);
    }

    public BasicTOCNavigatorUI(JHelpTOCNavigator b) {
        BasicTOCNavigatorUI.debug(this + " " + "CreateUI - sort of");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.help.plaf.basic.BasicTOCNavigatorUI");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setIcon(BasicHelpUI.getIcon(clazz, "images/toc.gif"));
    }

    public void installUI(JComponent c) {
        BasicTOCNavigatorUI.debug(this + " " + "installUI");
        this.toc = (JHelpTOCNavigator)c;
        HelpModel model = this.toc.getModel();
        this.toc.setLayout(new BorderLayout());
        this.toc.addPropertyChangeListener(this);
        if (model != null) {
            model.addHelpModelListener(this);
        }
        this.topNode = new DefaultMutableTreeNode();
        this.tree = new JTree(this.topNode);
        TreeSelectionModel tsm = this.tree.getSelectionModel();
        tsm.addTreeSelectionListener(this);
        this.tree.setShowsRootHandles(false);
        this.tree.setRootVisible(false);
        this.sp = new JScrollPane();
        this.sp.getViewport().add(this.tree);
        this.toc.add("Center", this.sp);
        this.reloadData();
        BasicTOCNavigatorUI.debug("topTree is: " + this.topNode);
    }

    public void uninstallUI(JComponent c) {
        BasicTOCNavigatorUI.debug(this + " " + "unistallUI");
        HelpModel model = this.toc.getModel();
        this.toc.removePropertyChangeListener(this);
        TreeSelectionModel tsm = this.tree.getSelectionModel();
        tsm.removeTreeSelectionListener(this);
        this.toc.setLayout(null);
        this.toc.removeAll();
        if (model != null) {
            model.removeHelpModelListener(this);
        }
        this.toc = null;
    }

    public Dimension getPreferredSize(JComponent c) {
        return new Dimension(200, 100);
    }

    public Dimension getMinimumSize(JComponent c) {
        return new Dimension(100, 100);
    }

    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    protected void setCellRenderer(NavigatorView view, JTree tree) {
        Map map = view.getHelpSet().getCombinedMap();
        tree.setCellRenderer(new BasicTOCCellRenderer(map));
    }

    private void reloadData() {
        BasicTOCNavigatorUI.debug("reloadData");
        if (this.toc.getModel() == null) {
            return;
        }
        this.topNode.removeAllChildren();
        TOCView view = (TOCView)this.toc.getNavigatorView();
        if (view == null) {
            return;
        }
        DefaultMutableTreeNode node = view.getDataAsTree();
        while (node.getChildCount() > 0) {
            this.topNode.add((DefaultMutableTreeNode)node.getFirstChild());
        }
        ((DefaultTreeModel)this.tree.getModel()).reload();
        this.setVisibility(this.topNode);
        this.setCellRenderer(view, this.tree);
    }

    public void merge(NavigatorView view) {
        BasicTOCNavigatorUI.debug("merging " + view);
        TOCView tocView = (TOCView)view;
        DefaultMutableTreeNode node = tocView.getDataAsTree();
        while (node.getChildCount() > 0) {
            this.topNode.add((DefaultMutableTreeNode)node.getFirstChild());
        }
        ((DefaultTreeModel)this.tree.getModel()).reload();
        this.setVisibility(this.topNode);
        this.setCellRenderer(tocView, this.tree);
    }

    public void remove(NavigatorView view) {
        BasicTOCNavigatorUI.debug("removing " + view);
        this.remove(this.topNode, view.getHelpSet());
        ((DefaultTreeModel)this.tree.getModel()).reload();
        this.setVisibility(this.topNode);
        this.setCellRenderer(view, this.tree);
    }

    private void remove(DefaultMutableTreeNode node, HelpSet hs) {
        BasicTOCNavigatorUI.debug("remove(" + node + ", " + hs + ")");
        Vector<DefaultMutableTreeNode> toRemove = new Vector<DefaultMutableTreeNode>();
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)e.nextElement();
            BasicTOCNavigatorUI.debug("  considering " + child);
            TOCItem item = (TOCItem)child.getUserObject();
            HelpSet chs = item.getHelpSet();
            if (chs != null && hs.contains(chs)) {
                BasicTOCNavigatorUI.debug("  tagging for removal: " + child);
                toRemove.addElement(child);
                continue;
            }
            this.remove(child, hs);
        }
        int i = 0;
        while (i < toRemove.size()) {
            BasicTOCNavigatorUI.debug("  removing " + toRemove.elementAt(i));
            node.remove((DefaultMutableTreeNode)toRemove.elementAt(i));
            ++i;
        }
    }

    private void setVisibility(DefaultMutableTreeNode node) {
        int max = node.getChildCount();
        int i = 0;
        while (i < max) {
            DefaultMutableTreeNode subnode = (DefaultMutableTreeNode)node.getChildAt(i);
            this.tree.expandPath(new TreePath(subnode.getPath()));
            ++i;
        }
    }

    public void idChanged(HelpModelEvent e) {
        Map.ID nId;
        DefaultMutableTreeNode tn;
        TOCItem item;
        Object o;
        Map.ID id = e.getID();
        URL url = e.getURL();
        HelpModel helpModel = this.toc.getModel();
        BasicTOCNavigatorUI.debug("idChanged(" + e + ")");
        if (e.getSource() != helpModel) {
            System.err.println("Internal inconsistency!");
            System.err.println("  " + e.getSource() + " != " + helpModel);
            throw new Error("Internal error");
        }
        TreePath s = this.tree.getSelectionPath();
        if (s != null && (o = s.getLastPathComponent()) instanceof DefaultMutableTreeNode && (item = (TOCItem)(tn = (DefaultMutableTreeNode)o).getUserObject()) != null && (nId = item.getID()) != null && nId.equals(id)) {
            return;
        }
        DefaultMutableTreeNode node = this.findID(this.topNode, id);
        if (node == null) {
            this.tree.clearSelection();
            return;
        }
        TreePath path = new TreePath(node.getPath());
        this.tree.expandPath(path);
        this.tree.setSelectionPath(path);
        this.tree.scrollPathToVisible(path);
    }

    private DefaultMutableTreeNode findID(DefaultMutableTreeNode node, Map.ID id) {
        BasicTOCNavigatorUI.debug("findID: (" + id + ")");
        BasicTOCNavigatorUI.debug("  node: " + node);
        if (id == null) {
            return null;
        }
        TOCItem item = (TOCItem)node.getUserObject();
        if (item != null) {
            Map.ID testID = item.getID();
            BasicTOCNavigatorUI.debug("  testID: " + testID);
            if (testID != null && testID.equals(id)) {
                return node;
            }
        }
        int size = node.getChildCount();
        int i = 0;
        while (i < size) {
            DefaultMutableTreeNode tmp = (DefaultMutableTreeNode)node.getChildAt(i);
            DefaultMutableTreeNode test = this.findID(tmp, id);
            if (test != null) {
                return test;
            }
            ++i;
        }
        return null;
    }

    public void valueChanged(TreeSelectionEvent e) {
        BasicTOCNavigatorUI.debug("ValueChanged: " + e);
        BasicTOCNavigatorUI.debug("  model: " + this.toc.getModel());
        TreePath path = this.tree.getSelectionPath();
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        TOCItem tocEl = (TOCItem)node.getUserObject();
        if (tocEl != null && tocEl.getID() != null) {
            try {
                this.toc.getModel().setCurrentID(tocEl.getID());
            }
            catch (InvalidHelpSetContextException e2) {
                BasicTOCNavigatorUI.debug(this + " " + "BadID");
                return;
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        BasicTOCNavigatorUI.debug(this + " " + "propertyChange: " + event.getSource() + " " + event.getPropertyName());
        if (event.getSource() == this.toc) {
            String changeName = event.getPropertyName();
            if (changeName.equals("helpModel")) {
                this.reloadData();
            } else if (changeName.equals("font")) {
                BasicTOCNavigatorUI.debug("Font change");
                Font newFont = (Font)event.getNewValue();
                this.tree.setFont(newFont);
                RepaintManager.currentManager(this.tree).markCompletelyDirty(this.tree);
            }
        }
    }

    protected static void debug(String str) {
    }
}

