/*
 * Decompiled with CFR 0.152.
 */
package javax.help.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import javax.help.DefaultHelpModel;
import javax.help.HelpModel;
import javax.help.HelpSet;
import javax.help.HelpUtilities;
import javax.help.InvalidHelpSetContextException;
import javax.help.JHelpSearchNavigator;
import javax.help.Map;
import javax.help.NavigatorView;
import javax.help.SearchHit;
import javax.help.SearchTOCItem;
import javax.help.TextHelpModel;
import javax.help.event.HelpModelEvent;
import javax.help.event.HelpModelListener;
import javax.help.plaf.HelpNavigatorUI;
import javax.help.plaf.basic.BasicHelpUI;
import javax.help.plaf.basic.BasicSearchCellRenderer;
import javax.help.search.SearchEngine;
import javax.help.search.SearchEvent;
import javax.help.search.SearchItem;
import javax.help.search.SearchListener;
import javax.help.search.SearchQuery;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.RepaintManager;
import javax.swing.ScrollPaneLayout;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class BasicSearchNavigatorUI
extends HelpNavigatorUI
implements HelpModelListener,
SearchListener,
PropertyChangeListener,
TreeSelectionListener {
    protected JHelpSearchNavigator searchnav;
    protected JScrollPane sp;
    protected JTree tree;
    protected DefaultMutableTreeNode topNode;
    protected JTextField searchparams;
    protected boolean displayOptions;
    protected SearchEngine helpsearch;
    protected SearchQuery searchquery;
    protected DefaultMutableTreeNode lastTOCnode;
    ActionListener searchAction = new SearchActionListener();
    private Cursor paramCursor;
    private Cursor treeCursor;
    private Cursor waitCursor = null;
    private static boolean debug = false;
    static /* synthetic */ Class class$0;

    public static ComponentUI createUI(JComponent x) {
        return new BasicSearchNavigatorUI((JHelpSearchNavigator)x);
    }

    public BasicSearchNavigatorUI(JHelpSearchNavigator b) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.help.plaf.basic.BasicSearchNavigatorUI");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setIcon(BasicHelpUI.getIcon(clazz, "images/search.gif"));
    }

    public void installUI(JComponent c) {
        this.searchnav = (JHelpSearchNavigator)c;
        HelpModel helpmodel = this.searchnav.getModel();
        this.searchnav.setLayout(new BorderLayout());
        this.searchnav.addPropertyChangeListener(this);
        if (helpmodel != null) {
            helpmodel.addHelpModelListener(this);
        }
        JLabel search = new JLabel(HelpUtilities.getString(HelpUtilities.getLocale(c), "search.findLabel"));
        this.searchparams = new JTextField("", 20);
        search.setLabelFor(this.searchparams);
        this.searchparams.addActionListener(this.searchAction);
        Box box = Box.createHorizontalBox();
        box.add(search);
        box.add(this.searchparams);
        this.searchnav.add("North", box);
        this.topNode = new DefaultMutableTreeNode();
        this.lastTOCnode = null;
        this.tree = new JTree(this.topNode);
        TreeSelectionModel tsm = this.tree.getSelectionModel();
        tsm.addTreeSelectionListener(this);
        this.tree.setShowsRootHandles(false);
        this.tree.setRootVisible(false);
        this.sp = new JScrollPane();
        this.sp.getViewport().add(this.tree);
        this.searchnav.add("Center", this.sp);
        this.reloadData();
    }

    public void uninstallUI(JComponent c) {
        HelpModel helpmodel = this.searchnav.getModel();
        this.searchnav.removePropertyChangeListener(this);
        TreeSelectionModel tsm = this.tree.getSelectionModel();
        tsm.removeTreeSelectionListener(this);
        this.searchnav.setLayout(null);
        this.searchnav.removeAll();
        if (helpmodel != null) {
            helpmodel.removeHelpModelListener(this);
        }
        this.searchnav = null;
    }

    public Dimension getPreferredSize(JComponent c) {
        return new Dimension(200, 100);
    }

    public Dimension getMinimumSize(JComponent c) {
        if (this.sp != null) {
            return ((ScrollPaneLayout)this.sp.getLayout()).minimumLayoutSize(this.sp);
        }
        return new Dimension(100, 100);
    }

    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    private void reloadData() {
        this.helpsearch = null;
        this.setCellRenderer(this.searchnav.getNavigatorView(), this.tree);
    }

    public void merge(NavigatorView view) {
        BasicSearchNavigatorUI.debug("merging " + view);
        String text = this.searchparams.getText();
        if (text != null && text.length() != 0) {
            this.searchAction.actionPerformed(new ActionEvent(this.searchparams, 1001, ""));
        }
    }

    public void remove(NavigatorView view) {
        BasicSearchNavigatorUI.debug("removing " + view);
        if (this.searchparams.getText() != null) {
            this.searchAction.actionPerformed(new ActionEvent(this.searchparams, 1001, ""));
        }
    }

    protected void setCellRenderer(NavigatorView view, JTree tree) {
        if (view == null) {
            return;
        }
        Map map = view.getHelpSet().getCombinedMap();
        tree.setCellRenderer(new BasicSearchCellRenderer(map));
    }

    public void idChanged(HelpModelEvent e) {
        Map.ID nId;
        DefaultMutableTreeNode tn;
        SearchTOCItem item;
        Object o;
        Map.ID id = e.getID();
        URL url = e.getURL();
        HelpModel helpModel = this.searchnav.getModel();
        BasicSearchNavigatorUI.debug("idChanged(" + e + ")");
        if (e.getSource() != helpModel) {
            System.err.println("Internal inconsistency!");
            System.err.println("  " + e.getSource() + " != " + helpModel);
            throw new Error("Internal error");
        }
        TreePath s = this.tree.getSelectionPath();
        if (s != null && (o = s.getLastPathComponent()) instanceof DefaultMutableTreeNode && (item = (SearchTOCItem)(tn = (DefaultMutableTreeNode)o).getUserObject()) != null && (nId = item.getID()) != null && nId.equals(id)) {
            return;
        }
        DefaultMutableTreeNode node = this.findIDorURL(this.topNode, id, url);
        if (node == null) {
            BasicSearchNavigatorUI.debug("node didn't exist");
            this.tree.clearSelection();
            return;
        }
        TreePath path = new TreePath(node.getPath());
        this.tree.expandPath(path);
        this.tree.setSelectionPath(path);
        this.tree.scrollPathToVisible(path);
    }

    public void valueChanged(TreeSelectionEvent e) {
        BasicSearchNavigatorUI.debug("ValueChanged: " + e);
        BasicSearchNavigatorUI.debug("  model: " + this.searchnav.getModel());
        TreePath path = this.tree.getSelectionPath();
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        SearchTOCItem item = (SearchTOCItem)node.getUserObject();
        BasicSearchNavigatorUI.debug("item:" + item.getURL());
        if (item != null) {
            HelpModel helpmodel = this.searchnav.getModel();
            HelpSet hs = helpmodel.getHelpSet();
            if (item.getID() != null) {
                try {
                    helpmodel.setCurrentID(item.getID());
                }
                catch (InvalidHelpSetContextException e2) {
                    BasicSearchNavigatorUI.debug(this + " " + "BadID");
                    return;
                }
            } else if (item.getURL() != null) {
                helpmodel.setCurrentURL(item.getURL());
            } else {
                return;
            }
            if (helpmodel instanceof TextHelpModel) {
                TextHelpModel m = (TextHelpModel)helpmodel;
                TextHelpModel.Highlight[] h = new DefaultHelpModel.DefaultHighlight[item.hitCount()];
                int i = 0;
                Enumeration enumeration = item.getSearchHits();
                while (enumeration.hasMoreElements()) {
                    SearchHit info = (SearchHit)enumeration.nextElement();
                    h[i] = new DefaultHelpModel.DefaultHighlight(info.getBegin(), info.getEnd());
                    ++i;
                }
                m.setHighlights(h);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        BasicSearchNavigatorUI.debug(this + " " + "propertyChange: " + event.getSource() + " " + event.getPropertyName());
        if (event.getSource() == this.searchnav) {
            String changeName = event.getPropertyName();
            if (changeName.equals("helpModel")) {
                this.reloadData();
            } else if (changeName.equals("font")) {
                BasicSearchNavigatorUI.debug("Font change");
                Font newFont = (Font)event.getNewValue();
                this.tree.setFont(newFont);
                RepaintManager.currentManager(this.tree).markCompletelyDirty(this.tree);
            }
        }
    }

    private DefaultMutableTreeNode findIDorURL(DefaultMutableTreeNode node, Map.ID id, URL url) {
        SearchTOCItem item = (SearchTOCItem)node.getUserObject();
        if (item != null) {
            Map.ID testID = item.getID();
            if (testID != null && id != null && testID.equals(id)) {
                return node;
            }
            URL testURL = item.getURL();
            if (testURL != null && url != null && url.sameFile(testURL)) {
                return node;
            }
        }
        int size = node.getChildCount();
        int i = 0;
        while (i < size) {
            DefaultMutableTreeNode tmp = (DefaultMutableTreeNode)node.getChildAt(i);
            DefaultMutableTreeNode test = this.findIDorURL(tmp, id, url);
            if (test != null) {
                return test;
            }
            ++i;
        }
        return null;
    }

    private void reorder(Vector nodes) {
        BasicSearchNavigatorUI.debug("reorder nodes");
        this.topNode.removeAllChildren();
        Object[] array = new DefaultMutableTreeNode[nodes.size()];
        nodes.copyInto(array);
        this.quickSort((DefaultMutableTreeNode[])array, 0, array.length - 1);
        int i = 0;
        while (i < array.length) {
            this.topNode.add((MutableTreeNode)array[i]);
            ++i;
        }
        ((DefaultTreeModel)this.tree.getModel()).reload();
        this.tree.invalidate();
        this.tree.repaint();
    }

    /*
     * Unable to fully structure code
     */
    void quickSort(DefaultMutableTreeNode[] a, int lo0, int hi0) {
        block5: {
            lo = lo0;
            hi = hi0;
            if (hi0 <= lo0) break block5;
            mid = (lo0 + hi0) / 2;
            ** GOTO lbl16
            {
                ++lo;
                do {
                    if (lo < hi0 && this.compare(a[lo], a[mid]) > 0) continue block0;
                    while (hi > lo0 && this.compare(a[hi], a[mid]) < 0) {
                        --hi;
                    }
                    if (lo > hi) continue;
                    this.swap(a, lo, hi);
                    ++lo;
                    --hi;
lbl16:
                    // 3 sources

                } while (lo <= hi);
            }
            if (lo0 < hi) {
                this.quickSort(a, lo0, hi);
            }
            if (lo < hi0) {
                this.quickSort(a, lo, hi0);
            }
        }
    }

    private void swap(DefaultMutableTreeNode[] a, int i, int j) {
        DefaultMutableTreeNode T = a[i];
        a[i] = a[j];
        a[j] = T;
    }

    private int compare(DefaultMutableTreeNode node1, DefaultMutableTreeNode node2) {
        SearchTOCItem item1 = (SearchTOCItem)node1.getUserObject();
        double confidence1 = item1.getConfidence();
        int hits1 = item1.hitCount();
        SearchTOCItem item2 = (SearchTOCItem)node2.getUserObject();
        double confidence2 = item2.getConfidence();
        int hits2 = item2.hitCount();
        if (confidence1 > confidence2) {
            return -1;
        }
        if (confidence1 < confidence2) {
            return 1;
        }
        if (hits1 < hits2) {
            return -1;
        }
        if (hits1 > hits2) {
            return 1;
        }
        return 0;
    }

    public synchronized void itemsFound(SearchEvent e) {
        Vector<DefaultMutableTreeNode> nodes = new Vector<DefaultMutableTreeNode>();
        Enumeration<TreeNode> children = this.topNode.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)children.nextElement();
            nodes.addElement(node);
        }
        BasicSearchNavigatorUI.debug("items found");
        HelpModel helpmodel = this.searchnav.getModel();
        HelpSet hs = helpmodel.getHelpSet();
        Map map = hs.getCombinedMap();
        Enumeration itemEnum = e.getSearchItems();
        while (itemEnum.hasMoreElements()) {
            SearchTOCItem tocitem;
            URL url;
            SearchItem item = (SearchItem)itemEnum.nextElement();
            BasicSearchNavigatorUI.debug("  item: " + item);
            try {
                url = new URL(item.getBase(), item.getFilename());
            }
            catch (MalformedURLException me) {
                BasicSearchNavigatorUI.debug("Failed to create URL from " + item.getBase() + "|" + item.getFilename());
                continue;
            }
            boolean foundNode = false;
            DefaultMutableTreeNode node = null;
            Enumeration nodesEnum = nodes.elements();
            while (nodesEnum.hasMoreElements()) {
                node = (DefaultMutableTreeNode)nodesEnum.nextElement();
                tocitem = (SearchTOCItem)node.getUserObject();
                URL testURL = tocitem.getURL();
                if (testURL == null || url == null || !url.sameFile(testURL)) continue;
                tocitem = (SearchTOCItem)node.getUserObject();
                tocitem.addSearchHit(new SearchHit(item.getConfidence(), item.getBegin(), item.getEnd()));
                foundNode = true;
                break;
            }
            if (foundNode) continue;
            tocitem = new SearchTOCItem(item);
            node = new DefaultMutableTreeNode(tocitem);
            nodes.addElement(node);
        }
        this.reorder(nodes);
        ((DefaultTreeModel)this.tree.getModel()).reload();
    }

    public synchronized void searchStarted(SearchEvent e) {
        BasicSearchNavigatorUI.debug("search Started");
        TreeSelectionModel tsm = this.tree.getSelectionModel();
        tsm.clearSelection();
        this.topNode.removeAllChildren();
        ((DefaultTreeModel)this.tree.getModel()).reload();
        this.tree.invalidate();
        this.tree.repaint();
    }

    public synchronized void searchFinished(SearchEvent e) {
        BasicSearchNavigatorUI.debug("search Finished");
        TreeSelectionModel tsm = this.tree.getSelectionModel();
        if (this.lastTOCnode == null && this.topNode.getChildCount() > 0) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.topNode.getFirstChild();
            if (node != null) {
                tsm.clearSelection();
                tsm.setSelectionPath(new TreePath(node.getPath()));
            }
        } else {
            this.searchnav.getToolkit().beep();
        }
        this.searchparams.setCursor(this.paramCursor);
        this.tree.setCursor(this.treeCursor);
    }

    private static void debug(String str) {
        if (debug) {
            System.out.println("BasicSearchNavigatorUI: " + str);
        }
    }

    class SearchActionListener
    implements ActionListener {
        SearchActionListener() {
        }

        public synchronized void actionPerformed(ActionEvent e) {
            HelpModel helpmodel = BasicSearchNavigatorUI.this.searchnav.getModel();
            try {
                if (BasicSearchNavigatorUI.this.paramCursor == null) {
                    BasicSearchNavigatorUI.this.paramCursor = BasicSearchNavigatorUI.this.searchparams.getCursor();
                }
                if (BasicSearchNavigatorUI.this.treeCursor == null) {
                    BasicSearchNavigatorUI.this.treeCursor = BasicSearchNavigatorUI.this.tree.getCursor();
                }
                if (BasicSearchNavigatorUI.this.waitCursor == null) {
                    BasicSearchNavigatorUI.this.waitCursor = Cursor.getPredefinedCursor(3);
                }
                BasicSearchNavigatorUI.this.searchparams.setCursor(BasicSearchNavigatorUI.this.waitCursor);
                BasicSearchNavigatorUI.this.tree.setCursor(BasicSearchNavigatorUI.this.waitCursor);
                if (BasicSearchNavigatorUI.this.helpsearch == null) {
                    BasicSearchNavigatorUI.this.helpsearch = BasicSearchNavigatorUI.this.searchnav.getSearchEngine();
                    BasicSearchNavigatorUI.this.searchquery = BasicSearchNavigatorUI.this.helpsearch.createQuery();
                    BasicSearchNavigatorUI.this.searchquery.addSearchListener(BasicSearchNavigatorUI.this);
                }
                BasicSearchNavigatorUI.debug("click on search w/: " + BasicSearchNavigatorUI.this.searchparams.getText());
                if (BasicSearchNavigatorUI.this.searchquery.isActive()) {
                    BasicSearchNavigatorUI.this.searchquery.stop();
                }
                BasicSearchNavigatorUI.this.searchquery.start(BasicSearchNavigatorUI.this.searchparams.getText(), BasicSearchNavigatorUI.this.searchnav.getLocale());
            }
            catch (Exception e2) {
                BasicSearchNavigatorUI.this.searchparams.setCursor(BasicSearchNavigatorUI.this.paramCursor);
                BasicSearchNavigatorUI.this.tree.setCursor(BasicSearchNavigatorUI.this.treeCursor);
                e2.printStackTrace();
                BasicSearchNavigatorUI.this.searchnav.getToolkit().beep();
                BasicSearchNavigatorUI.this.searchnav.getToolkit().beep();
            }
        }
    }
}

