/*
 * Decompiled with CFR 0.152.
 */
package javax.help.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.Collator;
import java.text.RuleBasedCollator;
import java.util.Enumeration;
import java.util.Vector;
import javax.help.HelpModel;
import javax.help.HelpSet;
import javax.help.HelpUtilities;
import javax.help.IndexItem;
import javax.help.IndexView;
import javax.help.InvalidHelpSetContextException;
import javax.help.JHelpIndexNavigator;
import javax.help.Map;
import javax.help.NavigatorView;
import javax.help.event.HelpModelEvent;
import javax.help.event.HelpModelListener;
import javax.help.plaf.HelpNavigatorUI;
import javax.help.plaf.basic.BasicHelpUI;
import javax.help.plaf.basic.BasicIndexCellRenderer;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.RepaintManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class BasicIndexNavigatorUI
extends HelpNavigatorUI
implements HelpModelListener,
TreeSelectionListener,
PropertyChangeListener,
ActionListener,
Serializable {
    protected JHelpIndexNavigator index;
    protected JScrollPane sp;
    protected DefaultMutableTreeNode topNode;
    protected JTree tree;
    protected JTextField searchField;
    protected RuleBasedCollator rbc;
    protected String oldText;
    protected DefaultMutableTreeNode currentFindNode;
    private static boolean debug = false;
    static /* synthetic */ Class class$0;

    public static ComponentUI createUI(JComponent x) {
        return new BasicIndexNavigatorUI((JHelpIndexNavigator)x);
    }

    public BasicIndexNavigatorUI(JHelpIndexNavigator b) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.help.plaf.basic.BasicIndexNavigatorUI");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setIcon(BasicHelpUI.getIcon(clazz, "images/index.gif"));
    }

    public void installUI(JComponent c) {
        BasicIndexNavigatorUI.debug("installUI");
        this.index = (JHelpIndexNavigator)c;
        HelpModel model = this.index.getModel();
        this.index.setLayout(new BorderLayout());
        this.index.addPropertyChangeListener(this);
        if (model != null) {
            model.addHelpModelListener(this);
        }
        this.topNode = new DefaultMutableTreeNode();
        JLabel search = new JLabel(HelpUtilities.getString(HelpUtilities.getLocale(c), "index.findLabel"));
        this.searchField = new JTextField();
        search.setLabelFor(this.searchField);
        this.searchField.addActionListener(this);
        Box box = Box.createHorizontalBox();
        box.add(search);
        box.add(this.searchField);
        this.index.add("North", box);
        this.tree = new JTree(this.topNode);
        TreeSelectionModel tsm = this.tree.getSelectionModel();
        tsm.addTreeSelectionListener(this);
        this.tree.setShowsRootHandles(false);
        this.tree.setRootVisible(false);
        this.setCellRenderer(this.index.getNavigatorView(), this.tree);
        this.sp = new JScrollPane();
        this.sp.getViewport().add(this.tree);
        this.index.add("Center", this.sp);
        this.reloadData();
    }

    protected void setCellRenderer(NavigatorView view, JTree tree) {
        tree.setCellRenderer(new BasicIndexCellRenderer());
    }

    public void uninstallUI(JComponent c) {
        BasicIndexNavigatorUI.debug("uninstallUI");
        HelpModel model = this.index.getModel();
        this.index.removePropertyChangeListener(this);
        TreeSelectionModel tsm = this.tree.getSelectionModel();
        tsm.removeTreeSelectionListener(this);
        this.index.setLayout(null);
        this.index.removeAll();
        if (model != null) {
            model.removeHelpModelListener(this);
        }
        this.index = null;
    }

    public Dimension getPreferredSize(JComponent c) {
        return new Dimension(200, 100);
    }

    public Dimension getMinimumSize(JComponent c) {
        return new Dimension(100, 100);
    }

    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    private void reloadData() {
        BasicIndexNavigatorUI.debug("reloadData");
        if (this.index.getModel() == null) {
            return;
        }
        this.topNode.removeAllChildren();
        IndexView view = (IndexView)this.index.getNavigatorView();
        if (view == null) {
            return;
        }
        DefaultMutableTreeNode node = view.getDataAsTree();
        while (node.getChildCount() > 0) {
            this.topNode.add((DefaultMutableTreeNode)node.getFirstChild());
        }
        ((DefaultTreeModel)this.tree.getModel()).reload();
        this.setVisibility(this.topNode);
    }

    public void merge(NavigatorView view) {
        BasicIndexNavigatorUI.debug("merging data");
        IndexView indexView = (IndexView)view;
        DefaultMutableTreeNode node = indexView.getDataAsTree();
        while (node.getChildCount() > 0) {
            this.topNode.add((DefaultMutableTreeNode)node.getFirstChild());
        }
        ((DefaultTreeModel)this.tree.getModel()).reload();
        this.setVisibility(this.topNode);
    }

    public void remove(NavigatorView view) {
        BasicIndexNavigatorUI.debug("removing " + view);
        Enumeration<TreeNode> e = this.topNode.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)e.nextElement();
            BasicIndexNavigatorUI.debug("  A child of topNode: " + child);
        }
        this.remove(this.topNode, view.getHelpSet());
        ((DefaultTreeModel)this.tree.getModel()).reload();
        this.setVisibility(this.topNode);
    }

    private void remove(DefaultMutableTreeNode node, HelpSet hs) {
        BasicIndexNavigatorUI.debug("remove(" + node + ", " + hs + ")");
        Vector<DefaultMutableTreeNode> toRemove = new Vector<DefaultMutableTreeNode>();
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)e.nextElement();
            BasicIndexNavigatorUI.debug("  considering " + child);
            IndexItem item = (IndexItem)child.getUserObject();
            HelpSet chs = item.getHelpSet();
            if (chs != null && hs.contains(chs)) {
                BasicIndexNavigatorUI.debug("  tagging for removal: " + child);
                toRemove.addElement(child);
                continue;
            }
            this.remove(child, hs);
        }
        int i = 0;
        while (i < toRemove.size()) {
            BasicIndexNavigatorUI.debug("  removing " + toRemove.elementAt(i));
            node.remove((DefaultMutableTreeNode)toRemove.elementAt(i));
            ++i;
        }
    }

    private void setVisibility(DefaultMutableTreeNode node) {
        this.tree.expandPath(new TreePath(node.getPath()));
        if (!node.isLeaf()) {
            int max = node.getChildCount();
            int i = 0;
            while (i < max) {
                this.setVisibility((DefaultMutableTreeNode)node.getChildAt(i));
                ++i;
            }
        }
    }

    public void idChanged(HelpModelEvent e) {
        Map.ID nId;
        DefaultMutableTreeNode tn;
        IndexItem item;
        Object o;
        Map.ID id = e.getID();
        HelpModel helpModel = this.index.getModel();
        BasicIndexNavigatorUI.debug("idChanged(" + e + ")");
        if (e.getSource() != helpModel) {
            System.err.println("Internal inconsistency!");
            System.err.println("  " + e.getSource() + " != " + helpModel);
            throw new Error("Internal error");
        }
        TreePath s = this.tree.getSelectionPath();
        if (s != null && (o = s.getLastPathComponent()) instanceof DefaultMutableTreeNode && (item = (IndexItem)(tn = (DefaultMutableTreeNode)o).getUserObject()) != null && (nId = item.getID()) != null && nId.equals(id)) {
            return;
        }
        DefaultMutableTreeNode node = this.findID(this.topNode, id);
        if (node == null) {
            this.tree.clearSelection();
            return;
        }
        TreePath path = new TreePath(node.getPath());
        this.tree.expandPath(path);
        this.tree.setSelectionPath(path);
        this.tree.scrollPathToVisible(path);
    }

    private DefaultMutableTreeNode findID(DefaultMutableTreeNode node, Map.ID id) {
        BasicIndexNavigatorUI.debug("findID: (" + id + ")");
        BasicIndexNavigatorUI.debug("  node: " + node);
        if (id == null) {
            return null;
        }
        IndexItem item = (IndexItem)node.getUserObject();
        if (item != null) {
            Map.ID testID = item.getID();
            BasicIndexNavigatorUI.debug("  testID: " + testID);
            if (testID != null && testID.equals(id)) {
                return node;
            }
        }
        int size = node.getChildCount();
        int i = 0;
        while (i < size) {
            DefaultMutableTreeNode tmp = (DefaultMutableTreeNode)node.getChildAt(i);
            DefaultMutableTreeNode test = this.findID(tmp, id);
            if (test != null) {
                return test;
            }
            ++i;
        }
        return null;
    }

    public void valueChanged(TreeSelectionEvent e) {
        TreePath path = this.tree.getSelectionPath();
        BasicIndexNavigatorUI.debug("valueChanged; path: " + path);
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        IndexItem indexEl = (IndexItem)node.getUserObject();
        if (indexEl != null && indexEl.getID() != null) {
            try {
                this.index.getModel().setCurrentID(indexEl.getID());
            }
            catch (InvalidHelpSetContextException e2) {
                BasicIndexNavigatorUI.debug("BadID");
                return;
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        BasicIndexNavigatorUI.debug("propertyChange: " + event.getSource() + " " + event.getPropertyName());
        if (event.getSource() == this.index) {
            String changeName = event.getPropertyName();
            if (changeName.equals("helpModel")) {
                this.reloadData();
            } else if (changeName.equals("font")) {
                BasicIndexNavigatorUI.debug("Font change");
                Font newFont = (Font)event.getNewValue();
                this.tree.setFont(newFont);
                RepaintManager.currentManager(this.tree).markCompletelyDirty(this.tree);
            }
        }
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.searchField) {
            this.rbc = (RuleBasedCollator)Collator.getInstance(this.index.getLocale());
            String text = this.searchField.getText();
            if (text != null) {
                text = text.toLowerCase();
            }
            if (this.oldText != null && text.compareTo(this.oldText) != 0) {
                this.currentFindNode = null;
            }
            this.oldText = text;
            DefaultMutableTreeNode node = this.searchName(this.topNode, text);
            if (node == null) {
                this.currentFindNode = null;
                this.index.getToolkit().beep();
                return;
            }
            this.currentFindNode = node;
            TreePath path = new TreePath(node.getPath());
            this.tree.scrollPathToVisible(path);
            this.tree.expandPath(path);
            this.tree.setSelectionPath(path);
        }
    }

    private DefaultMutableTreeNode searchName(DefaultMutableTreeNode node, String name) {
        if (this.currentFindNode == null) {
            String itemName;
            IndexItem item = (IndexItem)node.getUserObject();
            if (item != null && (itemName = item.getName()) != null && HelpUtilities.isStringInString(this.rbc, name, itemName = itemName.toLowerCase())) {
                return node;
            }
        } else if (this.currentFindNode == node) {
            this.currentFindNode = null;
        }
        int size = node.getChildCount();
        int i = 0;
        while (i < size) {
            DefaultMutableTreeNode tmp = (DefaultMutableTreeNode)node.getChildAt(i);
            DefaultMutableTreeNode test = this.searchName(tmp, name);
            if (test != null) {
                return test;
            }
            ++i;
        }
        return null;
    }

    private static void debug(String str) {
        if (debug) {
            System.out.println("BasicIndexNavigatorUI: " + str);
        }
    }
}

