/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.util;

import CH.ifa.draw.figures.PolyLineFigure;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.Painter;
import DE.siemens.ad.pdraw.figures.FixedElbowConnection;
import DE.siemens.ad.pdraw.figures.InputCutConnectFigure;
import DE.siemens.ad.pdraw.figures.OutputCutConnectFigure;
import DE.siemens.ad.pdraw.figures.SelectionFigure;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import DE.siemens.ad.pdraw.standard.LogoDrawingView;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Vector;

public class SelectionPainter
implements Painter {
    private LogoDrawing fDrawing = new LogoDrawing();

    public SelectionPainter(DrawingView drawingView) {
        this.fDrawing.addObserver(drawingView);
    }

    public void draw(Graphics g, DrawingView view) {
        g = g.create();
        double scale = (double)((LogoDrawingView)view).getZoomManager().getZoom() / 100.0;
        ((Graphics2D)g).scale(scale, scale);
        this.fDrawing.draw(g);
    }

    public LogoDrawing getDrawing() {
        return this.fDrawing;
    }

    public void add(PolyLineFigure figure, int colorIndex) {
        this.addToDrawing(figure, colorIndex);
        FixedElbowConnection otherLine = this.checkCutConnectFigure(figure);
        if (otherLine != null) {
            this.addToDrawing(otherLine, colorIndex);
        }
    }

    private void addToDrawing(PolyLineFigure figure, int colorIndex) {
        SelectionFigure selectionFigure = new SelectionFigure(figure, colorIndex);
        this.getDrawing().add(selectionFigure);
    }

    private FixedElbowConnection checkCutConnectFigure(PolyLineFigure figure) {
        FixedElbowConnection result = null;
        if (figure instanceof FixedElbowConnection) {
            Figure startFigure = ((FixedElbowConnection)figure).startFigure();
            if (startFigure instanceof OutputCutConnectFigure) {
                OutputCutConnectFigure cutConnectFigure = (OutputCutConnectFigure)startFigure;
                result = cutConnectFigure.getPartner().getConnectionFigure();
            } else {
                Figure endFigure = ((FixedElbowConnection)figure).endFigure();
                if (endFigure instanceof InputCutConnectFigure) {
                    result = ((InputCutConnectFigure)endFigure).getPartner().getConnectionFigure();
                }
            }
        }
        return result;
    }

    public void remove(Figure figure) {
        Vector figures = (Vector)this.getDrawing().getFigures().clone();
        for (SelectionFigure selectionFigure : figures) {
            if (selectionFigure.getSourceFigure() != figure) continue;
            this.getDrawing().remove(selectionFigure);
            FixedElbowConnection otherLine = this.checkCutConnectFigure((PolyLineFigure)figure);
            if (otherLine == null) continue;
            this.remove(otherLine);
        }
    }

    public void removeAll() {
        LogoDrawing drawing = this.getDrawing();
        Vector figures = (Vector)drawing.getFigures().clone();
        drawing.removeAll(figures);
        drawing.checkDamage();
    }
}

