/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.util;

import DE.siemens.ad.logo.app.Editor;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.pdraw.app.LogoComfort;
import DE.siemens.ad.pdraw.app.print.LogoPrinter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.MatteBorder;

public class PrintPreview
extends JDialog {
    protected Pageable fPageable;
    protected JComboBox m_cbScale;
    protected PreviewContainer m_previewContainer;
    protected PagePreview m_previewPage;
    protected JTextField fStatusline;
    protected JComboBox fComboBox;
    protected JButton fForwardButton;
    protected JButton fBackwardButton;
    protected JScrollPane fScrollPane = null;
    protected static double NORMAL_ZOOM = 1.0;
    protected Editor fEditor;

    private PrintPreview(JFrame parent) {
        super(parent);
    }

    private PrintPreview(JDialog parent) {
        super(parent);
    }

    public static PrintPreview create(Editor editor, Pageable pageable, String title) {
        Window window = editor.getApplicationSurface().getWindow();
        PrintPreview printPreview = null;
        if (window instanceof JFrame) {
            printPreview = new PrintPreview((JFrame)window);
        } else if (window instanceof JDialog) {
            printPreview = new PrintPreview((JDialog)window);
        } else {
            throw new IllegalArgumentException("A PrintPreview can only be created with a JDialog or JFrameas parent.");
        }
        printPreview.setTitle(title);
        printPreview.setEditor(editor);
        printPreview.setPageable(pageable);
        printPreview.initComponents();
        return printPreview;
    }

    private void initComponents() {
        this.setModal(true);
        this.setVisible(false);
        JToolBar tb = new JToolBar();
        tb.setFloatable(false);
        this.fBackwardButton = new JButton(Language.getString("dialog.printPreview.back", "Back"));
        ActionListener lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PrintPreview.this.m_previewPage.decPageIndex();
                PrintPreview.this.fComboBox.setSelectedIndex(PrintPreview.this.fComboBox.getSelectedIndex() - 1);
                PrintPreview.this.checkForwardBackward();
                PrintPreview.this.repaint();
            }
        };
        this.fBackwardButton.addActionListener(lst);
        this.fBackwardButton.setAlignmentY(0.5f);
        this.fBackwardButton.setMargin(new Insets(2, 6, 2, 6));
        this.fBackwardButton.setEnabled(false);
        tb.add(this.fBackwardButton);
        this.fForwardButton = new JButton(Language.getString("dialog.printPreview.forward", "Forward"));
        lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PrintPreview.this.m_previewPage.incPageIndex();
                PrintPreview.this.fComboBox.setSelectedIndex(PrintPreview.this.fComboBox.getSelectedIndex() + 1);
                PrintPreview.this.checkForwardBackward();
                PrintPreview.this.repaint();
            }
        };
        this.fForwardButton.addActionListener(lst);
        this.fForwardButton.setAlignmentY(0.5f);
        this.fForwardButton.setMargin(new Insets(2, 6, 2, 6));
        tb.add(this.fForwardButton);
        this.fComboBox = new JComboBox();
        Dimension d = this.fComboBox.getPreferredSize();
        this.fComboBox.setMinimumSize(new Dimension(40, d.height));
        this.fComboBox.setPreferredSize(new Dimension(40, d.height));
        this.fillPagesComboBox();
        ItemListener ilst = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    String str = (String)PrintPreview.this.fComboBox.getSelectedItem();
                    int scale = 0;
                    try {
                        scale = Integer.parseInt(str);
                        PrintPreview.this.m_previewPage.setPageIndex(scale - 1);
                        PrintPreview.this.checkForwardBackward();
                        PrintPreview.this.repaint();
                    }
                    catch (NumberFormatException ex) {
                        return;
                    }
                }
            }
        };
        this.fComboBox.addItemListener(ilst);
        this.fComboBox.setMaximumSize(this.fComboBox.getPreferredSize());
        this.fComboBox.setEditable(false);
        tb.addSeparator();
        tb.add(this.fComboBox);
        tb.addSeparator();
        JButton bt = new JButton(Language.getString("dialog.printPreview.zoom", "Zoom"));
        lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PrintPreview.this.changeZoom(new Point(0, 0));
            }
        };
        bt.addActionListener(lst);
        bt.setAlignmentY(0.5f);
        bt.setMargin(new Insets(2, 6, 2, 6));
        tb.add(bt);
        bt = new JButton(Language.getString("dialog.printPreview.print", "Print"), Global.getIcon("Print.gif"));
        lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PrintPreview.this.print();
            }
        };
        bt.addActionListener(lst);
        bt.setAlignmentY(0.5f);
        bt.setMargin(new Insets(2, 6, 2, 6));
        tb.add(bt);
        bt = new JButton(Language.getString("dialog.printPreview.properties", "Properties"));
        bt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PrintPreview.this.setupPrintOptions();
            }
        });
        tb.addSeparator();
        tb.add(bt);
        bt = new JButton(Language.getString("dialog.printPreview.close", "Close"));
        lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PrintPreview.this.dispose();
            }
        };
        bt.addActionListener(lst);
        bt.setAlignmentY(0.5f);
        bt.setMargin(new Insets(2, 6, 2, 6));
        tb.addSeparator();
        tb.add(bt);
        this.getContentPane().add((Component)tb, "North");
        this.fStatusline = new JTextField();
        this.fStatusline.setEditable(false);
        this.fStatusline.setBackground(UIManager.getColor("Panel.background"));
        this.getContentPane().add((Component)this.fStatusline, "South");
        this.m_previewPage = new PagePreview(0);
        this.m_previewContainer = new PreviewContainer();
        this.m_previewPage.addMouseListener(new PageMouseAdapter());
        this.m_previewContainer.add(this.m_previewPage);
        this.fScrollPane = new JScrollPane(this.m_previewContainer);
        JScrollBar scrollBar = this.fScrollPane.getVerticalScrollBar();
        scrollBar.setUnitIncrement(16);
        scrollBar = this.fScrollPane.getHorizontalScrollBar();
        scrollBar.setUnitIncrement(16);
        this.getContentPane().add((Component)this.fScrollPane, "Center");
        this.setDefaultCloseOperation(2);
        this.setSize((int)tb.getPreferredSize().getWidth() + 5, 400);
        this.checkForwardBackward();
        this.setVisible(true);
        this.repaint();
    }

    public void adjustZoom() {
        double zoom = this.m_previewPage.getZoom();
        if (zoom != NORMAL_ZOOM) {
            Dimension dim = this.m_previewContainer.getPreferredSize();
            double visibleAmount = this.fScrollPane.getVerticalScrollBar().getVisibleAmount();
            zoom = visibleAmount / (double)dim.height;
            visibleAmount = this.fScrollPane.getHorizontalScrollBar().getVisibleAmount();
            double zoom2 = visibleAmount / (double)dim.width;
            this.m_previewPage.changeZoom(Math.min(zoom, zoom2));
        }
    }

    public void changeZoom(Point p) {
        double zoom = this.m_previewPage.getZoom();
        p.x = (int)((double)p.x / zoom);
        p.y = (int)((double)p.y / zoom);
        this.m_previewPage.changeZoom();
        if (zoom == NORMAL_ZOOM) {
            this.fScrollPane.getVerticalScrollBar().setValue(1);
            this.fScrollPane.getHorizontalScrollBar().setValue(1);
        } else {
            int maximum = this.fScrollPane.getVerticalScrollBar().getMaximum();
            int visibleAmount = this.fScrollPane.getVerticalScrollBar().getVisibleAmount();
            int position = Math.max(1, p.y - (int)((double)visibleAmount * 0.5));
            position = Math.min(position, maximum - visibleAmount);
            this.fScrollPane.getVerticalScrollBar().setValue(position);
            maximum = this.fScrollPane.getHorizontalScrollBar().getMaximum();
            visibleAmount = this.fScrollPane.getHorizontalScrollBar().getVisibleAmount();
            position = Math.max(1, p.x - (int)((double)visibleAmount * 0.5));
            position = Math.min(position, maximum - visibleAmount);
            this.fScrollPane.getHorizontalScrollBar().setValue(position);
        }
        this.setZoomCursor();
        this.repaint();
    }

    public void checkForwardBackward() {
        if (this.m_previewPage.getPageIndex() >= this.fPageable.getNumberOfPages() - 1) {
            this.fForwardButton.setEnabled(false);
        } else {
            this.fForwardButton.setEnabled(true);
        }
        if (this.m_previewPage.getPageIndex() <= 0) {
            this.fBackwardButton.setEnabled(false);
        } else {
            this.fBackwardButton.setEnabled(true);
        }
    }

    protected void fillPagesComboBox() {
        int previewPagesCount = this.fPageable.getNumberOfPages();
        String[] scales = new String[previewPagesCount];
        for (int i = 1; i <= previewPagesCount; ++i) {
            scales[i - 1] = new String(Integer.toString(i));
        }
        DefaultComboBoxModel<String> dcbm = new DefaultComboBoxModel<String>(scales);
        this.fComboBox.setModel(dcbm);
        this.fComboBox.setVisible(previewPagesCount > 1);
        this.fComboBox.invalidate();
        if (this.fComboBox.getParent() != null) {
            this.fComboBox.getParent().validate();
        }
    }

    public void print() {
        PrinterJob printJob = LogoPrinter.getPrinterJob();
        printJob.setPageable(this.fPageable);
        if (printJob.printDialog()) {
            try {
                printJob.print();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setupPrintOptions() {
        LogoPrinter lp = new LogoPrinter((LogoComfort)this.fEditor);
        lp.showPrintScopeDialog();
        this.fPageable = lp.getBook();
        this.fillPagesComboBox();
        this.m_previewPage.setPageIndex(0);
        this.checkForwardBackward();
        this.repaint();
    }

    protected void setZoomCursor() {
        double zoom = this.m_previewPage.getZoom();
        Cursor cursor = null;
        cursor = zoom == NORMAL_ZOOM ? Toolkit.getDefaultToolkit().createCustomCursor(Global.getImage("ZoomOutCursor.gif"), new Point(1, 1), "ZoomOutCursor") : Toolkit.getDefaultToolkit().createCustomCursor(Global.getImage("ZoomInCursor.gif"), new Point(1, 1), "ZoomInCursor");
        this.m_previewPage.setCursor(cursor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void show() {
        this.setZoomCursor();
        PrintPreview printPreview = this;
        synchronized (printPreview) {
            Rectangle bounds = this.getParent().getBounds();
            Rectangle abounds = this.getBounds();
            this.setLocation(Math.max(0, bounds.x + (bounds.width - abounds.width) / 2), Math.max(0, bounds.y + (bounds.height - abounds.height) / 2));
        }
        super.show();
    }

    public void update(Graphics g) {
        this.adjustZoom();
        this.fStatusline.setText(Language.getString("dialog.printPreview.page", "Page:") + " " + (this.m_previewPage.getPageIndex() + 1) + "/" + this.fPageable.getNumberOfPages());
        if (this.fComboBox != null) {
            this.fComboBox.setSelectedIndex(this.m_previewPage.getPageIndex());
        }
        super.update(g);
    }

    public Editor getEditor() {
        return this.fEditor;
    }

    public void setEditor(Editor editor) {
        this.fEditor = editor;
    }

    public Pageable getPageable() {
        return this.fPageable;
    }

    public void setPageable(Pageable pageable) {
        this.fPageable = pageable;
    }

    static {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class PageMouseAdapter
    extends MouseAdapter {
        PageMouseAdapter() {
        }

        public void mouseClicked(MouseEvent e) {
            PrintPreview.this.changeZoom(e.getPoint());
        }
    }

    class PagePreview
    extends JPanel {
        protected int fPageIndex;
        protected double m_zoom = 0.5;

        public PagePreview(int pageIndex) {
            this.fPageIndex = pageIndex;
            this.setBackground(Color.white);
            this.setBorder(new MatteBorder(1, 1, 2, 2, Color.black));
        }

        public Dimension getPreferredSize() {
            if (this.getPageIndex() == -1) {
                return new Dimension(0, 0);
            }
            PageFormat pf = PrintPreview.this.fPageable.getPageFormat(this.getPageIndex());
            return new Dimension((int)pf.getWidth(), (int)pf.getHeight());
        }

        public void incPageIndex() {
            this.setPageIndex(this.getPageIndex() + 1);
            this.invalidate();
            this.getParent().validate();
        }

        public void decPageIndex() {
            this.setPageIndex(this.getPageIndex() - 1);
            this.invalidate();
            this.getParent().validate();
        }

        public int getPageIndex() {
            this.fPageIndex = Math.min(this.fPageIndex, PrintPreview.this.fPageable.getNumberOfPages() - 1);
            return this.fPageIndex;
        }

        public void setPageIndex(int newIndex) {
            this.fPageIndex = newIndex;
            this.invalidate();
            this.getParent().validate();
        }

        public void changeZoom() {
            this.m_zoom = this.m_zoom != NORMAL_ZOOM ? NORMAL_ZOOM : 0.5;
        }

        public void changeZoom(double newZoom) {
            this.m_zoom = newZoom;
        }

        public double getZoom() {
            return this.m_zoom;
        }

        public void paint(Graphics g) {
            int pageIndex = this.getPageIndex();
            if (pageIndex == -1) {
                return;
            }
            if (this.m_zoom != NORMAL_ZOOM) {
                g.setClip(0, 0, 32000, 32000);
            }
            Graphics2D g2 = (Graphics2D)g;
            g2.scale(this.m_zoom, this.m_zoom);
            g2.setColor(this.getBackground());
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.paintBorder(g);
            try {
                PrintPreview.this.fPageable.getPrintable(pageIndex).print(g2, PrintPreview.this.fPageable.getPageFormat(pageIndex), pageIndex);
            }
            catch (PrinterException pe) {
                System.out.println("PrintException aufgetreten");
            }
            JScrollBar sb = PrintPreview.this.fScrollPane.getVerticalScrollBar();
            sb.repaint();
            sb = PrintPreview.this.fScrollPane.getHorizontalScrollBar();
            sb.repaint();
        }
    }

    class PreviewContainer
    extends JPanel {
        protected int H_GAP = 16;
        protected int V_GAP = 10;

        PreviewContainer() {
        }

        public Dimension getPreferredSize() {
            int n = this.getComponentCount();
            if (n == 0) {
                return new Dimension(this.H_GAP, this.V_GAP);
            }
            Component comp = this.getComponent(0);
            Dimension dc = comp.getPreferredSize();
            int w = dc.width;
            int h = dc.height;
            Insets ins = this.getInsets();
            return new Dimension(w + ins.left + ins.right + 50, h + ins.top + ins.bottom + 50);
        }

        public void doLayout() {
            Insets ins = this.getInsets();
            int x = ins.left + this.H_GAP;
            int y = ins.top + this.V_GAP;
            int n = this.getComponentCount();
            if (n == 0) {
                return;
            }
            Component comp = this.getComponent(0);
            PagePreview pp = (PagePreview)comp;
            double zoom = pp.getZoom();
            Dimension dc = comp.getPreferredSize();
            int w = dc.width;
            int h = dc.height;
            Dimension dp = this.getParent().getSize();
            int nCol = Math.max((dp.width - this.H_GAP) / (w + this.H_GAP), 1);
            int nRow = n / nCol;
            if (nRow * nCol < n) {
                ++nRow;
            }
            int index = 0;
            for (int k = 0; k < nRow; ++k) {
                for (int m = 0; m < nCol; ++m) {
                    if (index >= n) {
                        return;
                    }
                    comp = this.getComponent(index++);
                    comp.setBounds(x, y, w, h);
                    x += w + this.H_GAP;
                }
                y += h + this.V_GAP;
                x = ins.left + this.H_GAP;
            }
        }
    }
}

