/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.util;

import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.DrawingView;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.DrawingProperties;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.OutBlockConnector;
import DE.siemens.ad.logo.model.block.OutputBlock;
import DE.siemens.ad.logo.util.BlockEnumerator;
import DE.siemens.ad.logo.util.ProgressListener;
import DE.siemens.ad.pdraw.figures.BlockFigure;
import DE.siemens.ad.pdraw.figures.FixedElbowConnection;
import DE.siemens.ad.pdraw.figures.InputIfcFigure;
import DE.siemens.ad.pdraw.figures.OutputIfcFigure;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import DE.siemens.ad.pdraw.standard.LogoDrawingView;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class LayoutProducer {
    protected int fVerticalDistance;
    protected int fHorizontalDistance;
    protected static int HOR_WIDTH = -75;
    protected static int VER_HEIGHT = 55;
    protected DrawingView fView = null;
    protected Block[] fBlocks;
    protected List fCreatedFigures = new ArrayList(30);
    protected List fConnectionsToCreate = new ArrayList(50);
    protected int fXMoveBy = 0;
    protected int fDepth = 1;

    public LayoutProducer(DrawingView view, List blocks) {
        this.fView = view;
        Vector<Block> outputBlocksVector = new Vector<Block>();
        for (Block b : blocks) {
            if (!(b instanceof OutputBlock) && !b.getViaOutConnectorConnectedBlocks().isEmpty()) continue;
            outputBlocksVector.addElement(b);
        }
        this.fBlocks = new Block[outputBlocksVector.size()];
        outputBlocksVector.copyInto(this.fBlocks);
    }

    protected void adaptPages(int width, int height) {
        LogoDrawing drawing = (LogoDrawing)this.fView.drawing();
        int pageWidth = (int)drawing.getPageDimension().getWidth();
        int pageHeight = (int)drawing.getPageDimension().getHeight();
        int horPageCount = width / pageWidth + 1;
        int verPageCount = height / pageHeight + 1;
        ((LogoDrawingView)this.fView).setSize(new Dimension(width, height));
        DrawingProperties prop = drawing.getWiringDiagram().getDrawingProperties();
        prop.setPagesHorizontal(horPageCount);
        prop.setPagesVertical(verPageCount);
    }

    protected boolean blockProcessed(Block block, int column) {
        if (block instanceof OutputBlock) {
            return column != 1;
        }
        boolean retValue = false;
        for (int i = this.fCreatedFigures.size() - 1; i >= 0; --i) {
            Block b = ((BlockFigure)this.fCreatedFigures.get(i)).getBlock();
            if (!b.equals(block)) continue;
            retValue = true;
            break;
        }
        return retValue;
    }

    protected void createConnections() {
        InBlockConnector inBlockConnector = null;
        OutBlockConnector outBlockConnector = null;
        InputIfcFigure inputIfcFigure = null;
        OutputIfcFigure outputIfcFigure = null;
        for (int i = 0; i < this.fConnectionsToCreate.size(); ++i) {
            inBlockConnector = (InBlockConnector)this.fConnectionsToCreate.get(i);
            outBlockConnector = inBlockConnector.getLinkedConnector();
            inputIfcFigure = this.getInputIfcFigure(inBlockConnector);
            outputIfcFigure = this.getOutputIfcFigure(outBlockConnector);
            if (inputIfcFigure == null || outputIfcFigure == null) continue;
            Connector conn1 = inputIfcFigure.connectorAt(0, 0);
            Connector conn2 = outputIfcFigure.connectorAt(0, 0);
            FixedElbowConnection connection = new FixedElbowConnection();
            connection.connectStart(conn2);
            connection.connectEnd(conn1);
            connection.updateConnection();
            connection.moveBy(this.fXMoveBy, 0);
            this.fView.add(connection);
        }
    }

    private InputIfcFigure getInputIfcFigure(InBlockConnector connector) {
        InputIfcFigure inputIfcFigure = null;
        for (int i = this.fCreatedFigures.size() - 1; i >= 0; --i) {
            inputIfcFigure = ((BlockFigure)this.fCreatedFigures.get(i)).getInputIfcFigure(connector);
            if (inputIfcFigure == null) continue;
            Block b = ((BlockFigure)this.fCreatedFigures.get(i)).getBlock();
            int position = b.getInConnectorPosition(connector);
            this.fXMoveBy = -10 + position * 10;
            break;
        }
        return inputIfcFigure;
    }

    private OutputIfcFigure getOutputIfcFigure(OutBlockConnector connector) {
        OutputIfcFigure outputIfcFigure = null;
        for (int i = this.fCreatedFigures.size() - 1; i >= 0 && (outputIfcFigure = ((BlockFigure)this.fCreatedFigures.get(i)).getOutputIfcFigure(connector)) == null; --i) {
        }
        return outputIfcFigure;
    }

    public void layout() {
        this.calculateDistances();
        this.doLayout(0, this.fVerticalDistance, null);
    }

    public void layout2(ProgressListener progressListener) {
        this.calculateDistances();
        this.doLayout(5000, 25, progressListener);
    }

    private void doLayout(int startX, int startY, ProgressListener progressListener) {
        int rowOffset = 0;
        int rowMax = 0;
        int rowLast = 0;
        Dimension dim = this.fView.getSize();
        Point startPoint = new Point(startX + this.fHorizontalDistance, startY);
        int row = 0;
        for (int i = 0; i < this.fBlocks.length; ++i) {
            if (progressListener != null) {
                progressListener.increment(1);
            }
            rowLast = 0;
            rowOffset += rowMax;
            rowMax = 0;
            Block block = this.fBlocks[i];
            Block previousBlock = null;
            Block actBlock = null;
            InBlockConnector inBlockConnector = null;
            BlockEnumerator enumeration = new BlockEnumerator(block, false);
            while (enumeration.hasMoreElements()) {
                int column;
                actBlock = enumeration.nextBlock();
                if (!this.blockProcessed(actBlock, column = enumeration.getColumn())) {
                    if (column > this.fDepth) {
                        this.fDepth = column;
                    }
                    Point refPoint = new Point(startPoint);
                    row = enumeration.getRow();
                    if (row > rowLast) {
                        row = ++rowLast;
                    }
                    if (row > rowMax) {
                        rowMax = row;
                    }
                    refPoint.translate((column - 1) * this.fHorizontalDistance, (row - 1 + rowOffset) * this.fVerticalDistance);
                    BlockFigure f = new BlockFigure(actBlock, refPoint);
                    f.moveAlignmentAnchorTo(refPoint);
                    this.fCreatedFigures.add(f);
                    this.fView.add(f);
                }
                if (previousBlock != null && !this.fConnectionsToCreate.contains(inBlockConnector = enumeration.getInBlockConnector())) {
                    this.fConnectionsToCreate.add(inBlockConnector);
                }
                previousBlock = actBlock;
            }
        }
        this.moveBlocks(-startX - (this.fDepth + 1) * this.fHorizontalDistance);
        this.adaptPages((this.fDepth + 1) * -this.fHorizontalDistance, (row + rowOffset) * this.fVerticalDistance);
        this.createConnections();
        this.fView.checkDamage();
    }

    public int getProgressSteps() {
        return this.fBlocks.length;
    }

    protected void moveBlocks(int xMove) {
        int size = this.fCreatedFigures.size();
        for (int i = 0; i < size; ++i) {
            ((BlockFigure)this.fCreatedFigures.get(i)).moveBy(xMove, 0);
        }
    }

    private void calculateDistances() {
        int grid = ((LogoDrawingView)this.fView).getGridInfo().getDistance();
        this.fHorizontalDistance = -grid;
        while (this.fHorizontalDistance > HOR_WIDTH) {
            this.fHorizontalDistance -= grid;
        }
        this.fVerticalDistance = grid;
        while (this.fVerticalDistance < VER_HEIGHT) {
            this.fVerticalDistance += grid;
        }
    }
}

