/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.standard;

import CH.ifa.draw.framework.DrawingView;
import DE.siemens.ad.kop.model.WiringDiagramKop;
import DE.siemens.ad.kop.model.block.AnalogCoilBlock;
import DE.siemens.ad.kop.model.block.CoilBlock;
import DE.siemens.ad.logo.app.Editor;
import DE.siemens.ad.logo.app.action.ActionManager;
import DE.siemens.ad.logo.app.action.ShowHelpContextAction;
import DE.siemens.ad.logo.app.comp.PopupWindow;
import DE.siemens.ad.logo.app.comp.RolloverButton;
import DE.siemens.ad.logo.dialog.CompactBlockSelectionPanel;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockGroup;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.ScalableMouseEvent;
import DE.siemens.ad.pdraw.action.InsertBlockAction;
import DE.siemens.ad.pdraw.figures.BlockFigure;
import DE.siemens.ad.pdraw.standard.IconTextTooltip;
import DE.siemens.ad.pdraw.standard.ImageBlockTool;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import DE.siemens.ad.pdraw.standard.LogoDrawingView;
import DE.siemens.ad.pdraw.standard.LogoGridConstrainer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.help.CSH;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.UIResource;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreeImageBlockTool
extends ImageBlockTool {
    protected Block fSelectedBlock;
    private int fRowHeight = 16;
    protected TooltipEnabledTree fBlockTree;
    private List fNotAvailableBlocks;
    protected Point fLastMousePosition;
    private IconTextTooltip fKeySelectorTooltip;
    private Timer fKeySelectorTooltipTimer;
    private BlockFigure fDragBlockFigure;

    public TreeImageBlockTool(BlockGroup blockGroup) {
        this.fBlockGroup = blockGroup;
        this.fNotAvailableBlocks = new ArrayList(30);
        this.createBlockTree(blockGroup);
        this.expandTree(this.fBlockTree);
        CSH.setHelpIDString((Component)this.fBlockTree, (String)"toolbar.catalogue");
        this.fKeySelectorTooltip = new IconTextTooltip();
        this.fKeySelectorTooltipTimer = new Timer(1500, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TreeImageBlockTool.this.fKeySelectorTooltip.setVisible(false);
                if (TreeImageBlockTool.this.fKeySelectorTooltip.getParent() != null) {
                    TreeImageBlockTool.this.fKeySelectorTooltip.getParent().remove(TreeImageBlockTool.this.fKeySelectorTooltip);
                }
            }
        });
        this.fKeySelectorTooltipTimer.setRepeats(false);
    }

    private JTree createBlockTree(BlockGroup blockGroup) {
        DefaultMutableTreeNode blockRoot = new DefaultMutableTreeNode("Blocks");
        this.addBlockGroup(blockRoot, blockGroup);
        DefaultTreeModel treeModel = new DefaultTreeModel(blockRoot);
        this.fBlockTree = new TooltipEnabledTree(treeModel);
        this.fBlockTree.setDragEnabled(true);
        this.fBlockTree.setTransferHandler(new BlockTreeTransferHandler());
        this.fBlockTree.setRowHeight(0);
        DefaultTreeSelectionModel selectionModel = new DefaultTreeSelectionModel();
        selectionModel.setSelectionMode(1);
        this.fBlockTree.setSelectionModel(selectionModel);
        this.fBlockTree.setRootVisible(false);
        this.fBlockTree.setCellRenderer(new BlockCellRenderer());
        this.fBlockTree.addTreeSelectionListener(new BlockTreeSelectionListener());
        this.fBlockTree.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                TreeImageBlockTool.this.getBlockTree().getTransferHandler().exportAsDrag(TreeImageBlockTool.this.getBlockTree(), e, 1);
            }
        });
        MouseWheelZoomer mouseWheelZoomer = new MouseWheelZoomer();
        this.fBlockTree.addMouseWheelListener(mouseWheelZoomer);
        return this.fBlockTree;
    }

    protected boolean isInsertable(MouseEvent evt, int x, int y, DrawingView view) {
        DefaultMutableTreeNode lastNode;
        if (this.fBlockTree.getSelectionPath() != null && (lastNode = (DefaultMutableTreeNode)this.fBlockTree.getSelectionPath().getLastPathComponent()).getUserObject() instanceof Block) {
            return !this.fNotAvailableBlocks.contains(lastNode.getUserObject());
        }
        return false;
    }

    private void addBlockGroup(DefaultMutableTreeNode parentNode, BlockGroup blockGroup) {
        DefaultMutableTreeNode blockGroupNode = null;
        if (blockGroup.getBlockGroupVisible().equals(Boolean.TRUE) && blockGroup.getElementCount() > 0) {
            blockGroupNode = new DefaultMutableTreeNode(blockGroup.getLocalizedName());
            parentNode.add(blockGroupNode);
        } else {
            blockGroupNode = parentNode;
        }
        for (Object block : blockGroup.getBlocks()) {
            if (block instanceof BlockGroup) {
                if (((BlockGroup)block).getElementCount() <= 0) continue;
                this.addBlockGroup(blockGroupNode, (BlockGroup)block);
                continue;
            }
            DefaultMutableTreeNode blockNode = new DefaultMutableTreeNode(block);
            blockGroupNode.add(blockNode);
        }
    }

    public JTree getBlockTree() {
        return this.fBlockTree;
    }

    protected void expandTree(final JTree tree) {
        Runnable r = new Runnable(){

            public void run() {
                for (int row = 0; row < tree.getRowCount(); ++row) {
                    if (tree.isExpanded(row)) continue;
                    tree.expandRow(row);
                }
            }
        };
        SwingUtilities.invokeLater(r);
    }

    public void checkBlockAvailability(WiringDiagram wiringDiagram) {
        this.fNotAvailableBlocks.clear();
        Enumeration<TreeNode> e = ((DefaultMutableTreeNode)this.fBlockTree.getModel().getRoot()).breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            if (!(node.getUserObject() instanceof Block)) continue;
            Block block = (Block)node.getUserObject();
            if (block instanceof AnalogCoilBlock) {
                if (((WiringDiagramKop)wiringDiagram).getAvailableAnalogCoilBlocks(block).size() != 0) continue;
                this.fNotAvailableBlocks.add(block);
                continue;
            }
            if (block instanceof CoilBlock || block.isResourceAvailable(wiringDiagram)) continue;
            this.fNotAvailableBlocks.add(block);
        }
        this.fBlockTree.repaint();
    }

    protected void setComponentInApplication(DrawingView view) {
    }

    public void mouseDown(MouseEvent e, int x, int y, DrawingView view) {
        this.fKeySelectorTooltip.setVisible(false);
        if (e.isControlDown()) {
            this.showBlockPopup(e, view);
        } else {
            super.mouseDown(e, x, y, view);
        }
    }

    private void showBlockPopup(final MouseEvent mouseEvent, final DrawingView view) {
        final CompactBlockSelectionPanel compactBlockSelectionPanel = new CompactBlockSelectionPanel(this.fBlockGroup);
        Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, (LogoDrawingView)view);
        final PopupWindow popupWindow = new PopupWindow(window);
        popupWindow.getContentPane().add(compactBlockSelectionPanel);
        popupWindow.addPopupWindowListener(new PopupWindow.PopupWindowListener(){

            public void popupWindowCanceled(PopupWindow.PopupWindowEvent popupEvent) {
            }

            public void popupWindowApproved(PopupWindow.PopupWindowEvent popupEvent) {
                Block block = compactBlockSelectionPanel.getSelectedBlock();
                if (block != null) {
                    TreeImageBlockTool.this.fClassName = block.getClassName();
                    TreeImageBlockTool.this.selectBlockInTree(block);
                    TreeImageBlockTool.super.mouseDown(mouseEvent, mouseEvent.getPoint().x, mouseEvent.getPoint().y, view);
                }
            }
        });
        MouseAdapter doubleClickListener = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                if (e.getClickCount() == 2) {
                    popupWindow.approvePopupWindow();
                }
            }
        };
        compactBlockSelectionPanel.getBlockList().addMouseListener(doubleClickListener);
        compactBlockSelectionPanel.getConnectorList().addMouseListener(doubleClickListener);
        Point popupLocation = mouseEvent instanceof ScalableMouseEvent ? ((ScalableMouseEvent)mouseEvent).getUnscaledPoint() : mouseEvent.getPoint();
        popupLocation = ((LogoDrawingView)view).getZoomManager().convertModelToDisplayCoordinates(popupLocation);
        SwingUtilities.convertPointToScreen(popupLocation, (LogoDrawingView)view);
        popupWindow.requestFocusInWindow();
        popupWindow.show(new Rectangle(popupLocation, new Dimension(200, 200)));
    }

    public void mouseMove(MouseEvent evt, int x, int y, DrawingView view) {
        Window window;
        super.mouseMove(evt, x, y, view);
        this.fLastMousePosition = evt.getPoint();
        if (!((JComponent)((Object)view)).hasFocus() && (window = (Window)SwingUtilities.getAncestorOfClass(Window.class, (Component)((Object)view))) != null && window.isActive() && window.getFocusOwner() != null) {
            ((JComponent)((Object)view)).requestFocus();
        }
    }

    protected void selectBlockInTree(Block block) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.fBlockTree.getModel().getRoot();
        Enumeration<TreeNode> e = root.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode blockNode = (DefaultMutableTreeNode)e.nextElement();
            if (blockNode.getUserObject() != block) continue;
            this.fBlockTree.setSelectionPath(new TreePath(blockNode.getPath()));
            break;
        }
    }

    public void deactivate(DrawingView view) {
        this.setActiveTool(false);
        this.getBlockTree().repaint();
    }

    public void keyDown(KeyEvent evt, int key, DrawingView view) {
        int currentRow;
        super.keyDown(evt, key, view);
        int[] selectedRows = this.fBlockTree.getSelectionRows();
        int n = currentRow = selectedRows == null || selectedRows.length > 0 ? selectedRows[0] + 1 : 0;
        if (currentRow >= this.fBlockTree.getRowCount()) {
            currentRow = 0;
        }
        Position.Bias searchDirection = evt.isShiftDown() ? Position.Bias.Backward : Position.Bias.Forward;
        TreePath treePath = null;
        do {
            treePath = this.fBlockTree.getNextMatch(evt.getKeyChar() + "", currentRow, searchDirection);
            ++currentRow;
        } while (treePath != null && !(((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject() instanceof Block));
        if (treePath != null) {
            this.fBlockTree.setSelectionPath(treePath);
            this.fBlockTree.scrollPathToVisible(treePath);
            Object selectedObject = ((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
            if (selectedObject instanceof Block) {
                Block block = (Block)selectedObject;
                this.fKeySelectorTooltip.setIcon(Global.getIcon(block.getIconName()));
                this.fKeySelectorTooltip.setText(block.getLocalizedName(false));
                float zoomFactor = (float)((LogoDrawingView)view).getZoomManager().getZoom() / 100.0f;
                Dimension tooltipSize = this.fKeySelectorTooltip.getPreferredSize();
                Point tooltipLocation = new Point(Math.max(0, (int)((float)this.fLastMousePosition.x * zoomFactor - (float)tooltipSize.width / 2.0f)), Math.max(0, (int)((float)this.fLastMousePosition.y * zoomFactor - (float)tooltipSize.height)));
                this.fKeySelectorTooltip.setLocation(tooltipLocation);
                this.fKeySelectorTooltip.setSize(tooltipSize);
                ((JComponent)((Object)view)).add(this.fKeySelectorTooltip);
                this.fKeySelectorTooltip.setVisible(true);
                this.fKeySelectorTooltipTimer.restart();
                this.fKeySelectorTooltip.validate();
            }
        }
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent, LogoDrawingView view) {
        LogoDrawing drawing = (LogoDrawing)view.drawing();
        WiringDiagram wDiagram = drawing.getWiringDiagram();
        Rectangle blockFigureBox = this.fDragBlockFigure.displayBox();
        view.remove(this.fDragBlockFigure);
        wDiagram.deleteBlock(this.fDragBlockFigure.getBlock());
        Block block = null;
        try {
            block = Block.createInstanceForName(this.fClassName, wDiagram);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        BlockFigure insertedFigure = new BlockFigure(block, blockFigureBox.getLocation());
        Rectangle insertedFigureBox = insertedFigure.displayBox();
        insertedFigure.getConstraint().move(new Dimension(blockFigureBox.x - insertedFigureBox.x, blockFigureBox.y - insertedFigureBox.y));
        ActionManager actionManager = ((Editor)((Object)view.editor())).getActionManager();
        InsertBlockAction insertAction = (InsertBlockAction)actionManager.getActionFactory().getAction(this.getInsertActionString());
        insertAction.setBlockFigure(insertedFigure);
        actionManager.invokeAction(insertAction);
        this.fDragBlockFigure = null;
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent, LogoDrawingView view) {
        if (!view.getEditor().isActivated() || !this.acceptDragAndDrop(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
            return;
        }
        LogoDrawing drawing = (LogoDrawing)view.drawing();
        WiringDiagram wDiagram = drawing.getWiringDiagram();
        Block block = null;
        try {
            block = Block.createInstanceForName(this.fClassName, wDiagram);
            if (!block.isResourceAvailable(wDiagram)) {
                dropTargetDragEvent.rejectDrag();
            }
            wDiagram.insert(block);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Point location = dropTargetDragEvent.getLocation();
        if (view.getZoomManager() != null) {
            location = view.getZoomManager().convertDisplayToModelCoordinates(location);
        }
        this.fDragBlockFigure = new BlockFigure(block, location);
        view.add(this.fDragBlockFigure);
        view.checkDamage();
    }

    public boolean acceptDragAndDrop(DropTargetDragEvent dropTargetDragEvent) {
        return dropTargetDragEvent != null && dropTargetDragEvent.isDataFlavorSupported(new DataFlavor(Block.class, "BlockTemplate"));
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent, LogoDrawingView view) {
        if (!view.getEditor().isActivated() || !this.acceptDragAndDrop(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
            return;
        }
        Point clickPoint = new Point(dropTargetDragEvent.getLocation());
        if (view.getZoomManager() != null) {
            clickPoint = view.getZoomManager().convertDisplayToModelCoordinates(clickPoint);
        }
        int x = clickPoint.getLocation().x;
        int y = clickPoint.getLocation().y;
        if (!(view.getConstrainer() instanceof LogoGridConstrainer) || ((LogoGridConstrainer)view.getConstrainer()).getStepX() < 40) {
            x -= 12;
            y -= 15;
        }
        if (view.getConstrainer() != null) {
            Point constrainedPoint = view.getConstrainer().constrainPoint(new Point(x, y));
            this.fDragBlockFigure.moveAlignmentAnchorTo(constrainedPoint);
        } else {
            this.fDragBlockFigure.moveAlignmentAnchorTo(clickPoint);
        }
        view.checkDamage();
    }

    public void dragExit(DropTargetEvent dropTargetEvent, LogoDrawingView view) {
        if (this.fDragBlockFigure != null) {
            view.remove(this.fDragBlockFigure);
            this.fDragBlockFigure.getBlock().getWiringDiagram().deleteBlock(this.fDragBlockFigure.getBlock());
            view.checkDamage();
            this.fDragBlockFigure = null;
        }
    }

    protected class BlockCellRenderer
    extends DefaultTreeCellRenderer {
        private Hashtable blockIcons = new Hashtable();
        private int fLastRowHeight = 0;
        private Color fDefaultSelectionColor = this.getBackgroundSelectionColor();
        private Font fBlockFont;
        private Font fBlockGroupFont;

        public BlockCellRenderer() {
            Font font;
            this.fBlockFont = font = new JLabel().getFont();
            String name = font.getName();
            int size = font.getSize();
            this.fBlockGroupFont = new Font(name, 1, size);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (((DefaultMutableTreeNode)value).getUserObject() instanceof Block) {
                ImageIcon icon;
                super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                Block block = (Block)((DefaultMutableTreeNode)value).getUserObject();
                this.setText(block.getLocalizedName(false));
                int rowHeight = tree.getRowHeight();
                if (rowHeight <= 0) {
                    rowHeight = TreeImageBlockTool.this.fRowHeight;
                }
                if (this.fLastRowHeight != rowHeight) {
                    this.blockIcons = new Hashtable();
                    this.fLastRowHeight = rowHeight;
                }
                if ((icon = (ImageIcon)this.blockIcons.get(block)) == null) {
                    icon = Global.getIcon(block.getIconName());
                    if (icon.getIconHeight() != rowHeight) {
                        int unscaledHeight = icon.getIconHeight();
                        float scale = (float)rowHeight / (float)unscaledHeight;
                        icon = new ImageIcon(icon.getImage().getScaledInstance((int)((float)icon.getIconWidth() * scale), (int)((float)icon.getIconHeight() * scale), scale > 1.0f ? 2 : 4));
                    }
                    this.blockIcons.put(block, icon);
                }
                this.setIcon(icon);
                if (TreeImageBlockTool.this.fNotAvailableBlocks.contains(block)) {
                    this.setForeground(Color.lightGray);
                    this.setIcon(new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)this.getIcon()).getImage())));
                }
                if (selected && !TreeImageBlockTool.this.isActiveTool()) {
                    this.setBackgroundSelectionColor(Color.gray);
                } else {
                    this.setBackgroundSelectionColor(this.fDefaultSelectionColor);
                }
                this.setFont(this.fBlockFont);
            } else {
                super.getTreeCellRendererComponent(tree, value, false, expanded, leaf, row, hasFocus);
                this.setFont(this.fBlockGroupFont);
            }
            return this;
        }
    }

    protected class TooltipEnabledTree
    extends JTree {
        private RolloverButton fQuicktestButton;
        private JToolTip fToolTip;
        private Hashtable fBlockIconCache;
        private TreePath fToolTipPath;
        private JButton fHelpButton;

        public String getToolTipText(MouseEvent event) {
            int row = this.getRowForLocation(event.getX(), event.getY());
            this.fToolTipPath = this.getPathForLocation(event.getX(), event.getY());
            if (this.fToolTipPath == null) {
                return null;
            }
            boolean leaf = false;
            Object currentValue = this.fToolTipPath.getLastPathComponent();
            if (currentValue == null) {
                return null;
            }
            if (currentValue != null && ((DefaultMutableTreeNode)currentValue).getUserObject() instanceof Block) {
                Block block = (Block)((DefaultMutableTreeNode)currentValue).getUserObject();
                ((IconTextTooltip)this.fToolTip).setIcon(this.getBlockIcon(block));
                ((IconTextTooltip)this.fToolTip).setText(block.getLocalizedName(false));
                String helpID = "block." + block.getName();
                this.fHelpButton.putClientProperty("helpID", helpID);
                this.fHelpButton.setVisible(true);
            } else {
                ((IconTextTooltip)this.fToolTip).setIcon(null);
                ((IconTextTooltip)this.fToolTip).setText(currentValue.toString());
                this.fHelpButton.setVisible(false);
                this.getQuicktestButton().setVisible(false);
            }
            return currentValue.toString();
        }

        private Icon getBlockIcon(Block block) {
            if (!this.fBlockIconCache.containsKey(block)) {
                ImageIcon icon = Global.getIcon(block.getIconName());
                this.fBlockIconCache.put(block, icon);
            }
            return (Icon)this.fBlockIconCache.get(block);
        }

        public JToolTip createToolTip() {
            return this.fToolTip;
        }

        public Point getToolTipLocation(MouseEvent event) {
            TreePath cursorPath = this.getPathForLocation(event.getX(), event.getY());
            if (cursorPath == null) {
                return super.getToolTipLocation(event);
            }
            Rectangle pathBounds = this.getPathBounds(cursorPath);
            Point toolTipLocation = pathBounds.getLocation();
            int delta = (this.fToolTip.getPreferredSize().height - pathBounds.height) / 2;
            toolTipLocation.y -= delta;
            toolTipLocation.x += 10;
            return toolTipLocation;
        }

        public TooltipEnabledTree(TreeModel newModel) {
            super(newModel);
            this.fToolTip = new IconTextTooltip();
            this.fToolTip.setLayout(new FlowLayout());
            this.fBlockIconCache = new Hashtable(30);
            this.setToolTipText("Tip");
            this.fHelpButton = new RolloverButton("?");
            this.fHelpButton.setMargin(new Insets(0, 0, 0, 0));
            this.fToolTip.add(this.fHelpButton);
            this.initListeners();
        }

        protected RolloverButton getQuicktestButton() {
            if (this.fQuicktestButton == null) {
                this.fQuicktestButton = new RolloverButton();
                this.fQuicktestButton.setMargin(new Insets(0, 0, 0, 0));
            }
            return this.fQuicktestButton;
        }

        private void initListeners() {
            this.fToolTip.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    if (TooltipEnabledTree.this.fToolTipPath != null) {
                        e = SwingUtilities.convertMouseEvent(TooltipEnabledTree.this.fToolTip, e, TreeImageBlockTool.this.fBlockTree);
                        TreeImageBlockTool.this.fBlockTree.dispatchEvent(e);
                    }
                }
            });
            this.fToolTip.addMouseMotionListener(new MouseMotionAdapter(){

                public void mouseMoved(MouseEvent e) {
                    e = new MouseEvent((Component)e.getSource(), e.getID(), e.getWhen(), e.getModifiers(), 0, e.getPoint().y, e.getClickCount(), e.isPopupTrigger());
                    e = SwingUtilities.convertMouseEvent(TooltipEnabledTree.this.fToolTip, e, TreeImageBlockTool.this.fBlockTree);
                    if (TreeImageBlockTool.this.fBlockTree.getVisibleRect().contains(e.getPoint())) {
                        TreeImageBlockTool.this.fBlockTree.dispatchEvent(e);
                    }
                }

                public void mouseDragged(MouseEvent e) {
                    e = new MouseEvent((Component)e.getSource(), e.getID(), e.getWhen(), e.getModifiers(), 0, e.getPoint().y, e.getClickCount(), e.isPopupTrigger());
                    e = SwingUtilities.convertMouseEvent(TooltipEnabledTree.this.fToolTip, e, TreeImageBlockTool.this.fBlockTree);
                    TreeImageBlockTool.this.fBlockTree.dispatchEvent(e);
                }
            });
            this.fToolTip.addMouseWheelListener(new MouseWheelListener(){

                public void mouseWheelMoved(MouseWheelEvent e) {
                    if (e.isControlDown()) {
                        TreeImageBlockTool.this.fBlockTree.dispatchEvent(e);
                    }
                }
            });
            this.fHelpButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String helpID = (String)TooltipEnabledTree.this.fHelpButton.getClientProperty("helpID");
                    if (helpID != null) {
                        ShowHelpContextAction action = new ShowHelpContextAction();
                        action.setHelpID(helpID);
                        action.setActivationWindow((Window)SwingUtilities.getAncestorOfClass(Window.class, TreeImageBlockTool.this.fBlockTree));
                        action.doIt();
                    }
                }
            });
        }

        public JToolTip getToolTip() {
            return this.fToolTip;
        }
    }

    protected class BlockTreeSelectionListener
    implements TreeSelectionListener {
        protected BlockTreeSelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent e) {
            DefaultMutableTreeNode selectedNode;
            if (e.getNewLeadSelectionPath() != null && (selectedNode = (DefaultMutableTreeNode)e.getNewLeadSelectionPath().getLastPathComponent()) != null) {
                if (selectedNode.getUserObject() instanceof Block) {
                    TreeImageBlockTool.this.fSelectedBlock = (Block)selectedNode.getUserObject();
                    TreeImageBlockTool.this.setClassName(TreeImageBlockTool.this.fSelectedBlock.getClassName());
                    String helpID = "block." + TreeImageBlockTool.this.fSelectedBlock.getName();
                    CSH.setHelpIDString((Component)TreeImageBlockTool.this.fBlockTree, (String)helpID);
                } else {
                    CSH.setHelpIDString((Component)TreeImageBlockTool.this.fBlockTree, (String)"toolbar.catalogue");
                }
            }
        }
    }

    protected class MouseWheelZoomer
    implements MouseWheelListener {
        protected MouseWheelZoomer() {
        }

        public void mouseWheelMoved(MouseWheelEvent e) {
            if (e.isControlDown()) {
                if (e.getWheelRotation() > 0) {
                    TreeImageBlockTool.this.fRowHeight = Math.max(15, (int)((double)TreeImageBlockTool.this.fRowHeight / 1.1));
                } else {
                    TreeImageBlockTool.this.fRowHeight = Math.min(100, (int)((double)TreeImageBlockTool.this.fRowHeight * 1.1));
                }
                int rowHeight = TreeImageBlockTool.this.fBlockTree.getRowHeight();
                if (rowHeight <= 0) {
                    TreeImageBlockTool.this.fBlockTree.setRowHeight(rowHeight - 1);
                }
            } else {
                TreeImageBlockTool.this.fBlockTree.getParent().dispatchEvent(e);
            }
        }
    }

    class BlockTreeTransferHandler
    extends TransferHandler
    implements UIResource,
    Comparator {
        private JTree tree;

        BlockTreeTransferHandler() {
        }

        protected Transferable createTransferable(JComponent c) {
            if (c instanceof JTree) {
                DefaultMutableTreeNode defaultMutableTreeNode;
                this.tree = (JTree)c;
                Object selectedNode = this.tree.getLastSelectedPathComponent();
                if (selectedNode instanceof DefaultMutableTreeNode && (defaultMutableTreeNode = (DefaultMutableTreeNode)selectedNode).getUserObject() instanceof Block) {
                    Block block = (Block)defaultMutableTreeNode.getUserObject();
                    if (!TreeImageBlockTool.this.fNotAvailableBlocks.contains(block)) {
                        return new BlockTemplateTransferable(block, this.tree);
                    }
                }
            }
            return null;
        }

        public int compare(Object o1, Object o2) {
            int row1 = this.tree.getRowForPath((TreePath)o1);
            int row2 = this.tree.getRowForPath((TreePath)o2);
            return row1 - row2;
        }

        public int getSourceActions(JComponent c) {
            return 1;
        }
    }

    public static class BlockTemplateTransferable
    implements Transferable {
        private JTree fBlockTree;
        private Block fBlockTemplate;
        private DataFlavor fBlockTemplateDataFlavor = new DataFlavor(Block.class, "BlockTemplate");

        public BlockTemplateTransferable(Block blockTemplate, JTree blockTree) {
            this.fBlockTemplate = blockTemplate;
            this.fBlockTree = blockTree;
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!flavor.equals(this.fBlockTemplateDataFlavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.fBlockTemplate;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{this.fBlockTemplateDataFlavor};
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(this.fBlockTemplateDataFlavor);
        }
    }
}

