/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.standard;

import CH.ifa.draw.framework.HJDError;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.util.Iconkit;
import DE.siemens.ad.logo.app.comp.RolloverToggleButton;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.pdraw.standard.ToolButtonListener;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;

public class ToolJButton
extends RolloverToggleButton {
    private String fName;
    private Tool fTool;
    protected ToolButtonListener fListener;

    public ToolJButton(ToolButtonListener listener, String iconName, String name, Tool tool) {
        Iconkit kit = Iconkit.instance();
        if (kit == null) {
            throw new HJDError("Iconkit instance isn't set");
        }
        Image iconImage = Global.getImage(iconName + ".gif");
        Image cursorImage = Global.getImage(iconName + "Cursor.gif");
        MediaTracker tracker = new MediaTracker(this);
        try {
            tracker.addImage(iconImage, 0);
            tracker.addImage(cursorImage, 1);
            tracker.waitForAll();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.setIcon(new ImageIcon(iconImage));
        this.setToolTipText(name);
        this.fTool = tool;
        this.fName = name;
        this.fListener = listener;
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ToolJButton.this.action();
            }
        });
        if (cursorImage != null) {
            Cursor cursor = null;
            cursor = Toolkit.getDefaultToolkit().createCustomCursor(cursorImage, new Point(1, 1), "ToolCursor");
            if (cursor != null) {
                this.fTool.setCursor(cursor);
            }
        }
    }

    protected void action() {
        this.fListener.userSelectedButton(this);
    }

    public Object attributeValue() {
        return this.tool();
    }

    public Dimension getMaximumSize() {
        return new Dimension(26, 26);
    }

    public Dimension getMinimumSize() {
        return new Dimension(26, 26);
    }

    public Dimension getPreferredSize() {
        return new Dimension(26, 26);
    }

    public String name() {
        return this.fName;
    }

    public void reset() {
        this.setSelected(false);
    }

    public void select() {
        this.setSelected(true);
    }

    public Tool tool() {
        return this.fTool;
    }
}

