/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.standard;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Painter;
import DE.siemens.ad.logo.util.LogoProperties;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import DE.siemens.ad.pdraw.standard.LogoDrawingView;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.JComponent;

public class SimulationUpdateStrategy
implements Painter {
    private transient Image fOffscreen;
    private int fImagewidth = -1;
    private int fImageheight = -1;
    private static final long serialVersionUID = 6489532222954612824L;
    private int bufferedUpdateSerializedDataVersion = 1;
    protected boolean doubleBufferedUpdateUsed = true;
    protected boolean doubleBufferedUpdatedUsedInitialized = false;
    protected Rectangle fLastVisibleRect;
    protected double fLastZoomFactor;
    private boolean fParameterValuesDisabled;

    public SimulationUpdateStrategy(DrawingView view) {
        this.initialize(view);
    }

    public void draw(Graphics g, DrawingView view) {
        boolean showStates = ((LogoDrawing)view.drawing()).getOptionProperties().getShowStatesDuringSimulation();
        boolean showParameterValues = ((LogoDrawing)view.drawing()).getOptionProperties().getShowParameterValuesDuringSimulation() && !this.fParameterValuesDisabled;
        double zoomFactor = (double)((LogoDrawingView)view).getZoomManager().getZoom() / 100.0;
        if (LogoProperties.instance().getBooleanProperty("useDoubleBufferedSimulationUpdate", true)) {
            Rectangle visibleRect = ((JComponent)((Object)view)).getVisibleRect();
            Dimension d = view.getSize();
            if (this.fOffscreen == null || d.width > this.fImagewidth || d.height > this.fImageheight) {
                Dimension screenDimension = Toolkit.getDefaultToolkit().getScreenSize();
                this.fOffscreen = view.createImage(Math.min(screenDimension.width, d.width), Math.min(screenDimension.height, d.height));
                this.fImagewidth = d.width;
                this.fImageheight = d.height;
                Graphics g2 = this.fOffscreen.getGraphics();
                g2.translate(-visibleRect.x, -visibleRect.y);
                if (zoomFactor < 1.0) {
                    g2.setClip(0, 0, (int)((double)this.fImagewidth / zoomFactor), (int)((double)this.fImageheight / zoomFactor));
                } else {
                    g2.setClip(0, 0, (int)((double)(visibleRect.x + visibleRect.width) * zoomFactor), (int)((double)(visibleRect.y + visibleRect.height) * zoomFactor));
                }
                ((LogoDrawingView)view).drawAll(g2);
                this.fLastVisibleRect = visibleRect;
            }
            Graphics g2 = this.fOffscreen.getGraphics();
            g2.translate(-visibleRect.x, -visibleRect.y);
            if (zoomFactor < 1.0) {
                g2.setClip(visibleRect.x, visibleRect.y, visibleRect.width, visibleRect.height);
            } else {
                g2.setClip(visibleRect.x, visibleRect.y, visibleRect.width, visibleRect.height);
            }
            if (!((LogoDrawingView)view).isSimulationUpdate() || !this.fLastVisibleRect.equals(visibleRect) || this.fLastZoomFactor != zoomFactor) {
                ((LogoDrawingView)view).drawAll(g2);
                this.fLastVisibleRect = visibleRect;
                ((LogoDrawingView)view).drawSimulation(g2, showStates, showParameterValues);
            } else {
                ((LogoDrawingView)view).drawSimulation(g2, showStates, showParameterValues);
            }
            g.drawImage(this.fOffscreen, visibleRect.x, visibleRect.y, view);
            ((LogoDrawingView)view).setSimulationUpdate(false);
        } else {
            ((LogoDrawingView)view).drawAll(g);
            ((LogoDrawingView)view).drawSimulation(g, showStates, showParameterValues);
        }
        this.fLastZoomFactor = zoomFactor;
    }

    public boolean isDoubleBufferedUpdateUsed() {
        if (!this.doubleBufferedUpdatedUsedInitialized) {
            this.doubleBufferedUpdateUsed = LogoProperties.instance().getProperty("useDoubleBufferedSimulationUpdate", true);
            this.doubleBufferedUpdatedUsedInitialized = true;
        }
        return this.doubleBufferedUpdateUsed;
    }

    public boolean isParameterValuesDisabled() {
        return this.fParameterValuesDisabled;
    }

    public void setParameterValuesDisabled(boolean parameterValuesDisabled) {
        this.fParameterValuesDisabled = parameterValuesDisabled;
    }

    public void initialize(DrawingView view) {
        Dimension screenDimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.fOffscreen = view.createImage(screenDimension.width, screenDimension.height);
    }
}

