/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.standard;

import DE.siemens.ad.logo.app.comp.LabelledEditableNumericSpinner;
import DE.siemens.ad.logo.app.comp.NumericSpinnerListener;
import DE.siemens.ad.logo.dialog.comp.Measurement;
import DE.siemens.ad.logo.dialog.comp.SpinnerChangedEvent;
import DE.siemens.ad.logo.model.AbstractInputSimulationParameter;
import DE.siemens.ad.logo.model.AnalogInputSimulationParameter;
import DE.siemens.ad.logo.model.Parameter;
import DE.siemens.ad.logo.model.ParameterSetListener;
import DE.siemens.ad.logo.model.block.InputBlock;
import DE.siemens.ad.logo.util.Language;
import java.awt.Component;
import javax.help.CSH;

public class SimulationSpinner
extends LabelledEditableNumericSpinner
implements NumericSpinnerListener,
ParameterSetListener {
    protected AbstractInputSimulationParameter fSimulationParameter;
    private boolean fOnlineTestMode;

    public SimulationSpinner(InputBlock block, AbstractInputSimulationParameter parameter) {
        this.fSimulationParameter = parameter;
        this.setSliderActive(true);
        this.setMax((int)parameter.getMaxValue());
        this.setMin((int)parameter.getMinValue());
        this.setValue((int)parameter.getExternAnalogValue());
        this.setLabel(block.getNumberString());
        this.addNumericSpinnerListener(this);
        CSH.setHelpIDString((Component)this, (String)"toolbar.simulation.analogButton");
    }

    public SimulationSpinner(InputBlock block, AnalogInputSimulationParameter simulationParameter, boolean onlineTestMode) {
        this(block, simulationParameter);
        this.fOnlineTestMode = onlineTestMode;
    }

    public void parameterSet(Parameter parameter, String newParameterText) {
        AbstractInputSimulationParameter simParam = (AbstractInputSimulationParameter)parameter;
        int min = (int)simParam.getMinValue();
        int max = (int)simParam.getMaxValue();
        int value = (int)simParam.getExternAnalogValue();
        if (this.fOnlineTestMode) {
            min = Math.min(min, value);
            max = Math.max(max, value);
        }
        if (this.getMin() != min || this.getMax() != max) {
            this.setMinMax(min, max);
        }
        if (this.getValue() != value) {
            this.setValue(value);
        }
        this.setSpecificTooltip();
    }

    private void setSpecificTooltip() {
        String toolTip = Language.getString("dialog.switch.frequency", "Frequency");
        AbstractInputSimulationParameter simulationParameter = this.getSimulationParameter();
        if (simulationParameter.getSwitchMode() == 4) {
            if (this.fOnlineTestMode) {
                toolTip = Language.getString("simulation.analogButton.internValue", "Internal value (0-1000)");
            } else if (simulationParameter instanceof AnalogInputSimulationParameter) {
                Measurement.Sensor sensor = ((AnalogInputSimulationParameter)simulationParameter).getSensor();
                toolTip = sensor == null || sensor instanceof Measurement.SensorNoSensor ? Language.getString("simulation.analogButton.internValue", "Internal Value") : Language.getString("simulation.analogButton.externValue", "Physical value");
            }
        }
        this.setToolTipText(toolTip);
    }

    public void spinnerChanged(SpinnerChangedEvent se) {
        this.fSimulationParameter.setExternAnalogValue(this.getValue());
    }

    public AbstractInputSimulationParameter getSimulationParameter() {
        return this.fSimulationParameter;
    }
}

