/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.standard;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JToolTip;
import javax.swing.Timer;
import javax.swing.border.LineBorder;

public class IconTextTooltip
extends JToolTip {
    private Timer fAutoHideTimer;
    private int fAutoHideTimeout;
    private JLabel fLabel = null;
    public static Color DEFAULT;
    public static final Color WARNING;
    private FlowLayout fFlowLayout = new FlowLayout(3, 2, 0);

    public IconTextTooltip() {
        this.fLabel = new JLabel();
        this.add(this.fLabel);
        this.setBorder(new LineBorder(Color.black));
        DEFAULT = this.getBackground();
    }

    public void setText(String text) {
        this.fLabel.setText(text);
        this.setLayout(this.fFlowLayout);
    }

    public void setIcon(Icon icon) {
        this.fLabel.setIcon(icon);
    }

    public void setTipText(String tipText) {
    }

    public Dimension getPreferredSize() {
        return this.getLayout().minimumLayoutSize(this);
    }

    public void pack() {
        this.setSize(this.getPreferredSize());
        this.validate();
    }

    public int getAutoHideTimeout() {
        return this.fAutoHideTimeout;
    }

    public void setAutoHideTimeout(int autoHideTimeout) {
        this.fAutoHideTimeout = autoHideTimeout;
    }

    public void startAutoHide() {
        if (this.fAutoHideTimer == null) {
            this.fAutoHideTimer = new Timer(this.getAutoHideTimeout(), new AutoHideHandler());
            this.fAutoHideTimer.setRepeats(false);
        }
        if (this.fAutoHideTimer.isRunning()) {
            this.fAutoHideTimer.stop();
        }
        this.fAutoHideTimer.setDelay(this.fAutoHideTimeout);
        this.fAutoHideTimer.start();
    }

    public void hideTooltip() {
        Container parent;
        if (this.fAutoHideTimer != null && this.fAutoHideTimer.isRunning()) {
            this.fAutoHideTimer.stop();
        }
        if ((parent = this.getParent()) != null) {
            parent.remove(this);
            parent.repaint();
        }
    }

    static {
        WARNING = new Color(255, 242, 238);
    }

    private class AutoHideHandler
    implements ActionListener {
        private AutoHideHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            IconTextTooltip.this.hideTooltip();
        }
    }
}

