/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.standard;

import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.ChangeConnectionEndHandle;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.OutBlockConnector;
import DE.siemens.ad.pdraw.figures.CutConnectFigure;
import DE.siemens.ad.pdraw.figures.InputIfcFigure;
import DE.siemens.ad.pdraw.figures.constraints.ConnectionConstraint;
import DE.siemens.ad.pdraw.standard.ConnectionValidator;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public class ChangeInputIfcHandle
extends ChangeConnectionEndHandle {
    private ConnectionValidator fConnectionValidator = new ConnectionValidator();
    protected boolean fIsReconnectable = true;
    protected OutBlockConnector fOutBlockConnector = null;

    public ChangeInputIfcHandle(Figure owner) {
        super(owner);
        this.checkReconnectivity();
    }

    protected void checkReconnectivity() {
        Figure f;
        Connector conn = this.fConnection.end();
        if (conn != null && (f = conn.owner()) != null && f instanceof CutConnectFigure) {
            this.fIsReconnectable = false;
        }
    }

    protected void connect(Connector c, DrawingView view) {
        try {
            super.connect(c, view);
        }
        catch (ClassCastException cce) {
            super.connect(c, view);
        }
    }

    protected void disconnect() {
        super.disconnect();
        ConnectionConstraint connectionConstraint = (ConnectionConstraint)((Object)this.fConnection.getConstraint().getTopLevelConstraint());
        this.fOutBlockConnector = connectionConstraint.getOutBlockConnector();
    }

    public void draw(Graphics g) {
        Rectangle r = this.displayBox();
        g.setColor(Color.blue);
        g.fillRect(r.x, r.y, r.width, r.height);
        g.setColor(Color.black);
        g.drawRect(r.x, r.y, r.width, r.height);
    }

    protected Figure findConnectableFigure(int x, int y, Drawing drawing) {
        Figure figure;
        if (this.fIsReconnectable && (figure = drawing.findFigureInsideWithout(x, y, this.fConnection)) instanceof InputIfcFigure) {
            this.fConnectionValidator.setTooltipLocation(figure.displayBox().getLocation());
            if (this.isCorrectConnectorType((InputIfcFigure)figure) && !this.isFigureConnected((InputIfcFigure)figure) && !this.producesRecursion((InputIfcFigure)figure)) {
                this.fConnectionValidator.hideTooltip();
                return figure;
            }
        }
        return null;
    }

    public void invokeStart(int x, int y, DrawingView view) {
        super.invokeStart(x, y, view);
        this.fConnectionValidator.setView(view);
    }

    protected boolean isCorrectConnectorType(InputIfcFigure inputIfcFigure) {
        InBlockConnector inBlockConnector = (InBlockConnector)inputIfcFigure.getBlockConnector();
        return this.fConnectionValidator.checkSignalTypeCompatible(this.fOutBlockConnector, inBlockConnector);
    }

    protected boolean isFigureConnected(InputIfcFigure target) {
        return ((InBlockConnector)target.getBlockConnector()).isConnected();
    }

    protected boolean producesRecursion(InputIfcFigure iF) {
        InBlockConnector inBlockConnector = (InBlockConnector)iF.getBlockConnector();
        return !this.fConnectionValidator.checkRecursiveFree(inBlockConnector, this.fOutBlockConnector);
    }
}

