/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.simulation;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import DE.siemens.ad.logo.app.ApplicationSurface;
import DE.siemens.ad.logo.app.Editor;
import DE.siemens.ad.logo.app.action.ActionManager;
import DE.siemens.ad.logo.app.action.LogoAction;
import DE.siemens.ad.logo.app.comp.LogoJPopupMenu;
import DE.siemens.ad.logo.app.comp.SplittedDlg;
import DE.siemens.ad.logo.app.comp.ToolBarLayout;
import DE.siemens.ad.logo.model.AbstractInputSimulationParameter;
import DE.siemens.ad.logo.model.AnalogInputSimulationParameter;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.InputSimulationParameter;
import DE.siemens.ad.logo.model.block.AnalogInputBlock;
import DE.siemens.ad.logo.model.block.InputBlock;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.pdraw.action.ShowSimulationPaletteAction;
import DE.siemens.ad.pdraw.app.LogoComfort;
import DE.siemens.ad.pdraw.figures.BlockFigure;
import DE.siemens.ad.pdraw.simulation.OfflineInterpreter;
import DE.siemens.ad.pdraw.simulation.SimulationControl;
import DE.siemens.ad.pdraw.simulation.SimulationEndListener;
import DE.siemens.ad.pdraw.simulation.SimulationManager;
import DE.siemens.ad.pdraw.standard.LogoAbstractTool;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import DE.siemens.ad.pdraw.standard.LogoDrawingView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.help.CSH;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SimulationTool
extends LogoAbstractTool {
    protected LogoComfort fEditor = null;
    protected Vector fDialogs = new Vector();
    protected transient Figure fSimulationButtonFigure = null;
    protected transient boolean fInsideFigure = false;
    protected transient Cursor fSwitchCursor = null;
    protected transient Cursor fKeyCursor = null;
    protected transient Cursor fAnalogCursor = null;
    private SimulationManager fSimulationManager;
    private OfflineInterpreter fInterpreter;
    private SimulationControl fSimulationControl;
    private JComponent fSimulationToolbar;
    private ArrayList fSimulationEndListener;

    public SimulationTool(LogoComfort editor) {
        this.fEditor = editor;
        this.createCursors();
        this.fInterpreter = new OfflineInterpreter(((LogoDrawing)this.fEditor.getView().getModel()).getWiringDiagram());
        this.fSimulationManager = new SimulationManager(this.fEditor, this.fInterpreter);
        this.fSimulationControl = new SimulationControl(this.fSimulationManager);
        this.fSimulationToolbar = new JToolBar();
        this.fSimulationToolbar.setName("Simulation Toolbar");
        CSH.setHelpIDString((Component)this.fSimulationToolbar, (String)"toolbar.simulation");
        ((JToolBar)this.fSimulationToolbar).setFloatable(false);
        this.fSimulationToolbar.setLayout(new ToolBarLayout(3));
        this.fSimulationToolbar.add(this.fSimulationManager.getInputBlockBar());
        this.fSimulationToolbar.add(this.fSimulationManager.getOutputBlockBar());
        this.fSimulationToolbar.add(this.fSimulationControl.getToolbar());
    }

    protected void finalize() throws Throwable {
    }

    public void activate(DrawingView view) {
        super.activate(view);
        view.clearSelection();
        boolean simulationPaletteVisible = ((ShowSimulationPaletteAction)this.fEditor.getActionFactory().getAction("ShowSimulationPaletteAction")).isSelected();
        this.fSimulationManager.setSimulationMode(true);
        this.fSimulationToolbar.setVisible(simulationPaletteVisible);
        this.setComponentInApplication(view);
        RefreshThread t = new RefreshThread();
        t.setView(view);
        t.start();
    }

    public void addOpenDialog(JDialog dialog) {
        this.fDialogs.add(dialog);
    }

    protected void changeInputSignal(BlockFigure figure) {
        this.fSimulationButtonFigure = figure;
        this.fInsideFigure = true;
        InputBlock block = this.getInputBlock(figure.getBlock());
        if (block.getSimulationParameter() instanceof InputSimulationParameter) {
            ((InputSimulationParameter)block.getSimulationParameter()).inputPressed();
        }
    }

    public void createCursors() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        try {
            Image image = Global.getImage("SwitchCursor.gif");
            this.fSwitchCursor = toolkit.createCustomCursor(image, new Point(0, 0), "SwitchCursor");
            image = Global.getImage("KeyCursor.gif");
            this.fKeyCursor = toolkit.createCustomCursor(image, new Point(0, 0), "KeyCursor");
            image = Global.getImage("AnalogCursor.gif");
            this.fAnalogCursor = toolkit.createCustomCursor(image, new Point(0, 0), "AnalogCursor");
        }
        catch (Exception ex) {
            return;
        }
    }

    public void deactivate(DrawingView view) {
        this.fInterpreter.getStateMachine().addInput("terminate");
        this.fSimulationManager.setSimulationMode(false);
        int count = this.fDialogs.size();
        for (int i = 0; i < count; ++i) {
            if (!((SplittedDlg)this.fDialogs.elementAt(i)).isVisible()) continue;
            ((SplittedDlg)this.fDialogs.elementAt(i)).closeDialogWithQuery();
        }
        this.fDialogs.removeAllElements();
        view.setCursor(Cursor.getDefaultCursor());
        for (SimulationEndListener listener : (ArrayList)this.getSimulationEndListener().clone()) {
            listener.simulationDeactivated();
        }
        this.fSimulationEndListener = null;
        final LogoDrawingView logoDrawingView = (LogoDrawingView)view;
        Runnable r = new Runnable(){

            public void run() {
                logoDrawingView.repaint();
            }
        };
        SwingUtilities.invokeLater(r);
        this.fSimulationToolbar.setVisible(false);
    }

    public void editorEnded(Editor editor) {
        super.editorEnded(editor);
        this.fInterpreter.getStateMachine().addInput("terminate");
        this.fSimulationManager.setSimulationMode(false);
    }

    public void mouseDown(MouseEvent e, int x, int y, DrawingView view) {
        if (SwingUtilities.isRightMouseButton(e)) {
            return;
        }
        this.fSimulationButtonFigure = null;
        Figure figure = view.drawing().findFigure(e.getX(), e.getY());
        if (!(figure instanceof BlockFigure)) {
            return;
        }
        BlockFigure blockFigure = (BlockFigure)figure;
        if (e.isControlDown()) {
            if (e.getClickCount() == 2) {
                this.showParameterDialog(view, blockFigure);
            }
        } else {
            InputBlock block = this.getInputBlock(blockFigure.getBlock());
            if (e.getClickCount() == 2) {
                if (block instanceof InputBlock) {
                    this.changeInputSignal(blockFigure);
                } else {
                    this.showParameterDialog(view, blockFigure);
                }
            } else {
                try {
                    this.fInsideFigure = false;
                    if (block instanceof InputBlock) {
                        if (block instanceof AnalogInputBlock) {
                            this.showAnalogSlider(blockFigure, x, y, view);
                        } else if (((InputSimulationParameter)((Block)block).getSimulationParameter()).getSwitchMode() == 2) {
                            this.showFrequencySlider(blockFigure, x, y, view);
                        } else {
                            this.changeInputSignal(blockFigure);
                        }
                    }
                }
                catch (NullPointerException npe) {
                    // empty catch block
                }
            }
        }
    }

    public void mouseDrag(MouseEvent e, int x, int y, DrawingView view) {
        this.mouseMove(e, x, y, view);
    }

    public void mouseMove(MouseEvent e, int x, int y, DrawingView view) {
        Figure figure = view.drawing().findFigure(e.getX(), e.getY());
        if (figure instanceof BlockFigure) {
            AbstractInputSimulationParameter inputSimulationParameter;
            BlockFigure bF = (BlockFigure)figure;
            InputBlock inputBlock = this.getInputBlock(bF.getBlock());
            if (inputBlock != null && (inputSimulationParameter = (AbstractInputSimulationParameter)inputBlock.getSimulationParameter()) != null) {
                Cursor newCursor = null;
                int currentSwitchMode = inputSimulationParameter.getSwitchMode();
                if (currentSwitchMode == 1 || currentSwitchMode == 8) {
                    newCursor = this.fKeyCursor;
                }
                if (currentSwitchMode == 0) {
                    newCursor = this.fSwitchCursor;
                }
                if (currentSwitchMode == 2 || currentSwitchMode == 4) {
                    newCursor = this.fAnalogCursor;
                }
                if (newCursor != null) {
                    ((Component)((Object)view)).setCursor(newCursor);
                }
            }
        } else {
            ((Component)((Object)view)).setCursor(Cursor.getDefaultCursor());
        }
    }

    public void mouseUp(MouseEvent e, int x, int y, DrawingView view) {
        BlockFigure bF;
        InputBlock inputBlock;
        if (SwingUtilities.isRightMouseButton(e)) {
            return;
        }
        if (this.fSimulationButtonFigure != null && (inputBlock = this.getInputBlock((bF = (BlockFigure)this.fSimulationButtonFigure).getBlock())) != null && inputBlock.getSimulationParameter() instanceof InputSimulationParameter) {
            ((InputSimulationParameter)inputBlock.getSimulationParameter()).inputReleased();
        }
    }

    protected InputBlock getInputBlock(Block block) {
        if (block instanceof InputBlock) {
            return (InputBlock)block;
        }
        return null;
    }

    protected void showAnalogSlider(BlockFigure blockFigure, int x, int y, DrawingView drawingView) {
        Block block = blockFigure.getBlock();
        final AnalogInputSimulationParameter aisp = (AnalogInputSimulationParameter)block.getSimulationParameter();
        LogoJPopupMenu popup = new LogoJPopupMenu();
        final JSlider slider = new JSlider();
        slider.setMinimum((int)aisp.getMinValue());
        slider.setMaximum((int)aisp.getMaxValue());
        slider.setValue((int)aisp.getExternAnalogValue());
        slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                aisp.setExternAnalogValue(slider.getValue());
            }
        });
        slider.setPaintTrack(true);
        popup.setLayout(new BorderLayout());
        popup.add((Component)slider, "Center");
        popup.add((Component)new JLabel(String.valueOf(slider.getMinimum())), "West");
        popup.add((Component)new JLabel(String.valueOf(slider.getMaximum())), "East");
        Rectangle r = blockFigure.displayBox();
        double zoomFactor = (double)((LogoDrawingView)drawingView).getZoomManager().getZoom() / 100.0;
        r.x = (int)((double)r.x * zoomFactor);
        r.y = (int)((double)r.y * zoomFactor);
        r.width = (int)((double)r.width * zoomFactor);
        r.height = (int)((double)r.height * zoomFactor);
        ((JPopupMenu)popup).show((Component)((Object)drawingView), r.x - slider.getPreferredSize().width, r.y + r.height - slider.getPreferredSize().height - 10);
        slider.repaint();
    }

    protected void showFrequencySlider(BlockFigure blockFigure, int x, int y, DrawingView drawingView) {
        Block block = blockFigure.getBlock();
        final InputSimulationParameter aisp = (InputSimulationParameter)block.getSimulationParameter();
        LogoJPopupMenu popup = new LogoJPopupMenu();
        final JSlider slider = new JSlider();
        slider.setMinimum((int)aisp.getMinValue());
        slider.setMaximum((int)aisp.getMaxValue());
        slider.setValue((int)aisp.getExternAnalogValue());
        slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                aisp.setExternAnalogValue(slider.getValue());
            }
        });
        slider.setPaintTrack(true);
        popup.setLayout(new BorderLayout());
        popup.add((Component)slider, "Center");
        popup.add((Component)new JLabel(String.valueOf(slider.getMinimum())), "West");
        popup.add((Component)new JLabel(String.valueOf(slider.getMaximum())), "East");
        Rectangle r = blockFigure.displayBox();
        double zoomFactor = (double)((LogoDrawingView)drawingView).getZoomManager().getZoom() / 100.0;
        r.x = (int)((double)r.x * zoomFactor);
        r.y = (int)((double)r.y * zoomFactor);
        r.width = (int)((double)r.width * zoomFactor);
        r.height = (int)((double)r.height * zoomFactor);
        ((JPopupMenu)popup).show((Component)((Object)drawingView), r.x - slider.getPreferredSize().width, r.y + r.height);
    }

    protected void showParameterDialog(DrawingView view, BlockFigure blockFigure) {
        view.clearSelection();
        view.addToSelection(blockFigure);
        ActionManager actionManager = ((Editor)((Object)view.editor())).getActionManager();
        LogoAction action = actionManager.getActionFactory().getAction("EditBlockPropertiesAction");
        actionManager.invokeAction(action);
    }

    public void editorDeactivated(Editor editor) {
        super.editorDeactivated(null);
        this.fSimulationManager.getMessageWindow().setEditorActivated(false);
        this.fSimulationManager.getPIControllerWindow().setEditorActivated(false);
        this.fSimulationToolbar.setVisible(false);
    }

    public void editorActivated(Editor editor) {
        super.editorActivated(null);
        JComponent c = editor.getApplicationSurface().getWindowManager().getToolbarPanel("Simulation", "South");
        c.add(this.fSimulationToolbar);
        this.fSimulationManager.getMessageWindow().setEditorActivated(true);
        this.fSimulationManager.getPIControllerWindow().setEditorActivated(true);
        this.fSimulationToolbar.setVisible(true);
    }

    protected void setComponentInApplication(DrawingView view) {
        ApplicationSurface applicationSurface = ((LogoComfort)view.editor()).getApplicationSurface();
        JComponent c = applicationSurface.getWindowManager().getToolbarPanel("Simulation", "South");
        c.add(this.fSimulationToolbar);
        applicationSurface.revalidate();
    }

    public void addSimulationEndListener(SimulationEndListener listener) {
        ArrayList simulationEndListener = this.getSimulationEndListener();
        if (!simulationEndListener.contains(listener)) {
            simulationEndListener.add(listener);
        }
    }

    public void removeSimulationEndListener(SimulationEndListener listener) {
        this.getSimulationEndListener().remove(listener);
    }

    public ArrayList getSimulationEndListener() {
        if (this.fSimulationEndListener == null) {
            this.fSimulationEndListener = new ArrayList();
        }
        return this.fSimulationEndListener;
    }

    public static class RefreshThread
    extends Thread {
        DrawingView fView;

        public void setView(DrawingView view) {
            this.fView = view;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Thread.sleep(100L);
                ((Component)((Object)this.fView)).setVisible(false);
                ((Component)((Object)this.fView)).invalidate();
                Thread.sleep(100L);
                ((Component)((Object)this.fView)).setVisible(true);
                ((Component)((Object)this.fView)).invalidate();
                ((Component)((Object)this.fView)).repaint();
            }
            catch (Exception exception) {
            }
            finally {
                this.fView = null;
            }
        }
    }
}

