/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.simulation;

import DE.siemens.ad.logo.model.InputSimulationParameter;
import DE.siemens.ad.logo.model.Parameter;
import DE.siemens.ad.logo.model.ParameterSetListener;
import DE.siemens.ad.logo.model.block.InputBlock;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.pdraw.simulation.SimulationManager;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.help.CSH;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class SimulationButton
extends JLabel
implements ParameterSetListener {
    protected InputBlock fInputBlock;
    protected boolean fValue = false;
    protected boolean fPressedEvent = false;
    protected static ImageIcon cMomentaryOpenerOpen;
    protected static ImageIcon cMomentaryOpenerClosed;
    protected static ImageIcon cSwitchOnIcon;
    protected static ImageIcon cSwitchOffIcon;
    protected static ImageIcon cKeyOnIcon;
    protected static ImageIcon cKeyOffIcon;
    protected SimulationManager fSimulationManager;
    private ImageIcon fUnselectedIcon;
    private ImageIcon fSelectedIcon;

    public SimulationButton(InputBlock block, SimulationManager sm) {
        this.fInputBlock = block;
        if (cSwitchOnIcon == null) {
            cSwitchOnIcon = Global.getIcon("SwitchOn.gif");
        }
        if (cSwitchOffIcon == null) {
            cSwitchOffIcon = Global.getIcon("SwitchOff.gif");
        }
        if (cKeyOnIcon == null) {
            cKeyOnIcon = Global.getIcon("KeyOn.gif");
        }
        if (cKeyOffIcon == null) {
            cKeyOffIcon = Global.getIcon("KeyOff.gif");
        }
        this.initializeButton(this.getIputSimulationParameter().getSwitchMode());
        this.setSelected(this.getIputSimulationParameter().getInputState());
        this.fSimulationManager = sm;
    }

    public void setSelected(boolean selected) {
        if (selected) {
            this.setBorder(BorderFactory.createBevelBorder(1));
            this.setIcon(this.fSelectedIcon);
        } else {
            this.setBorder(BorderFactory.createBevelBorder(0));
            this.setIcon(this.fUnselectedIcon);
        }
    }

    protected void initializeButton(int switchMode) {
        if (switchMode == 0) {
            this.setUnselectedIcon(cSwitchOffIcon);
            this.setSelectedIcon(cSwitchOnIcon);
            this.addMouseListener(new ToggleMouseListener());
            this.setToolTipText(Language.getString("dialog.switch.switch", "Switch"));
        }
        if (switchMode == 8) {
            this.setUnselectedIcon(cMomentaryOpenerClosed);
            this.setSelectedIcon(cMomentaryOpenerOpen);
            this.addMouseListener(new NormalMouseListener());
            this.setToolTipText(Language.getString("dialog.switch.key.closed", "Momentary (normally closed)"));
        }
        if (switchMode == 1) {
            this.setUnselectedIcon(cKeyOffIcon);
            this.setSelectedIcon(cKeyOnIcon);
            this.addMouseListener(new NormalMouseListener());
            this.setToolTipText(Language.getString("dialog.switch.key.opened", "Momentary (normally opened)"));
        }
        this.setHorizontalTextPosition(0);
        this.setVerticalTextPosition(3);
        this.setText(this.fInputBlock.getNumberString());
        this.setIconTextGap(0);
        this.setAlignmentX(0.5f);
        this.setAlignmentY(0.5f);
        this.setVerticalAlignment(0);
        CSH.setHelpIDString((Component)this, (String)"toolbar.simulation.inputButton");
    }

    public void setSelectedIcon(ImageIcon cSwitchOnIcon) {
        this.fSelectedIcon = cSwitchOnIcon;
    }

    public void setUnselectedIcon(ImageIcon cSwitchOffIcon) {
        this.fUnselectedIcon = cSwitchOffIcon;
    }

    public InputBlock getBlock() {
        return this.fInputBlock;
    }

    protected void handlePopupTrigger(MouseEvent me) {
        this.fSimulationManager.getEditor().getMenuManager().getPopupMenu(this).show(this, me.getX(), me.getY());
    }

    public void parameterSet(Parameter parameter, String newParameterText) {
        InputSimulationParameter inputSimulationParameter = (InputSimulationParameter)parameter;
        this.setSelected(inputSimulationParameter.getInputState());
        this.repaint();
    }

    private InputSimulationParameter getIputSimulationParameter() {
        return (InputSimulationParameter)this.getBlock().getSimulationParameter();
    }

    static {
        cSwitchOnIcon = Global.getIcon("SwitchOn.gif");
        cSwitchOffIcon = Global.getIcon("SwitchOff.gif");
        cKeyOnIcon = Global.getIcon("KeyOn.gif");
        cKeyOffIcon = Global.getIcon("KeyOff.gif");
        cMomentaryOpenerOpen = Global.getIcon("MomentaryOpenerOpen.gif");
        cMomentaryOpenerClosed = Global.getIcon("MomentaryOpenerClosed.gif");
    }

    class NormalMouseListener
    implements MouseListener {
        NormalMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            if (!SimulationButton.this.isEnabled()) {
                return;
            }
            if (SwingUtilities.isRightMouseButton(e)) {
                return;
            }
            SimulationButton.this.getIputSimulationParameter().inputPressed();
        }

        public void mouseReleased(MouseEvent e) {
            if (!SimulationButton.this.isEnabled()) {
                return;
            }
            if (e.isPopupTrigger()) {
                SimulationButton.this.handlePopupTrigger(e);
                return;
            }
            SimulationButton.this.getIputSimulationParameter().inputReleased();
        }
    }

    class ToggleMouseListener
    implements MouseListener {
        ToggleMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            if (!SimulationButton.this.isEnabled()) {
                return;
            }
            if (SwingUtilities.isRightMouseButton(e)) {
                return;
            }
            SimulationButton.this.getIputSimulationParameter().inputPressed();
        }

        public void mouseReleased(MouseEvent e) {
            if (!SimulationButton.this.isEnabled()) {
                return;
            }
            if (e.isPopupTrigger()) {
                SimulationButton.this.handlePopupTrigger(e);
                return;
            }
            SimulationButton.this.getIputSimulationParameter().inputReleased();
        }
    }
}

